C:::::      ,,,,,VEM912.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM912(N,M,L,MAT)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEM912  computes the invers matrices of a large             ***
C**             system of M x M matrices (M=1,2,3)                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           M, N, L
      DOUBLE PRECISION  MAT(L,M,M)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of matrices
C--------I------I-----I------------------------------------------------
C M      I  I   I in  I dimension of the matrices M=1,2,3
C--------I------I-----I------------------------------------------------
C MAT    I  R   I in  I set of M x M matrices
C        I      I out I their inverses                array: MAT(L,M,M)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z
      DOUBLE PRECISION  D,R11,R12,R13,R21,R22,R23,R31,R32,R33
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      IF (M.EQ.1) THEN

        DO 100 Z=1,N
           D         =MAT(Z,1,1)
           MAT(Z,1,1)=1.D0/D
100     CONTINUE

      ENDIF

      IF (M.EQ.2) THEN

          DO 200 Z=1,N

            R11=MAT(Z,1,1)
            R12=MAT(Z,1,2)
            R21=MAT(Z,2,1)
            R22=MAT(Z,2,2)

            D = R11*R22-R12*R21
            D=1.D0/D

            MAT(Z,1,1)= R22*D
            MAT(Z,2,1)=-R21*D
            MAT(Z,1,2)=-R12*D
            MAT(Z,2,2)= R11*D

  200    CONTINUE


      ENDIF

      IF (M.EQ.3) THEN

          DO 300 Z=1,N

             R11=MAT(Z,1,1)
             R21=MAT(Z,2,1)
             R31=MAT(Z,3,1)
             R12=MAT(Z,1,2)
             R22=MAT(Z,2,2)
             R32=MAT(Z,3,2)
             R13=MAT(Z,1,3)
             R23=MAT(Z,2,3)
             R33=MAT(Z,3,3)

             D         =  R11*(R22*R33-R23*R32)
     &                  + R12*(R31*R23-R21*R33)
     &                  + R13*(R21*R32-R31*R22)
             D=1.D0/D

             MAT(Z,1,1)=(R22*R33-R23*R32)*D
             MAT(Z,2,1)=(R31*R23-R21*R33)*D
             MAT(Z,3,1)=(R21*R32-R31*R22)*D
             MAT(Z,1,2)=(R13*R32-R12*R33)*D
             MAT(Z,2,2)=(R11*R33-R31*R13)*D
             MAT(Z,3,2)=(R12*R31-R11*R32)*D
             MAT(Z,1,3)=(R12*R23-R13*R22)*D
             MAT(Z,2,3)=(R13*R21-R11*R23)*D
             MAT(Z,3,3)=(R11*R22-R12*R21)*D

  300   CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM912----------------------------------------------------
      E    N    D
