C:::::      ,,,,,VEM915.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM915 (N,L,X1,NORMX1,X2,NORMX2,S)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM915   l2-norm of the outer product for a large set of   ***
C**               three dimensional vectors. additionally the       ***
C**               vectors are normalized.                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N, L
      DOUBLE PRECISION  X1(L,3),X2(L,3),NORMX1(L),NORMX2(L),S(L)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of vectors
C--------I------I-----I------------------------------------------------
C X1, X2 I  R   I in  I sets of vectors
C        I      I out I normalized vectors              array: Xi(L,3)
C--------I------I-----I------------------------------------------------
C NORMX1 I  R   I out I NORMXi are normalization factors of the Xi's.
C NORMX2 I      I     I                                array: NORMXi(L)
C--------I------I-----I------------------------------------------------
C S      I  R   I out I l2-norms of the outer products X1 x X2
C        I      I     I                                     array: S(L)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z
      DOUBLE PRECISION  D1,D2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
         DO 300 Z=1,N

           D1= 1.D0 / SQRT(X1(Z,1)**2+X1(Z,2)**2+X1(Z,3)**2)
           D2= 1.D0 / SQRT(X2(Z,1)**2+X2(Z,2)**2+X2(Z,3)**2)

           NORMX1(Z)=D1
           NORMX2(Z)=D2
	
           S(Z)=SQRT((X1(Z,2)*X2(Z,3)-X2(Z,2)*X1(Z,3))**2 +
     &               (X1(Z,1)*X2(Z,3)-X2(Z,1)*X1(Z,3))**2 +
     &               (X1(Z,1)*X2(Z,2)-X1(Z,2)*X2(Z,1))**2 )

           X1(Z,1)=D1*X1(Z,1)
           X1(Z,2)=D1*X1(Z,2)
           X1(Z,3)=D1*X1(Z,3)

           X2(Z,1)=D2*X2(Z,1)
           X2(Z,2)=D2*X2(Z,2)
           X2(Z,3)=D2*X2(Z,3)

  300   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM915----------------------------------------------------
      E    N    D
