C:::::      ,,,,,VEM916.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM916 (N,M,L,X,NORMX,S)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM916    computes the L2-norm S and normalized a set of N   ***
C**              M-dimensional vectors.                             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N, M,L
      DOUBLE PRECISION  X(L,M), NORMX(L), S(L)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of vectors (large)
C--------I------I-----I------------------------------------------------
C M      I  I   I in  I dimension of vectors (=1,2,3)
C--------I------I-----I------------------------------------------------
C X      I  R   I i/o I system of vectors                 array: X(L,M)
C--------I------I-----I------------------------------------------------
C NORMX  I  R   I out I normalization factor            array: NORMX(L)
C--------I------I-----I------------------------------------------------
C S      I  R   I out I L2-norm of input vector X          array : S(L)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***

      IF (M.EQ.1) THEN

         DO 100 Z=1,N

              S(Z)=ABS(X(Z,1))
              NORMX(Z)=1.D0 / S(Z)
              X(Z,1)=X(Z,1)*NORMX(Z)

  100    CONTINUE

      ENDIF


      IF (M.EQ.2) THEN

         DO 200 Z=1,N

              S(Z)=SQRT(X(Z,1)**2+X(Z,2)**2)
              NORMX(Z)=1.D0 / S(Z)
              X(Z,1)=X(Z,1)*NORMX(Z)
              X(Z,2)=X(Z,2)*NORMX(Z)

  200    CONTINUE

      ENDIF


      IF (M.EQ.3) THEN

         DO 300 Z=1,N

              S(Z)=SQRT(X(Z,1)**2+X(Z,2)**2+X(Z,3)**2)
              NORMX(Z)=1.D0 / S(Z)
              X(Z,1)=X(Z,1)*NORMX(Z)
              X(Z,2)=X(Z,2)*NORMX(Z)
              X(Z,3)=X(Z,3)*NORMX(Z)

  300    CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM916----------------------------------------------------
      E    N    D
