C:::::      ,,,,,VEM917.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM917 (N,L,X1,X2,S)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM917  computes the L2-norm S of the outer product of two   ***
C**            systems of 3-dimensional vectors.                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N, L
      DOUBLE PRECISION  X1(L,3),X2(L,3), S(L)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of vectors (large)
C--------I------I-----I------------------------------------------------
C X1,2   I  R   I in  I system of vectors                array: XI(L,3)
C--------I------I-----I------------------------------------------------
C S      I  R   I out I L2-norm of the outer product X1 x X2
C        I      I     I                                     array: S(L)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***

      DO 300 Z=1,N

         S(Z)=SQRT((X1(Z,2)*X2(Z,3)-X2(Z,2)*X1(Z,3))**2 +
     &             (X1(Z,1)*X2(Z,3)-X2(Z,1)*X1(Z,3))**2 +
     &             (X1(Z,1)*X2(Z,2)-X1(Z,2)*X2(Z,1))**2 )

  300 CONTINUE

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM917----------------------------------------------------
      E    N    D
