C:::::      ,,,,,VEM918.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM918 (N,M,L,X,S)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM918  L2-Norm S of N M-dimensional vectors                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N, M,L
      DOUBLE PRECISION  X(L,M), S(L)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of vectors (large)
C--------I------I-----I------------------------------------------------
C M      I  I   I in  I dimension of the vectors =1,2,3
C--------I------I-----I------------------------------------------------
C X      I  R   I in  I system of vectors                 array: X(L,M)
C--------I------I-----I------------------------------------------------
C S      I  R   I out I L2-norm of vectors X                array: S(L)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER Z
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**                                                                 ***
      IF (M.EQ.1) THEN
         DO 100 Z=1,N
           S(Z)=ABS(X(Z,1))
  100    CONTINUE
      ENDIF

      IF (M.EQ.2) THEN
         DO 200 Z=1,N
           S(Z)=SQRT(X(Z,1)**2+X(Z,2)**2)
  200    CONTINUE
      ENDIF

      IF (M.EQ.3) THEN
         DO 300 Z=1,N
           S(Z)=SQRT(X(Z,1)**2+X(Z,2)**2+X(Z,3)**2)
  300    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM918----------------------------------------------------
      E    N    D
