C:::::      ,,,,,VEM920.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM920 (N,M,L,K1,A,K,B,C)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM920   computes the product of a large system of M x L     ***
C**             matrices with one K x M matrix for M=1,2,3          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N, M, K, L, K1
      DOUBLE PRECISION  A(K1,M,L), B(K,M), C(K1,K,L)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of matrices (large)
C--------I------I-----I------------------------------------------------
C M      I  I   I in  I dimension of the matrices =1,2,3
C--------I------I-----I------------------------------------------------
C A      I  R   I in  I system of M x L matrices       array: A(K1,M,L)
C--------I------I-----I------------------------------------------------
C B      I  R   I in  I one K x M matrix                  array: B(K,M)
C--------I------I-----I------------------------------------------------
C C      I  R   I out I product od A and B             array: C(K1,K,L)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,I,J
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      IF (M.EQ.1) THEN

        DO 100 J=1,L
          DO 110 I=1,K
            DO 120 Z=1,N

              C(Z,I,J)= B(I,1)*A(Z,1,J)

  120       CONTINUE
 110      CONTINUE
100     CONTINUE

      ENDIF

      IF (M.EQ.2) THEN

        DO 200 J=1,L
          DO 210 I=1,K
            DO 220 Z=1,N

              C(Z,I,J)=B(I,1)*A(Z,1,J)+B(I,2)*A(Z,2,J)

  220       CONTINUE
 210      CONTINUE
200     CONTINUE

      ENDIF

      IF (M.EQ.3) THEN

          DO 300 J=1,L
            DO 310 I=1,K
              DO 320 Z=1,N

                C(Z,I,J)=B(I,1)*A(Z,1,J)+B(I,2)*A(Z,2,J)+
     &                   B(I,3)*A(Z,3,J)

  320         CONTINUE
 310        CONTINUE
300       CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM920----------------------------------------------------
      E    N    D
