C:::::      ,,,,,VEM921...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM921(M,LX,L,X,K,LIST,W,V)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEM921  weighted sum of vectors selected by an index list     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           M,LX,L,K,LIST(K)
      DOUBLE PRECISION  X(LX,L),W(K),V(M)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C M      I  I   I in  I vector length (large)
C--------I------I-----I------------------------------------------------
C X      I  R   I in  I system of vectors                array: X(LX,L)
C--------I------I-----I------------------------------------------------
C K      I  I   I in  I number of terms in sums
C--------I------I-----I------------------------------------------------
C LIST   I  I   I in  I pointer to the vectors in X      array: LIST(K)
C--------I------I-----I------------------------------------------------
C W      I  R   I in  I weights to the terms of the sum     array: W(K)
C--------I------I-----I------------------------------------------------
C V      I  R   I out I sums of the K vectors selected by LIST from X
C        I      I     I and weigthed by W                   array: V(M)
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           Z,J
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
           DO 105 Z=1,M
             V(Z)=0
  105      CONTINUE

          DO 302 J=1,K
            DO 300 Z=1,M
              V(Z)=V(Z)+W(J)*X(Z,LIST(J))
  300       CONTINUE
 302       CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----END OF VEM921----------------------------------------------------
      E    N    D
