C:::::      ,,,,,VEM930.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      DOUBLE PRECISION FUNCTION VEM930 ( NN,V,EPS )
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM930   computes the absolute maximum of vector V         ***
C**               over all components on one processor              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      INTEGER            NN
      DOUBLE PRECISION   V(NN),EPS
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NN     I  I   I in  I number of elements in V
C--------I------I-----I------------------------------------------------
C V      I  R   I in  I input vector                       array: V(NN)
C--------I------I-----I------------------------------------------------
C EPS    I  R   I in  I small constant ( VMAX >= EPS )
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER          I1
      DOUBLE PRECISION VMAX
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**                                                                 ***
      VMAX=EPS
      DO 10 I1=1,NN
         VMAX=MAX(VMAX,ABS(V(I1)))
   10 CONTINUE
      VEM930=VMAX
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM930----------------------------------------------------
      E    N    D
