C:::::      ,,,,,VEM933.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM933(NK,NKN,N,COMIND,X,EPS,NORMX,
     &                  RWORK,MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEM933  component-by-component absulute maximum of a vector   ***
C**           the entries of the input vector are assigned to the   ***
C**           components by an index vector.                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      INTEGER           NK,N,MYPROC,NPROC,NMSG
      DOUBLE PRECISION  EPS,X(N),NORMX(NK),RWORK(2*NK)
      INTEGER           NKN(NK),COMIND(N),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C EPS    I  R   I in  I small positiv constant
C--------I------I-----I------------------------------------------------
C NKN    I  I   I in  I number of indices for the components
C--------I------I-----I------------------------------------------------
C COMIND I  I   I in  I gather index                   array: COMIND(N)
C--------I------I-----I------------------------------------------------
C X      I  R   I in  I input vector                        array: X(N)
C--------I------I-----I------------------------------------------------
C NORMX  I  R   I out I component-by-component norm of X
C        I      I     I                                array: NORMX(NK)
C--------I------I-----I------------------------------------------------
C RWORK  I  R   I  -  I real work array     ARRAY : RWORK(2*NK)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           I,J,CC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**                                                                 ***
      CC=0
      DO 110 I=1,NK
        RWORK(I)=EPS
        DO 120 J=1,NKN(I)
120       RWORK(I)=MAX(RWORK(I),ABS(X(COMIND(J+CC))))
        CC=CC+NKN(I)
110   CONTINUE

      CALL LL4RNM (1,NK,1,RWORK(1),NORMX,RWORK(NK+1),
     &             MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM933----------------------------------------------------
      E    N    D
