C:::::      ,,,,,VEM996.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM996(ND,LMAT,LDEX,IA1,IA2,INFO,
     #                  MAT,INDEX,NDC,DIND,LM,DMASKC,DMASKR,NJUMP,
     #                  JUMP,NPROC,LMATBK,PTRMBK,MYPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM996  insert Dirichlet conditions into the global matrix   ***
C**            the columns and rows for defrees of freedoms         ***
C**            belongs to a Dirchlet condition are set to zero      ***
C**            and the main diagonal gets the value one             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      INTEGER           ND,LM, LMAT,LDEX,NDC,IA1,IA2,
     #                  NPROC,NJUMP,MYPROC,NMSG
      INTEGER           INFO(IA1,IA2),INDEX(LDEX),DIND(NDC),
     #                  DMASKC(LM,2),DMASKR(LM),JUMP(NJUMP),
     #                  LMATBK(NPROC),PTRMBK(NPROC),TIDS(NPROC)
      DOUBLE PRECISION  MAT(LMAT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C ND     I  I   I in  I number of terms in matrix partition
C--------I------I-----I------------------------------------------------
C LMAT   I  I   I in  I length of the matrix-file
C--------I------I-----I------------------------------------------------
C LDEX   I  I   I in  I length of the index-file of the matrix
C--------I------I-----I------------------------------------------------
C INFO   I  I   I  I  I information array for mvm
C        I      I     I (see user's guide)         array: INFO(IA1,IA2)
C--------I------I-----I------------------------------------------------
C MAT    I  R   I i/o I matrix-file
C--------I------I-----I------------------------------------------------
C INDEX  I  I   I in  I index-file
C--------I------I-----I------------------------------------------------
C DIND   I  I   I in  I row index for Dirichlet-condions
C        I      I     I                                array: DIND(NDC)
C--------I------I-----I------------------------------------------------
C DMASKR I  I   I  -  I row mask for Dirichlet conditions
C        I      I     I is sent arround !             array: DMASKR(LM)
C--------I------I-----I------------------------------------------------
C DMASKC I  I   I  -  I column mask for Dirichlet conditions
C        I      I     I                             array: DMASKC(LM,2)
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I array : LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I array : PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I  process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I  task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I,K,DR,DC,FIRST,TYP,ADDA,L,IAC,IAR,INDC,INDR,
     &                  PROC,P,FRTID,TOTID,MIDS,MIDR,LL9MAP,
     &                  M0,MERR,M1,M01,SWPBUF,RCVBUF,SNDBUF
      include"bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      PROC=MYPROC
      M0=PTRMBK(MYPROC)
      RCVBUF=1
      SNDBUF=2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of processor loop:                                      ***
C**   -----------------------                                       ***
C**                                                                 ***
      DO 9980 P=1,NJUMP
        IF (P.EQ.1) THEN
C**                                                                 ***
C******** ctreate the mask for rows and colums with Dirichlet       ***
C**       conditions and send to the other processors:              ***
C**                                                                 ***
          DO 10 I=1,LM
           DMASKR(I)=0
 10       CONTINUE
          DO 20 I=1,NDC
            DMASKR(DIND(I))=I+M0
 20       CONTINUE
          DO 30 I=1,LM
           DMASKC(I,RCVBUF)=DMASKR(I)
 30       CONTINUE
        ELSE
          FRTID=TIDS(LL9MAP(MYPROC-JUMP(P-1),NPROC))
          TOTID=TIDS(LL9MAP(MYPROC+JUMP(P-1),NPROC))
          PROC=LL9MAP(PROC-JUMP(P-1),NPROC)
	  CALL MPRCVA(FRTID,NMSG+P,IINT*LM,DMASKC(1,RCVBUF),MIDR,MERR)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*LM,DMASKC(1,SNDBUF),MIDS,MERR)
	  CALL MPSNDW(TOTID,NMSG+P,IINT*LM,DMASKC(1,SNDBUF),MIDS,MERR)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*LM,DMASKC(1,RCVBUF),MIDR,MERR)
        ENDIF
	M1=LMATBK(PROC)
	M01=PTRMBK(PROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** Now the elemination starts :                                ***
C**     -------------------------                                   ***
C**                                                                 ***
        DO   100   K = 1,ND
C**                                                                 ***
          TYP   =INFO(K,1)
          ADDA  =INFO(K,2)
          L     =INFO(K,3)
          IAC =INFO(K,4)
          IAR   =INFO(K,5)
          INDC=INFO(K,6)
          INDR  =INFO(K,7)
C**                                                                 ***
          IF ((TYP.EQ.10).OR.(TYP .EQ. 20)) THEN
	    FIRST=IAC
            IF ((M01.LE.FIRST).AND.(FIRST.LT.M01+M1)) THEN
              DO   120   I = 1,L
                DR=DMASKR(I+IAR-M0)
                DC=DMASKC(I+IAC-M01,RCVBUF)
                IF ( (DR.NE.0).OR.(DC.NE.0) ) THEN
                  IF( DR.EQ.DC) THEN
                    MAT(I+ADDA)=1
                  ELSE
                    MAT(I+ADDA)=0
                  ENDIF
                ENDIF
  120         CONTINUE
            ENDIF
          ENDIF
C**                                                                 ***
          IF (TYP .EQ. 30) THEN
	    FIRST=IAC
            IF ((M01.LE.FIRST).AND.(FIRST.LT.M01+M1)) THEN
              DO   130   I = 1,L
                DR=DMASKR(INDEX(I+INDC)+IAR-M0)
                DC=DMASKC(INDEX(I+INDC)+IAC-M01,RCVBUF)
                IF ( (DR.NE.0).OR.(DC.NE.0) ) THEN
                  IF( DR.EQ.DC) THEN
                    MAT(I+ADDA)=1
                  ELSE
                    MAT(I+ADDA)=0
                  ENDIF
                ENDIF
  130         CONTINUE
            ENDIF
          ENDIF
C**                                                                 ***
          IF (TYP .EQ. 40) THEN
	    FIRST=INDEX(I+INDC)-1
            IF ((M01.LE.FIRST).AND.(FIRST.LT.M01+M1)) THEN
              DO   140   I = 1,L
                DR=DMASKR(I+IAR-M0)
                DC=DMASKC(INDEX(I+INDC)-M01,RCVBUF)
                IF ( (DR.NE.0).OR.(DC.NE.0) ) THEN
                  IF( DR.EQ.DC) THEN
                    MAT(I+ADDA)=1
                  ELSE
                    MAT(I+ADDA)=0
                  ENDIF
                ENDIF
  140         CONTINUE
            ENDIF
          ENDIF
C**                                                                 ***
          IF (TYP .EQ. 50) THEN
	    FIRST=IAC
            IF ((M01.LE.FIRST).AND.(FIRST.LT.M01+M1)) THEN
              DO   150   I = 1,L
                DR=DMASKR(INDEX(I+INDR)-M0)
                DC=DMASKC(I+IAC-M01,RCVBUF)
                IF ( (DR.NE.0).OR.(DC.NE.0) ) THEN
                  IF( DR.EQ.DC) THEN
                    MAT(I+ADDA)=1
                  ELSE
                    MAT(I+ADDA)=0
                  ENDIF
                ENDIF
  150         CONTINUE
            ENDIF
          ENDIF
C**                                                                 ***
          IF (TYP .EQ. 60) THEN
	    FIRST=IAC+INDEX(1+INDC)-1
            IF ((M01.LE.FIRST).AND.(FIRST.LT.M01+M1)) THEN
              DO   160   I = 1,L
                DR=DMASKR(INDEX(I+INDR)+IAR-M0)
                DC=DMASKC(INDEX(I+INDC)+IAC-M01,RCVBUF)
                IF ( (DR.NE.0).OR.(DC.NE.0) ) THEN
                  IF( DR.EQ.DC) THEN
                    MAT(I+ADDA)=1
                  ELSE
                    MAT(I+ADDA)=0
                  ENDIF
                ENDIF
  160         CONTINUE
            ENDIF
          ENDIF
C**                                                                 ***
  100   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   end of processor loop                                         ***
C**   --------------------                                          ***
C**                                                                 ***
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
9980  CONTINUE
      NMSG=NMSG+NJUMP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM996----------------------------------------------------
      E    N    D
