C:::::      ,,,,,VEMAVS...                                          ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMAVS(TEXT1,TEXT2,T,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                  NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMAVS     VECFEM ===> AVS UCD file                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1997                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"

      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,
     &                  LIDPRM,LNODN,LNOD,LNOPRM,LBIG,LU
      DOUBLE PRECISION  NOD(LNOD),RPARM(LRPARM),RDPARM(LRDPRM),
     &                  NOPARM(LNOPRM),RBIG(LBIG),T,U(LU)
      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  IDPARM(LIDPRM),DNOD(LDNOD),IBIG(RPI*LBIG)
      CHARACTER*80      TEXT2,TEXT1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           MESH,UCDOUT,LOUT,NDEG,ERR,FTYPE,STEP,CASE,
     &                  DIM,NN,OUTCNT,TIDS,NPROC,N,NESUM,U1,
     &                  MYPROC,NMSG,IOTID,MYTID,NBIG,NMIN,NMAX,
     &                  IBUF,RBUF,NDEGL,NDEG0L,I,NCARD,
     &                  NGROUP,GINFO,GINFO1,NCARD1,NCELL,NDATA,
     &                  LBFIN,LBFRN,LBFN,LBFRE,LBFIE,LBFE,
     &                  LBFRR,LBFIR,LBFR,LLNGTH(16),MDATA,
     &                  NLNGTH(16),MPINFO,SBT,IH1(1),IH2(1),NU
      DOUBLE PRECISION  TIME,VEMSCD,LIMIT
      include "archi.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      TIDS=204
      LOUT=IVEM(120)
      IF ((ARCHI.LT.10).OR.(IVEM(200).EQ.1)) THEN
	IVEM(200)=1
	IVEM(201)=1
	IVEM(TIDS-1)=1
	IVEM(TIDS)=1
      ENDIF
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9300)
	IVEM(2)=99
	RETURN
      ENDIF
      ERR=0
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=LU
      TIME=VEMSCD()
      OUTCNT = IVEM(121)
      UCDOUT = IVEM(127)
      IF (LOUT.LE.0) LOUT=6
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      NBIG=0
      NCARD=0

      LIMIT=10.D0**IVEM(4)
      FTYPE=IVEM(130)
      CASE=IVEM(137)
      STEP=IVEM(138)
      U1=MAX(IVEM(128),0)
      N=MAX(IVEM(129),0)
      NDATA=N
      IF (FTYPE.EQ.1) NDATA=1
      IF (FTYPE.EQ.2) NDATA=3
      N=MIN(N,NDATA)
      NU=N*U1

      MESH=IVEM(1)
      IF (LOUT.LT.0) LOUT=6
      IF (UCDOUT.LE.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title:                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('VEMAVS',OUTCNT,LOUT)
	WRITE (LOUT,9300) 127,UCDOUT
	WRITE (LOUT,9330) 128,U1
	WRITE (LOUT,9320) 129,N
        WRITE(LOUT,9350) 130,FTYPE
        IF (FTYPE.EQ.1) THEN
           WRITE(LOUT,9351)
        ELSEIF (FTYPE.EQ.2) THEN
           WRITE(LOUT,9352)
        ELSE
           WRITE(LOUT,9353)
        ENDIF
	WRITE (LOUT,9310) 137,CASE
	WRITE (LOUT,9311) 138,STEP
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print mesh infos:                                             ***
C**   ----------------                                              ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF (U1.LT.NDEG) THEN
	ERR=99
        WRITE (LOUT,9101) MYPROC,MYTID,U1
      ENDIF
      NLNGTH(16)=NU
      CALL VEM098('VEMAVS',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      NDEG  =IVEM(MESH+1)
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      NESUM=IVEM(MESH+25)+2
      IF (STEP.LT.0) THEN
        MDATA=1
      ELSE
        MDATA=3
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute buffer sizes:                                         ***
C**   --------------------                                          ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMAX=IH1(1)
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-IH1(1)
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,I,MYPROC,NPROC)
C**                                                                 ***
      CALL VEAV00(NDEGL,DIM,NGROUP,GINFO1,IVEM(GINFO),IVEM(NESUM),
     &            N,NCELL,LBFIN,LBFRN,LBFN,
     &            LBFRE,LBFIE,LBFE,LBFRR,LBFIR,LBFR,
     &            IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),LOUT,ERR)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check the array length of IBIG:                               ***
C**   ------------------------------                                ***
C**                                                                 ***
      NBIG=(MAX(LBFE,LBFR*SBT,LBFN*SBT)+RPI-1)/RPI
      NLNGTH(4)=NBIG
      CALL VEM098('VEMAVS',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write node coordinates :                                      ***
C**   ----------------------                                        ***
C**                                                                 ***
      IBUF=1
      RBUF=(IBUF+LBFIN*SBT-1+RPI-1)/RPI+1

      NCARD1=NCARD
      CALL VEAV02(UCDOUT,NODNUM,NOD,DIM,NN,NDEG,NCELL,NDATA,MDATA,
     &            SBT,LBFIN,IBIG(IBUF),LBFRN,RBIG(RBUF),NDEGL,NDEG0L,
     &            IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),NCARD)
      IF ((MYTID.EQ.IOTID).AND.(OUTCNT.GT.0)) THEN
	 WRITE(LOUT,4050) NCARD-NCARD1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write elements:                                               ***
C**   --------------                                                ***
C**                                                                 ***
      IBUF=1
      NCARD1=NCARD
      CALL VEAV03(UCDOUT,NODNUM,NGROUP,GINFO1,IVEM(GINFO),
     &            LNEK,NEK,LIPARM,IPARM,LBFIE,IBIG(IBUF),
     &            IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),NCARD)
      IF ((MYTID.EQ.IOTID).AND.(OUTCNT.GT.0)) THEN
	 WRITE(LOUT,4060) NCARD-NCARD1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write results :                                               ***
C**   --------------                                                ***
C**                                                                 ***
      IF (N.GT.0) THEN
        IBUF=1
        RBUF=(IBUF+LBFIR*SBT-1+RPI-1)/RPI+1

        NCARD1=NCARD
        CALL VEAV07(UCDOUT,NODNUM,U,N,U1,NDEG,TEXT1,FTYPE,LIMIT,SBT,
     &              LBFIR,IBIG(IBUF),LBFRR,RBIG(RBUF),NDEGL,NDEG0L,
     &              IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),NCARD)
      ENDIF
      IF ((MYTID.EQ.IOTID).AND.(OUTCNT.GT.0)) THEN
	 WRITE(LOUT,4070) NCARD-NCARD1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write nodel id:                                               ***
C**   --------------                                                ***
C**                                                                 ***
      NCARD1=0
      IF (MYTID.EQ.IOTID) THEN
        IF (N.GT.0) THEN
          IF (STEP.LT.0) THEN
            NCARD1=3
            WRITE(UCDOUT,*) 1,1
            WRITE(UCDOUT,*) 'Load_Case,'
            WRITE(UCDOUT,'(A,1X,I7)') TEXT2(:INDEX(TEXT2,' ')-1),CASE
          ELSE
            NCARD1=5
            WRITE(UCDOUT,*) 3,1,1,1
            WRITE(UCDOUT,*) 'Load_Case,'
            WRITE(UCDOUT,*) 'Time_Step,'
            WRITE(UCDOUT,*) 'Time,'
            WRITE(UCDOUT,'(A,1X,2I7,1X,G15.5)')
     &                          TEXT2(:INDEX(TEXT2,' ')-1),CASE,STEP,T
          ENDIF
        ELSE
          NCARD1=2
          WRITE(UCDOUT,*) 0
          WRITE(UCDOUT,*) TEXT2(:INDEX(TEXT2,' ')-1)
        ENDIF

        IF (OUTCNT.GT.0) THEN 
          WRITE(LOUT,4080) NCARD1
          WRITE(LOUT,4083) NCARD+NCARD1
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMAVS',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9300  FORMAT(5X,'unit of UCD nodal result file ............... =',
     &                                          ' IVEM(',I4,') = ',I10)
9330  FORMAT(5X,'leading dimension of result array ........ U1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9320  FORMAT(5X,'number of components ...................... N =',
     &                                          ' IVEM(',I4,') = ',I10)
9310  FORMAT(5X,'load case number ....................... CASE =',
     &                                          ' IVEM(',I4,') = ',I10)
9311  FORMAT(5X,'time step number ....................... STEP =',
     &                                          ' IVEM(',I4,') = ',I10)
9350  FORMAT(5X,'file format ........................... FTYPE =',
     &                                          ' IVEM(',I4,') = ',I10)
9353  FORMAT(8X,'> unknown')
9351  FORMAT(8X,'> scalar')
9352  FORMAT(8X,'> vector')
4050  FORMAT(/3X,'write node coordinates ......... cards =',I8)
4060  FORMAT(3X,'write cells .................... cards =',I8)
4070  FORMAT(3X,'write nodal results ............ cards =',I8)
4080  FORMAT(3X,'write model id ................. cards =',I8)
4083  FORMAT(3X,'total number of cards ................ =',I8)
9101  FORMAT('>>VEMCD:02:9998'/
     &       '>>VEMAVS error on process ',I10,' (TID=',I10,')'/
     &       '>>U1 = ',I10,' is defective!')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMAVS ---------------------------------------------------
      E    N    D
