C:::::      ,,,,,VEMDIS...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMDIS (LIVEM,IVEM,LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                   LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                   LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                   LBIG,RBIG,IBIG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMDIS    distribute the element mesh to the processors    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"
      include "archi.h"

      INTEGER           LIVEM,LBIG,LNODN,LNOPRM,
     &                  LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,LIDPRM,LNOD

      DOUBLE PRECISION  RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                  IDPARM(LIDPRM),IBIG(RPI*LBIG),NODNUM(LNODN)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                    >                                            ***
      DOUBLE PRECISION  TIME,VEMSCD
      INTEGER           LOUT,OUTCNT,NK,DIM,NN,NGROUP,NDEG,
     &                  DINFO1,DINFO,GINFO1,GINFO,MESH,NOP,NOP1,
     &                  M,OWN,ORDER,DIS,M0,TOTNE,AMOU,AMOU2
      INTEGER           LOAD,PIND,NWNEK1,WORK1,WORK2,IWORK,RWORK,
     &                  DCCOUN,MASK,NODNU2,LBF,MASKBF,PDIND,
     &                  NODBF,LMATBK,JUMP,NJUMP,MASK1,PNEK,NPNEK,
     &                  PTRMBK,BLKLST,PERM,BLK,NBLK,SORTI,PMASK,LOADI,
     &                  NIBUF,NRBUF,IBUF,RBUF,NISAVE,NRSAVE,
     &                  NIDBUF,NRDBUF,IDBUF,RDBUF,MPINFO,SBT,
     &                  NECOU,ISAVE,RSAVE,TOTDC,LOOP,LDBUF
      INTEGER           ERR,IERR,I,Z,G,INTH1(2),INTH3(2),INTH2(2)
      INTEGER           NPROC,MYPROC,IOTID,MYTID,NMSG,TIDS
      INTEGER           LMMIN,LMMAX,MMIN,MMAX,NMIN,NMAX,LM,NDEG2,
     &                  NDEGL,NDEG0L,LMM
      INTEGER           NIVEM,NNOD,NNEK,NRPARM,NIPARM,NDNOD,NNOPRM,
     &                  NRDPRM,NIDPRM,NBIG,NNODN,LLNGTH(16),NLNGTH(16)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**                                                                 ***
      LOUT=IVEM(80)
      TIDS=204
      IF ((ARCHI.LT.10).OR.(IVEM(200).EQ.1)) THEN
	IVEM(200)=1
	IVEM(201)=1
	IVEM(TIDS-1)=1
	IVEM(TIDS)=1
      ENDIF
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9310)
	IVEM(2)=99
	RETURN
      ENDIF
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=0
      TIME=VEMSCD()
      IF (IVEM(80).LE.0) IVEM(80)=6
      IVEM(81)=MAX(IVEM(81),0)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      MESH=IVEM(1)
      OUTCNT=IVEM(81)
      ORDER=IVEM(51)
      ERR=0
      NBIG=0

      IF (OUTCNT.NE.0) THEN
	CALL VEM000('VEMDIS',OUTCNT,LOUT)
        WRITE(LOUT,9200) 80,LOUT
        WRITE(LOUT,9210) 81,OUTCNT
        WRITE(LOUT,9220) 51,ORDER
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check input parameters:                                       ***
C**   ----------------------                                        ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,0,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      CALL VEM098('VEMDIS',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch infos :                                                 ***
C**   -----------                                                   ***
C**                                                                 ***
      NDEG  =IVEM(MESH+ 1)
      NK    =IVEM(MESH+ 2)
      DIM   =IVEM(MESH+ 3)
      NGROUP=IVEM(MESH+ 4)
      NN    =IVEM(MESH+ 5)
      NOP1  =IVEM(MESH+ 13)
      NOP   =IVEM(MESH+ 14)
      OWN   =IVEM(MESH+ 15)
      DIS   =IVEM(MESH+18)
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      DINFO =IVEM(MESH+23)+MESH
      DINFO1=IVEM(MESH+24)
      NIVEM= MESH+IVEM(MESH+12)-1
      NBIG=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create the geometrical mesh in the global numbering :         ***
C**   ---------------------------------------------------           ***
C**                                                                 ***
      NNEK=IVEM(MESH+6)
      NDNOD=IVEM(MESH+9)
      CALL VEM300(OWN,DIS,NGROUP,GINFO1,IVEM(GINFO),NNEK,LNEK,NEK,
     &            NK,DINFO1,IVEM(DINFO),NDNOD,LDNOD,DNOD,
     &            NDEG,NODNUM,LMMIN,LMMAX)
      IVEM(MESH+9)=NDNOD
      IVEM(MESH+6)=NNEK
      NLNGTH(8)=NNEK
      NLNGTH(11)=NDNOD
      INTH1(1)=LMMAX
      INTH1(2)=-LMMIN
      CALL LL4INM(1,2,1,INTH1,INTH2,INTH3,MYPROC,NPROC,
     &                                           IVEM(TIDS),IVEM(NMSG))
      MMAX=INTH2(1)
      MMIN=-INTH2(2)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** find maximal and minimal global geometrical node number :     ***
C**   -------------------------------------------------------       ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMAX,INTH1,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      DO 5000 I=1,NDEG
5000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMIN,INTH1,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-NMIN
      DO 5001 I=1,NDEG
5001    NODNUM(I)=-NODNUM(I)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compact the global node numbers :                             ***
C**   ---------------------------------                             ***
C**                                                                 ***
      CALL VEM301(MMIN,MMAX,M,M0,LM,MYPROC,NPROC)
      IF (OUTCNT.NE.0) THEN
         WRITE(LOUT,9304)
         WRITE(LOUT,9240) NMIN
         WRITE(LOUT,9230) NMAX
         WRITE(LOUT,9241) MMIN
         WRITE(LOUT,9231) MMAX
         WRITE(LOUT,9300)
      ENDIF

      MASK=1
      NBIG=MAX(NBIG,((MAX(NGROUP,LM,NDEG,LDNOD)+2)*SBT+RPI-1)/RPI)
      NLNGTH(4)=NBIG
      CALL VEM098('VEMDIS',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999

      CALL VEM302(NGROUP,GINFO1,IVEM(GINFO),NK,DINFO1,IVEM(DINFO),
     &            M,M0,LM,MMIN,MMAX,LNEK,NEK,LDNOD,DNOD,
     &            LRDPRM,RDPARM,LIDPRM,IDPARM,SBT,
     &            MAX(LM,LDNOD)+2,IBIG(MASK),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**  MMIN and MMAX have get a new value                             ***
C**                                                                 ***
      CALL VEM301(MMIN,MMAX,M,M0,LMM,MYPROC,NPROC)
      IF (OUTCNT.NE.0) THEN
         WRITE(LOUT,9241) MMIN
         WRITE(LOUT,9231) MMAX
         WRITE(LOUT,9301)
         WRITE(LOUT,9242) M
         WRITE(LOUT,9243) M0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** storage check :                                               ***
C**   ---------------                                               ***
C**                                                                 ***
      TOTNE=0
      DO 1238 G=1,NGROUP
1238     TOTNE=IVEM(GINFO+GINFO1*(G-1))+TOTNE
      TOTDC=0
      DO 1237 G=1,NK
1237     TOTDC=IVEM(DINFO+DINFO1*(G-1))+TOTDC

      JUMP=1
      LMATBK=JUMP+NPROC
      PTRMBK=LMATBK+NPROC
      PNEK=PTRMBK+NPROC
      NPNEK=IVEM(MESH+6)
	
      MASK=PNEK+NPNEK
      NBIG=MAX(NBIG,(MASK-1+MAX(2*NPROC,LMM)+RPI-1)/RPI)
	
      PIND=PNEK+NPNEK
      PDIND=PIND+TOTNE

      LOADI=PDIND+TOTDC
      LOAD=LOADI+1
      NWNEK1=LOAD+NGROUP+1
      DCCOUN=NWNEK1+NGROUP
      PMASK=DCCOUN+NK
      LDBUF=PMASK+NPROC
      WORK1=LDBUF+MAX(2+NGROUP,NK+NGROUP)*SBT
      WORK2=WORK1+MAX(TOTNE,M,TOTDC)
      NBIG=MAX(NBIG,(WORK2-1+TOTNE+RPI-1)/RPI)
	
      NLNGTH(4)=NBIG
      CALL VEM098('VEMDIS',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the comunication index is created and PNEK is computed:       ***
C**   ------------------------------------------------------        ***
C**                                                                 ***
      CALL VEM330(NGROUP,GINFO1,IVEM(GINFO),NPNEK,NEK,IBIG(PNEK),
     &            M,NJUMP,IBIG(JUMP),IBIG(LMATBK),IBIG(PTRMBK),
     &            IBIG(MASK),MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF (OUTCNT.NE.0) THEN
         WRITE(LOUT,9303)
         WRITE(LOUT,9250) NJUMP
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the load on the processes:                            ***
C**   ---------------------------------                             ***
C**                                                                 ***
      CALL VEM303(NGROUP,GINFO1,IVEM(GINFO),ORDER,IBIG(LOAD),
     &            AMOU,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),LOUT,IERR)
      IF (IERR.NE.0) ERR=99

      IF (OUTCNT.NE.0) THEN
         WRITE(LOUT,9244) 1,IBIG(LOAD)
	 DO 20 I=2,NGROUP
 20        WRITE(LOUT,9245) I,IBIG(LOAD-1+I)
         WRITE(LOUT,9246) AMOU
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** mark the process for the elements                             ***
C**   --------------------------------                              ***
C**                                                                 ***
      IBIG(LOADI)=AMOU
      CALL VEM310(NGROUP,GINFO1,IVEM(GINFO),TOTNE,IBIG(PIND),NJUMP,
     &            IBIG(JUMP),IBIG(PNEK),IBIG(LOADI),IBIG(WORK1),
     &            IBIG(WORK2),IBIG(PMASK),LOOP,SBT,IBIG(LDBUF),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** mark the process for the Dirchlet conditions :                ***
C**   --------------------------------------------                  ***
C**                                                                 ***
      CALL VEM314(NK,DINFO1,IVEM(DINFO),DNOD,TOTDC,IBIG(PDIND),
     &            NPROC,IBIG(LMATBK),IBIG(PTRMBK))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check storage for element distribution :                      ***
C**   --------------------------------------                        ***
C**                                                                 ***
      CALL VEM313(NGROUP,GINFO1,IVEM(GINFO),IBIG(PIND),NNEK,
     &            NRPARM,NIPARM,NIBUF,NRBUF,IBIG(NWNEK1),
     &            NK,DINFO1,IVEM(DINFO),IBIG(PDIND),
     &            NDNOD,NRDPRM,NIDPRM,NIDBUF,NRDBUF,IBIG(DCCOUN),
     &            NISAVE,NRSAVE,SBT,NGROUP+NK,IBIG(LDBUF),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))

      AMOU2=IBIG(LOADI)
      INTH1(1)=ABS(100*(AMOU-AMOU2))/MAX(AMOU,1)
      CALL LL4INM(1,1,1,INTH1,INTH2,INTH3,MYPROC,NPROC,
     &                                           IVEM(TIDS),IVEM(NMSG))
      IF (OUTCNT.NE.0) THEN
         WRITE(LOUT,9251) LOOP
         WRITE(LOUT,9247) AMOU2
         WRITE(LOUT,9248) (100*(AMOU-AMOU2))/MAX(AMOU,1)
         WRITE(LOUT,9252) INTH2(1)
      ENDIF

      NECOU=WORK2
      ISAVE=NECOU+MAX(NGROUP,NK)
      RSAVE=(ISAVE-1+NISAVE+RPI-1)/RPI+1
      IBUF=(RSAVE-1+NRSAVE)*RPI+1
      RBUF=(IBUF+NIBUF*SBT-1+RPI-1)/RPI+1
      NBIG=MAX(NBIG,RBUF-1+NRBUF*SBT)

      IDBUF=(RSAVE-1+NRSAVE)*RPI+1
      RDBUF=(IDBUF+NIDBUF*SBT-1+RPI-1)/RPI+1
      NBIG=MAX(NBIG,RDBUF-1+NRDBUF*SBT)
      NLNGTH(4)=NBIG

      NNEK=MAX(NNEK,IVEM(MESH+6))
      NRPARM=MAX(NRPARM,IVEM(MESH+7))
      NIPARM=MAX(NIPARM,IVEM(MESH+8))
      IVEM(MESH+6)=NNEK
      IVEM(MESH+7)=NRPARM
      IVEM(MESH+8)=NIPARM
      NLNGTH(8)=NNEK
      NLNGTH(9)=NIPARM
      NLNGTH(10)=NRPARM

      NDNOD=MAX(NDNOD,IVEM(MESH+9))
      NRDPRM=MAX(NRDPRM,IVEM(MESH+10))
      NIDPRM=MAX(NIDPRM,IVEM(MESH+11))
      IVEM(MESH+9)=NDNOD
      IVEM(MESH+10)=NRDPRM
      IVEM(MESH+11)=NIDPRM
      NLNGTH(11)=NDNOD
      NLNGTH(12)=NIDPRM
      NLNGTH(13)=NRDPRM

      CALL VEM098('VEMDIS',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the elements are distributed                              ***
C**   --------------------------------                              ***
C**                                                                 ***
      CALL VEM311(NGROUP,GINFO1,IVEM(GINFO),TOTNE,IBIG(PIND),
     &            LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &            IBIG(NWNEK1),IBIG(NECOU),IBIG(WORK1),
     &            NRSAVE,RBIG(RSAVE),NISAVE,IBIG(ISAVE),SBT,
     &            NRBUF,RBIG(RBUF),NIBUF,IBIG(IBUF),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the dirichlet conditions are distributed                  ***
C**   --------------------------------------------                  ***
C**                                                                 ***
      CALL VEM312(NK,DINFO1,IVEM(DINFO),TOTDC,IBIG(PDIND),
     &            LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &            IBIG(DCCOUN),IBIG(NECOU),IBIG(WORK1),
     &            NRSAVE,RBIG(RSAVE),NISAVE,IBIG(ISAVE),SBT,
     &            NRDBUF,RBIG(RDBUF),NIDBUF,IBIG(IDBUF),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the geometrical nodes are distributed :                   ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      NODNU2=PTRMBK+NPROC
      LBF=LBIG*RPI-NODNU2+1
      CALL VEM320(NGROUP,GINFO1,IVEM(GINFO),NK,DINFO1,IVEM(DINFO),
     &            LNEK,NEK,LDNOD,DNOD,LBF,IBIG(NODNU2),NDEG2)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,LM,MYPROC,NPROC)
      IF (OUTCNT.NE.0) THEN
         WRITE(LOUT,9302)
         WRITE(LOUT,9249) NDEG2
      ENDIF

      NNOD=MAX(NDEG2,NN)*DIM
      NNOPRM=MAX(NDEG2,NOP1)*NOP
      NNODN=MAX(NDEG,NDEG2)
      NLNGTH(5)=NNODN
      NLNGTH(6)=NNOD
      NLNGTH(7)=NNOPRM

      LBF=LM*(DIM+NOP)
      MASKBF=NODNU2+NDEG2
      NODBF=(MASKBF+(2+LM)*SBT-1+RPI-1)/RPI+1
      NBIG=MAX(NBIG,NODBF-1+LBF*SBT)
      NLNGTH(4)=NBIG
      CALL VEM098('VEMDIS',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999

      CALL VEM321(NDEG,LNODN,NODNUM,DIM,NN,LNOD,NOD,NOP,NOP1,
     &            LNOPRM,NOPARM,NDEG2,IBIG(NODNU2),
     &            NDEGL,NDEG0L,SBT,LM,IBIG(MASKBF),RBIG(NODBF),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),IERR,LOUT)
      IF (IERR.NE.0) ERR=99
      IVEM(MESH+5)=NN
      IVEM(MESH+13)=NOP1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Storage check for blocking:                                   ***
C**   ---------------------------                                   ***
C**                                                                 ***
      TOTNE=0
      DO 1239 G=1,NGROUP
1239     TOTNE=IVEM(GINFO+GINFO1*(G-1))+TOTNE
      BLKLST=PTRMBK+NPROC
      BLK=BLKLST+NGROUP
      PERM=BLK+TOTNE
      MASK1=PERM+TOTNE
      RWORK=(MASK1-1+LMM+RPI-1)/RPI+1
      IWORK=(RWORK-1)*RPI+1
      NBIG=MAX(NBIG,RWORK-1+TOTNE)

      NLNGTH(4)=NBIG
      CALL VEM098('VEMDIS',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** block the elements:                                           ***
C**   ------------------                                            ***
C**                                                                 ***
      CALL VEM350 (NGROUP,GINFO1,IVEM(GINFO),LNEK,NEK,
     &             LRPARM,RPARM,LIPARM,IPARM,MYPROC,NJUMP,
     &             IBIG(JUMP),NPROC,IBIG(LMATBK),IBIG(PTRMBK),
     &             IBIG(BLKLST),NBLK,IBIG(BLK),TOTNE,IBIG(PERM),
     &             LMM,IBIG(MASK1),IBIG(IWORK),RBIG(RWORK),OUTCNT,LOUT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy comunication index and blk-infos to ivem                 ***
C**   ---------------------------------------------                 ***
C**                                                                 ***
      SORTI=DINFO+DINFO1*NK-MESH+1
      NIVEM=MAX(MESH+SORTI-1+2+3*NPROC+NGROUP+NBLK,NIVEM)
      NLNGTH(1)=NIVEM
      CALL VEM098('VEMDIS',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999

      IVEM(MESH+18)=220964
      IVEM(MESH+19)=SORTI
      IVEM(MESH+12)=MAX(IVEM(MESH+12),SORTI+1+NBLK+NPROC*3+NGROUP)
      SORTI=SORTI+MESH
      IVEM(SORTI)=NJUMP
      IVEM(SORTI+1)=NBLK
      IVEM(MESH+16)=0
      DO 300 Z=1,NPROC
        IVEM(SORTI+1+Z)=IBIG(JUMP-1+Z)
	M=IBIG(LMATBK-1+Z)*(NK-MAX(OWN,1)+1)
        IVEM(SORTI+1+NPROC+Z)=M
        IVEM(MESH+16)=MAX(M,IVEM(MESH+16))
300     IVEM(SORTI+1+2*NPROC+Z)=IBIG(PTRMBK-1+Z)*(NK-MAX(OWN,1)+1)
      DO 301 Z=1,NGROUP
301      IVEM(SORTI+1+3*NPROC+Z)=IBIG(BLKLST-1+Z)
      DO 302 Z=1,NBLK
302      IVEM(SORTI+1+3*NPROC+NGROUP+Z)=IBIG(BLK-1+Z)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print end cards :                                             ***
C**   ---------------                                               ***
C**                                                                 ***
9999  CONTINUE
      IVEM(5)=NIVEM
      IVEM(MESH+1)=NDEG
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMDIS',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9200  FORMAT('    line output to unit .................... LOUT =',
     &                                           ' IVEM(',I4,') =',I10)
9210  FORMAT('    output control ....................... OUTCNT =',
     &                                           ' IVEM(',I4,') =',I10)
9220  FORMAT('    order of integration formulas ......... ORDER =',
     &                                           ' IVEM(',I4,') =',I10)
9230  FORMAT('    maximal geometrical node id ................. =',I10)
9231  FORMAT('    maximal global node id ...................... =',I10)
9240  FORMAT('    minimal geometrical node id ................. =',I10)
9241  FORMAT('    minimal global node id ...................... =',I10)
9242  FORMAT('    number of global nodes on processor ....... M =',I10)
9243  FORMAT('    first global node id on processor ........ M0 =',I10)
9244  FORMAT('    amount LOAD per element in group ',I3,
     &                                               ' ........ =',I10)
9245  FORMAT('                               group ',I3,
     &                                               ' ........ =',I10)
9246  FORMAT('    available amount on process ................. =',I10)
9247  FORMAT('    real amount on process ...................... =',I10)
9248  FORMAT('               discrepancy .................. (%) =',I10)
9252  FORMAT('       maximal discrepancy .................. (%) =',I10)
9249  FORMAT('    number of geometrical nodes on process ...... =',I10)
9250  FORMAT('    number of communication jumps ......... NJUMP =',I10)
9251  FORMAT('    number of distribution loops ................ =',I10)
9300  FORMAT('  compacting of global node numbers.')
9301  FORMAT('  distribution of mesh.')
9302  FORMAT('  compacting of geometrical node numbers.')
9303  FORMAT('  create communication index.')
9304  FORMAT('  start configuration.')
9310  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMDIS----------------------------------------------------
      E    N    D
