C:::::     ,,,,,VEME00...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEME00 (T,LU,U,LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &                   LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                   LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                   NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG,
     &                   MASKL,MASKF,USERB,USERL,USERF,
     &                   VEM50X,VEM63X)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEME00  main routine for the solution of linear and steady   ***
C**            functional equations.                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**   All length in IBIG and RBIG in length of REAL variables !     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   Parameters :                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      include "bytes.h"

      INTEGER          LU,LIVEM,LLVEM,LRVEM,LBIG,LNOPRM,LNODN,
     &                 LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,LIDPRM,LNOD

      DOUBLE PRECISION T,U(LU),RVEM(LRVEM),RPARM(LRPARM),RDPARM(LRDPRM),
     &                 NOD(LNOD),NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER          IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                 NODNUM(LNODN),IDPARM(LIDPRM),IBIG(RPI*LBIG)

      LOGICAL          LVEM(LLVEM),MASKL(*),MASKF(*)

      EXTERNAL         USERB,USERL,USERF
      EXTERNAL         VEM50X,VEM63X
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Parameters : see 'man veme00(3)'                      ***
C**   ------------------                                            ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** dimension of the management vector :                          ***
C**   -----------------------------------                           ***
C**                                                                 ***
      INTEGER           NOPER,MOUNT1,LREC0
      PARAMETER        (MOUNT1=9,NOPER=1,LREC0=0)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   Variables :                                                   ***
C**   ----------                                                    ***
C**                    >                                            ***
      DOUBLE PRECISION  VEMSCD,TIME,HTIME,ZERO

      INTEGER           I,J,IERR,ICONV
      INTEGER           LOUT,STEP,OUTCNT,MESH,ERR,NK,DIM,NGROUP,NN,
     &                  NRHS,NDEG,GINFO,GINFO1,DINFO,DINFO1,
     &                  M0,NJUMP,LMATBK,PTRMBK,SORTI,BLKLST,BLK,NBLK,
     &                  JUMP,OWN,PCLASS,MSPACK,SPACE,LSPACE,SPACE2,
     &                  NOP,NOP1,ORDER(NOPER),OPER(NOPER),TIDS,
     &                  NMSG,NPROC,MYPROC,IOTID,MYTID,MPINFO,SBT,
     &                  LM,IL1,IL2,STEML,STMOL,STDIL,STLIN,N,
     &                  PTRVTS,INFOL,NVTYP,TC,TCALL,P,PNEW,LREC,HERE,
     &                  TNDC,LDC,LCOND,LI800,LR800,INDL,ADDL,MATL,MATK,
     &                  ILIN,NVT,NKN,COMIND,DINDEX,NUBUF,NLOCU,NELEMD,
     &                  MOUNTL,RMOUNL,NADDL,NEML,LLNGTH(16),NLNGTH(16),
     &                  PTRMAT(2),LRPREC,LIPREC
      INTEGER           NIVEM,NRVEM,NLVEM,NBIG,NINFO,NINDEX,NMAT
      INTEGER           LSYM,STARTU,LMASKL,FMASKL
      INTEGER           INDEX,MATRI,ADDRE,LINDEX,LMATRI,LADDRE,
     &                  LWORK,F,RWORK,IWORK,LOCU,BUF,EM,RPREC,IPREC
      INTEGER           X,B,WORK2,DNOPRM,DMASKR,DMASKC

      INTEGER           EPS,EPSLIN,NORMU,NORMF,TTOT,TADD,TELEM,
     &                  TMOUNT,TLIN,TPAGE,TRUN,MINU,MAXU,WORKN

      LOGICAL           SYM(NOPER)
      EXTERNAL          DUMMY,LL6AX
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT=IVEM(40)
      TIME=VEMSCD()
      LLNGTH(1)=LIVEM
      LLNGTH(2)=LRVEM
      LLNGTH(3)=LLVEM
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=LU
      LLNGTH(15)=0
      LLNGTH(16)=0
      IF (IVEM(40).LE.0) IVEM(40)=6
      IVEM(41)=MAX(IVEM(41),0)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9350)
	IVEM(2)=99
	RETURN
      ENDIF

      MESH=IVEM(1)
      STEP=IVEM(3)
      OUTCNT=MAX(IVEM(41),0)
      ZERO=0
      NIVEM=0
      NRVEM=0
      NLVEM=0
      NBIG=0
      CALL VEM000('VEME00',OUTCNT,LOUT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check the input data :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      CALL VEM601(.FALSE.,LIVEM,IVEM,RVEM,LRVEM,LLVEM,LVEM,
     &            MYPROC,MYTID,ERR)
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      CALL VEM098('VEME00',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) THEN
        TIME=0
        GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch parameters from IVEM :                                  ***
C**   --------------------------                                    ***
C**                                                                 ***
      NDEG=IVEM(MESH+1)
      NK=IVEM(MESH+2)
      DIM=IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN=IVEM(MESH+5)
      NINFO=IVEM(MESH+12)
      NOP1=IVEM(MESH+13)
      NOP=IVEM(MESH+14)
      OWN=IVEM(MESH+15)
      LM=IVEM(MESH+16)
      SORTI=IVEM(MESH+19)+MESH
      GINFO=IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      DINFO=IVEM(MESH+23)+MESH
      DINFO1=IVEM(MESH+24)

      NJUMP=IVEM(SORTI)
      NBLK=IVEM(SORTI+1)
      JUMP=SORTI+2
      LMATBK=JUMP+NPROC
      PTRMBK=LMATBK+NPROC
      BLKLST=JUMP+3*NPROC
      BLK=BLKLST+NGROUP

      NRHS=IVEM(52)
      IF (STEP.EQ.1) THEN
        SPACE=IVEM(8)
        LSPACE=IVEM(9)
      ELSE
        SPACE=1
        LSPACE=LBIG
	IVEM(6)=0
	IVEM(7)=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set start addresses for information in IVEM :                 ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      TC=MESH+NINFO
      TCALL=TC+1
      P=TCALL+1
      PNEW=P+1
      LREC=PNEW+1
      HERE=LREC+1
      TNDC=HERE+LREC0
      LDC=TNDC+1
      LCOND=LDC+1
      LRPREC=LCOND+1
      LIPREC=LRPREC+1
      LI800=LIPREC+1
      LR800=LI800+1
      INDL=LR800+1
      ADDL=INDL+4
      MATL=ADDL+4
      MATK=MATL+4
      ILIN=MATK+4
      NVT=ILIN+4
      NKN=ILIN+100
      COMIND=NKN+NK
      DINDEX=COMIND+LM
      NUBUF=DINDEX+IVEM(MESH+9)
      NLOCU=NUBUF+1
      NELEMD=NLOCU+1
      MOUNTL=NELEMD+1
      RMOUNL=MOUNTL+NOPER*MOUNT1*NGROUP
      NADDL=RMOUNL+NOPER*1
      NEML=NADDL+NOPER*1
      NIVEM=NEML+NOPER*1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set start addresses for informations in LVEM :                ***
C**   --------------------------------------------                  ***
C**                                                                 ***
      LSYM=1
      STARTU=5
      LMASKL=21+2*NK
      FMASKL=LMASKL+NK*NK*NGROUP*NOPER
      NLVEM=FMASKL+NK*NRHS*NGROUP*NOPER-1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set start addresses for informations in RVEM :                ***
C**   ---------------------------------------------                 ***
C**                                                                 ***
      EPS=2
      EPSLIN=3
      MINU=20
      MAXU=MINU+NK*NRHS
      NORMU=MAXU+NK*NRHS
      NORMF=NORMU+NK*NRHS
      TTOT=NORMF+NK*NRHS
      TADD=TTOT+1
      TELEM=TADD+1
      TMOUNT=TELEM+1
      TLIN=TMOUNT+1
      TPAGE=TLIN+1
      TRUN=TPAGE+1
      WORKN=TRUN+1
      NRVEM=WORKN+2*NK-1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** are the information vectors large enough ?                    ***
C**   ----------------------------------------                      ***
C**                                                                 ***
      NLNGTH(1)=NIVEM
      NLNGTH(2)=NRVEM
      NLNGTH(3)=NLVEM
      NLNGTH(14)=LM
      CALL VEM098('VEME00',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) THEN 
        TIME=VEMSCD()-TIME
        GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C***** initialize timers :                                          ***
C**    -----------------                                            ***
C**                                                                 ***
       RVEM(TADD )=0
       RVEM(TELEM)=0
       RVEM(TMOUNT)=0
       RVEM(TLIN )=0
       RVEM(TPAGE)=0
       RVEM(TTOT )=0
       RVEM(TRUN )=-TIME
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy masks into LVEM :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      IF (STEP.EQ.0) THEN
        DO 10 I=1,NK*NK*NGROUP
          LVEM(LMASKL-1+I)=MASKL(I)
10      CONTINUE
        DO 11 I=1,NK*NRHS*NGROUP
          LVEM(FMASKL -1+I)=MASKF(I)
11      CONTINUE
        CALL VEM610(NOPER,SYM,NK,NGROUP,LVEM(LMASKL))
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the storage and managment infos for element matrices  ***
C**   ------------------------------------------------------------  ***
C**                                                                 ***
      IF (STEP.EQ.0) THEN
        OPER(1)=0
        ORDER(1)=IVEM(51)
        SYM(1)=LVEM(LSYM)
        CALL VEM620(NGROUP,NK,DIM,NOP,OWN,
     &             GINFO1,IVEM(GINFO),ORDER,NRHS,NOPER,
     &             OPER,SYM,LVEM(LMASKL),LVEM(FMASKL),
     &             IVEM(NADDL),MOUNT1,IVEM(MOUNTL),
     &             IVEM(RMOUNL),IVEM(NEML),IVEM(NLOCU),IVEM(NUBUF),
     &             DINFO1,IVEM(DINFO),IVEM(LDC),IVEM(NELEMD),
     &             VEM63X,NPROC,IVEM(LMATBK),MYPROC,MYTID,LOUT,ERR)
	IF (ERR.GT.0) ERR=99 

        IVEM(ADDL  )=LBIG-IVEM(NADDL)+1
        IVEM(ADDL+1)=IVEM(NADDL)
        IVEM(ADDL+2)=IVEM(11)
        IVEM(ADDL+3)=1
        IVEM(INDL)=1
C**                                                                 ***
C****** enough storage for VEM700 and VEM608 ?                      ***
C**                                                                 ***
        NBIG=MAX(NBIG,((20*LM+2*LM*NJUMP)+RPI-1)/RPI+IVEM(ADDL+1))

	NLNGTH(4)=NBIG
        CALL VEM098('VEME00',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &              LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &              IVEM(19),OUTCNT,LOUT)
        IF (ERR.GT.0) GOTO 1000
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create Dirchlet and component index                           ***
C**   -----------------------------------                           ***
C**                                                                 ***
      IF (STEP.EQ.0) THEN
        IWORK=(IVEM(INDL)-1)*RPI+1
        RVEM(TADD)=RVEM(TADD)-VEMSCD()
        CALL VEM608(OWN,NGROUP,GINFO1,IVEM(GINFO),NEK,
     &              NK,DINFO1,IVEM(DINFO),DNOD,IVEM(NKN),
     &              IVEM(COMIND),IVEM(DINDEX),IVEM(TNDC),
     &              LM,IBIG(IWORK),
     &              NJUMP,IVEM(JUMP),NPROC,IVEM(LMATBK),IVEM(PTRMBK),
     &              MYPROC,IVEM(TIDS),IVEM(NMSG))
        RVEM(TADD)=RVEM(TADD)+VEMSCD()
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Pack the global matrix :                                      ***
C**   -----------------------                                       ***
C**                                                                 ***
      IF (STEP.EQ.0) THEN
        PCLASS=IVEM(46)
        MSPACK=IVEM(45)
        INDEX=(IVEM(INDL)-1)*RPI+1
        LINDEX=(IVEM(ADDL)-IVEM(INDL))*RPI
        ADDRE=(IVEM(ADDL)-1)*RPI+1
        LADDRE=IVEM(ADDL+1)*RPI
        RVEM(TADD)=RVEM(TADD)-VEMSCD()
        CALL VEM700(OWN,NGROUP,GINFO1,IVEM(GINFO),
     &              LVEM(LSYM),NK,LVEM(LMASKL),NEK,
     &              PCLASS,MSPACK,MOUNT1,IVEM(MOUNTL),
     &              LADDRE,IBIG(ADDRE),NINDEX,N,LINDEX,IBIG(INDEX),
     &              NMAT,IVEM(NVT),
     &              NJUMP,IVEM(JUMP),NPROC,IVEM(LMATBK),IVEM(PTRMBK),
     &              MYPROC,IVEM(TIDS),IVEM(NMSG),OUTCNT,IERR,LOUT)
        RVEM(TADD)=RVEM(TADD)+VEMSCD()

        IVEM(INDL+1)=(NINDEX+RPI-1)/RPI
        IVEM(INDL+2)=IVEM(10)
        IVEM(INDL+3)=1

        IVEM(MATL+1)=NMAT
        IVEM(MATL+2)=0
        IVEM(MATL+3)=1

        N=(N+RPI-1)/RPI
        NBIG=MAX(NBIG,N+IVEM(ADDL+1))
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Set the storage and the informations for linsol :             ***
C**   -----------------------------------------------               ***
C**                                                                 ***
      IF (STEP.EQ.0) THEN
	IF (IERR.GT.0) THEN
	  IVEM(LIPREC)=0
	  IVEM(LRPREC)=0
	  IVEM(LI800)=0
	  IVEM(LR800)=0
        ELSE
          IVEM(ILIN   )=IVEM(70)
          IVEM(ILIN+ 1)=IVEM(72)
          IVEM(ILIN+ 6)=0
          IVEM(ILIN+ 7)=0
          IVEM(ILIN+ 8)=0
          IVEM(ILIN+11)=LOUT
          IVEM(ILIN+12)=OUTCNT
          IVEM(ILIN+14)=IVEM(71)
          IVEM(ILIN+15)=4711
          IVEM(ILIN+16)=MYPROC
	  IF (LVEM(9)) THEN
            IVEM(ILIN+17)=0
          ELSE
            IVEM(ILIN+17)=1
          ENDIF
	  IF ((IVEM(73).LT.100).AND.(IVEM(73).GT.20)) THEN
	    IVEM(ILIN+18)=01000
	    IVEM(ILIN+22)=IVEM(73)
          ELSE
	    IVEM(ILIN+18)=00000
	    IVEM(ILIN+22)=6
 	  ENDIF
          IVEM(ILIN+19)=0000
          IVEM(ILIN+20)=6
          IVEM(ILIN+21)=6
	  CALL VEM950(NPROC,LM,IVEM(ILIN),IVEM(MATL+1),IVEM(INDL+1),
     &                IVEM(LIPREC),IVEM(LRPREC),
     &                IVEM(LI800),IVEM(LR800))
	  IVEM(LI800)=(IVEM(LI800)+RPI-1)/RPI
	  IVEM(LIPREC)=(IVEM(LIPREC)+RPI-1)/RPI
        ENDIF
	IVEM(LCOND)=IVEM(LIPREC)+IVEM(LRPREC)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check the storage for RBIG  :                                 ***
C**   ---------------------------                                   ***
C**                                                                 ***
      IF (IERR.EQ.0) THEN
	STEML=IVEM(NEML)+IVEM(RMOUNL)+IVEM(NLOCU)
	STMOL=IVEM(NEML)+SBT*(LM*NRHS+IVEM(MATL+1))+IVEM(ADDL+1)
	STDIL=IVEM(INDL+1)+IVEM(NELEMD)+LM*NRHS*SBT+IVEM(MATL+1)
	STLIN=IVEM(INDL+1)+IVEM(LI800)+IVEM(LR800)+
     &        IVEM(LCOND)+LM*NRHS*SBT+IVEM(MATL+1)
        NBIG=MAX(NBIG,STEML,STMOL,STDIL,STLIN)
      ENDIF
      NLNGTH(4)=NBIG
      CALL VEM098('VEME00',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &             LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 1000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** is the index written to external data set ?                   ***
C**   -----------------------------------------                     ***
C**                                                                 ***
      IF ((MAX(STEML,STMOL)+IVEM(INDL+1).GT.LBIG)
     &                                 .AND.(IVEM(INDL+3).EQ.1)) THEN
        RVEM(TPAGE)=RVEM(TPAGE)-VEMSCD()
        CALL VEM690(IVEM(INDL+1),RBIG(IVEM(INDL)),IVEM(INDL+2),ERR)
        RVEM(TPAGE)=RVEM(TPAGE)+VEMSCD()
        IF (ERR.GT.0) THEN
	  WRITE (LOUT,9101) MYPROC,MYTID,IVEM(INDL+1)*IREAL,
     &                                                  IVEM(INDL+2)
        ELSE
          IF (OUTCNT.NE.0)
     &               WRITE(LOUT,9150) IVEM(INDL+1)*IREAL,IVEM(INDL+2)
        ENDIF
        IVEM(INDL+3)=0
	SPACE=1
      ELSE
        ERR=0
        SPACE=IVEM(INDL)+IVEM(INDL+1)
        STEML=STEML+IVEM(INDL+1)
        STMOL=STMOL+IVEM(INDL+1)
      ENDIF
      LSPACE=IVEM(ADDL)-SPACE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** is the address array written to an external data set ?        ***
C**   ----------------------------------------------------          ***
C**                                                                 ***
      IF ((MAX(STEML,STDIL,STLIN)+IVEM(ADDL+1).GT.LBIG)
     &                                 .AND.(IVEM(ADDL+3).EQ.1)) THEN
        RVEM(TPAGE)=RVEM(TPAGE)-VEMSCD()
        CALL VEM690(IVEM(ADDL+1),RBIG(IVEM(ADDL)),IVEM(ADDL+2),ERR)
        RVEM(TPAGE)=RVEM(TPAGE)+VEMSCD()
        IF (ERR.GT.0) THEN
	   WRITE (LOUT,9101) MYPROC,MYTID,IVEM(ADDL+1)*IREAL,
     &                                                   IVEM(ADDL+2)
        ELSE
          IF (OUTCNT.NE.0)
     &              WRITE (LOUT,9151) IVEM(ADDL+1)*IREAL,IVEM(ADDL+2)
        ENDIF
        IVEM(ADDL+3)=0
        IVEM(MATL)=LBIG-LM*NRHS*SBT-IVEM(MATL+1)+1
        IVEM(ADDL)=IVEM(MATL)-IVEM(ADDL+1)
        LSPACE=LSPACE+IVEM(ADDL+1)
      ELSE
        ERR=0
        IVEM(MATL)=IVEM(ADDL)-LM*NRHS*SBT-IVEM(MATL+1)
        STEML=STEML+IVEM(ADDL+1)
        STDIL=STDIL+IVEM(ADDL+1)
        STLIN=STLIN+IVEM(ADDL+1)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** is there any error on any process ?                           ***
C**   ----------------------------------                            ***
C**                                                                 ***
      CALL VEM098('VEME00',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &             LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 1000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** distribute the initial solution onto the elements :           ***
C**   -------------------------------------------------             ***
C**                                                                 ***
      IF (OUTCNT.NE.0) WRITE(LOUT,9300)
      HTIME=VEMSCD()
      RVEM(TELEM)=RVEM(TELEM)-VEMSCD()
C**                                                                 ***
      LOCU=SPACE+LSPACE-IVEM(NLOCU)
      BUF=SPACE
      IF (LVEM(STARTU)) THEN
        CALL VEM661(LM,U,OWN,NK,NGROUP,GINFO1,IVEM(GINFO),NEK,NJUMP,
     &              IVEM(JUMP),IVEM(LMATBK),IVEM(PTRMBK),
     &              IVEM(NLOCU),RBIG(LOCU),SBT,IVEM(NUBUF)/SBT,
     &              RBIG(BUF),MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      ELSE
        DO 1007 I=1,IVEM(NLOCU)
 1007     RBIG(LOCU-1+I)=0.D0
        DO 1008 I=1,LM
 1008     U(I)=0.D0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute element matrices :                                    ***
C**   -------------------------                                     ***
C**                                                                 ***
      EM=SPACE
      RWORK=EM+IVEM(NEML)
      IWORK=(RWORK-1)*RPI+1
      LWORK=LOCU-RWORK
      DO 1009 I=1,IVEM(NEML)
 1009   RBIG(EM-1+I)=0.D0
      CALL VEM50X(T,ZERO,OWN,NK,NGROUP,GINFO1,IVEM(GINFO),MOUNT1,
     &            IVEM(MOUNTL),DIM,NN,NOD,NOP1,NOP,NOPARM,
     &            RBIG(LOCU),RBIG(LOCU),NEK,RPARM,IPARM,0,LVEM(LSYM),
     &            LVEM(LMASKL),USERL,USERL,
     &            NRHS,LVEM(FMASKL),USERF,IVEM(NEML),
     &            RBIG(EM),LWORK,RBIG(RWORK),IBIG(IWORK),
     &            MYPROC,MYTID,OUTCNT,LOUT,ERR)
      RVEM(TELEM)=RVEM(TELEM)+VEMSCD()
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** add the element matrices to the global matrix :               ***
C**   ---------------------------------------------                 ***
C**                                                                 ***
C**** read addresses :                                              ***
C**                                                                 ***
      IF (IVEM(ADDL+3).EQ.0) THEN
        ERR=0
        RVEM(TPAGE)=RVEM(TPAGE)-VEMSCD()
        CALL VEM691(IVEM(ADDL+1),RBIG(IVEM(ADDL)),IVEM(ADDL+2),ERR)
        RVEM(TPAGE)=RVEM(TPAGE)+VEMSCD()
        IF (ERR.GT.0) THEN
	   WRITE (LOUT,9102) MYPROC,MYTID,IVEM(ADDL+2)
        ELSE
           IF (OUTCNT.NE.0) WRITE(LOUT,9171) IVEM(ADDL+2)
        ENDIF
      ENDIF
C**                                                                 ***
C**** is there an error on any process ?                            ***
C**                                                                 ***
      CALL VEM098('VEME00',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &             LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 1000
C**                                                                 ***
C**** call the mounting procedure :                                 ***
C**                                                                 ***
      ADDRE=(IVEM(ADDL)-1)*RPI+1
      LMATRI=IVEM(MATL+1)
      MATRI=IVEM(MATL)
      F=MATRI+LMATRI
      PTRMAT(1)=1
      PTRMAT(2)=1-LMATRI
      RVEM(TMOUNT)=RVEM(TMOUNT)-VEMSCD()
      CALL VEM511(NK,OWN,NRHS,NGROUP,GINFO1,IVEM(GINFO),NEK,
     &            IVEM(BLKLST),IVEM(BLK),MOUNT1,IVEM(MOUNTL),
     &            IBIG(ADDRE),RBIG(EM),SBT,PTRMAT,LMATRI,RBIG(MATRI),
     &            LVEM(FMASKL),LM,RBIG(F),NJUMP,IVEM(JUMP),
     &            IVEM(LMATBK),IVEM(PTRMBK),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      RVEM(TMOUNT)=RVEM(TMOUNT)+VEMSCD()
C**                                                                 ***
C**** global matrix is ready :                                      ***
C**                                                                 ***
      IF (OUTCNT.NE.0)  WRITE(LOUT,9310) VEMSCD()-HTIME
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read index :                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      ERR=0
      IF (IVEM(INDL+3).EQ.0) THEN
        RVEM(TPAGE)=RVEM(TPAGE)-VEMSCD()
        CALL VEM691(IVEM(INDL+1),RBIG(IVEM(INDL)),IVEM(INDL+2),ERR)
        RVEM(TPAGE)=RVEM(TPAGE)+VEMSCD()
        IF (ERR.GT.0) THEN 
	   WRITE(LOUT,9102) MYPROC,MYTID,IVEM(INDL+2)
        ELSE
          IF (OUTCNT.NE.0) WRITE(LOUT,9170) IVEM(INDL+2)
        ENDIF
      ENDIF
      CALL VEM098('VEME00',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &             LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 1000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** enter the Dirichlet condtions into the vector B :             ***
C**   -----------------------------------------------               ***
C**                                                                 ***
      LINDEX=IVEM(INDL+1)*RPI
      INDEX=(IVEM(INDL)-1)*RPI+1
      PTRVTS=IBIG(INDEX-1+1)
      NVTYP =IBIG(INDEX-1+2)
      INFOL =IBIG(INDEX-1+3)
      IL1   =IBIG(INDEX-1+4)
      IL2   =IBIG(INDEX-1+5)

      SPACE2=IVEM(INDL)+IVEM(INDL+1)

      B=SPACE2
      X=B+LM*NRHS
      DNOPRM=X+IVEM(LDC)*DIM
      WORK2=DNOPRM+IVEM(LDC)*NOP
      M0=IVEM(PTRMBK-1+MYPROC)
      DO 2410 J=0,LM*NRHS-1
        RBIG(B+J)=0
 2410 CONTINUE
      CALL VEM518(OWN,T,NK,DINFO1,IVEM(DINFO),NRHS,M0,LM,
     &            DIM,NN,NOD,NOP1,NOP,NOPARM,DNOD,RDPARM,IDPARM,
     &            RBIG(B),IVEM(LDC),RBIG(X),
     &            RBIG(DNOPRM),RBIG(WORK2),USERB)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** to eleminate columns with Dirichlet conditions from the       ***
C**   matrix the right hand side is corrected by a MVM F=F-MAT*B    ***
C**   and the solution and rhs f are set to the actual value        ***
C**   of the Dirichlet conditions :                                 ***
C**   ------------------------------------------------------        ***
C**                                                                 ***
      BUF=X
      DO 2500 I=1,NRHS
        include "norec.h"
        DO 2511 J=0,IVEM(TNDC)-1
          HTIME=RBIG(B-1+IVEM(DINDEX+J)+LM*(I-1))
          U(IVEM(DINDEX+J)+LM*(I-1))=HTIME
          RBIG(B-1+IVEM(DINDEX+J)+LM*(I-1))=-HTIME
 2511   CONTINUE
        IF (LVEM(LSYM)) THEN
          CALL LL3ASX(RBIG(MATRI),RBIG(B+LM*(I-1)),RBIG(F+LM*(I-1)),
     &		      RBIG(BUF),IVEM(PTRMBK),IVEM(LMATBK),
     &                IBIG(PTRVTS+INDEX-1),LM,NPROC,IVEM(TIDS),MYPROC,
     &		      IVEM(JUMP),.TRUE.,LMATRI,LINDEX,IL1,
     &		      IBIG(INFOL+INDEX-1),IBIG(INDEX),IVEM(NMSG))
        ELSE
          CALL LL3AX(LL6AX,RBIG(MATRI),RBIG(B+LM*(I-1)),
     &	             RBIG(F+LM*(I-1)),RBIG(BUF),IVEM(PTRMBK),
     &		     IVEM(LMATBK),IBIG(PTRVTS+INDEX-1),LM,NPROC,
     &               IVEM(TIDS),MYPROC,IVEM(JUMP),.TRUE.,LMATRI,
     &		     LINDEX,IL1,IBIG(INFOL+INDEX-1),IBIG(INDEX),
     &	 	     IVEM(NMSG))
        ENDIF
        include "norec.h"
        DO 2510 J=0,IVEM(TNDC)-1
          RBIG(F-1+IVEM(DINDEX+J)+LM*(I-1))=U(IVEM(DINDEX+J)+LM*(I-1))
 2510   CONTINUE
 2500 CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** columns ans rows with Dirichlet conditions are set to zero :  ***
C**   ----------------------------------------------------------    ***
C**                                                                 ***
      DMASKC=(SPACE2-1)*RPI+1
      DMASKR=DMASKC+LM*2
      CALL VEM996(IVEM(NVT),LMATRI,LINDEX,IL1,IL2,IBIG(INFOL+INDEX-1),
     &            RBIG(MATRI),IBIG(INDEX),IVEM(TNDC),IVEM(DINDEX),
     &            LM,IBIG(DMASKC),IBIG(DMASKR),NJUMP,IVEM(JUMP),
     &            NPROC,IVEM(LMATBK),IVEM(PTRMBK),MYPROC,IVEM(TIDS),
     &            IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Call LINSOL :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IVEM(ILIN+ 5)=0
      RPREC=SPACE2
      IPREC=(RPREC+IVEM(LRPREC)-1)*RPI+1
      RWORK=RPREC+IVEM(LCOND)
      IWORK=(RWORK+IVEM(LR800)-1)*RPI+1
      DO 2000 I=1,NRHS

        CALL VEM933(NK,IVEM(NKN),LM,IVEM(COMIND),RBIG(F+LM*(I-1)),
     &              ZERO,RVEM(NORMF+NK*(I-1)),RVEM(WORKN),
     &              MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
        IF (OUTCNT.NE.0) THEN
          WRITE (LOUT,9190) I
          WRITE (LOUT,9220) (J,RVEM(NORMF-1+J+NK*(I-1)),J=1,NK)
          WRITE (LOUT,*)
        ENDIF

        IVEM(ILIN+9)=0
        ICONV=1
	IVEM(ILIN+2)=IVEM(NMSG)
C**                                                                 ***
        HTIME=VEMSCD()
        CALL LSOLPP(LMATRI,IVEM(LRPREC),IVEM(LIPREC)*RPI,LINDEX,LM,
     &  	    IVEM(LR800),IVEM(LI800)*RPI,NPROC,LVEM(LSYM),
     &  	    IL1,IBIG(INFOL+INDEX-1),RBIG(MATRI),
     &  	    RBIG(RPREC),U(LM*(I-1)+1),RBIG(F+LM*(I-1)),
     &  	    RBIG(RWORK),IBIG(IPREC),IBIG(INDEX),IBIG(IWORK),
     &  	    IVEM(ILIN),IVEM(LMATBK),IBIG(PTRVTS+INDEX-1),
     &              IVEM(TIDS),RVEM(EPSLIN),ICONV,ERR)
	IVEM(NMSG)=IVEM(ILIN+2)
        HTIME=VEMSCD()-HTIME
        RVEM(TLIN)=RVEM(TLIN)+HTIME
	IF (ICONV.GT.1) THEN
	  IF (INT(ERR/100.+.0005).EQ.11) THEN
	    ERR=9
          ELSE
	    ERR=MAX(10,ERR)
            IF (ERR.EQ.3201) ERR=10
          ENDIF
        ELSE
	  ERR=0
        ENDIF
        IVEM(74)=IVEM(ILIN+9)

        CALL VEM098('VEME00',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &               LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &               IVEM(19),OUTCNT,LOUT)
C**                                                                 ***
	IF (ERR.EQ.0) THEN
          CALL VEM933(NK,IVEM(NKN),LM,IVEM(COMIND),U(1+LM*(I-1)),
     &                ZERO,RVEM(NORMU+NK*(I-1)),RVEM(WORKN),
     &                MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
        ENDIF

        IF (OUTCNT.NE.0) THEN
          IF (ERR.NE.0) THEN
            WRITE (LOUT,9210) HTIME
          ELSE
            WRITE (LOUT,9230) (J,RVEM(NORMU-1+J+NK*(I-1)),J=1,NK)
            WRITE (LOUT,9200) HTIME
           ENDIF
        ENDIF
        IF (ERR.NE.0) GOTO 1000

 2000 CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** statistics :                                                  ***
C**   ----------                                                    ***
C**                                                                 ***
1000  CONTINUE

      RVEM(TRUN)=RVEM(TRUN)+VEMSCD()
      RVEM(TTOT)=RVEM(TTOT)-TIME+VEMSCD()
      TIME=RVEM(TRUN)

      IF ((OUTCNT.GT.0).AND.(ERR.LE.10)) THEN
        WRITE(LOUT,9031)
        WRITE(LOUT,9040)'addresses             ',RVEM(TADD)
        WRITE(LOUT,9040)'element matrices      ',RVEM(TELEM)
        WRITE(LOUT,9040)'mounting              ',RVEM(TMOUNT)
        WRITE(LOUT,9040)'LINSOL                ',RVEM(TLIN)
        WRITE(LOUT,9040)'paging                ',RVEM(TPAGE)
        WRITE(LOUT,9040)'total                 ',RVEM(TTOT)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** this is the end of VEME00 :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
9999  CONTINUE
      IVEM(3)=0
      IVEM(5)=MAX(NIVEM,IVEM(5))
      IVEM(6)=MAX(NRVEM,IVEM(6))
      IVEM(7)=MAX(NLVEM,IVEM(7))
      IVEM(8)=SPACE
      IVEM(9)=LSPACE
      CALL VEM097('VEME00',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   --------                                                      ***
C**                                                                 ***
9031  FORMAT(/'  time statistics :'/
     &       /37X,'|   total time  '
     &       /17X,'operation          ',' |     in sec   '/13X,40('-'))
9040  FORMAT(13X,A23,' |  ',F10.2)
9350  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
9300  FORMAT(/'  mounting of the global system'/2X,29('-') )
9310  FORMAT(/'  mounting ended successfully. (time = ',F10.2,' sec)'/)
9190  FORMAT(/'  Right hand side ',I3/2X,19('-')/)
9200  FORMAT(/'  LINSOL ended successfully. (time = ',F10.2,' sec)'/)
9210  FORMAT(/'  LINSOL failed. (time = ',F10.2,' sec)'/)
9220  FORMAT(/'     norm of right hand side :'/
     &       ('         ',I5,'.    ',G10.2))
9230  FORMAT(/'     norm of solution :'/
     &       ('         ',I5,'.    ',G10.2))
9170  FORMAT('  Index was read from unit ',I2,'.')
9171  FORMAT('  Addresses were read from unit ',I2,'.')
9150  FORMAT('  Index (=',I10,' bytes) was written to unit ',I2,'.')
9151  FORMAT('  Addresses (=',I10,' bytes) were written to unit '
     &                                                         ,I2,'.')
9101  FORMAT ('>>VEMCD:10:0004'
     &       /'>>error in VEME00 on process ',I5,' (TID=',I10,')'
     &       /'>>during writing of data (=',I10,' bytes) ',
     &                                               'to unit ',I2,'.')
9102  FORMAT ('>>VEMCD:10:0003'
     &       /'>>error in VEME00 on process ',I5,' (TID=',I10,'):'
     &       /'>>during reading of data from unit ',I2,'.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEME00----------------------------------------------------
      E    N    D
