C:::::      ,,,,,VEME02...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEME02(T,LU,U,EEST,LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &                  LNEK, NEK ,LRPARM ,RPARM ,LIPARM ,IPARM ,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                  NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG,
     &                  MASKL,MASKF,USERB,USERL,USERF,
     &                  VEM50X,VEM63X)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEME02  controls the solution of a nonlinear, steady          ***
C**           functional equation.                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**   All length in IBIG and RBIG in length of REAL variables !     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"

      INTEGER          LU,LIVEM,LLVEM,LRVEM,LBIG,LNOPRM,LNODN,
     &                 LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,LIDPRM,LNOD

      DOUBLE PRECISION T,U(LU),RVEM(LRVEM),RPARM(LRPARM),RDPARM(LRDPRM),
     &                 EEST(LU),NOD(LNOD),NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER          IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                 NODNUM(LNODN),IDPARM(LIDPRM),IBIG(RPI*LBIG)

      LOGICAL          LVEM(LLVEM),MASKL(*),MASKF(*)

      EXTERNAL         USERB,USERL,USERF
      EXTERNAL         VEM50X,VEM63X
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Parameters : see veme02(3)                            ***
C**   ------------------                                            ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** dimensions of the management vectors:                         ***
C**   ------------------------------------                          ***
C**                                                                 ***
      INTEGER           NOPER,MOUNT1,LREC0
      PARAMETER(MOUNT1=9,NOPER=4,LREC0=1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   Variables :                                                   ***
C**   -----------                                                   ***
C**                    >                                            ***
      DOUBLE PRECISION  VEMSCD,TIME,HTIME,ALPHA,ZERO,BETA1(LREC0),
     &                  BETAW(LREC0*LREC0),TOLRED

      INTEGER           I,J,IERR,LENGTH,MPINFO,SBT,
     &                  LOUT,STEP,OUTCNT,MESH,ERR,NK,DIM,NGROUP,NN,
     &                  NDEG,GINFO,GINFO1,DINFO,DINFO1,
     &                  M0,NJUMP,LMATBK,PTRMBK,SORTI,BLKLST,BLK,NBLK,
     &                  JUMP,OWN,PCLASS,MSPACK,SPACE,
     &                  NOP,NOP1,ORDER(NOPER),OPER(NOPER),NUBUF,TIDS,
     &                  NMSG,NPROC,MYPROC,IOTID,MYTID,NLOCU,NKN,COMIND,
     &                  TNDC,DINDEX,MOUNTL,NADDL,RMOUNL,INDL,NEML,
     &                  ADDL,MATL,ILIN,NVT,LDC,NELEMD,LM,
     &                  LI800,LR800,LCOND,N,LRPREC,LIPREC,
     &                  MOUNTF,MOUNTE,MOUNTW,RMOUNF,RMOUNE,RMOUNW,
     &                  NEMF,NEME,NEMW,NADDF,NADDE,MATK,
     &                  TC,TCALL,P,PNEW,HERE,NADDW,LREC,
     &                  STOPRP,STOLIN,STOEMF,STOEML,STOMOF,STOMOL,
     &                  NIVEM,NRVEM,NLVEM,NBIG,NINFO,NINDEX,NMAT,
     &                  LSYM,STARTU,LMASKL,FMASKL,LMASKE,FMASKE,
     &                  LMASKW,FMASKW,LMASKF,FMASKF,ERREST,NORMDT
      INTEGER           INDEX,MATRI,ADDRE,LINDEX,LMATRI,LADDRE,
     &                  LWORK,F,RWORK,IWORK,EM,X,B,WORK2,DNOPRM,
     &                  EPS,EPSLIN,NORMU,NORMF,TTOT,TADD,TELEM,
     &                  TMOUNT,TLIN,TPAGE,TRUN,MINU,MAXU,WORKN,
     &                  NORMF2,NORMD2,DU,NORMW,NORMEU,TOLEQ,
     &                  NORMDU,NORMDX,TSTEPS,STORE,OUTMNT,NORMDG,
     &                  LLNGTH(16),NLNGTH(16),PTRMAT(2)

      LOGICAL           SYM(NOPER)
      EXTERNAL          DUMMY,VEM420,VEM410
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT=IVEM(40)
      TIME=VEMSCD()
      LLNGTH(1)=LIVEM
      LLNGTH(2)=LRVEM
      LLNGTH(3)=LLVEM
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=LU
      LLNGTH(15)=0
      LLNGTH(16)=0
      IF (IVEM(40).LE.0) IVEM(40)=6
      IVEM(41)=MAX(IVEM(41),0)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9350)
	IVEM(2)=99
	RETURN
      ENDIF

      MESH=IVEM(1)
      STEP=IVEM(3)
      OUTCNT=MAX(IVEM(41),0)
      ALPHA=0.0
      ZERO=0.0
      NIVEM=0
      NRVEM=0
      NLVEM=0
      NBIG=0
      IVEM(52)=1
      CALL VEM000('VEME02',OUTCNT,LOUT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check the input informations :                                ***
C**   -----------------------------                                 ***
C**                                                                 ***
      CALL VEM601(.TRUE.,LIVEM,IVEM,RVEM,LRVEM,LLVEM,LVEM,
     &            MYPROC,MYTID,ERR)
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      CALL VEM098('VEME02',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) THEN
        TIME=0
        GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch parameters from IVEM :                                  ***
C**   --------------------------                                    ***
C**                                                                 ***
      NDEG=IVEM(MESH+1)
      NK=IVEM(MESH+2)
      DIM=IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN=IVEM(MESH+5)
      NINFO=IVEM(MESH+12)
      NOP1=IVEM(MESH+13)
      NOP=IVEM(MESH+14)
      OWN=IVEM(MESH+15)
      LM=IVEM(MESH+16)
      SORTI=IVEM(MESH+19)+MESH
      GINFO=IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      DINFO=IVEM(MESH+23)+MESH
      DINFO1=IVEM(MESH+24)

      NJUMP=IVEM(SORTI)
      NBLK=IVEM(SORTI+1)
      JUMP=SORTI+2
      LMATBK=JUMP+NPROC
      PTRMBK=LMATBK+NPROC
      BLKLST=JUMP+3*NPROC
      BLK=BLKLST+NGROUP
      IF (STEP.EQ.1) THEN
        SPACE=IVEM(8)
      ELSE
        SPACE=1
        IVEM(9)=LBIG-LM
	IVEM(6)=0
	IVEM(7)=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set start addresses for information in IVEM :                 ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      TC=MESH+NINFO
      TCALL=TC+1
      P=TCALL+1
      PNEW=P+1
      LREC=PNEW+1
      HERE=LREC+1
      TNDC=HERE+LREC0
      LDC=TNDC+1
      LCOND=LDC+1
      LRPREC=LCOND+1
      LIPREC=LRPREC+1
      LI800=LIPREC+1
      LR800=LI800+1
      INDL=LR800+1
      ADDL=INDL+4
      MATL=ADDL+4
      MATK=MATL+4
      ILIN=MATK+4
      NVT=ILIN+4
      NKN=ILIN+100
      COMIND=NKN+NK
      DINDEX=COMIND+LM
      NUBUF=DINDEX+IVEM(MESH+9)
      NLOCU=NUBUF+1
      NELEMD=NLOCU+1
      MOUNTL=NELEMD+1
      MOUNTF=MOUNTL+MOUNT1*NGROUP
      MOUNTE=MOUNTF+MOUNT1*NGROUP
      MOUNTW=MOUNTE+MOUNT1*NGROUP
      RMOUNL=MOUNTL+NOPER*MOUNT1*NGROUP
      RMOUNF=RMOUNL+1
      RMOUNE=RMOUNF+1
      RMOUNW=RMOUNE+1
      NADDL=RMOUNL+NOPER*1
      NADDF=NADDL+1
      NADDE=NADDF+1
      NADDW=NADDE+1
      NEML=NADDL+NOPER*1
      NEMF=NEML+1
      NEME=NEMF+1
      NEMW=NEME+1
      NIVEM=NEML+NOPER*1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set start addresses for information in LVEM :                 ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      LSYM=1
      STARTU=5
      ERREST=7
      LMASKL= 21+2*NK
      LMASKF= LMASKL+NK*NK*NGROUP
      LMASKE= LMASKF+NK*NK*NGROUP
      LMASKW= LMASKE+NK*NK*NGROUP
      FMASKL= LMASKL+NK*NK*NGROUP*NOPER
      FMASKF= FMASKL+NK*NGROUP
      FMASKE= FMASKF+NK*NGROUP
      FMASKW= FMASKE+NK*NGROUP
      NLVEM= FMASKL+NK*NGROUP*NOPER-1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set start addresses for information in RVEM :                 ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      EPS=2
      EPSLIN=3
      MINU=20
      MAXU=MINU+NK
      NORMU=MAXU+NK
      NORMF=NORMU+NK
      NORMDU=NORMF+NK
      NORMDX=NORMDU+NK
      NORMEU=NORMDX+NK
      NORMDT=NORMEU+NK
      NORMDG=NORMDT+NK
      TOLEQ=NORMDG+NK
      TTOT=TOLEQ+NK
      TADD=TTOT+1
      TELEM=TADD+1
      TMOUNT=TELEM+1
      TLIN=TMOUNT+1
      TPAGE=TLIN+1
      TRUN=TPAGE+1
      NORMW=TRUN+1
      NORMD2=NORMW+LM
      NORMF2=NORMD2+NK
      WORKN=NORMF2+NK
      TSTEPS=WORKN+2*NK
      DU=TSTEPS+LREC0
      NRVEM=DU+LM-1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** are the information vectors large enough ?                    ***
C**   ----------------------------------------                      ***
C**                                                                 ***
      NLNGTH(1)=NIVEM
      NLNGTH(2)=NRVEM
      NLNGTH(3)=NLVEM
      NLNGTH(14)=LM
      CALL VEM098('VEME02',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) THEN
        TIME=VEMSCD()-TIME
        GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initialize timers :                                           ***
C**   -----------------                                             ***
C**                                                                 ***
      IVEM(LREC)=LREC0
      IVEM(HERE)=1
      RVEM(TSTEPS)=0
      IVEM(P)=0
      IF (STEP.NE.2) THEN
        RVEM(TADD )=0
        RVEM(TELEM)=0
        RVEM(TMOUNT)=0
        RVEM(TLIN )=0
        RVEM(TPAGE)=0
        RVEM(TTOT )=0
        RVEM(TRUN )=-TIME
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy masks into LVEM :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      IF (STEP.EQ.0) THEN
        DO 10 I=1,NK*NK*NGROUP
          LVEM(LMASKL-1+I)=MASKL(I)
          LVEM(LMASKF-1+I)=.FALSE.
          LVEM(LMASKE-1+I)=.FALSE.
          LVEM(LMASKW-1+I)=.FALSE.
10      CONTINUE
        DO 11 I=1,NK*NGROUP
          LVEM(FMASKL -1+I)=.FALSE.
          LVEM(FMASKF -1+I)=MASKF(I)
          LVEM(FMASKE -1+I)=MASKF(I)
          LVEM(FMASKW -1+I)=.FALSE.
11      CONTINUE
        DO 12 I=1,NGROUP
          DO 13 J=1,NK
            LVEM(FMASKW-1+NK*(I-1)+1)=LVEM(FMASKW-1+NK*(I-1)+1)
     &                                   .OR.LVEM(FMASKF-1+NK*(I-1)+J)
13        CONTINUE
          DO 14 J=2,NK
            LVEM(FMASKW-1+NK*(I-1)+J)=LVEM(FMASKW-1+NK*(I-1)+1)
14        CONTINUE
12      CONTINUE
        CALL VEM610(NOPER,SYM,NK,NGROUP,LVEM(LMASKL))
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the storage and managment infos for element matrices  ***
C**   ------------------------------------------------------------  ***
C**                                                                 ***
      IF (STEP.EQ.0) THEN
C**                                                                 ***
C****** Frechet derivative :                                        ***
C**                                                                 ***
        OPER(1)=0
        ORDER(1)=IVEM(51)
        SYM(1)=LVEM(LSYM)
C**                                                                 ***
C****** Newton defect :                                             ***
C**                                                                 ***
        OPER(2)=0
        SYM(2)=.FALSE.
        ORDER(2)=IVEM(51)
C**                                                                 ***
C****** defect of discretization error:                             ***
C**                                                                 ***
        OPER(3)=10
        SYM(3)=.FALSE.
        ORDER(3)=IVEM(51)+2
C**                                                                 ***
C****** weight of defect norms :                                    ***
C**                                                                 ***
        OPER(4)=100
        SYM(4)=.FALSE.
        ORDER(4)=2

        CALL VEM620(NGROUP,NK,DIM,NOP,OWN,
     &             GINFO1,IVEM(GINFO),ORDER,1,NOPER,
     &             OPER,SYM,LVEM(LMASKL),LVEM(FMASKL),
     &             IVEM(NADDL),MOUNT1,IVEM(MOUNTL),
     &             IVEM(RMOUNL),IVEM(NEML),IVEM(NLOCU),IVEM(NUBUF),
     &             DINFO1,IVEM(DINFO),IVEM(LDC),IVEM(NELEMD),
     &             VEM63X,NPROC,IVEM(LMATBK),MYPROC,MYTID,LOUT,ERR)
	IF (ERR.GT.0) ERR=99

        IVEM(ADDL+1)=IVEM(NADDL)
        IVEM(ADDL+2)=IVEM(11)
        IVEM(RMOUNF)=MAX(IVEM(RMOUNF),IVEM(RMOUNE))
C**                                                                 ***
C****** enough storage for VEM700 and VEM608 ?                      ***
C**                                                                 ***
        NBIG=MAX(NBIG,((20*LM+2*LM*NJUMP)+RPI-1)/RPI+IVEM(ADDL+1))

	NLNGTH(4)=NBIG
        CALL VEM098('VEME02',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &              LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &              IVEM(19),OUTCNT,LOUT)
        IF (ERR.GT.0) GOTO 1000

      ENDIF

      IF (STEP.NE.1) THEN
        IVEM(ADDL  )=LBIG-IVEM(NADDL)+1
        IVEM(ADDL+3)=1
        IVEM(INDL  )=1
        IVEM(INDL+3)=1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create Dirchlet and component index                           ***
C**   -----------------------------------                           ***
C**                                                                 ***
      IF (STEP.EQ.0) THEN
        INDEX=(IVEM(INDL)-1)*RPI+1
        LINDEX=(IVEM(ADDL)-IVEM(INDL))*RPI
        RVEM(TADD)=RVEM(TADD)-VEMSCD()
        CALL VEM608(OWN,NGROUP,GINFO1,IVEM(GINFO),NEK,
     &              NK,DINFO1,IVEM(DINFO),DNOD,IVEM(NKN),
     &              IVEM(COMIND),IVEM(DINDEX),IVEM(TNDC),
     &              LM,IBIG(INDEX),
     &              NJUMP,IVEM(JUMP),NPROC,IVEM(LMATBK),IVEM(PTRMBK),
     &              MYPROC,IVEM(TIDS),IVEM(NMSG))
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Pack the global matrix :                                      ***
C**   -----------------------                                       ***
C**                                                                 ***
      IF (STEP.NE.1) THEN
        PCLASS=IVEM(46)
        MSPACK=IVEM(45)
        INDEX=(IVEM(INDL)-1)*RPI+1
        LINDEX=(IVEM(ADDL)-IVEM(INDL))*RPI
        ADDRE=(IVEM(ADDL)-1)*RPI+1
        LADDRE=IVEM(ADDL+1)*RPI
        CALL VEM700(OWN,NGROUP,GINFO1,IVEM(GINFO),
     &              LVEM(LSYM),NK,LVEM(LMASKL),NEK,
     &              PCLASS,MSPACK,MOUNT1,IVEM(MOUNTL),
     &              LADDRE,IBIG(ADDRE),NINDEX,N,LINDEX,IBIG(INDEX),
     &              NMAT,IVEM(NVT),
     &              NJUMP,IVEM(JUMP),NPROC,IVEM(LMATBK),IVEM(PTRMBK),
     &              MYPROC,IVEM(TIDS),IVEM(NMSG),OUTCNT,IERR,LOUT)
C**                                                                 ***
        RVEM(TADD)=RVEM(TADD)+VEMSCD()

        IVEM(INDL+1)=(NINDEX+RPI-1)/RPI
        IVEM(INDL+2)=IVEM(10)

        IVEM(MATL+1)=NMAT
        IVEM(MATL+2)=IVEM(12)
        IVEM(MATL+3)=2

        N=(N+RPI-1)/RPI
        NBIG=MAX(NBIG,N+IVEM(ADDL+1))
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Set the storage and the informations for linsol :             ***
C**   -----------------------------------------------               ***
C**                                                                 ***
      IF (STEP.NE.1) THEN
	IF (IERR.GT.0) THEN
	  IVEM(LIPREC)=0
	  IVEM(LRPREC)=0
	  IVEM(LI800)=0
	  IVEM(LR800)=0
        ELSE
          IVEM(ILIN   )=IVEM(70)
          IVEM(ILIN+ 1)=IVEM(72)
          IVEM(ILIN+ 6)=0
          IVEM(ILIN+ 7)=0
          IVEM(ILIN+ 8)=0
          IVEM(ILIN+11)=LOUT
          IVEM(ILIN+12)=OUTCNT
          IVEM(ILIN+14)=IVEM(71)
          IVEM(ILIN+15)=0
          IVEM(ILIN+16)=MYPROC
	  IF (LVEM(9)) THEN
            IVEM(ILIN+17)=0
          ELSE
            IVEM(ILIN+17)=1
          ENDIF
          IF ((IVEM(73).LT.100).AND.(IVEM(73).GT.20)) THEN
	    IVEM(ILIN+18)=01000
	    IVEM(ILIN+22)=IVEM(73)
          ELSE
	    IVEM(ILIN+18)=00000
	    IVEM(ILIN+22)=6
	  ENDIF
          IVEM(ILIN+19)=0000
          IVEM(ILIN+20)=6
          IVEM(ILIN+21)=6
	  CALL VEM950(NPROC,LM,IVEM(ILIN),IVEM(MATL+1),IVEM(INDL+1),
     &                IVEM(LIPREC),IVEM(LRPREC),
     &                IVEM(LI800),IVEM(LR800))
	  IVEM(LI800)=(IVEM(LI800)+RPI-1)/RPI
	  IVEM(LIPREC)=(IVEM(LIPREC)+RPI-1)/RPI
        ENDIF
	IVEM(LCOND)=IVEM(LIPREC)+IVEM(LRPREC)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check the storage for RBIG  :                                 ***
C**   ---------------------------                                   ***
C**                                                                 ***
      IF (STEP.NE.1) THEN
C**                                                                 ***
C**   mounting of norm weigth:                                      ***
C**                                                                 ***
        STOPRP=IVEM(NEMW)+MAX(IVEM(RMOUNW),SBT*LM)
C**                                                                 ***
C**   STOLIN for VEM400 and error estimation                        ***
C**                                                                 ***
        STOLIN=IVEM(INDL+1)+LM+
     &       MAX(2*LM,(NOP+DIM+1)*IVEM(LDC),IVEM(LI800)+IVEM(LR800))
     &       +IVEM(LCOND)+IVEM(MATL+1)
C**                                                                 ***
C**   STOEMF,STOMOF for VEM410:                                     ***
C**                                                                 ***
        STOEMF=LM+MAX(IVEM(NLOCU),SBT*LM)+
     &     MAX(IVEM(NUBUF)+IVEM(MATL+1)+IVEM(LCOND),
     &         MAX(IVEM(NEMF)+IVEM(RMOUNF),IVEM(NEME)+IVEM(RMOUNE)))
        STOMOF=LM+MAX(IVEM(NLOCU),SBT*LM)+MAX(IVEM(NEMF),IVEM(NEME))
C**                                                                 ***
C**   STOEML,STOMOL for VEM420:                                     ***
C**                                                                 ***
        STOEML=LM+IVEM(NLOCU)+
     &     MAX(IVEM(NUBUF),IVEM(NEML)+IVEM(RMOUNL))
        STOMOL=LM+IVEM(NLOCU)+IVEM(NEML)+SBT*IVEM(MATL+1)+IVEM(ADDL+1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** check the storage for RBIG  :                               ***
C**     ---------------------------                                 ***
C**                                                                 ***
        NBIG=MAX(NBIG,STOPRP,STOLIN,STOEMF,STOEML,STOMOF,STOMOL)

	NLNGTH(4)=NBIG
        CALL VEM098('VEME02',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &              LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &              IVEM(19),OUTCNT,LOUT)
        IF (ERR.GT.0) GOTO 1000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** is the index written to external data set ?                 ***
C**     -----------------------------------------                   ***
C**                                                                 ***
        LENGTH=IVEM(MATL+1)+IVEM(LCOND)
        STORE=MAX(STOPRP,STOEMF+LENGTH,STOEML,STOMOF+LENGTH,STOMOL)
        IF ((STORE+IVEM(INDL+1).GT.LBIG).AND.(IVEM(INDL+3).EQ.1)) THEN
          RVEM(TPAGE)=RVEM(TPAGE)-VEMSCD()
          CALL VEM690(IVEM(INDL+1),RBIG(IVEM(INDL)),IVEM(INDL+2),ERR)
          RVEM(TPAGE)=RVEM(TPAGE)+VEMSCD()
          IF (ERR.GT.0) THEN
	    WRITE(LOUT,9101) MYPROC,MYTID,IVEM(INDL+1)*IREAL,
     &                                                   IVEM(INDL+2)
          ELSE
            IF (OUTCNT.NE.0)
     &            WRITE (LOUT,9150) IVEM(INDL+1)*IREAL,IVEM(INDL+2)
          ENDIF
          IVEM(INDL+3)=0
	  SPACE=1
        ELSE
          SPACE=IVEM(INDL)+IVEM(INDL+1)
          STOPRP=STOPRP+IVEM(INDL+1)
	  STOEMF=STOEMF+IVEM(INDL+1)
	  STOEML=STOEML+IVEM(INDL+1)
	  STOMOF=STOMOF+IVEM(INDL+1)
	  STOMOL=STOMOL+IVEM(INDL+1)
        ENDIF
        IVEM(9)=IVEM(ADDL)-SPACE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** is the address array written to external data set ?         ***
C**     -------------------------------------------------           ***
C**                                                                 ***
        STORE=MAX(STOPRP,STOEMF+LENGTH,STOEML,STOLIN)
        IF ((STORE+IVEM(ADDL+1).GT.LBIG).AND.(IVEM(ADDL+3).EQ.1)) THEN
          RVEM(TPAGE)=RVEM(TPAGE)-VEMSCD()
          CALL VEM690(IVEM(ADDL+1),RBIG(IVEM(ADDL)),IVEM(ADDL+2),ERR)
          RVEM(TPAGE)=RVEM(TPAGE)+VEMSCD()
          IF (ERR.GT.0) THEN
	     WRITE (LOUT,9101) MYPROC,MYTID,IVEM(ADDL+1)*IREAL,
     &                                                    IVEM(ADDL+2)
          ELSE
            IF (OUTCNT.NE.0)
     &               WRITE (LOUT,9151) IVEM(ADDL+1)*IREAL,IVEM(ADDL+2)
          ENDIF
          IVEM(ADDL+3)=0
          IVEM(9)=IVEM(9)+IVEM(ADDL+1)
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** is there any error on any process ?                           ***
C**   ----------------------------------                            ***
C**                                                                 ***
      CALL VEM098('VEME02',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 1000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** insert dirichlet condition to initial guess :                 ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      IF (STEP.NE.2) THEN
C**                                                                 ***
C****** if no initial guess, initialize U :                         ***
C**                                                                 ***
	IF (.NOT.LVEM(STARTU)) THEN
          DO 2510 J=1,LM
            U(J)=0
 2510     CONTINUE
        ENDIF
        B=SPACE
        X=B+LM
        DNOPRM=X+IVEM(LDC)*DIM
        WORK2=DNOPRM+IVEM(LDC)*NOP
        M0=IVEM(PTRMBK-1+MYPROC)
        CALL VEM518(OWN,T,NK,DINFO1,IVEM(DINFO),1,M0,LM,DIM,
     &              NN,NOD,NOP1,NOP,NOPARM,DNOD,RDPARM,IDPARM,U,
     &              IVEM(LDC),RBIG(X),RBIG(DNOPRM),RBIG(WORK2),USERB)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute weights for defect norms :                            ***
C**   --------------------------------                              ***
C**                                                                 ***
      IF (STEP.EQ.0) THEN
        IF (OUTCNT.NE.0) WRITE(LOUT,9301)
        HTIME=VEMSCD()
        EM=SPACE
        RWORK=EM+IVEM(NEMW)
        IWORK=(RWORK-1)*RPI+1
        LWORK=LBIG-RWORK+1
C**                                                                 ***
C****** compute element matrices :                                  ***
C**                                                                 ***
        RVEM(TELEM)=RVEM(TELEM)-VEMSCD()
        DO 1009 I=1,IVEM(NEMW)
 1009     RBIG(EM-1+I)=ZERO
        CALL VEM517(OWN,NK,NGROUP,GINFO1,IVEM(GINFO),
     &              MOUNT1,IVEM(MOUNTW),DIM,NN,NOD,NEK,IVEM(NEMW),
     &              RBIG(EM),LWORK,RBIG(RWORK),IBIG(IWORK),
     &              MYPROC,MYTID,OUTCNT,LOUT,ERR)
        RVEM(TELEM)=RVEM(TELEM)+VEMSCD()
C**                                                                 ***
C****** is there an error on any process ?                          ***
C**                                                                 ***
        CALL VEM098('VEME02',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &              LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &              IVEM(19),OUTCNT,LOUT)
        IF (ERR.GT.0) GOTO 1000
C**                                                                 ***
C****** call the mounting procedure :                               ***
C**                                                                 ***
        ADDRE=1
        LMATRI=0
        MATRI=1
        RVEM(TMOUNT)=RVEM(TMOUNT)-VEMSCD()
        CALL VEM511(NK,OWN,1,NGROUP,GINFO1,IVEM(GINFO),NEK,
     &              IVEM(BLKLST),IVEM(BLK),MOUNT1,IVEM(MOUNTW),
     &              IBIG(ADDRE),RBIG(EM),SBT,PTRMAT,LMATRI,
     &              RBIG(MATRI),LVEM(FMASKW),LM,RBIG(RWORK),NJUMP,
     &              IVEM(JUMP),IVEM(LMATBK),IVEM(PTRMBK),MYPROC,
     &              NPROC,IVEM(TIDS),IVEM(NMSG))
        RVEM(TMOUNT)=RVEM(TMOUNT)+VEMSCD()
	DO 1018 I=1,IVEM(LMATBK-1+MYPROC)
	  IF (RBIG(RWORK-1+I).NE.ZERO) THEN
	    RVEM(NORMW-1+I)=1/RBIG(RWORK-1+I)
          ELSE
	    RVEM(NORMW-1+I)=0
          ENDIF
1018    CONTINUE
C**                                                                 ***
C****** the weigth are ready :                                      ***
C**                                                                 ***
        IF (OUTCNT.NE.0) WRITE(LOUT,9310) VEMSCD()-HTIME
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** call the Newton iteration :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
      F=SPACE
      IVEM(8)=F+LM
      OUTMNT=OUTCNT
      TOLRED=1.
      LVEM(3)=.TRUE.

      HTIME=VEMSCD()
      CALL VEM400(T,TOLRED,LM,RBIG(F),U,RVEM(DU),ALPHA,U,U,
     &            LIVEM,IVEM,LRVEM,RVEM,LLVEM,LVEM,
     &            EEST,NOD,NOPARM,NEK,RPARM,IPARM,
     &            VEM410,USERF,VEM420,USERL,USERL,VEM50X,
     &            LBIG,RBIG,IBIG,OUTMNT,OUTCNT,ERR)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** error estimation :                                            ***
C**   -----------------                                             ***
C**                                                                 ***
       DO  999 J=1,LM
         EEST(J)=0
999   CONTINUE

      IF (LVEM(ERREST).AND.(ERR.EQ.0)) THEN
C**                                                                 ***
C****** read the index :                                            ***
C**                                                                 ***
       IF (IVEM(INDL+3).NE.1) THEN
	 IF (IVEM(MATL+3).NE.1) THEN
           IVEM(INDL)=IVEM(MATL)-IVEM(LCOND)-IVEM(INDL+1)
         ELSEIF (IVEM(ADDL+3).NE.1) THEN
           IVEM(INDL)=IVEM(ADDL)-IVEM(INDL+1)
         ELSE
           IVEM(INDL)=LBIG+1-IVEM(INDL+1)
         ENDIF
         RVEM(TPAGE)=RVEM(TPAGE)-VEMSCD()
         CALL VEM691(IVEM(INDL+1),RBIG(IVEM(INDL)),IVEM(INDL+2),ERR)
         RVEM(TPAGE)=RVEM(TPAGE)+VEMSCD()
         IF (ERR.GT.0) THEN
	   WRITE (LOUT,9102) MYPROC,MYTID,IVEM(INDL+2)
         ELSE
	  IF (OUTCNT.NE.0) WRITE(LOUT,9170) IVEM(INDL+2)
         ENDIF
        ENDIF
C**                                                                 ***
C**** is there any error on any process ?                           ***
C**                                                                 ***
        CALL VEM098('VEME02',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &              LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &              IVEM(19),OUTCNT,LOUT)
        IF (ERR.GT.0) GOTO 1000
C**                                                                 ***
C****** solve the global system :                                   ***
C**                                                                 ***
        CALL VEM401(LIVEM,IVEM,LRVEM,RVEM,LLVEM,LVEM,
     &              LM,1,EEST,RBIG(F),
     &              LBIG,RBIG,IBIG,BETA1,BETAW,OUTCNT,ERR)
C**                                                                 ***
C****** calculation of error estimator is ready :                   ***
C**                                                                 ***
        IF ((OUTCNT.NE.0).AND.(ERR.EQ.0)) THEN
          WRITE (LOUT,9230) (J,RVEM(NORMU-1+J),
     &                      RVEM(NORMDG-1+J),RVEM(NORMEU-1+J),J=1,NK)
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** statistics :                                                  ***
C**   ----------                                                    ***
C**                                                                 ***
1000  CONTINUE

      RVEM(TRUN)=RVEM(TRUN)+VEMSCD()
      RVEM(TTOT)=RVEM(TTOT)-TIME+VEMSCD()
      TIME=RVEM(TRUN)

      IF ((OUTCNT.GT.0).AND.(ERR.LE.10)) THEN
        WRITE(LOUT,9031)
        WRITE(LOUT,9040)'addresses             ',RVEM(TADD)
        WRITE(LOUT,9040)'element matrices      ',RVEM(TELEM)
        WRITE(LOUT,9040)'mounting              ',RVEM(TMOUNT)
        WRITE(LOUT,9040)'LINSOL                ',RVEM(TLIN)
        WRITE(LOUT,9040)'paging                ',RVEM(TPAGE)
        WRITE(LOUT,9040)'total                 ',RVEM(TTOT)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** this is the end of VEME02 :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
9999  CONTINUE
      IVEM(5)=MAX(NIVEM,IVEM(5))
      IVEM(6)=MAX(NRVEM,IVEM(6))
      IVEM(7)=MAX(NLVEM,IVEM(7))
      IVEM(8)=SPACE
      CALL VEM097('VEME02',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9031  FORMAT(/'  time statistics :'/
     &       /37X,'|   total time  '
     &       /17X,'operation          ',' |     in sec   '/13X,40('-'))
9040  FORMAT(13X,A23,' |  ',F10.2)
9230  FORMAT('  norms of the components :'/
     &        10X,'        solution      X-defect   relative error'/
     &        (2X,I5,'-th  ',3(4X,G10.2)) )
9301  FORMAT(/'  mounting of the norm weights'/2X,28('-') )
9310  FORMAT(/'  mounting ended successfully. ',
     &                                   '( time : ',F10.2,' sec)'/)
9350  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
9170  FORMAT('  Index was read from unit ',I2,'.')
9150  FORMAT('  Index (=',I10,' bytes) was written to unit ',I2,'.')
9151  FORMAT('  Addresses (=',I10,' bytes) were written to unit ',
     &                                                         I2,'.')
9101  FORMAT ('>>VEMCD:10:0004'
     &       /'>>error in VEME02 on process ',I5,' (TID=',I10,')'
     &       /'>>during writing of data (=',I10,' bytes) ',
     &                                               'to unit ',I2,'.')
9102  FORMAT ('>>VEMCD:10:0003'
     &       /'>>error in VEME02 on process ',I5,' (TID=',I10,'):'
     &       /'>>during reading of data from unit ',I2,'.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEME02----------------------------------------------------
      E    N    D
