C:::::      ,,,,,VEMENS...                                          ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMENS(NAME,LIVEM,IVEM,LNEK,NEK,LRPARM,RPARM,LIPARM,
     &                  IPARM,LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                  LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                  LBIG,RBIG,IBIG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMENS     VECFEM ===> ensight input file                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"

      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,
     &                  LIDPRM,LNODN,LNOD,LNOPRM,LBIG
      DOUBLE PRECISION  NOD(LNOD),RPARM(LRPARM),RDPARM(LRDPRM),
     &                  NOPARM(LNOPRM),RBIG(LBIG)
      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  IDPARM(LIDPRM),DNOD(LDNOD),IBIG(RPI*LBIG)
      CHARACTER*80 NAME
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           MESH,ENSOUT,LOUT,NDEG,ERR,
     &                  NK,DIM,NN,OUTCNT,TIDS,NPROC,
     &                  MYPROC,NMSG,IOTID,MYTID,NBIG,NMIN,NMAX,
     &                  IBUF,RBUF,NDEGL,NDEG0L,I,NCARD,
     &                  DIS,NGROUP,GINFO,GINFO1,DINFO,DINFO1,NCARD1,
     &                  OWN,NOP,LBFIN,LBFRN,LBFRE,LBFIE,LBFN,LBFE,
     &                  LLNGTH(16),NLNGTH(16),MPINFO,SBT,IH1(1),IH2(1),
     &                  NESUM,WELEM,LBFPCK,G,NODNM2,NDEG2
      DOUBLE PRECISION  TIME,VEMSCD
      include "archi.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      TIDS=204
      LOUT=IVEM(120)
      IF ((ARCHI.LT.10).OR.(IVEM(200).EQ.1)) THEN
	IVEM(200)=1
	IVEM(201)=1
	IVEM(TIDS-1)=1
	IVEM(TIDS)=1
      ENDIF
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9300)
	IVEM(2)=99
	RETURN
      ENDIF
      ERR=0
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=0
      TIME=VEMSCD()
      OUTCNT = IVEM(121)
      ENSOUT = IVEM(125)
      IF (LOUT.LE.0) LOUT=6
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      NBIG=0
      MESH=IVEM(1)
      NCARD=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print mesh infos:                                             ***
C**   ----------------                                              ***
C**                                                                 ***
      CALL VEM000('VEMENS',OUTCNT,LOUT)
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NLNGTH(4)=IVEM(MESH+4)
      CALL VEM098('VEMENS',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      NDEG  =IVEM(MESH+1)
      NK    =IVEM(MESH+2)
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      NOP   =0
      OWN   =IVEM(MESH+15)
      DIS   =IVEM(MESH+18)
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      DINFO =IVEM(MESH+23)+MESH
      DINFO1=IVEM(MESH+24)
      NESUM=IVEM(MESH+25)+2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute buffer sizes:                                         ***
C**   --------------------                                          ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMAX=IH1(1)
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-IH1(1)
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,I,MYPROC,NPROC)
      WELEM=1
      CALL VEEN00(NDEGL,DIM,NGROUP,GINFO1,IVEM(GINFO),IBIG(WELEM),
     &            LBFPCK,LBFIN,LBFRN,LBFN,LBFRE,LBFIE,LBFE,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF (OUTCNT.GT.0) THEN
	DO 1 G=0,NGROUP-1
  	  IF (IBIG(WELEM+G).LE.0) WRITE(LOUT,4051) G+1
1       CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check the array length of IBIG:                               ***
C**   ------------------------------                                ***
C**                                                                 ***
      WELEM=1
      NODNM2=WELEM+NGROUP
      NBIG=(NODNM2+NDEG-1+MAX(LBFPCK*SBT,LBFE*RPI,LBFN*SBT*RPI)+RPI-1)
     &                                                            /RPI
      NLNGTH(4)=NBIG
      CALL VEM098('VEMENS',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create continuous numbering of geometrical nodes:             ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      IBUF=NODNM2+NDEG

      CALL VEM309 (NODNUM,IBIG(NODNM2),NDEG,NDEGL,NDEG0L,NDEG2,SBT,
     &             LBFPCK,IBIG(IBUF),NGROUP,GINFO1,IVEM(GINFO),
     &             IBIG(WELEM),NEK,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write header of file :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        REWIND(ENSOUT)
        CALL VEEN01 (ENSOUT,NAME,NCARD)
        IF (OUTCNT.GT.0) WRITE(LOUT,4040) NCARD
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write node coordinates :                                      ***
C**   ----------------------                                        ***
C**                                                                 ***
      CALL VEM301(1,NDEG2,NDEGL,NDEG0L,LBFRN,MYPROC,NPROC)
      IBUF=NODNM2+NDEG
      RBUF=(IBUF+LBFIN*SBT-1+RPI-1)/RPI+1

      NCARD1=NCARD
      CALL VEEN02(ENSOUT,IBIG(NODNM2),NOD,DIM,NN,NDEG,NDEG2,SBT,
     &            LBFIN,IBIG(IBUF),LBFRN*DIM,RBIG(RBUF),NDEGL,NDEG0L,
     &            IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),NCARD)
      IF ((MYTID.EQ.IOTID).AND.(OUTCNT.GT.0)) THEN
	 WRITE(LOUT,4050) NCARD-NCARD1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write elements:                                               ***
C**   --------------                                                ***
C**                                                                 ***
      IBUF=NODNM2+NDEG
      NCARD1=NCARD
      CALL VEEN03(ENSOUT,IBIG(NODNM2),NDEG,NGROUP,GINFO1,IVEM(GINFO),
     &            IBIG(WELEM),IVEM(NESUM),LNEK,NEK,LBFIE,IBIG(IBUF),
     &            IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),NCARD)
      IF ((MYTID.EQ.IOTID).AND.(OUTCNT.GT.0)) THEN
	 WRITE(LOUT,4060) NCARD-NCARD1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMENS',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9300  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
4051  FORMAT(3X,'group ',I3,' is skipped !')
4040  FORMAT(3X,'write header ................... cards =',I8)
4041  FORMAT(3X,'write end card ................. cards =',I8)
4050  FORMAT(3X,'write node coordinates ......... cards =',I8)
4060  FORMAT(3X,'write elements ................. cards =',I8)
4083  FORMAT(3X,'total number of cards ................ =',I8)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMENS ---------------------------------------------------
      E    N    D
