C:::::      ,,,,,VEMFRE...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMFRE(T,LU,U,UT,LIVEM,IVEM,LRVEM,RVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                  NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG,
     &                  MASKL,MASKF,USERL,USERF)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMFRE   checks the frechet derivatives of the linear        ***
C**             form                                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
      include "bytes.h"

      INTEGER          LU,LIVEM,LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,
     &                 LIDPRM,LNOD,LNOPRM,LBIG,LRVEM,LNODN

      DOUBLE PRECISION T,U(LU),UT(LU),RPARM(LRPARM),RDPARM(LRDPRM),
     &                 NOD(LNOD),NOPARM(LNOPRM),RBIG(LBIG),RVEM(LRVEM)

      INTEGER          IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                 IDPARM(LIDPRM),IBIG(LBIG*RPI),NODNUM(LNODN)

      LOGICAL          MASKF(*),MASKL(*)
      EXTERNAL         USERL,USERF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  TIME,VEMSCD,DIAM,DU,EPS,XMAX(3),XH1(3),LL8EPS,
     &                  ONE

      INTEGER           NQMAX,Q,WQ,S,DSDV,X,LIWORK,LRWORK,
     &                  IWORK,RWORK,ENOP,LIST,TAU,UU,UUT,
     &                  DUDX,DUTDX,DNOPDX,VRBIG,VRB2,NVRB2,
     &                  OUTCNT,ORDER,PARAB,ERR,IERR,G,
     &                  ELM1,ELM1T,LTAU,ORD,K,LOUT,
     &                  MESH,NGROUP,NDEG,NK,DIM,NN,GINFO,GINFO1,
     &                  NE,GEOTYP,FORM,CLASS,ADDGEO,GEO1,
     &                  ADRSP,NRSP,ADRVP,RVP1,NRVP,ADISP,NISP,ADIVP,
     &                  IVP1,NIVP,NOP,NOP1,NRVEM,NPROC,MYPROC,IOTID,
     &                  MYTID,NBIG,NU,NQ,U1,TIDS,NMSG,
     &                  LLNGTH(16),NLNGTH(16),MPINFO,SBT,IHELP(3)
      LOGICAL           DFDUT, SYM2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT=IVEM(90)
      LLNGTH(1)=LIVEM
      LLNGTH(2)=LRVEM
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=LU
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9300)
	IVEM(2)=99
	RETURN
      ENDIF

      TIME=VEMSCD()
      DU=RVEM(4)
      IF (LOUT.LE.0) LOUT=6
      OUTCNT=MAX(1,IVEM(91))
      PARAB=IVEM(92)
      MESH=IVEM(1)
      U1=IVEM(93)
      ERR=0
      NBIG=0
      SYM2=.TRUE.
      IF (PARAB.GE.2) THEN
        DFDUT=.TRUE.
      ELSE
        DFDUT=.FALSE.
      ENDIF
      ONE=1
      NRVEM=20
      EPS=LL8EPS(ONE)
      NK=IVEM(MESH+2)
      NU=NK*U1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('VEMFRE',OUTCNT,LOUT)
        WRITE (LOUT,9100) 90,LOUT
        WRITE (LOUT,9120) 92,PARAB
        IF (PARAB.LE.0) THEN
          WRITE (LOUT,9130)
        ELSE IF (PARAB.LE.1) THEN
           WRITE (LOUT,9140)
        ELSE
           WRITE (LOUT,9150)
        ENDIF
        WRITE (LOUT,9121) 93,U1
        WRITE (LOUT,9110) 4,DU
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check input parameters :                                      ***
C**   ----------------------                                        ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NLNGTH(2)=NRVEM
      NLNGTH(16)=NU
      CALL VEM098('VEMFRE',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch values from IVEM :                                      ***
C**   -----------------------                                       ***
C**                                                                 ***
      NDEG  =IVEM(MESH+1)
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      NOP1  =IVEM(MESH+13)
      NOP   =IVEM(MESH+14)
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      ORDER=1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute mesh diameter :                                       ***
C**   ---------------------                                         ***
C**                                                                 ***
      CALL LL4RNM(NDEG,DIM,NN,NOD,XMAX,XH1,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      DIAM=0
      DO 5002 K=1,DIM
5002    DIAM=MAX(DIAM,XMAX(K))
      IF (OUTCNT.NE.0) WRITE (LOUT,9160) DIAM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** begin of group loop :                                         ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 10   G=1,NGROUP

        NE     = IVEM(GINFO+GINFO1*(G-1)   )
        GEOTYP = IVEM(GINFO+GINFO1*(G-1)+ 1)
        FORM   = IVEM(GINFO+GINFO1*(G-1)+ 2)
        CLASS  = IVEM(GINFO+GINFO1*(G-1)+ 3)
        ADDGEO = IVEM(GINFO+GINFO1*(G-1)+ 4)
        GEO1   = IVEM(GINFO+GINFO1*(G-1)+ 5)

        ADRSP  = IVEM(GINFO+GINFO1*(G-1)+ 7)
        NRSP   = IVEM(GINFO+GINFO1*(G-1)+ 8)
        ADRVP  = IVEM(GINFO+GINFO1*(G-1)+ 9)
        RVP1   = IVEM(GINFO+GINFO1*(G-1)+10)
        NRVP   = IVEM(GINFO+GINFO1*(G-1)+11)

        ADISP  = IVEM(GINFO+GINFO1*(G-1)+12)
        NISP   = IVEM(GINFO+GINFO1*(G-1)+13)
        ADIVP  = IVEM(GINFO+GINFO1*(G-1)+14)
        IVP1   = IVEM(GINFO+GINFO1*(G-1)+15)
        NIVP   = IVEM(GINFO+GINFO1*(G-1)+16)
        IF (NE.GT.0) THEN
        IF (OUTCNT.GT.0) WRITE(LOUT,9600) G,MYPROC
        ORD  =ORDER
        ELM1=NE
        IF (PARAB.GT.0) THEN
          ELM1T=NE
        ELSE
          ELM1T=0
        ENDIF
        IF ((CLASS.EQ.DIM).OR.(CLASS.EQ.0)) THEN
          LTAU=0
        ELSE
          LTAU=NE
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** check shape functions :                                     ***
C**     ---------------------                                       ***
C**                                                                 ***
C**     RWORK/IWORK is the real/integer storage needed to           ***
C**     compute the centre point and the shape functions            ***
C**                                                                 ***
        CALL VEMPR0(0,G,CLASS,FORM,0,ORD,NQMAX,
     &              GEOTYP,IVEM(GINFO+GINFO1*(G-1)+ 1),
     &              IVEM(GINFO+GINFO1*(G-1)+ 6),GEOTYP,
     &              LRWORK,LIWORK,MYPROC,MYTID,LOUT,IERR)
        IF (IERR.NE.0) THEN
          ERR=99
          GOTO 10
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** start addresses:                                            ***
C**     ---------------                                             ***
C**                                                                 ***
        LIST =1
        WQ   =(LIST-1+NE+RPI-1)/RPI+1
        Q    =WQ                   +1           *NQMAX
        S    =Q                    +CLASS       *NQMAX
        DSDV =S                    +GEOTYP      *NQMAX
        RWORK=DSDV                 +GEOTYP*CLASS*NQMAX
        IWORK=(RWORK-1+LRWORK)*RPI      +1
        X     =(IWORK-1+LIWORK+RPI-1)/RPI+1
        TAU   =X     +ELM1*DIM
        UU    =TAU   +LTAU*CLASS*DIM
        UUT   =UU    +ELM1*NK
        ENOP  =UUT   +ELM1T*NK
        DUDX  =ENOP  +ELM1*NOP
        DUTDX =DUDX  +ELM1*NK*CLASS
        DNOPDX=DUTDX +ELM1T*NK*CLASS

        VRBIG =DNOPDX+ELM1*NOP*CLASS
        VRB2  =MAX((LBIG-VRBIG+1)/NE,0)
        NBIG  =MAX(VRBIG-1+VRB2*NE,NBIG)
	IF (NBIG.GT.LBIG) GOTO 10
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** set shape functions:                                        ***
C**     -------------------                                         ***
C**                                                                 ***
        CALL VEMPRF(0,G,CLASS,FORM,0,ORD,NQ,NQMAX,RBIG(WQ),RBIG(Q),
     &              GEOTYP,RBIG(S),RBIG(DSDV),
     &              IVEM(GINFO+GINFO1*(G-1)+ 1),
     &              IVEM(GINFO+GINFO1*(G-1)+ 6),GEOTYP,
     &              RBIG(S),RBIG(DSDV),
     &              RBIG(S),RBIG(DSDV),
     &              LRWORK,RBIG(RWORK),LIWORK,IBIG(IWORK),
     &              MYPROC,MYTID,LOUT,ERR)
        IF (ERR.NE.0) GOTO 10
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** call of Frechet test:                                       ***
C**     --------------------                                        ***
C**                                                                 ***
C**   IERR = X0 small storage                                       ***
C**          X1 illegal element volume                              ***
C**          X2 illegal frechets                                    ***
C**          X3 illegal mask                                        ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** inner elements                                                ***
C**   --------------                                                ***
C**                                                                 ***
      IF (CLASS.EQ.DIM) THEN

        CALL VEM590(DFDUT,DU,EPS,SYM2,DIAM,
     &              T,G,U1,NK,NE,GEOTYP,GEO1,NEK(ADDGEO),
     &              NRSP,RPARM(ADRSP),NRVP,RVP1,RPARM(ADRVP),
     &              NISP,IPARM(ADISP),NIVP,IVP1,IPARM(ADIVP),
     &              NOP1,NOP,NOPARM,
     &              DIM,NN,NOD,U,UT,
     &              MASKL(1+NK*NK*(G-1)),USERL,
     &              MASKF(1+NK*(G-1)),USERF,
     &              RBIG(S),RBIG(DSDV),ELM1,RBIG(X),
     &              RBIG(UU),ELM1T,RBIG(UUT),RBIG(ENOP),
     &              RBIG(DUDX),RBIG(DUTDX),RBIG(DNOPDX),
     &              NVRB2,VRB2,RBIG(VRBIG),
     &              IBIG(LIST),OUTCNT,LOUT,IERR)
        IF (IERR.EQ.5901) ERR=MAX(ERR,83)
        IF (IERR.EQ.5902) ERR=MAX(ERR,82)
        IF (IERR.EQ.5903) ERR=MAX(ERR,81)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** area elements                                                 ***
C**   -------------                                                 ***
C**                                                                 ***
      IF ((CLASS.EQ.2).AND.(DIM.EQ.3)) THEN

        CALL VEM592(DFDUT,DU,EPS,SYM2,DIAM,
     &              T,G,U1,NK,NE,GEOTYP,GEO1,NEK(ADDGEO),
     &              NRSP,RPARM(ADRSP),NRVP,RVP1,RPARM(ADRVP),
     &              NISP,IPARM(ADISP),NIVP,IVP1,IPARM(ADIVP),
     &              NOP1,NOP,NOPARM,NN,NOD,U,UT,
     &              MASKL(1+NK*NK*(G-1)),USERL,
     &              MASKF(1+NK*(G-1)),USERF,
     &              RBIG(S),RBIG(DSDV),ELM1,RBIG(X),
     &              RBIG(UU),ELM1T,RBIG(UUT),RBIG(ENOP),RBIG(TAU),
     &              RBIG(DUDX),RBIG(DUTDX),RBIG(DNOPDX),
     &              NVRB2,VRB2,RBIG(VRBIG),
     &              IBIG(LIST),OUTCNT,LOUT,IERR)
        IF (IERR.EQ.5921) ERR=MAX(ERR,83)
        IF (IERR.EQ.5922) ERR=MAX(ERR,82)
        IF (IERR.EQ.5923) ERR=MAX(ERR,81)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** line elements                                                 ***
C**   -------------                                                 ***
C**                                                                 ***
      IF ((CLASS.EQ.1).AND.(DIM.GT.1)) THEN

        CALL VEM593(DFDUT,DU,EPS,SYM2,DIAM,
     &              T,G,U1,NK,NE,GEOTYP,GEO1,NEK(ADDGEO),
     &              NRSP,RPARM(ADRSP),NRVP,RVP1,RPARM(ADRVP),
     &              NISP,IPARM(ADISP),NIVP,IVP1,IPARM(ADIVP),
     &              NOP1,NOP,NOPARM,DIM,NN,NOD,U,UT,
     &              MASKL(1+NK*NK*(G-1)),USERL,
     &              MASKF(1+NK*(G-1)),USERF,
     &              RBIG(S),RBIG(DSDV),ELM1,RBIG(X),
     &              RBIG(UU),ELM1T,RBIG(UUT),RBIG(ENOP),RBIG(TAU),
     &              RBIG(DUDX),RBIG(DUTDX),RBIG(DNOPDX),
     &              NVRB2,VRB2,RBIG(VRBIG),
     &              IBIG(LIST),OUTCNT,LOUT,IERR)
        IF (IERR.EQ.5931) ERR=MAX(ERR,83)
	IF (IERR.EQ.5932) ERR=MAX(ERR,82)
        IF (IERR.EQ.5933) ERR=MAX(ERR,81)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** nodal elements                                                ***
C**   --------------                                                ***
C**                                                                 ***
      IF (CLASS.EQ.0) THEN

        CALL VEM594(DFDUT,DU,EPS,SYM2,
     &              T,G,U1,NK,NE,GEO1,NEK(ADDGEO),
     &              NRSP,RPARM(ADRSP),NRVP,RVP1,RPARM(ADRVP),
     &              NISP,IPARM(ADISP),NIVP,IVP1,IPARM(ADIVP),
     &              NOP1,NOP,NOPARM,
     &              DIM,NN,NOD,U,UT,
     &              MASKL(1+NK*NK*(G-1)),USERL,
     &              MASKF(1+NK*(G-1)),USERF,
     &              ELM1,RBIG(X),
     &              RBIG(UU),ELM1T,RBIG(UUT),RBIG(ENOP),
     &              NVRB2,VRB2,RBIG(VRBIG),
     &              IBIG(LIST),OUTCNT,LOUT,IERR)
        IF (IERR.EQ.5942) ERR=MAX(ERR,82)
        IF (IERR.EQ.5943) ERR=MAX(ERR,81)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      IF (OUTCNT.GT.0) THEN
        IF (IERR.GT.0) THEN
          WRITE(LOUT,9620) G,MYPROC
        ELSE
          WRITE(LOUT,9610) G,MYPROC
        ENDIF
      ENDIF
      NBIG=MAX(VRBIG-1+NVRB2*NE,NBIG)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of GROUP LOOP :                                           ***
C**   -------------------                                           ***
C**                                                                 ***
        ENDIF
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
 1000 CONTINUE
      NLNGTH(4)=NBIG
      CALL VEM098('VEMFRE',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check the symmetry flag:                                      ***
C**   -----------------------                                       ***
C**                                                                 ***
      IF ((ERR.EQ.0).AND.(OUTCNT.GT.0)) THEN
        IHELP(1)=1
        IF (SYM2) IHELP(1)=0
        CALL LL4INM(1,1,1,IHELP(1),IHELP(2),IHELP(3),
     &              MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
        IF (IHELP(2).EQ.0) WRITE(LOUT,9530)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print end cards :                                             ***
C**   ---------------                                               ***
C**                                                                 ***
9999  CONTINUE
      IVEM(6)=NRVEM
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMFRE',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9100  FORMAT('    line out unit ......................... LOUT =',
     &                                          ' IVEM(',I4,') = ',I10)
9110  FORMAT('    perturbation ............................ DU =',
     &                                        ' RVEM(',I4,') = ',G10.5)
9120  FORMAT('    case indicator ....................... PARAB =',
     &                                          ' IVEM(',I4,') = ',I10)
9121  FORMAT('    leading dimension of U and UT array ..... U1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9130  FORMAT('    => elliptic case')
9140  FORMAT('    => parabolic case, Frechets with respect to U')
9150  FORMAT('    => parabolic case, Frechets with respect to UT')
9160  FORMAT('    diameter of the domain .......................',
     &                                         '........... = ',G10.5)
9300  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
9530  FORMAT(/'**>The test indicates a symmetric Frechet derivative.'
     &       /'   Please check whether you can set the symmetry flag.')
9600  FORMAT(/'   group ',I3,', process ',I4,' : S T A R T')
9610  FORMAT('   group ',I3,', process ',I4,' : P E R F E C T')
9620  FORMAT('   group ',I3,', process ',I4,' : D E F E C T I V')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
      R E T U R N
C-----End of VEMFRE----------------------------------------------------
      E    N    D
