C:::::      ,,,,,VEMGE2...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMGE2 (PROPOP,LIVEM,IVEM,LNEK,NEK,LRPARM,RPARM,LIPARM,
     &                   IPARM,LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                   LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                   LBIG,IBIG,RBIG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMGE2   generate a mixed mesh from isoparametrical mesh     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"
      include "archi.h"

      INTEGER           LIVEM,LBIG,LNOPRM,LNODN,
     &                  LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,LIDPRM,LNOD

      DOUBLE PRECISION  RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  DNOD(LDNOD),NODNUM(LNODN),
     &                  PROPOP(*),IDPARM(LIDPRM),IBIG(RPI*LBIG)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  TIME,VEMSCD
      INTEGER           LOUT,OUTCNT,NK,DIM,NN,NGROUP,NDEG,
     &                  DINFO1,DINFO,GINFO1,GINFO,MESH,NOP,NOP1,
     &                  OWN,DIS,ERR,Z,NBIG,NNEK,NDNOD,
     &                  NNEK2,NDNOD2,NPROC,MYPROC,MYTID,IOTID,TIDS,
     &                  NMSG,LLNGTH(16),NLNGTH(16),MPINFO,SBT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      TIDS=204
      LOUT=IVEM(101)
      IF ((ARCHI.LT.10).OR.(IVEM(200).EQ.1)) THEN
	IVEM(200)=1
	IVEM(201)=1
	IVEM(TIDS-1)=1
	IVEM(TIDS)=1
      ENDIF
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9300)
	IVEM(2)=99
	RETURN
      ENDIF
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=0
      TIME=VEMSCD()
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)

      IF (IVEM(101).LE.0) IVEM(101)=6
      IVEM(102)=MAX(IVEM(102),0)
      MESH=IVEM(1)
      OUTCNT=IVEM(102)
      ERR=0
      NBIG=0
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('VEMGE2',OUTCNT,LOUT)
        WRITE(LOUT,9200) 101,LOUT
        WRITE(LOUT,9210) 102,OUTCNT
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check input data :                                            ***
C**   -----------------                                             ***
C**                                                                 ***
      IVEM(MESH+15)=0
      CALL VEM600(LIVEM,IVEM,NLNGTH,0,ERR,0,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      CALL VEM098('VEMGE2',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch mesh parameters :                                       ***
C**   ---------------------                                         ***
C**                                                                 ***
      NDEG  =IVEM(MESH+ 1)
      NK    =IVEM(MESH+ 2)
      DIM   =IVEM(MESH+ 3)
      NGROUP=IVEM(MESH+ 4)
      NN    =IVEM(MESH+ 5)
      NOP1  =IVEM(MESH+ 13)
      NOP   =IVEM(MESH+ 14)
      OWN   =IVEM(MESH+15)
      DIS   =IVEM(MESH+18)
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      DINFO =IVEM(MESH+23)+MESH
      DINFO1=IVEM(MESH+24)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute storage and set ginfo :                               ***
C**   -----------------------------                                 ***
C**                                                                 ***
      CALL VEM210(NGROUP,GINFO1,IVEM(GINFO),NK,DINFO1,IVEM(DINFO),
     &            PROPOP,OWN,NNEK2,NDNOD2)
      NDNOD =IVEM(MESH+ 9)
      NNEK=IVEM(MESH+6)
      NBIG=(MAX(NDNOD,NNEK)+RPI-1)/RPI
      IVEM(MESH+6)=NNEK2
      IVEM(MESH+9)=NDNOD2

      NLNGTH(4)=NBIG
      NLNGTH(8)=NNEK2
      NLNGTH(11)=NDNOD2
      CALL VEM098('VEMGE2',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create mixed mesh :                                           ***
C**   ------------------                                            ***
C**                                                                 ***
      IF (OUTCNT.NE.0) WRITE(LOUT,9301)
      DO 2341 Z=1,NNEK
2341   IBIG(Z)=NEK(Z)
      CALL VEM214(DIS,NGROUP,GINFO1,IVEM(GINFO),OWN,NK,PROPOP,
     &            NNEK,IBIG,LNEK,NEK,NDEG,NODNUM,OUTCNT,LOUT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create the dirichlet conditions:                              ***
C**   -------------------------------                               ***
C**                                                                 ***
      IF (OUTCNT.NE.0) WRITE(LOUT,9302)
      DO 2340 Z=1,NDNOD
2340   IBIG(Z)=DNOD(Z)
      CALL VEM215(DIS,OWN,NK,DINFO1,IVEM(DINFO),
     &            NDNOD,IBIG,LDNOD,DNOD,NDEG,NODNUM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print new mesh infos:                                         ***
C**   --------------------                                          ***
C**                                                                 ***
      IVEM(MESH   )=0
      IVEM(MESH+15)=OWN
      IVEM(MESH+16)=0
      CALL VEM600(LIVEM,IVEM,NLNGTH,0,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF (ERR.NE.0) ERR=ERR+100
      CALL VEM098('VEMGE2',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print end cards :                                             ***
C**   ---------------                                               ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      IVEM(MESH+18)=0
      CALL VEM097('VEMGE2',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9200  FORMAT ('    line output to unit .................... LOUT =',
     &                                          ' IVEM(',I4,') =',I10)
9210  FORMAT ('    output control ....................... OUTCNT =',
     &                                          ' IVEM(',I4,') =',I10)
9300  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
9301  FORMAT(/'  create mixed mesh:')
9302  FORMAT('  create Dirichlet conditions.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMGE2----------------------------------------------------
      E    N    D
