C:::::      ,,,,,VEMISV...                                          ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMISV(NAME,LIVEM,IVEM,LNEK,NEK,LRPARM,RPARM,LIPARM,
     &                  IPARM,LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                  LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                  LBIG,RBIG,IBIG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMISV         VECFEM ===> ISVAS 3.1                       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"

      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,
     &                  LIDPRM,LNODN,LNOD,LNOPRM,LBIG
      DOUBLE PRECISION  NOD(LNOD),RPARM(LRPARM),RDPARM(LRDPRM),
     &                  NOPARM(LNOPRM),RBIG(LBIG)
      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  IDPARM(LIDPRM),DNOD(LDNOD),IBIG(RPI*LBIG)
      CHARACTER*80 NAME
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                    >                                            ***
      INTEGER           MESH,LOUT,NDEG,ERR,
     &                  NK,DIM,NN,OUTCNT,TIDS,NPROC,
     &                  MYPROC,NMSG,IOTID,MYTID,NBIG,NMIN,NMAX,
     &                  IBUF,NDEGL,NDEG0L,I,ELMOUT,LIBFN,LIBFE,NESUM,
     &                  DIS,NGROUP,GINFO,GINFO1,DINFO,DINFO1,TOTNE,
     &                  OWN,WELEM,NODOUT,G,Z,GLBNOD,NDEG2,NODNM2,
     &                  LLNGTH(16),NLNGTH(16),MPINFO,SBT,IH1(1),IH2(1)
      DOUBLE PRECISION  TIME,VEMSCD
      include "archi.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT   = IVEM(120)
      TIDS=204
      IF ((ARCHI.LT.10).OR.(IVEM(200).EQ.1)) THEN
	IVEM(200)=1
	IVEM(201)=1
	IVEM(TIDS-1)=1
	IVEM(TIDS)=1
      ENDIF
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9300)
	IVEM(2)=99
	RETURN
      ENDIF
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=0
      ERR=0
      TIME=VEMSCD()
      OUTCNT = IVEM(121)
      NODOUT = IVEM(125)
      ELMOUT = IVEM(126)
      IF (LOUT.LE.0) LOUT=6
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      NBIG=0
      MESH=IVEM(1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   print table :                                                 ***
C**   -------------                                                 ***
C**                                                                 ***
      CALL VEM000('VEMISV',OUTCNT,LOUT)
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NLNGTH(4)=IVEM(MESH+4)
      CALL VEM098('VEMISV',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      NDEG  =IVEM(MESH+1)
      NK    =IVEM(MESH+2)
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      OWN   =IVEM(MESH+15)
      DIS   =IVEM(MESH+18)
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      DINFO =IVEM(MESH+23)+MESH
      DINFO1=IVEM(MESH+24)
      NESUM=IVEM(MESH+1)+2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute buffer sizes :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMAX=IH1(1)
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-IH1(1)
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,I,MYPROC,NPROC)

      WELEM=1
      CALL VEIS00 (NDEGL,NGROUP,GINFO1,IVEM(GINFO),IBIG(WELEM),
     &             LIBFN,LIBFE,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF (OUTCNT.GT.0) THEN
	DO 1 G=0,NGROUP-1
  	  IF (IBIG(WELEM+G).LE.0) WRITE(LOUT,4051) G+1
1       CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create continuous global geometrical node numbering:          ***
C**   ---------------------------------------------------           ***
C**                                                                 ***
      NODNM2=WELEM+NGROUP
      IBUF=NODNM2+NDEG
      NBIG=(IBUF-1+MAX(LIBFN*SBT,LIBFE)+RPI-1)/RPI
      NLNGTH(4)=NBIG
      CALL VEM098('VEMISV',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999

      CALL VEM309 (NODNUM,IBIG(NODNM2),NDEG,NDEGL,NDEG0L,NDEG2,SBT,
     &             LIBFN,IBIG(IBUF),NGROUP,GINFO1,IVEM(GINFO),
     &             IBIG(WELEM),NEK,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create global node vector and write it to unit NODOUT:        ***
C**   -----------------------------------------------------         ***
C**                                                                 ***
      GLBNOD=(IBUF-1+RPI-1)/RPI+1
      NBIG=MAX(GLBNOD-1+NDEG2*3,NBIG)
      NLNGTH(4)=NBIG
      CALL VEM098('VEMISV',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
      CALL VEIS08 (IBIG(NODNM2),NOD,DIM,NN,NDEG,RBIG(GLBNOD),NDEG2,3,
     &             MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF (MYTID.EQ.IOTID) THEN
	WRITE(NODOUT,'(A4,1X,I9)') 'NODE',NDEG2
	WRITE(NODOUT,'(A4,1X,80A)') 'NAME',NAME(:INDEX(NAME,' '))
	WRITE(NODOUT,'(A4,1X,I9)') 'TIME',1
	WRITE(NODOUT,*) (SNGL(RBIG(GLBNOD-1+Z)),Z=1,3*NDEG2)
        IF (OUTCNT.GT.0) WRITE(LOUT,4050) NDEG2
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write elements:                                               ***
C**   --------------                                                ***
C**                                                                 ***
      CALL VEIS03 (NAME,ELMOUT,IBIG(NODNM2),NDEG,NGROUP,GINFO1,
     &             IVEM(GINFO),IVEM(NESUM),TOTNE,IBIG(WELEM),LNEK,
     &             NEK,LIBFE,IBIG(IBUF),
     &             IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF ((OUTCNT.GT.0).AND.(MYTID.EQ.IOTID)) WRITE(LOUT,4060) TOTNE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it:                                                    ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMISV',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9300  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
4051  FORMAT(3X,'group ',I3,' is skipped !')
4050  FORMAT(3X,'written geometrical nodes ........... =',I9)
4060  FORMAT(3X,'written elements .................... =',I9)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C**---End of VEMISV ------------------------------------------------***
      E    N    D
