C**:::      ,,,,,VEMLP1.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMLP1(NELTYP,N,V,S,DSDV,NODE,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEMLP1  sets lagrangean proposal functions at points          ***
C**           for line-elements                                     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           NELTYP,N,ERR

      DOUBLE PRECISION  V(N),S(NELTYP,N),DSDV(NELTYP,N),NODE(NELTYP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes of the proposal functions
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of points
C--------I------I-----I------------------------------------------------
C V      I  R   I in  I points in the element               array: V(N)
C--------I------I-----I------------------------------------------------
C S      I  R   I out I proposal functions at V      array: S(NELTYP,N)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I out I derivatvess of the proposal functions at V 
C        I      I     I                           array: DSDV(NELTYP,N)
C--------I------I-----I------------------------------------------------
C NODE   I  R   I  -  I node coordinates            array: NODE(NELTYP)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10002   illegal proposal function
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           I,J,Q,R
      DOUBLE PRECISION  LDR,MULT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=0
      IF (NELTYP.LT.1) THEN
        ERR=10002
        RETURN
      ENDIF

      CALL VEMLP7(NELTYP,NODE)

      DO 10 I=1,NELTYP

        DO 8820 J=1,N
          S(I,J) = 1.D0
8820    CONTINUE
        DO 8810 R=1,NELTYP
          IF (R.NE.I) THEN
            DO 8821 J=1,N
              S(I,J)=S(I,J)*(NODE(R)-V(J))/(NODE(R)-NODE(I))
 8821       CONTINUE
          ENDIF
 8810   CONTINUE

        DO 20 J=1,N
          LDR = 0.D0
          DO 1110 Q=1,NELTYP
            IF (Q.NE.I) THEN
              MULT=1.D0
              DO 1120 R=1,NELTYP
                IF ((R.NE.I).AND.(R.NE.Q)) THEN
                  MULT=MULT*(NODE(R)-V(J))/(NODE(R)-NODE(I))
                ENDIF
 1120         CONTINUE
              LDR = LDR+MULT/(NODE(I)-NODE(Q))
            ENDIF
 1110     CONTINUE
          DSDV(I,J)=LDR
 20     CONTINUE

 10   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VEMLP1----------------------------------------------------
      E    N    D
