C**:::      ,,,,,VEMLP2.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMLP2(NELTYP,N,V,S,DSDV,NODE,ERR)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEMLP2  sets lagrangian proposal functions at points V        ***
C**           for triangles  (CLASS=2, FORM=3)                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           NELTYP,N,ERR

      DOUBLE PRECISION  V(2,N),S(NELTYP,N),DSDV(NELTYP,2,N),
     &                  NODE(NELTYP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes for the proposal functions
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of points
C--------I------I-----I------------------------------------------------
C V      I  R   I in  I points in the element             array: V(2,N)
C--------I------I-----I------------------------------------------------
C S      I  R   I out I proposal functions at V      array: S(NELTYP,N)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I out I derivatives of proposal functions at V
C        I      I     I                         array: DSDV(NELTYP,2,N)
C--------I------I-----I------------------------------------------------
C NODE   I  R   I  -  I node coordinates          array: NODE(2,NELTYP)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I ERROR NUMBER
C        I      I     I 10002   illegal proposal function
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           Z,L,M,NELT,HELP,NUMBER,Q,R
      DOUBLE PRECISION  XC,YC,LFNX,LFNY,LDRX,LDRY,LFN,LDR,MULT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=10002
      NELT=(-1.D0+SQRT(8.D0*DBLE(NELTYP)+1.D0))/2+.5D0
      HELP=((NELT+1)*NELT)/2
      IF (NELTYP.NE.HELP) RETURN
      ERR=0

      CALL  VEMLP7(NELT,NODE)

      NUMBER=0
      DO 10 M=1,NELT
        DO 20 L=1,NELT-M+1
          NUMBER=NUMBER+1
          DO 30 Z=1,N
            XC=V(1,Z)
            YC=V(2,Z)
            LFNX = 1.D0
            DO 8810 R=1,L-1
              LFNX=LFNX*(NODE(R)-XC)/(NODE(R)-NODE(L))
 8810       CONTINUE

            LFNY = 1.D0
            DO 8811 R=1,M-1
              LFNY=LFNY*(NODE(R)-YC)/(NODE(R)-NODE(M))
 8811       CONTINUE

            LFN = 1.D0
            DO 9910 R=1,NELT+1-L-M
              LFN=LFN*(NODE(L)-XC+NODE(M+R)-YC)/(NODE(M+R)-NODE(M))
 9910       CONTINUE

            S(NUMBER,Z)=LFN*LFNX*LFNY
            LDRX = 0.D0
            DO 1010 Q=1,L-1
              MULT=1.D0
              DO 1020 R=1,L-1
                IF (R.NE.Q) THEN
                  MULT=MULT*(NODE(R)-XC)/(NODE(R)-NODE(L))
                ENDIF
 1020         CONTINUE
              LDRX = LDRX+MULT/(NODE(L)-NODE(Q))
 1010       CONTINUE

            LDRY = 0.D0
            DO 1011 Q=1,M-1
              MULT=1.D0
              DO 1021 R=1,M-1
                IF (R.NE.Q) THEN
                  MULT=MULT*(NODE(R)-YC)/(NODE(R)-NODE(M))
                ENDIF
 1021         CONTINUE
              LDRY = LDRY+MULT/(NODE(M)-NODE(Q))
 1011       CONTINUE

            LDR=0.D0
            DO 1310 Q=1,NELT+1-L-M
              MULT=1.D0
              DO 1320 R=1,NELT+1-L-M
                IF (Q.NE.R) THEN
                 MULT=MULT*(NODE(L)-XC+NODE(M+R)-YC)/(NODE(M+R)-NODE(M))
                ENDIF
 1320           CONTINUE
              LDR=LDR+MULT/(-NODE(M+Q)+NODE(M))
 1310         CONTINUE

            DSDV(NUMBER,1,Z)=LFNY*(LDRX*LFN+LFNX*LDR)
            DSDV(NUMBER,2,Z)=LFNX*(LDRY*LFN+LFNY*LDR)
  30      CONTINUE
  20    CONTINUE
  10  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VEMLP2----------------------------------------------------
      E    N    D
