C**:::      ,,,,,VEMLP4.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMLP4(NELTYP,N,V,S,DSDV,NODE,ERR)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEMLP4  sets lagrangean proposal functions at point V         ***
C**           for prism  (CLASS=3, FORM=6)                          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           NELTYP,N,ERR

      DOUBLE PRECISION  V(3,N),S(NELTYP,N),DSDV(NELTYP,3,N),
     &                  NODE(NELTYP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes for the proposal functions
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of points
C--------I------I-----I------------------------------------------------
C V      I  R   I in  I points in the element             array: V(3,N)
C--------I------I-----I------------------------------------------------
C S      I  R   I out I proposal functions at V      array: S(NELTYP,N)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I out I derivatives of proposal functions at V :
C        I      I     I                         array: DSDV(NELTYP,3,N)
C--------I------I-----I------------------------------------------------
C NODE   I  R   I  -  I node coordinates          array: NODE(3,NELTYP)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10002   illegal proposal function
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           Z,K,L,M,NELT,NUMBER,MUELL,Q,R

      DOUBLE PRECISION  LFN,LFNX,LFNY,LFNZ,LDR,LDRX,LDRY,LDRZ,
     &                  XC,YC,ZC,MULT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=10002

      NELT=0
1234  NELT=NELT+1
      MUELL=(NELT**3+NELT**2)/2
      IF (MUELL.LT.NELTYP) GOTO 1234
      IF (MUELL.NE.NELTYP) RETURN
      ERR=0

      CALL  VEMLP7(NELT,NODE)

      NUMBER=0
      DO 20 K=1,NELT
        DO 30 M=1,NELT
          DO 40 L=1,NELT-M+1
            NUMBER=NUMBER+1
            DO 50 Z=1,N
              XC=V(1,Z)
              YC=V(2,Z)
              ZC=V(3,Z)

              LFN = 1.D0
              DO 9910 R=1,NELT+1-L-M
                LFN=LFN*(NODE(L)-XC+NODE(M+R)-YC)/(NODE(M+R)-NODE(M))
 9910         CONTINUE

              LFNX = 1.D0
              DO 8810 R=1,L-1
                LFNX=LFNX*(NODE(R)-XC)/(NODE(R)-NODE(L))
 8810         CONTINUE

              LFNY = 1.D0
              DO 8811 R=1,M-1
                LFNY=LFNY*(NODE(R)-YC)/(NODE(R)-NODE(M))
 8811         CONTINUE

              LFNZ = 1.D0
              DO 8812 R=1,NELT
                IF (R.NE.K) THEN
                  LFNZ=LFNZ*(NODE(R)-ZC)/(NODE(R)-NODE(K))
                ENDIF
 8812         CONTINUE

              S(NUMBER,Z)=LFN*LFNX*LFNY*LFNZ

              LDRX = 0.D0
              DO 1110 Q=1,L-1
                MULT=1.D0
                DO 1120 R=1,L-1
                  IF (R.NE.Q) THEN
                    MULT=MULT*(NODE(R)-XC)/(NODE(R)-NODE(L))
                  ENDIF
 1120           CONTINUE
                LDRX = LDRX+MULT/(NODE(L)-NODE(Q))
 1110         CONTINUE

              LDRY = 0.D0
              DO 1111 Q=1,M-1
                MULT=1.D0
                DO 1121 R=1,M-1
                  IF (R.NE.Q) THEN
                    MULT=MULT*(NODE(R)-YC)/(NODE(R)-NODE(M))
                  ENDIF
 1121           CONTINUE
                LDRY = LDRY+MULT/(NODE(M)-NODE(Q))
 1111         CONTINUE

              LDRZ = 0.D0
              DO 1112 Q=1,NELT
                IF (Q.NE.K) THEN
                  MULT=1.D0
                  DO 1122 R=1,NELT
                    IF ((R.NE.K).AND.(R.NE.Q)) THEN
                      MULT=MULT*(NODE(R)-ZC)/(NODE(R)-NODE(K))
                    ENDIF
 1122             CONTINUE
                  LDRZ = LDRZ+MULT/(NODE(K)-NODE(Q))
                ENDIF
 1112         CONTINUE

              LDR=0.D0
              DO 1210 Q=1,NELT+1-L-M
                MULT=1.D0
                DO 1220 R=1,NELT+1-L-M
                  IF (Q.NE.R) THEN
                    MULT=MULT*(NODE(L)-XC+NODE(M+R)-YC)
     &                  /(NODE(M+R)-NODE(M))
                  ENDIF
 1220           CONTINUE
                LDR=LDR+MULT/(-NODE(M+Q)+NODE(M))
 1210         CONTINUE

              DSDV(NUMBER,1,Z)=LFNY*LFNZ*(LDRX*LFN+LFNX*LDR)
              DSDV(NUMBER,2,Z)=LFNX*LFNZ*(LDRY*LFN+LFNY*LDR)
              DSDV(NUMBER,3,Z)=LFNX*LFNY*LFN*LDRZ
  50        CONTINUE
  40      CONTINUE
  30    CONTINUE
  20  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VEMLP4----------------------------------------------------
      E    N    D
