C**:::      ,,,,,VEMLP6.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMLP6(NELTYP,N,V,S,DSDV,NODE,ERR)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEMLP6  sets Lagrangean proposal functions at points V        ***
C**           for hexahedron (CLASS=3, FORM=8)                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           NELTYP,N,ERR

      DOUBLE PRECISION  V(3,N),S(NELTYP,N),DSDV(NELTYP,3,N),
     &                  NODE(NELTYP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes for the proposal functions
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of points
C--------I------I-----I------------------------------------------------
C V      I  R   I in  I points in the element             array: V(3,N)
C--------I------I-----I------------------------------------------------
C S      I  R   I out I proposal functions at V      array: S(NELTYP,N)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I out I derivatives of proposal functions at V :
C        I      I     I                         array: DSDV(NELTYP,3,N)
C--------I------I-----I------------------------------------------------
C NODE   I  R   I  -  I node coordinates          array: NODE(3,NELTYP)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10002   illegal proposal function
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           Z,K,L,M,NELT,NUMBER,MUELL,Q,R

      DOUBLE PRECISION  LFNX,LFNY,LFNZ,LDRX,LDRY,LDRZ,
     &                  XC,YC,ZC,MULT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=10002

      NELT=DBLE(NELTYP)**(1.D0/3.D0)+.5D0
      MUELL=NELT**3
      IF (MUELL.NE.NELTYP) RETURN
      ERR=0

      CALL  VEMLP7(NELT,NODE)

      NUMBER=0
      DO 10 K=1,NELT
        DO 20 M=1,NELT
          DO 30 L=1,NELT
            NUMBER=NUMBER+1
            DO 40 Z=1,N
              XC=V(1,Z)
              YC=V(2,Z)
              ZC=V(3,Z)

              LFNX = 1.D0
              DO 8810 R=1,NELT
                IF (R.NE.L) THEN
                  LFNX=LFNX*(NODE(R)-XC)/(NODE(R)-NODE(L))
                ENDIF
 8810         CONTINUE

              LFNY = 1.D0
              DO 8811 R=1,NELT
                IF (R.NE.M) THEN
                  LFNY=LFNY*(NODE(R)-YC)/(NODE(R)-NODE(M))
                ENDIF
 8811         CONTINUE

              LFNZ = 1.D0
              DO 8812 R=1,NELT
                IF (R.NE.K) THEN
                  LFNZ=LFNZ*(NODE(R)-ZC)/(NODE(R)-NODE(K))
                ENDIF
 8812         CONTINUE

              S(NUMBER,Z)=LFNX*LFNY*LFNZ

              LDRX = 0.D0
              DO 1110 Q=1,NELT
                IF (Q.NE.L) THEN
                  MULT=1.D0
                  DO 1120 R=1,NELT
                    IF ((R.NE.L).AND.(R.NE.Q)) THEN
                      MULT=MULT*(NODE(R)-XC)/(NODE(R)-NODE(L))
                    ENDIF
 1120             CONTINUE
                  LDRX = LDRX+MULT/(NODE(L)-NODE(Q))
                ENDIF
 1110         CONTINUE

              LDRY = 0.D0
              DO 1111 Q=1,NELT
                IF (Q.NE.M) THEN
                  MULT=1.D0
                  DO 1121 R=1,NELT
                    IF ((R.NE.M).AND.(R.NE.Q)) THEN
                      MULT=MULT*(NODE(R)-YC)/(NODE(R)-NODE(M))
                    ENDIF
 1121             CONTINUE
                  LDRY = LDRY+MULT/(NODE(M)-NODE(Q))
                ENDIF
 1111         CONTINUE

              LDRZ = 0.D0
              DO 1112 Q=1,NELT
                IF (Q.NE.K) THEN
                  MULT=1.D0
                  DO 1122 R=1,NELT
                    IF ((R.NE.K).AND.(R.NE.Q)) THEN
                      MULT=MULT*(NODE(R)-ZC)/(NODE(R)-NODE(K))
                    ENDIF
 1122             CONTINUE
                  LDRZ = LDRZ+MULT/(NODE(K)-NODE(Q))
                ENDIF
 1112         CONTINUE

              DSDV(NUMBER,1,Z)=LDRX*LFNY*LFNZ
              DSDV(NUMBER,2,Z)=LFNX*LDRY*LFNZ
              DSDV(NUMBER,3,Z)=LFNX*LFNY*LDRZ
  40        CONTINUE
  30      CONTINUE
  20    CONTINUE
  10  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VEMLP6----------------------------------------------------
      E    N    D
