C**:::      ,,,,,VEMLP7.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMLP7(NELT,NODE)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEMLP7   sets the coordinates of the nodes for                ***
C**            the 1-D lagrangean interpolation                     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
       INTEGER            NELT
       DOUBLE PRECISION   NODE(NELT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NELT   I  I   I in  I number of nodes
C--------I------I-----I------------------------------------------------
C NODES  I  I   I in  I node coordinates             array: NODES(NELT)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER            Z
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      IF (NELT.GT.1) THEN
        DO 10 Z=1,NELT
          NODE(Z)=DBLE(Z-1)/DBLE(NELT-1)
  10    CONTINUE
      ELSE
        NODE(1)=0.5D0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VEMLP7 ---------------------------------------------------
      E    N    D
