C**:::      ,,,,,VEMLPF.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMLPF(CLASS,FORM,NELTYP,NV,V,N,DNDV,
     &                  LRWORK,RWORK,LIWORK,IWORK,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMLPF  calculation of Lagrangean proposal functions         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,NELTYP,FORM,NV,LIWORK,IWORK(LIWORK),
     &                  LRWORK,ERR
      DOUBLE PRECISION  V(CLASS,NV),N(NELTYP,NV),DNDV(NELTYP,CLASS,NV),
     &                  RWORK(LRWORK)

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of element
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of proposal functions
C--------I------I-----I------------------------------------------------
C NV     I  I   I in  I number of points
C--------I------I-----I------------------------------------------------
C V      I  R   I INV I points in the element        array: V(CLASS,NV)
C--------I------I-----I------------------------------------------------
C N      I  R   I out I proposal functions at V     array: N(NELTYP,NV)
C--------I------I-----I------------------------------------------------
C DNDV   I  R   I out I derivatives of proposal functions at V 
C        I      I     I                    array: DNDV(NELTYP,CLASS,NV)
C--------I------I-----I------------------------------------------------
C RWORK  I  R   I  -  I real work space            array: RWORK(LRWORK)
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I  -  I intger work space          array: IWORK(LIWORK)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10003   illegal NELTYP
C        I      I     I 10010   small storage
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER             NODE,I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      NODE=1
      IF (LRWORK.LT.NELTYP) THEN
        ERR=10010
        RETURN
      ENDIF
      ERR=10000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN
        ERR=10002
        IF( NELTYP .EQ. 1 ) THEN
	 ERR=0
	 DO 10 I=1,NV
	   N(1,I)=1.
 10      CONTINUE
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        ERR=10002
        CALL VEMLP1(NELTYP,NV,V,N,DNDV,RWORK(NODE),ERR)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN
        ERR=10001
C**                                                                 ***
C****** triangle :                                                  ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=10002
          CALL VEMLP2(NELTYP,NV,V,N,DNDV,RWORK(NODE),ERR)
        ENDIF
C**                                                                 ***
C****** quadrilateral :                                             ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          CALL VEMLP3(NELTYP,NV,V,N,DNDV,RWORK(NODE),ERR)
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN
        ERR=10001
C**                                                                 ***
C****** tetrahedron :                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          CALL VEMLP5(NELTYP,NV,V,N,DNDV,RWORK(NODE),ERR)
        ENDIF
C**                                                                 ***
C****** prism :                                                     ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=10002
          CALL VEMLP4(NELTYP,NV,V,N,DNDV,RWORK(NODE),ERR)
        ENDIF
C**                                                                 ***
C****** hexahedron :                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          ERR=10002
          CALL VEMLP6(NELTYP,NV,V,N,DNDV,RWORK(NODE),ERR)
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VEMLPF ---------------------------------------------------
      E    N    D
