C**:::      ,,,,,VEMLPZ.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      INTEGER FUNCTION VEMLPZ(P,CLASS,FORM,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEMLPZ   sets the number of Lagrangean proposal functions     ***
C**            for a given order P                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,FORM,P,ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C P      I  I   I in  I wished order
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of element
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER          NELTYP
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**                                                                 ***
      ERR=10000
      NELTYP=0
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN
        ERR=0
        NELTYP=1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        ERR=0
        NELTYP=(P+1)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN

        ERR=10001
C**                                                                 ***
C****** triangle :                                                  ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=0
          NELTYP=((P+1)*(P+2))/2
        ENDIF
C**                                                                 ***
C****** quadrilateral :                                             ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=0
          NELTYP=(P+1)**2
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN

        ERR=10001
C**                                                                 ***
C****** tetrahedron :                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=0
          NELTYP=((P+1)*(P+2)*(P+3))/6
        ENDIF
C**                                                                 ***
C****** prism:                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=0
          NELTYP=((P+1)*(P+2))/2*(P+1)
        ENDIF
C**                                                                 ***
C****** hexahedron :                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          ERR=0
          NELTYP=(P+1)**3
        ENDIF

      ENDIF
C**                                                                 ***
      VEMLPZ=NELTYP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMLPZ ---------------------------------------------------
      E    N    D
