C**:::      ,,,,,VEMLSQ.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMLSQ(CLASS,FORM,GEOTYP,INVSIJ,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEMLSQ  sets the invers of the matrix                         ***
C**                                                                 ***
C**     I                                                           ***
C**    I  S_i*S_j d x     i,j=1,GEOTYP                              *** 
C**   I                                                             ***
C**  reference element                                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     Copyrights Lutz Grosz Canberra, 1999                        ***
C**     Program by L. Grosz                                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,GEOTYP,FORM,ERR
      DOUBLE PRECISION  INVSIJ(GEOTYP,GEOTYP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of element of the element
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes
C--------I------I-----I------------------------------------------------
C INVSIJ I  R   I out I 
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10002   illegal element
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER I,J
      DOUBLE PRECISION ZERO
      PARAMETER(ZERO=0.D0)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**                                                                 ***
      ERR=10002
      DO 100 I=1,GEOTYP
        DO 100 J=I,GEOTYP
          INVSIJ(I,J)=ZERO
  100 CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      IF ((CLASS.EQ.0).AND.(FORM.EQ.1).AND.(GEOTYP.EQ. 1)) THEN
        ERR=0
        INVSIJ( 1, 1)=1.D0
      ENDIF
      IF ((CLASS.EQ.1).AND.(FORM.EQ.2).AND.(GEOTYP.EQ. 2)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.3999999999999999D+01
        INVSIJ( 1, 2)=  -0.1999999999999999D+01
        INVSIJ( 2, 2)=   0.3999999999999999D+01
      ENDIF
      IF ((CLASS.EQ.1).AND.(FORM.EQ.2).AND.(GEOTYP.EQ. 3)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.8999999999999993D+01
        INVSIJ( 1, 2)=   0.2999999999999990D+01
        INVSIJ( 1, 3)=  -0.1499999999999995D+01
        INVSIJ( 2, 2)=   0.8999999999999988D+01
        INVSIJ( 2, 3)=  -0.1499999999999995D+01
        INVSIJ( 3, 3)=   0.2249999999999998D+01
      ENDIF
      IF ((CLASS.EQ.1).AND.(FORM.EQ.2).AND.(GEOTYP.EQ. 4)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.1599999999999996D+02
        INVSIJ( 1, 2)=  -0.3999999999999999D+01
        INVSIJ( 1, 3)=  -0.2518518518518513D+01
        INVSIJ( 1, 4)=   0.1185185185185189D+01
        INVSIJ( 2, 2)=   0.1599999999999998D+02
        INVSIJ( 2, 3)=   0.1185185185185187D+01
        INVSIJ( 2, 4)=  -0.2518518518518522D+01
        INVSIJ( 3, 3)=   0.3050754458161867D+01
        INVSIJ( 3, 4)=   0.6035665294924110D-01
        INVSIJ( 4, 4)=   0.3050754458161868D+01
      ENDIF
      IF ((CLASS.EQ.2).AND.(FORM.EQ.3).AND.(GEOTYP.EQ. 3)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.1799999999999999D+02
        INVSIJ( 1, 2)=  -0.5999999999999992D+01
        INVSIJ( 1, 3)=  -0.5999999999999996D+01
        INVSIJ( 2, 2)=   0.1799999999999999D+02
        INVSIJ( 2, 3)=  -0.5999999999999997D+01
        INVSIJ( 3, 3)=   0.1799999999999999D+02
      ENDIF
      IF ((CLASS.EQ.2).AND.(FORM.EQ.3).AND.(GEOTYP.EQ. 6)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.7199999999999993D+02
        INVSIJ( 1, 2)=   0.1199999999999994D+02
        INVSIJ( 1, 3)=   0.1199999999999995D+02
        INVSIJ( 1, 4)=  -0.2999999999999996D+01
        INVSIJ( 1, 5)=   0.1200000000000000D+02
        INVSIJ( 1, 6)=  -0.3000000000000004D+01
        INVSIJ( 2, 2)=   0.7199999999999990D+02
        INVSIJ( 2, 3)=   0.1199999999999999D+02
        INVSIJ( 2, 4)=  -0.2999999999999973D+01
        INVSIJ( 2, 5)=  -0.3000000000000006D+01
        INVSIJ( 2, 6)=   0.1199999999999997D+02
        INVSIJ( 3, 3)=   0.7199999999999987D+02
        INVSIJ( 3, 4)=   0.1199999999999996D+02
        INVSIJ( 3, 5)=  -0.3000000000000005D+01
        INVSIJ( 3, 6)=  -0.2999999999999960D+01
        INVSIJ( 4, 4)=   0.1949999999999996D+02
        INVSIJ( 4, 5)=  -0.6750000000000005D+01
        INVSIJ( 4, 6)=  -0.6749999999999964D+01
        INVSIJ( 5, 5)=   0.1950000000000001D+02
        INVSIJ( 5, 6)=  -0.6750000000000011D+01
        INVSIJ( 6, 6)=   0.1949999999999997D+02
      ENDIF
      IF ((CLASS.EQ.2).AND.(FORM.EQ.3).AND.(GEOTYP.EQ. 9)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.7499999999999969D+02
        INVSIJ( 1, 2)=  -0.1999999999999995D+02
        INVSIJ( 1, 3)=  -0.1999999999999993D+02
        INVSIJ( 1, 4)=   0.2148148148148135D+02
        INVSIJ( 1, 5)=   0.1351851851851841D+02
        INVSIJ( 1, 6)=   0.1333333333333327D+02
        INVSIJ( 1, 7)=   0.1333333333333325D+02
        INVSIJ( 1, 8)=   0.1351851851851843D+02
        INVSIJ( 1, 9)=   0.2148148148148140D+02
        INVSIJ( 2, 2)=   0.1999999999999994D+03
        INVSIJ( 2, 3)=  -0.1999999999999981D+02
        INVSIJ( 2, 4)=   0.1481481481481389D+01
        INVSIJ( 2, 5)=  -0.8148148148148138D+01
        INVSIJ( 2, 6)=  -0.8148148148148151D+01
        INVSIJ( 2, 7)=   0.1481481481481481D+01
        INVSIJ( 2, 8)=  -0.1999999999999990D+02
        INVSIJ( 2, 9)=  -0.1999999999999985D+02
        INVSIJ( 3, 3)=   0.1999999999999995D+03
        INVSIJ( 3, 4)=  -0.1999999999999982D+02
        INVSIJ( 3, 5)=  -0.1999999999999990D+02
        INVSIJ( 3, 6)=   0.1481481481481486D+01
        INVSIJ( 3, 7)=  -0.8148148148148147D+01
        INVSIJ( 3, 8)=  -0.8148148148148136D+01
        INVSIJ( 3, 9)=   0.1481481481481384D+01
        INVSIJ( 4, 4)=   0.3604938271604919D+02
        INVSIJ( 4, 5)=   0.9629629629629560D+01
        INVSIJ( 4, 6)=   0.2167352537722864D+01
        INVSIJ( 4, 7)=  -0.1920438957475991D+01
        INVSIJ( 4, 8)=   0.7215363511659769D+01
        INVSIJ( 4, 9)=  -0.1758573388203010D+02
        INVSIJ( 5, 5)=   0.4191358024691350D+02
        INVSIJ( 5, 6)=  -0.1377229080932782D+02
        INVSIJ( 5, 7)=   0.6858710562414230D+01
        INVSIJ( 5, 8)=   0.4821673525377212D+01
        INVSIJ( 5, 9)=   0.7215363511659788D+01
        INVSIJ( 6, 6)=   0.3418381344307268D+02
        INVSIJ( 6, 7)=   0.3593964334705090D+01
        INVSIJ( 6, 8)=   0.6858710562414232D+01
        INVSIJ( 6, 9)=  -0.1920438957475995D+01
        INVSIJ( 7, 7)=   0.3418381344307265D+02
        INVSIJ( 7, 8)=  -0.1377229080932781D+02
        INVSIJ( 7, 9)=   0.2167352537722864D+01
        INVSIJ( 8, 8)=   0.4191358024691348D+02
        INVSIJ( 8, 9)=   0.9629629629629571D+01
        INVSIJ( 9, 9)=   0.3604938271604926D+02
      ENDIF
      IF ((CLASS.EQ.2).AND.(FORM.EQ.3).AND.(GEOTYP.EQ.10)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.1999999999999990D+03
        INVSIJ( 1, 2)=  -0.1999999999999995D+02
        INVSIJ( 1, 3)=  -0.1999999999999996D+02
        INVSIJ( 1, 4)=  -0.8148148148148088D+01
        INVSIJ( 1, 5)=   0.1481481481481503D+01
        INVSIJ( 1, 6)=  -0.1999999999999988D+02
        INVSIJ( 1, 7)=  -0.1999999999999988D+02
        INVSIJ( 1, 8)=   0.1481481481481489D+01
        INVSIJ( 1, 9)=  -0.8148148148148120D+01
        INVSIJ( 1,10)=   0.1481481481481473D+01
        INVSIJ( 2, 2)=   0.1999999999999994D+03
        INVSIJ( 2, 3)=  -0.1999999999999981D+02
        INVSIJ( 2, 4)=   0.1481481481481415D+01
        INVSIJ( 2, 5)=  -0.8148148148148172D+01
        INVSIJ( 2, 6)=  -0.8148148148148142D+01
        INVSIJ( 2, 7)=   0.1481481481481446D+01
        INVSIJ( 2, 8)=  -0.1999999999999990D+02
        INVSIJ( 2, 9)=  -0.1999999999999990D+02
        INVSIJ( 2,10)=   0.1481481481481486D+01
        INVSIJ( 3, 3)=   0.1999999999999995D+03
        INVSIJ( 3, 4)=  -0.1999999999999990D+02
        INVSIJ( 3, 5)=  -0.1999999999999995D+02
        INVSIJ( 3, 6)=   0.1481481481481477D+01
        INVSIJ( 3, 7)=  -0.8148148148148151D+01
        INVSIJ( 3, 8)=  -0.8148148148148168D+01
        INVSIJ( 3, 9)=   0.1481481481481411D+01
        INVSIJ( 3,10)=   0.1481481481481485D+01
        INVSIJ( 4, 4)=   0.4307270233196149D+02
        INVSIJ( 4, 5)=   0.1248285322359389D+02
        INVSIJ( 4, 6)=   0.1006858710562409D+02
        INVSIJ( 4, 7)=   0.5980795610425221D+01
        INVSIJ( 4, 8)=   0.1006858710562411D+02
        INVSIJ( 4, 9)=  -0.1056241426611796D+02
        INVSIJ( 4,10)=  -0.5432098765432070D+01
        INVSIJ( 5, 5)=   0.4307270233196159D+02
        INVSIJ( 5, 6)=  -0.1056241426611800D+02
        INVSIJ( 5, 7)=   0.1006858710562411D+02
        INVSIJ( 5, 8)=   0.5980795610425221D+01
        INVSIJ( 5, 9)=   0.1006858710562415D+02
        INVSIJ( 5,10)=  -0.5432098765432081D+01
        INVSIJ( 6, 6)=   0.4307270233196153D+02
        INVSIJ( 6, 7)=   0.1248285322359395D+02
        INVSIJ( 6, 8)=   0.1006858710562409D+02
        INVSIJ( 6, 9)=   0.5980795610425220D+01
        INVSIJ( 6,10)=  -0.5432098765432079D+01
        INVSIJ( 7, 7)=   0.4307270233196152D+02
        INVSIJ( 7, 8)=  -0.1056241426611797D+02
        INVSIJ( 7, 9)=   0.1006858710562411D+02
        INVSIJ( 7,10)=  -0.5432098765432085D+01
        INVSIJ( 8, 8)=   0.4307270233196153D+02
        INVSIJ( 8, 9)=   0.1248285322359390D+02
        INVSIJ( 8,10)=  -0.5432098765432076D+01
        INVSIJ( 9, 9)=   0.4307270233196154D+02
        INVSIJ( 9,10)=  -0.5432098765432082D+01
        INVSIJ(10,10)=   0.9547325102880645D+01
      ENDIF
      IF ((CLASS.EQ.2).AND.(FORM.EQ.4).AND.(GEOTYP.EQ. 4)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.1599999999999999D+02
        INVSIJ( 1, 2)=  -0.7999999999999992D+01
        INVSIJ( 1, 3)=   0.3999999999999996D+01
        INVSIJ( 1, 4)=  -0.7999999999999994D+01
        INVSIJ( 2, 2)=   0.1599999999999999D+02
        INVSIJ( 2, 3)=  -0.7999999999999996D+01
        INVSIJ( 2, 4)=   0.3999999999999996D+01
        INVSIJ( 3, 3)=   0.1599999999999999D+02
        INVSIJ( 3, 4)=  -0.7999999999999995D+01
        INVSIJ( 4, 4)=   0.1599999999999999D+02
      ENDIF
      IF ((CLASS.EQ.2).AND.(FORM.EQ.4).AND.(GEOTYP.EQ. 8)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.5599999999999992D+02
        INVSIJ( 1, 2)=   0.1999999999999982D+01
        INVSIJ( 1, 3)=  -0.1599999999999998D+02
        INVSIJ( 1, 4)=   0.2000000000000004D+01
        INVSIJ( 1, 5)=  -0.1000000000000010D+01
        INVSIJ( 1, 6)=   0.8000000000000002D+01
        INVSIJ( 1, 7)=   0.7999999999999984D+01
        INVSIJ( 1, 8)=  -0.9999999999999835D+00
        INVSIJ( 2, 2)=   0.5599999999999994D+02
        INVSIJ( 2, 3)=   0.1999999999999998D+01
        INVSIJ( 2, 4)=  -0.1599999999999998D+02
        INVSIJ( 2, 5)=  -0.9999999999999873D+00
        INVSIJ( 2, 6)=  -0.9999999999999887D+00
        INVSIJ( 2, 7)=   0.7999999999999978D+01
        INVSIJ( 2, 8)=   0.7999999999999986D+01
        INVSIJ( 3, 3)=   0.5599999999999991D+02
        INVSIJ( 3, 4)=   0.1999999999999982D+01
        INVSIJ( 3, 5)=   0.7999999999999989D+01
        INVSIJ( 3, 6)=  -0.1000000000000004D+01
        INVSIJ( 3, 7)=  -0.9999999999999757D+00
        INVSIJ( 3, 8)=   0.7999999999999971D+01
        INVSIJ( 4, 4)=   0.5599999999999990D+02
        INVSIJ( 4, 5)=   0.7999999999999981D+01
        INVSIJ( 4, 6)=   0.7999999999999972D+01
        INVSIJ( 4, 7)=  -0.9999999999999702D+00
        INVSIJ( 4, 8)=  -0.1000000000000001D+01
        INVSIJ( 5, 5)=   0.1399999999999999D+02
        INVSIJ( 5, 6)=  -0.3999999999999988D+01
        INVSIJ( 5, 7)=   0.4999999999999885D+00
        INVSIJ( 5, 8)=  -0.3999999999999988D+01
        INVSIJ( 6, 6)=   0.1399999999999998D+02
        INVSIJ( 6, 7)=  -0.3999999999999975D+01
        INVSIJ( 6, 8)=   0.4999999999999900D+00
        INVSIJ( 7, 7)=   0.1399999999999997D+02
        INVSIJ( 7, 8)=  -0.3999999999999978D+01
        INVSIJ( 8, 8)=   0.1399999999999997D+02
      ENDIF
      IF ((CLASS.EQ.2).AND.(FORM.EQ.4).AND.(GEOTYP.EQ. 9)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.8099999999999976D+02
        INVSIJ( 1, 2)=   0.2699999999999984D+02
        INVSIJ( 1, 3)=   0.8999999999999941D+01
        INVSIJ( 1, 4)=   0.2699999999999985D+02
        INVSIJ( 1, 5)=  -0.1349999999999992D+02
        INVSIJ( 1, 6)=  -0.4499999999999953D+01
        INVSIJ( 1, 7)=  -0.4499999999999961D+01
        INVSIJ( 1, 8)=  -0.1349999999999992D+02
        INVSIJ( 1, 9)=   0.2249999999999975D+01
        INVSIJ( 2, 2)=   0.8099999999999973D+02
        INVSIJ( 2, 3)=   0.2699999999999986D+02
        INVSIJ( 2, 4)=   0.8999999999999927D+01
        INVSIJ( 2, 5)=  -0.1349999999999992D+02
        INVSIJ( 2, 6)=  -0.1349999999999994D+02
        INVSIJ( 2, 7)=  -0.4499999999999964D+01
        INVSIJ( 2, 8)=  -0.4499999999999966D+01
        INVSIJ( 2, 9)=   0.2249999999999984D+01
        INVSIJ( 3, 3)=   0.8099999999999986D+02
        INVSIJ( 3, 4)=   0.2699999999999990D+02
        INVSIJ( 3, 5)=  -0.4499999999999955D+01
        INVSIJ( 3, 6)=  -0.1349999999999996D+02
        INVSIJ( 3, 7)=  -0.1349999999999995D+02
        INVSIJ( 3, 8)=  -0.4499999999999975D+01
        INVSIJ( 3, 9)=   0.2249999999999991D+01
        INVSIJ( 4, 4)=   0.8099999999999974D+02
        INVSIJ( 4, 5)=  -0.4499999999999958D+01
        INVSIJ( 4, 6)=  -0.4499999999999964D+01
        INVSIJ( 4, 7)=  -0.1349999999999993D+02
        INVSIJ( 4, 8)=  -0.1349999999999993D+02
        INVSIJ( 4, 9)=   0.2249999999999981D+01
        INVSIJ( 5, 5)=   0.2024999999999995D+02
        INVSIJ( 5, 6)=   0.2249999999999980D+01
        INVSIJ( 5, 7)=   0.6749999999999963D+01
        INVSIJ( 5, 8)=   0.2249999999999983D+01
        INVSIJ( 5, 9)=  -0.3374999999999983D+01
        INVSIJ( 6, 6)=   0.2024999999999996D+02
        INVSIJ( 6, 7)=   0.2249999999999981D+01
        INVSIJ( 6, 8)=   0.6749999999999968D+01
        INVSIJ( 6, 9)=  -0.3374999999999984D+01
        INVSIJ( 7, 7)=   0.2024999999999995D+02
        INVSIJ( 7, 8)=   0.2249999999999984D+01
        INVSIJ( 7, 9)=  -0.3374999999999982D+01
        INVSIJ( 8, 8)=   0.2024999999999995D+02
        INVSIJ( 8, 9)=  -0.3374999999999984D+01
        INVSIJ( 9, 9)=   0.5062499999999987D+01
      ENDIF
      IF ((CLASS.EQ.2).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.12)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.1119999999999998D+03
        INVSIJ( 1, 2)=  -0.3999999999999990D+02
        INVSIJ( 1, 3)=   0.1199999999999969D+02
        INVSIJ( 1, 4)=  -0.3999999999999987D+02
        INVSIJ( 1, 5)=   0.1392592592592596D+02
        INVSIJ( 1, 6)=   0.4740740740740716D+01
        INVSIJ( 1, 7)=   0.1037037037037029D+01
        INVSIJ( 1, 8)=  -0.2370370370370506D+01
        INVSIJ( 1, 9)=  -0.2370370370370407D+01
        INVSIJ( 1,10)=   0.1037037037036979D+01
        INVSIJ( 1,11)=   0.4740740740740797D+01
        INVSIJ( 1,12)=   0.1392592592592587D+02
        INVSIJ( 2, 2)=   0.1119999999999998D+03
        INVSIJ( 2, 3)=  -0.3999999999999974D+02
        INVSIJ( 2, 4)=   0.1199999999999996D+02
        INVSIJ( 2, 5)=   0.4740740740740739D+01
        INVSIJ( 2, 6)=   0.1392592592592596D+02
        INVSIJ( 2, 7)=   0.1392592592592590D+02
        INVSIJ( 2, 8)=   0.4740740740740891D+01
        INVSIJ( 2, 9)=   0.1037037037036975D+01
        INVSIJ( 2,10)=  -0.2370370370370325D+01
        INVSIJ( 2,11)=  -0.2370370370370408D+01
        INVSIJ( 2,12)=   0.1037037037037078D+01
        INVSIJ( 3, 3)=   0.1119999999999998D+03
        INVSIJ( 3, 4)=  -0.4000000000000003D+02
        INVSIJ( 3, 5)=  -0.2370370370370340D+01
        INVSIJ( 3, 6)=   0.1037037037037017D+01
        INVSIJ( 3, 7)=   0.4740740740740815D+01
        INVSIJ( 3, 8)=   0.1392592592592587D+02
        INVSIJ( 3, 9)=   0.1392592592592588D+02
        INVSIJ( 3,10)=   0.4740740740740654D+01
        INVSIJ( 3,11)=   0.1037037037037001D+01
        INVSIJ( 3,12)=  -0.2370370370370512D+01
        INVSIJ( 4, 4)=   0.1119999999999998D+03
        INVSIJ( 4, 5)=   0.1037037037037050D+01
        INVSIJ( 4, 6)=  -0.2370370370370365D+01
        INVSIJ( 4, 7)=  -0.2370370370370368D+01
        INVSIJ( 4, 8)=   0.1037037037037100D+01
        INVSIJ( 4, 9)=   0.4740740740740714D+01
        INVSIJ( 4,10)=   0.1392592592592594D+02
        INVSIJ( 4,11)=   0.1392592592592586D+02
        INVSIJ( 4,12)=   0.4740740740740742D+01
        INVSIJ( 5, 5)=   0.2820301783264740D+02
        INVSIJ( 5, 6)=   0.8241426611796930D+01
        INVSIJ( 5, 7)=   0.2370370370370364D+01
        INVSIJ( 5, 9)=  -0.1454046639231817D+01
        INVSIJ( 5,10)=  -0.8768175582990382D+01
        INVSIJ( 5,11)=   0.2370370370370402D+01
        INVSIJ( 5,12)=  -0.1407407407407400D+02
        INVSIJ( 6, 6)=   0.2820301783264746D+02
        INVSIJ( 6, 7)=  -0.1407407407407410D+02
        INVSIJ( 6, 8)=   0.2370370370370395D+01
        INVSIJ( 6, 9)=  -0.8768175582990429D+01
        INVSIJ( 6,10)=  -0.1454046639231828D+01
        INVSIJ( 6,12)=   0.2370370370370404D+01
        INVSIJ( 7, 7)=   0.2820301783264751D+02
        INVSIJ( 7, 8)=   0.8241426611797008D+01
        INVSIJ( 7, 9)=   0.2370370370370367D+01
        INVSIJ( 7,11)=  -0.1454046639231820D+01
        INVSIJ( 7,12)=  -0.8768175582990407D+01
        INVSIJ( 8, 8)=   0.2820301783264753D+02
        INVSIJ( 8, 9)=  -0.1407407407407411D+02
        INVSIJ( 8,10)=   0.2370370370370351D+01
        INVSIJ( 8,11)=  -0.8768175582990411D+01
        INVSIJ( 8,12)=  -0.1454046639231866D+01
        INVSIJ( 9, 9)=   0.2820301783264747D+02
        INVSIJ( 9,10)=   0.8241426611796948D+01
        INVSIJ( 9,11)=   0.2370370370370357D+01
        INVSIJ(10,10)=   0.2820301783264743D+02
        INVSIJ(10,11)=  -0.1407407407407407D+02
        INVSIJ(10,12)=   0.2370370370370338D+01
        INVSIJ(11,11)=   0.2820301783264743D+02
        INVSIJ(11,12)=   0.8241426611796927D+01
        INVSIJ(12,12)=   0.2820301783264738D+02
      ENDIF
      IF ((CLASS.EQ.2).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.16)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.2559999999999986D+03
        INVSIJ( 1, 2)=  -0.6400000000000000D+02
        INVSIJ( 1, 3)=   0.1599999999999810D+02
        INVSIJ( 1, 4)=  -0.6399999999999923D+02
        INVSIJ( 1, 5)=  -0.4029629629629606D+02
        INVSIJ( 1, 6)=   0.1896296296296308D+02
        INVSIJ( 1, 7)=   0.1007407407407489D+02
        INVSIJ( 1, 8)=  -0.4740740740739153D+01
        INVSIJ( 1, 9)=  -0.4740740740740904D+01
        INVSIJ( 1,10)=   0.1007407407407373D+02
        INVSIJ( 1,11)=   0.1896296296296248D+02
        INVSIJ( 1,12)=  -0.4029629629629631D+02
        INVSIJ( 1,13)=   0.6342935528120730D+01
        INVSIJ( 1,14)=  -0.2984910836763033D+01
        INVSIJ( 1,15)=   0.1404663923181913D+01
        INVSIJ( 1,16)=  -0.2984910836762638D+01
        INVSIJ( 2, 2)=   0.2559999999999982D+03
        INVSIJ( 2, 3)=  -0.6399999999999724D+02
        INVSIJ( 2, 4)=   0.1599999999999910D+02
        INVSIJ( 2, 5)=   0.1896296296296313D+02
        INVSIJ( 2, 6)=  -0.4029629629629612D+02
        INVSIJ( 2, 7)=  -0.4029629629629649D+02
        INVSIJ( 2, 8)=   0.1896296296296118D+02
        INVSIJ( 2, 9)=   0.1007407407407359D+02
        INVSIJ( 2,10)=  -0.4740740740740554D+01
        INVSIJ( 2,11)=  -0.4740740740740198D+01
        INVSIJ( 2,12)=   0.1007407407407447D+02
        INVSIJ( 2,13)=  -0.2984910836762852D+01
        INVSIJ( 2,14)=   0.6342935528120998D+01
        INVSIJ( 2,15)=  -0.2984910836762207D+01
        INVSIJ( 2,16)=   0.1404663923182357D+01
        INVSIJ( 3, 3)=   0.2559999999999965D+03
        INVSIJ( 3, 4)=  -0.6399999999999731D+02
        INVSIJ( 3, 5)=  -0.4740740740742133D+01
        INVSIJ( 3, 6)=   0.1007407407407328D+02
        INVSIJ( 3, 7)=   0.1896296296296240D+02
        INVSIJ( 3, 8)=  -0.4029629629629444D+02
        INVSIJ( 3, 9)=  -0.4029629629629517D+02
        INVSIJ( 3,10)=   0.1896296296296261D+02
        INVSIJ( 3,11)=   0.1007407407407283D+02
        INVSIJ( 3,12)=  -0.4740740740740157D+01
        INVSIJ( 3,13)=   0.1404663923183225D+01
        INVSIJ( 3,14)=  -0.2984910836762789D+01
        INVSIJ( 3,15)=   0.6342935528120364D+01
        INVSIJ( 3,16)=  -0.2984910836762806D+01
        INVSIJ( 4, 4)=   0.2559999999999979D+03
        INVSIJ( 4, 5)=   0.1007407407407420D+02
        INVSIJ( 4, 6)=  -0.4740740740740621D+01
        INVSIJ( 4, 7)=  -0.4740740740740788D+01
        INVSIJ( 4, 8)=   0.1007407407407214D+02
        INVSIJ( 4, 9)=   0.1896296296296203D+02
        INVSIJ( 4,10)=  -0.4029629629629596D+02
        INVSIJ( 4,11)=  -0.4029629629629557D+02
        INVSIJ( 4,12)=   0.1896296296296258D+02
        INVSIJ( 4,13)=  -0.2984910836762725D+01
        INVSIJ( 4,14)=   0.1404663923182451D+01
        INVSIJ( 4,15)=  -0.2984910836762360D+01
        INVSIJ( 4,16)=   0.6342935528120699D+01
        INVSIJ( 5, 5)=   0.4881207133058980D+02
        INVSIJ( 5, 6)=   0.9657064471878721D+00
        INVSIJ( 5, 7)=  -0.2984910836763011D+01
        INVSIJ( 5, 8)=   0.1404663923182112D+01
        INVSIJ( 5, 9)=  -0.2414266117967111D+00
        INVSIJ( 5,10)=  -0.1220301783264744D+02
        INVSIJ( 5,11)=  -0.2984910836762585D+01
        INVSIJ( 5,12)=   0.6342935528120713D+01
        INVSIJ( 5,13)=  -0.7683381598333606D+01
        INVSIJ( 5,14)=  -0.1520093481684486D+00
        INVSIJ( 5,15)=   0.7153381090282006D-01
        INVSIJ( 5,16)=   0.3615708987451098D+01
        INVSIJ( 6, 6)=   0.4881207133058991D+02
        INVSIJ( 6, 7)=   0.6342935528120790D+01
        INVSIJ( 6, 8)=  -0.2984910836762023D+01
        INVSIJ( 6, 9)=  -0.1220301783264737D+02
        INVSIJ( 6,10)=  -0.2414266117970526D+00
        INVSIJ( 6,11)=   0.1404663923182306D+01
        INVSIJ( 6,12)=  -0.2984910836762884D+01
        INVSIJ( 6,13)=  -0.1520093481684329D+00
        INVSIJ( 6,14)=  -0.7683381598333755D+01
        INVSIJ( 6,15)=   0.3615708987450927D+01
        INVSIJ( 6,16)=   0.7153381090283177D-01
        INVSIJ( 7, 7)=   0.4881207133059017D+02
        INVSIJ( 7, 8)=   0.9657064471880540D+00
        INVSIJ( 7, 9)=  -0.2984910836762357D+01
        INVSIJ( 7,10)=   0.1404663923182459D+01
        INVSIJ( 7,11)=  -0.2414266117967057D+00
        INVSIJ( 7,12)=  -0.1220301783264777D+02
        INVSIJ( 7,13)=   0.3615708987451214D+01
        INVSIJ( 7,14)=  -0.7683381598333686D+01
        INVSIJ( 7,15)=  -0.1520093481683787D+00
        INVSIJ( 7,16)=   0.7153381090276784D-01
        INVSIJ( 8, 8)=   0.4881207133058840D+02
        INVSIJ( 8, 9)=   0.6342935528119766D+01
        INVSIJ( 8,10)=  -0.2984910836762395D+01
        INVSIJ( 8,11)=  -0.1220301783264641D+02
        INVSIJ( 8,12)=  -0.2414266117970183D+00
        INVSIJ( 8,13)=   0.7153381090283163D-01
        INVSIJ( 8,14)=  -0.1520093481685262D+00
        INVSIJ( 8,15)=  -0.7683381598333153D+01
        INVSIJ( 8,16)=   0.3615708987450907D+01
        INVSIJ( 9, 9)=   0.4881207133058908D+02
        INVSIJ( 9,10)=   0.9657064471880059D+00
        INVSIJ( 9,11)=  -0.2984910836762102D+01
        INVSIJ( 9,12)=   0.1404663923182216D+01
        INVSIJ( 9,13)=   0.7153381090270122D-01
        INVSIJ( 9,14)=   0.3615708987450969D+01
        INVSIJ( 9,15)=  -0.7683381598333302D+01
        INVSIJ( 9,16)=  -0.1520093481684949D+00
        INVSIJ(10,10)=   0.4881207133058986D+02
        INVSIJ(10,11)=   0.6342935528120564D+01
        INVSIJ(10,12)=  -0.2984910836762555D+01
        INVSIJ(10,13)=   0.3615708987451101D+01
        INVSIJ(10,14)=   0.7153381090287605D-01
        INVSIJ(10,15)=  -0.1520093481684943D+00
        INVSIJ(10,16)=  -0.7683381598333578D+01
        INVSIJ(11,11)=   0.4881207133058936D+02
        INVSIJ(11,12)=   0.9657064471876970D+00
        INVSIJ(11,13)=  -0.1520093481684522D+00
        INVSIJ(11,14)=   0.7153381090268927D-01
        INVSIJ(11,15)=   0.3615708987450887D+01
        INVSIJ(11,16)=  -0.7683381598333534D+01
        INVSIJ(12,12)=   0.4881207133058984D+02
        INVSIJ(12,13)=  -0.7683381598333582D+01
        INVSIJ(12,14)=   0.3615708987451236D+01
        INVSIJ(12,15)=   0.7153381090268415D-01
        INVSIJ(12,16)=  -0.1520093481684529D+00
        INVSIJ(13,13)=   0.9307102763994525D+01
        INVSIJ(13,14)=   0.1841333280646049D+00
        INVSIJ(13,15)=   0.3642925555243569D-02
        INVSIJ(13,16)=   0.1841333280646374D+00
        INVSIJ(14,14)=   0.9307102763994557D+01
        INVSIJ(14,15)=   0.1841333280645605D+00
        INVSIJ(14,16)=   0.3642925555241051D-02
        INVSIJ(15,15)=   0.9307102763994349D+01
        INVSIJ(15,16)=   0.1841333280646220D+00
        INVSIJ(16,16)=   0.9307102763994525D+01
      ENDIF
      IF ((CLASS.EQ.3).AND.(FORM.EQ.4).AND.(GEOTYP.EQ. 4)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.9599999999999937D+02
        INVSIJ( 1, 2)=  -0.2399999999999977D+02
        INVSIJ( 1, 3)=  -0.2399999999999973D+02
        INVSIJ( 1, 4)=  -0.2399999999999984D+02
        INVSIJ( 2, 2)=   0.9600000000000010D+02
        INVSIJ( 2, 3)=  -0.2400000000000029D+02
        INVSIJ( 2, 4)=  -0.2399999999999997D+02
        INVSIJ( 3, 3)=   0.9600000000000010D+02
        INVSIJ( 3, 4)=  -0.2400000000000004D+02
        INVSIJ( 4, 4)=   0.9599999999999980D+02
      ENDIF
      IF ((CLASS.EQ.3).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.10)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.5999999999999975D+03
        INVSIJ( 1, 2)=   0.6000000000000006D+02
        INVSIJ( 1, 3)=   0.5999999999999988D+02
        INVSIJ( 1, 4)=   0.5999999999999972D+02
        INVSIJ( 1, 5)=   0.1499999999999970D+02
        INVSIJ( 1, 6)=   0.6000000000000033D+02
        INVSIJ( 1, 7)=   0.1499999999999980D+02
        INVSIJ( 1, 8)=   0.1500000000000009D+02
        INVSIJ( 1, 9)=   0.5999999999999967D+02
        INVSIJ( 1,10)=   0.5999999999999973D+02
        INVSIJ( 2, 2)=   0.6000000000000005D+03
        INVSIJ( 2, 3)=   0.6000000000000005D+02
        INVSIJ( 2, 4)=   0.6000000000000019D+02
        INVSIJ( 2, 5)=   0.1500000000000000D+02
        INVSIJ( 2, 6)=   0.1500000000000017D+02
        INVSIJ( 2, 7)=   0.5999999999999991D+02
        INVSIJ( 2, 8)=   0.5999999999999965D+02
        INVSIJ( 2, 9)=   0.1500000000000034D+02
        INVSIJ( 2,10)=   0.6000000000000010D+02
        INVSIJ( 3, 3)=   0.5999999999999994D+03
        INVSIJ( 3, 4)=   0.6000000000000001D+02
        INVSIJ( 3, 5)=   0.5999999999999987D+02
        INVSIJ( 3, 6)=   0.1500000000000010D+02
        INVSIJ( 3, 7)=   0.1499999999999995D+02
        INVSIJ( 3, 8)=   0.5999999999999964D+02
        INVSIJ( 3, 9)=   0.5999999999999989D+02
        INVSIJ( 3,10)=   0.1500000000000036D+02
        INVSIJ( 4, 4)=   0.5999999999999992D+03
        INVSIJ( 4, 5)=   0.6000000000000001D+02
        INVSIJ( 4, 6)=   0.5999999999999930D+02
        INVSIJ( 4, 7)=   0.6000000000000019D+02
        INVSIJ( 4, 8)=   0.1499999999999964D+02
        INVSIJ( 4, 9)=   0.1500000000000032D+02
        INVSIJ( 4,10)=   0.1500000000000020D+02
        INVSIJ( 5, 5)=   0.1725000000000002D+03
        INVSIJ( 5, 6)=  -0.4125000000000007D+02
        INVSIJ( 5, 7)=  -0.4125000000000013D+02
        INVSIJ( 5, 8)=  -0.4125000000000029D+02
        INVSIJ( 5, 9)=  -0.4124999999999994D+02
        INVSIJ( 5,10)=   0.6000000000000007D+02
        INVSIJ( 6, 6)=   0.1724999999999994D+03
        INVSIJ( 6, 7)=  -0.4125000000000002D+02
        INVSIJ( 6, 8)=   0.5999999999999995D+02
        INVSIJ( 6, 9)=  -0.4124999999999968D+02
        INVSIJ( 6,10)=  -0.4124999999999969D+02
        INVSIJ( 7, 7)=   0.1725000000000003D+03
        INVSIJ( 7, 8)=  -0.4125000000000021D+02
        INVSIJ( 7, 9)=   0.6000000000000004D+02
        INVSIJ( 7,10)=  -0.4124999999999997D+02
        INVSIJ( 8, 8)=   0.1724999999999998D+03
        INVSIJ( 8, 9)=  -0.4124999999999974D+02
        INVSIJ( 8,10)=  -0.4124999999999981D+02
        INVSIJ( 9, 9)=   0.1724999999999994D+03
        INVSIJ( 9,10)=  -0.4125000000000001D+02
        INVSIJ(10,10)=   0.1724999999999996D+03
      ENDIF
      IF ((CLASS.EQ.3).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.16)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.3839999999999753D+03
        INVSIJ( 1, 2)=  -0.1199999999999793D+03
        INVSIJ( 1, 3)=  -0.1199999999999824D+03
        INVSIJ( 1, 4)=  -0.1199999999999839D+03
        INVSIJ( 1, 5)=   0.1413333333333247D+03
        INVSIJ( 1, 6)=   0.1066666666666481D+02
        INVSIJ( 1, 7)=   0.1039999999999922D+03
        INVSIJ( 1, 8)=   0.1039999999999923D+03
        INVSIJ( 1, 9)=   0.1066666666666257D+02
        INVSIJ( 1,10)=   0.1413333333333244D+03
        INVSIJ( 1,11)=   0.1413333333333160D+03
        INVSIJ( 1,12)=   0.1039999999999956D+03
        INVSIJ( 1,13)=   0.1039999999999956D+03
        INVSIJ( 1,14)=   0.1066666666665622D+02
        INVSIJ( 1,15)=   0.1039999999999973D+03
        INVSIJ( 1,16)=   0.1039999999999966D+03
        INVSIJ( 2, 2)=   0.2399999999999977D+04
        INVSIJ( 2, 3)=  -0.1200000000000100D+03
        INVSIJ( 2, 4)=  -0.1200000000000107D+03
        INVSIJ( 2, 5)=  -0.2666666666665914D+02
        INVSIJ( 2, 6)=   0.6666666666666896D+02
        INVSIJ( 2, 7)=   0.6666666666667211D+02
        INVSIJ( 2, 8)=  -0.2666666666665974D+02
        INVSIJ( 2, 9)=  -0.1199999999999948D+03
        INVSIJ( 2,10)=  -0.1199999999999913D+03
        INVSIJ( 2,11)=  -0.1199999999999876D+03
        INVSIJ( 2,12)=   0.6666666666667047D+02
        INVSIJ( 2,13)=  -0.1199999999999971D+03
        INVSIJ( 2,14)=  -0.1199999999999936D+03
        INVSIJ( 2,15)=  -0.2666666666666308D+02
        INVSIJ( 2,16)=  -0.1199999999999962D+03
        INVSIJ( 3, 3)=   0.2399999999999981D+04
        INVSIJ( 3, 4)=  -0.1200000000000106D+03
        INVSIJ( 3, 5)=  -0.1199999999999928D+03
        INVSIJ( 3, 6)=  -0.1199999999999967D+03
        INVSIJ( 3, 7)=  -0.2666666666666075D+02
        INVSIJ( 3, 8)=   0.6666666666667079D+02
        INVSIJ( 3, 9)=   0.6666666666667028D+02
        INVSIJ( 3,10)=  -0.2666666666665924D+02
        INVSIJ( 3,11)=  -0.1199999999999896D+03
        INVSIJ( 3,12)=  -0.1199999999999971D+03
        INVSIJ( 3,13)=   0.6666666666666968D+02
        INVSIJ( 3,14)=  -0.1199999999999942D+03
        INVSIJ( 3,15)=  -0.1199999999999969D+03
        INVSIJ( 3,16)=  -0.2666666666666346D+02
        INVSIJ( 4, 4)=   0.2399999999999986D+04
        INVSIJ( 4, 5)=  -0.1199999999999947D+03
        INVSIJ( 4, 6)=  -0.1199999999999986D+03
        INVSIJ( 4, 7)=  -0.1199999999999951D+03
        INVSIJ( 4, 8)=  -0.1199999999999947D+03
        INVSIJ( 4, 9)=  -0.1199999999999972D+03
        INVSIJ( 4,10)=  -0.1199999999999936D+03
        INVSIJ( 4,11)=  -0.2666666666665409D+02
        INVSIJ( 4,12)=  -0.2666666666666131D+02
        INVSIJ( 4,13)=  -0.2666666666666270D+02
        INVSIJ( 4,14)=   0.6666666666667807D+02
        INVSIJ( 4,15)=   0.6666666666666737D+02
        INVSIJ( 4,16)=   0.6666666666666782D+02
        INVSIJ( 5, 5)=   0.1848888888888865D+03
        INVSIJ( 5, 6)=   0.7911111111111119D+02
        INVSIJ( 5, 7)=   0.3061728395058496D+01
        INVSIJ( 5, 8)=  -0.3950617283980775D+00
        INVSIJ( 5, 9)=   0.3071604938271465D+02
        INVSIJ( 5,10)=   0.1550617283950334D+02
        INVSIJ( 5,11)=   0.1550617283949877D+02
        INVSIJ( 5,12)=   0.3061728395059596D+01
        INVSIJ( 5,13)=   0.7911111111110958D+02
        INVSIJ( 5,14)=   0.3071604938270988D+02
        INVSIJ( 5,15)=  -0.3950617283951369D+00
        INVSIJ( 5,16)=   0.7911111111111043D+02
        INVSIJ( 6, 6)=   0.4462222222222206D+03
        INVSIJ( 6, 7)=  -0.6883950617284029D+02
        INVSIJ( 6, 8)=   0.9017283950617178D+02
        INVSIJ( 6, 9)=  -0.3427160493827155D+02
        INVSIJ( 6,10)=   0.3071604938271537D+02
        INVSIJ( 6,11)=   0.3071604938271275D+02
        INVSIJ( 6,12)=  -0.6883950617284015D+02
        INVSIJ( 6,13)=  -0.2044444444444496D+02
        INVSIJ( 6,14)=  -0.3427160493827477D+02
        INVSIJ( 6,15)=   0.9017283950617362D+02
        INVSIJ( 6,16)=  -0.2044444444444425D+02
        INVSIJ( 7, 7)=   0.4116543209876521D+03
        INVSIJ( 7, 8)=   0.7634567901234395D+02
        INVSIJ( 7, 9)=   0.9017283950617123D+02
        INVSIJ( 7,10)=  -0.3950617283980980D+00
        INVSIJ( 7,11)=   0.7911111111110664D+02
        INVSIJ( 7,12)=  -0.1310617283950629D+03
        INVSIJ( 7,13)=   0.2795061728394915D+02
        INVSIJ( 7,14)=  -0.2044444444444624D+02
        INVSIJ( 7,15)=   0.2795061728394899D+02
        INVSIJ( 7,16)=   0.2449382716049261D+02
        INVSIJ( 8, 8)=   0.4116543209876528D+03
        INVSIJ( 8, 9)=  -0.6883950617284113D+02
        INVSIJ( 8,10)=   0.3061728395058146D+01
        INVSIJ( 8,11)=   0.7911111111110695D+02
        INVSIJ( 8,12)=   0.2795061728394940D+02
        INVSIJ( 8,13)=  -0.1310617283950635D+03
        INVSIJ( 8,14)=  -0.2044444444444623D+02
        INVSIJ( 8,15)=   0.2449382716049295D+02
        INVSIJ( 8,16)=   0.2795061728394865D+02
        INVSIJ( 9, 9)=   0.4462222222222197D+03
        INVSIJ( 9,10)=   0.7911111111111020D+02
        INVSIJ( 9,11)=   0.3071604938271099D+02
        INVSIJ( 9,12)=  -0.2044444444444588D+02
        INVSIJ( 9,13)=  -0.6883950617284015D+02
        INVSIJ( 9,14)=  -0.3427160493827624D+02
        INVSIJ( 9,15)=  -0.2044444444444431D+02
        INVSIJ( 9,16)=   0.9017283950617316D+02
        INVSIJ(10,10)=   0.1848888888888859D+03
        INVSIJ(10,11)=   0.1550617283949800D+02
        INVSIJ(10,12)=   0.7911111111110907D+02
        INVSIJ(10,13)=   0.3061728395059761D+01
        INVSIJ(10,14)=   0.3071604938270826D+02
        INVSIJ(10,15)=   0.7911111111111093D+02
        INVSIJ(10,16)=  -0.3950617283950766D+00
        INVSIJ(11,11)=   0.1848888888888806D+03
        INVSIJ(11,12)=  -0.3950617283978949D+00
        INVSIJ(11,13)=  -0.3950617283977413D+00
        INVSIJ(11,14)=   0.7911111111110912D+02
        INVSIJ(11,15)=   0.3061728395058105D+01
        INVSIJ(11,16)=   0.3061728395057687D+01
        INVSIJ(12,12)=   0.4116543209876546D+03
        INVSIJ(12,13)=   0.2449382716049351D+02
        INVSIJ(12,14)=   0.9017283950617042D+02
        INVSIJ(12,15)=   0.7634567901234563D+02
        INVSIJ(12,16)=   0.2795061728395037D+02
        INVSIJ(13,13)=   0.4116543209876551D+03
        INVSIJ(13,14)=   0.9017283950617173D+02
        INVSIJ(13,15)=   0.2795061728395008D+02
        INVSIJ(13,16)=   0.7634567901234546D+02
        INVSIJ(14,14)=   0.4462222222222199D+03
        INVSIJ(14,15)=  -0.6883950617284209D+02
        INVSIJ(14,16)=  -0.6883950617284160D+02
        INVSIJ(15,15)=   0.4116543209876534D+03
        INVSIJ(15,16)=  -0.1310617283950604D+03
        INVSIJ(16,16)=   0.4116543209876533D+03
      ENDIF
      IF ((CLASS.EQ.3).AND.(FORM.EQ.6).AND.(GEOTYP.EQ. 6)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.7199999999999996D+02
        INVSIJ( 1, 2)=  -0.2400000000000002D+02
        INVSIJ( 1, 3)=  -0.2400000000000002D+02
        INVSIJ( 1, 4)=  -0.3599999999999989D+02
        INVSIJ( 1, 5)=   0.1199999999999998D+02
        INVSIJ( 1, 6)=   0.1199999999999999D+02
        INVSIJ( 2, 2)=   0.7200000000000016D+02
        INVSIJ( 2, 3)=  -0.2400000000000009D+02
        INVSIJ( 2, 4)=   0.1199999999999999D+02
        INVSIJ( 2, 5)=  -0.3600000000000006D+02
        INVSIJ( 2, 6)=   0.1200000000000004D+02
        INVSIJ( 3, 3)=   0.7200000000000016D+02
        INVSIJ( 3, 4)=   0.1199999999999999D+02
        INVSIJ( 3, 5)=   0.1200000000000004D+02
        INVSIJ( 3, 6)=  -0.3600000000000007D+02
        INVSIJ( 4, 4)=   0.7199999999999982D+02
        INVSIJ( 4, 5)=  -0.2399999999999993D+02
        INVSIJ( 4, 6)=  -0.2399999999999995D+02
        INVSIJ( 5, 5)=   0.7199999999999997D+02
        INVSIJ( 5, 6)=  -0.2400000000000000D+02
        INVSIJ( 6, 6)=   0.7199999999999997D+02
      ENDIF
      IF ((CLASS.EQ.3).AND.(FORM.EQ.6).AND.(GEOTYP.EQ.15)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.3780000000000015D+03
        INVSIJ( 1, 2)=   0.1800000000000142D+02
        INVSIJ( 1, 3)=   0.1800000000000224D+02
        INVSIJ( 1, 4)=  -0.5399999999999921D+02
        INVSIJ( 1, 5)=  -0.5400000000000028D+02
        INVSIJ( 1, 6)=  -0.5399999999999944D+02
        INVSIJ( 1, 7)=   0.1800000000000039D+02
        INVSIJ( 1, 8)=   0.1800000000000024D+02
        INVSIJ( 1, 9)=   0.1800000000000042D+02
        INVSIJ( 1,10)=   0.2699999999999996D+02
        INVSIJ( 1,11)=   0.2700000000000097D+02
        INVSIJ( 1,12)=   0.2700000000000114D+02
        INVSIJ( 1,13)=   0.3600000000000037D+02
        INVSIJ( 1,14)=  -0.5400000000000045D+02
        INVSIJ( 1,15)=   0.3600000000000068D+02
        INVSIJ( 2, 2)=   0.3780000000000015D+03
        INVSIJ( 2, 3)=   0.1800000000000136D+02
        INVSIJ( 2, 4)=  -0.5400000000000243D+02
        INVSIJ( 2, 5)=  -0.5400000000000109D+02
        INVSIJ( 2, 6)=  -0.5399999999999925D+02
        INVSIJ( 2, 7)=   0.1799999999999893D+02
        INVSIJ( 2, 8)=   0.1800000000000172D+02
        INVSIJ( 2, 9)=   0.1799999999999957D+02
        INVSIJ( 2,10)=   0.2700000000000031D+02
        INVSIJ( 2,11)=   0.2700000000000045D+02
        INVSIJ( 2,12)=   0.2700000000000005D+02
        INVSIJ( 2,13)=   0.3600000000000051D+02
        INVSIJ( 2,14)=   0.3599999999999874D+02
        INVSIJ( 2,15)=  -0.5399999999999964D+02
        INVSIJ( 3, 3)=   0.3780000000000023D+03
        INVSIJ( 3, 4)=  -0.5400000000000210D+02
        INVSIJ( 3, 5)=  -0.5399999999999944D+02
        INVSIJ( 3, 6)=  -0.5400000000000082D+02
        INVSIJ( 3, 7)=   0.1799999999999963D+02
        INVSIJ( 3, 8)=   0.1800000000000146D+02
        INVSIJ( 3, 9)=   0.1799999999999934D+02
        INVSIJ( 3,10)=   0.2700000000000023D+02
        INVSIJ( 3,11)=   0.2700000000000093D+02
        INVSIJ( 3,12)=   0.2700000000000070D+02
        INVSIJ( 3,13)=  -0.5399999999999987D+02
        INVSIJ( 3,14)=   0.3599999999999854D+02
        INVSIJ( 3,15)=   0.3600000000000116D+02
        INVSIJ( 4, 4)=   0.3779999999999989D+03
        INVSIJ( 4, 5)=   0.1800000000000217D+02
        INVSIJ( 4, 6)=   0.1800000000000187D+02
        INVSIJ( 4, 7)=   0.3599999999999903D+02
        INVSIJ( 4, 8)=  -0.5399999999999834D+02
        INVSIJ( 4, 9)=   0.3599999999999861D+02
        INVSIJ( 4,10)=   0.2700000000000117D+02
        INVSIJ( 4,11)=   0.2699999999999904D+02
        INVSIJ( 4,12)=   0.2699999999999930D+02
        INVSIJ( 4,13)=   0.1800000000000061D+02
        INVSIJ( 4,14)=   0.1799999999999966D+02
        INVSIJ( 4,15)=   0.1800000000000057D+02
        INVSIJ( 5, 5)=   0.3780000000000009D+03
        INVSIJ( 5, 6)=   0.1799999999999851D+02
        INVSIJ( 5, 7)=   0.3600000000000054D+02
        INVSIJ( 5, 8)=   0.3599999999999949D+02
        INVSIJ( 5, 9)=  -0.5399999999999984D+02
        INVSIJ( 5,10)=   0.2699999999999991D+02
        INVSIJ( 5,11)=   0.2700000000000010D+02
        INVSIJ( 5,12)=   0.2700000000000004D+02
        INVSIJ( 5,13)=   0.1799999999999998D+02
        INVSIJ( 5,14)=   0.1799999999999980D+02
        INVSIJ( 5,15)=   0.1800000000000052D+02
        INVSIJ( 6, 6)=   0.3780000000000011D+03
        INVSIJ( 6, 7)=  -0.5399999999999954D+02
        INVSIJ( 6, 8)=   0.3599999999999940D+02
        INVSIJ( 6, 9)=   0.3600000000000024D+02
        INVSIJ( 6,10)=   0.2699999999999995D+02
        INVSIJ( 6,11)=   0.2699999999999998D+02
        INVSIJ( 6,12)=   0.2700000000000095D+02
        INVSIJ( 6,13)=   0.1800000000000091D+02
        INVSIJ( 6,14)=   0.1799999999999944D+02
        INVSIJ( 6,15)=   0.1799999999999987D+02
        INVSIJ( 7, 7)=   0.1079999999999991D+03
        INVSIJ( 7, 8)=  -0.2699999999999916D+02
        INVSIJ( 7, 9)=  -0.2700000000000052D+02
        INVSIJ( 7,10)=  -0.1799999999999933D+02
        INVSIJ( 7,11)=  -0.1800000000000032D+02
        INVSIJ( 7,12)=   0.2699999999999961D+02
        INVSIJ( 7,13)=  -0.9000000000000121D+01
        INVSIJ( 7,14)=   0.1349999999999976D+02
        INVSIJ( 7,15)=   0.1350000000000014D+02
        INVSIJ( 8, 8)=   0.1079999999999991D+03
        INVSIJ( 8, 9)=  -0.2699999999999925D+02
        INVSIJ( 8,10)=   0.2699999999999969D+02
        INVSIJ( 8,11)=  -0.1799999999999918D+02
        INVSIJ( 8,12)=  -0.1799999999999904D+02
        INVSIJ( 8,13)=   0.1350000000000012D+02
        INVSIJ( 8,14)=  -0.8999999999999888D+01
        INVSIJ( 8,15)=   0.1350000000000002D+02
        INVSIJ( 9, 9)=   0.1079999999999991D+03
        INVSIJ( 9,10)=  -0.1799999999999947D+02
        INVSIJ( 9,11)=   0.2699999999999966D+02
        INVSIJ( 9,12)=  -0.1800000000000028D+02
        INVSIJ( 9,13)=   0.1350000000000004D+02
        INVSIJ( 9,14)=   0.1349999999999968D+02
        INVSIJ( 9,15)=  -0.9000000000000158D+01
        INVSIJ(10,10)=   0.9449999999999898D+02
        INVSIJ(10,11)=   0.4500000000000241D+01
        INVSIJ(10,12)=   0.4500000000000305D+01
        INVSIJ(10,13)=  -0.1799999999999938D+02
        INVSIJ(10,14)=   0.2699999999999962D+02
        INVSIJ(10,15)=  -0.1799999999999931D+02
        INVSIJ(11,11)=   0.9450000000000033D+02
        INVSIJ(11,12)=   0.4500000000000192D+01
        INVSIJ(11,13)=  -0.1799999999999967D+02
        INVSIJ(11,14)=  -0.1800000000000077D+02
        INVSIJ(11,15)=   0.2700000000000042D+02
        INVSIJ(12,12)=   0.9450000000000027D+02
        INVSIJ(12,13)=   0.2700000000000033D+02
        INVSIJ(12,14)=  -0.1800000000000069D+02
        INVSIJ(12,15)=  -0.1799999999999930D+02
        INVSIJ(13,13)=   0.1080000000000001D+03
        INVSIJ(13,14)=  -0.2699999999999992D+02
        INVSIJ(13,15)=  -0.2700000000000011D+02
        INVSIJ(14,14)=   0.1079999999999998D+03
        INVSIJ(14,15)=  -0.2700000000000008D+02
        INVSIJ(15,15)=   0.1080000000000001D+03
      ENDIF
      IF ((CLASS.EQ.3).AND.(FORM.EQ.6).AND.(GEOTYP.EQ.24)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.5159999999999560D+03
        INVSIJ( 1, 2)=  -0.1520000000000113D+03
        INVSIJ( 1, 3)=  -0.1520000000000039D+03
        INVSIJ( 1, 4)=  -0.1859999999999877D+03
        INVSIJ( 1, 5)=   0.5200000000000393D+02
        INVSIJ( 1, 6)=   0.5200000000000350D+02
        INVSIJ( 1, 7)=   0.2059259259259056D+03
        INVSIJ( 1, 8)=   0.7807407407406477D+02
        INVSIJ( 1, 9)=  -0.1866666666666681D+02
        INVSIJ( 1,10)=  -0.1866666666666640D+02
        INVSIJ( 1,11)=   0.7807407407406637D+02
        INVSIJ( 1,12)=   0.2059259259259078D+03
        INVSIJ( 1,13)=   0.6866666666666211D+02
        INVSIJ( 1,14)=  -0.1288888888889807D+02
        INVSIJ( 1,15)=  -0.1288888888889521D+02
        INVSIJ( 1,16)=   0.2133333333333308D+02
        INVSIJ( 1,17)=  -0.7111111111114160D+01
        INVSIJ( 1,18)=  -0.7111111111112884D+01
        INVSIJ( 1,19)=  -0.6296296296295792D+02
        INVSIJ( 1,20)=  -0.3103703703703390D+02
        INVSIJ( 1,21)=  -0.1466666666666360D+02
        INVSIJ( 1,22)=  -0.1466666666666348D+02
        INVSIJ( 1,23)=  -0.3103703703703398D+02
        INVSIJ( 1,24)=  -0.6296296296295988D+02
        INVSIJ( 2, 2)=   0.1016000000000014D+04
        INVSIJ( 2, 3)=  -0.1519999999999798D+03
        INVSIJ( 2, 4)=   0.5200000000000372D+02
        INVSIJ( 2, 5)=  -0.4360000000000098D+03
        INVSIJ( 2, 6)=   0.5199999999999068D+02
        INVSIJ( 2, 7)=   0.2992592592591719D+02
        INVSIJ( 2, 8)=   0.8740740740740101D+02
        INVSIJ( 2, 9)=   0.8740740740741120D+02
        INVSIJ( 2,10)=   0.2992592592592979D+02
        INVSIJ( 2,11)=  -0.1520000000000009D+03
        INVSIJ( 2,12)=  -0.1520000000000055D+03
        INVSIJ( 2,13)=  -0.1288888888888892D+02
        INVSIJ( 2,14)=   0.3186666666666710D+03
        INVSIJ( 2,15)=  -0.1288888888888391D+02
        INVSIJ( 2,16)=  -0.7111111111112196D+01
        INVSIJ( 2,17)=   0.2133333333333178D+02
        INVSIJ( 2,18)=  -0.7111111111110309D+01
        INVSIJ( 2,19)=  -0.6962962962960319D+01
        INVSIJ( 2,20)=  -0.3703703703700669D+01
        INVSIJ( 2,21)=  -0.3703703703705646D+01
        INVSIJ( 2,22)=  -0.6962962962963830D+01
        INVSIJ( 2,23)=   0.5200000000000004D+02
        INVSIJ( 2,24)=   0.5200000000000055D+02
        INVSIJ( 3, 3)=   0.1015999999999998D+04
        INVSIJ( 3, 4)=   0.5199999999999775D+02
        INVSIJ( 3, 5)=   0.5199999999999459D+02
        INVSIJ( 3, 6)=  -0.4360000000000043D+03
        INVSIJ( 3, 7)=  -0.1519999999999998D+03
        INVSIJ( 3, 8)=  -0.1519999999999989D+03
        INVSIJ( 3, 9)=   0.2992592592592821D+02
        INVSIJ( 3,10)=   0.8740740740740993D+02
        INVSIJ( 3,11)=   0.8740740740740341D+02
        INVSIJ( 3,12)=   0.2992592592592072D+02
        INVSIJ( 3,13)=  -0.1288888888888675D+02
        INVSIJ( 3,14)=  -0.1288888888888157D+02
        INVSIJ( 3,15)=   0.3186666666666634D+03
        INVSIJ( 3,16)=  -0.7111111111112092D+01
        INVSIJ( 3,17)=  -0.7111111111108869D+01
        INVSIJ( 3,18)=   0.2133333333333017D+02
        INVSIJ( 3,19)=   0.5199999999999698D+02
        INVSIJ( 3,20)=   0.5199999999999896D+02
        INVSIJ( 3,21)=  -0.6962962962963487D+01
        INVSIJ( 3,22)=  -0.3703703703704938D+01
        INVSIJ( 3,23)=  -0.3703703703702693D+01
        INVSIJ( 3,24)=  -0.6962962962961253D+01
        INVSIJ( 4, 4)=   0.5159999999999927D+03
        INVSIJ( 4, 5)=  -0.1520000000000042D+03
        INVSIJ( 4, 6)=  -0.1519999999999996D+03
        INVSIJ( 4, 7)=  -0.6296296296295628D+02
        INVSIJ( 4, 8)=  -0.3103703703703408D+02
        INVSIJ( 4, 9)=  -0.1466666666666723D+02
        INVSIJ( 4,10)=  -0.1466666666666715D+02
        INVSIJ( 4,11)=  -0.3103703703703509D+02
        INVSIJ( 4,12)=  -0.6296296296295861D+02
        INVSIJ( 4,13)=   0.2133333333333179D+02
        INVSIJ( 4,14)=  -0.7111111111108725D+01
        INVSIJ( 4,15)=  -0.7111111111109493D+01
        INVSIJ( 4,16)=   0.6866666666666254D+02
        INVSIJ( 4,17)=  -0.1288888888888854D+02
        INVSIJ( 4,18)=  -0.1288888888888644D+02
        INVSIJ( 4,19)=   0.2059259259259218D+03
        INVSIJ( 4,20)=   0.7807407407407104D+02
        INVSIJ( 4,21)=  -0.1866666666666967D+02
        INVSIJ( 4,22)=  -0.1866666666667034D+02
        INVSIJ( 4,23)=   0.7807407407407153D+02
        INVSIJ( 4,24)=   0.2059259259259252D+03
        INVSIJ( 5, 5)=   0.1016000000000010D+04
        INVSIJ( 5, 6)=  -0.1519999999999934D+03
        INVSIJ( 5, 7)=  -0.6962962962960747D+01
        INVSIJ( 5, 8)=  -0.3703703703703304D+01
        INVSIJ( 5, 9)=  -0.3703703703706778D+01
        INVSIJ( 5,10)=  -0.6962962962964828D+01
        INVSIJ( 5,11)=   0.5200000000000108D+02
        INVSIJ( 5,12)=   0.5200000000000239D+02
        INVSIJ( 5,13)=  -0.7111111111112292D+01
        INVSIJ( 5,14)=   0.2133333333333364D+02
        INVSIJ( 5,15)=  -0.7111111111112894D+01
        INVSIJ( 5,16)=  -0.1288888888889082D+02
        INVSIJ( 5,17)=   0.3186666666666719D+03
        INVSIJ( 5,18)=  -0.1288888888888818D+02
        INVSIJ( 5,19)=   0.2992592592592317D+02
        INVSIJ( 5,20)=   0.8740740740740492D+02
        INVSIJ( 5,21)=   0.8740740740740580D+02
        INVSIJ( 5,22)=   0.2992592592592603D+02
        INVSIJ( 5,23)=  -0.1520000000000004D+03
        INVSIJ( 5,24)=  -0.1520000000000004D+03
        INVSIJ( 6, 6)=   0.1015999999999997D+04
        INVSIJ( 6, 7)=   0.5199999999999905D+02
        INVSIJ( 6, 8)=   0.5199999999999977D+02
        INVSIJ( 6, 9)=  -0.6962962962963735D+01
        INVSIJ( 6,10)=  -0.3703703703705133D+01
        INVSIJ( 6,11)=  -0.3703703703703872D+01
        INVSIJ( 6,12)=  -0.6962962962960086D+01
        INVSIJ( 6,13)=  -0.7111111111111287D+01
        INVSIJ( 6,14)=  -0.7111111111114335D+01
        INVSIJ( 6,15)=   0.2133333333333421D+02
        INVSIJ( 6,16)=  -0.1288888888888801D+02
        INVSIJ( 6,17)=  -0.1288888888888851D+02
        INVSIJ( 6,18)=   0.3186666666666662D+03
        INVSIJ( 6,19)=  -0.1519999999999963D+03
        INVSIJ( 6,20)=  -0.1519999999999985D+03
        INVSIJ( 6,21)=   0.2992592592592609D+02
        INVSIJ( 6,22)=   0.8740740740740667D+02
        INVSIJ( 6,23)=   0.8740740740740689D+02
        INVSIJ( 6,24)=   0.2992592592592275D+02
        INVSIJ( 7, 7)=   0.2321975308641872D+03
        INVSIJ( 7, 8)=   0.9451851851851268D+02
        INVSIJ( 7, 9)=   0.6694101508919866D+00
        INVSIJ( 7,10)=  -0.4768175582990361D+02
        INVSIJ( 7,11)=   0.2086145404663684D+02
        INVSIJ( 7,12)=  -0.1434293552812912D+02
        INVSIJ( 7,13)=  -0.2222222222223970D+01
        INVSIJ( 7,14)=  -0.6074074074078622D+01
        INVSIJ( 7,15)=  -0.1288888888889252D+02
        INVSIJ( 7,16)=   0.1185185185185183D+02
        INVSIJ( 7,17)=   0.2370370370369062D+01
        INVSIJ( 7,18)=  -0.7111111111112858D+01
        INVSIJ( 7,19)=  -0.8676543209876343D+02
        INVSIJ( 7,20)=  -0.2859259259259014D+02
        INVSIJ( 7,21)=  -0.3001371742112049D+01
        INVSIJ( 7,22)=   0.1050754458162037D+02
        INVSIJ( 7,23)=  -0.1309739368998475D+02
        INVSIJ( 7,24)=   0.2583813443073063D+02
        INVSIJ( 8, 8)=   0.2556543209876503D+03
        INVSIJ( 8, 9)=   0.9108367626885318D+00
        INVSIJ( 8,10)=   0.1943484224965682D+02
        INVSIJ( 8,11)=  -0.2071330589849140D+02
        INVSIJ( 8,12)=   0.2086145404663631D+02
        INVSIJ( 8,13)=   0.1799999999999904D+02
        INVSIJ( 8,14)=  -0.6148148148148416D+02
        INVSIJ( 8,15)=  -0.1288888888889018D+02
        INVSIJ( 8,16)=   0.2370370370370241D+01
        INVSIJ( 8,17)=   0.1185185185185006D+02
        INVSIJ( 8,18)=  -0.7111111111111312D+01
        INVSIJ( 8,19)=  -0.2859259259259048D+02
        INVSIJ( 8,20)=  -0.9849382716049207D+02
        INVSIJ( 8,21)=   0.1821124828532268D+02
        INVSIJ( 8,22)=  -0.1238408779149430D+02
        INVSIJ( 8,23)=  -0.2976680384087385D+01
        INVSIJ( 8,24)=  -0.1309739368998573D+02
        INVSIJ( 9, 9)=   0.2247352537722900D+03
        INVSIJ( 9,10)=   0.7037585733881974D+02
        INVSIJ( 9,11)=   0.1943484224965666D+02
        INVSIJ( 9,12)=  -0.4768175582990430D+02
        INVSIJ( 9,13)=   0.5377777777777722D+02
        INVSIJ( 9,14)=  -0.6148148148147971D+02
        INVSIJ( 9,15)=  -0.6074074074072754D+01
        INVSIJ( 9,16)=  -0.7111111111111470D+01
        INVSIJ( 9,17)=   0.1185185185185166D+02
        INVSIJ( 9,18)=   0.2370370370369996D+01
        INVSIJ( 9,19)=  -0.3001371742113728D+01
        INVSIJ( 9,20)=   0.1821124828532202D+02
        INVSIJ( 9,21)=  -0.8303429355281195D+02
        INVSIJ( 9,22)=  -0.1652126200274311D+02
        INVSIJ( 9,23)=  -0.1238408779149454D+02
        INVSIJ( 9,24)=   0.1050754458161943D+02
        INVSIJ(10,10)=   0.2247352537722893D+03
        INVSIJ(10,11)=   0.9108367626878827D+00
        INVSIJ(10,12)=   0.6694101508916050D+00
        INVSIJ(10,13)=   0.5377777777777717D+02
        INVSIJ(10,14)=  -0.6074074074072398D+01
        INVSIJ(10,15)=  -0.6148148148147896D+02
        INVSIJ(10,16)=  -0.7111111111111386D+01
        INVSIJ(10,17)=   0.2370370370370215D+01
        INVSIJ(10,18)=   0.1185185185185206D+02
        INVSIJ(10,19)=   0.1050754458161839D+02
        INVSIJ(10,20)=  -0.1238408779149504D+02
        INVSIJ(10,21)=  -0.1652126200274327D+02
        INVSIJ(10,22)=  -0.8303429355281163D+02
        INVSIJ(10,23)=   0.1821124828532248D+02
        INVSIJ(10,24)=  -0.3001371742112902D+01
        INVSIJ(11,11)=   0.2556543209876513D+03
        INVSIJ(11,12)=   0.9451851851851394D+02
        INVSIJ(11,13)=   0.1799999999999926D+02
        INVSIJ(11,14)=  -0.1288888888889065D+02
        INVSIJ(11,15)=  -0.6148148148148335D+02
        INVSIJ(11,16)=   0.2370370370370429D+01
        INVSIJ(11,17)=  -0.7111111111111393D+01
        INVSIJ(11,18)=   0.1185185185185048D+02
        INVSIJ(11,19)=  -0.1309739368998586D+02
        INVSIJ(11,20)=  -0.2976680384087730D+01
        INVSIJ(11,21)=  -0.1238408779149415D+02
        INVSIJ(11,22)=   0.1821124828532311D+02
        INVSIJ(11,23)=  -0.9849382716049278D+02
        INVSIJ(11,24)=  -0.2859259259259158D+02
        INVSIJ(12,12)=   0.2321975308641895D+03
        INVSIJ(12,13)=  -0.2222222222223816D+01
        INVSIJ(12,14)=  -0.1288888888889321D+02
        INVSIJ(12,15)=  -0.6074074074077344D+01
        INVSIJ(12,16)=   0.1185185185185181D+02
        INVSIJ(12,17)=  -0.7111111111112810D+01
        INVSIJ(12,18)=   0.2370370370370187D+01
        INVSIJ(12,19)=   0.2583813443073012D+02
        INVSIJ(12,20)=  -0.1309739368998554D+02
        INVSIJ(12,21)=   0.1050754458162073D+02
        INVSIJ(12,22)=  -0.3001371742111644D+01
        INVSIJ(12,23)=  -0.2859259259259146D+02
        INVSIJ(12,24)=  -0.8676543209876588D+02
        INVSIJ(13,13)=   0.1309135802469117D+03
        INVSIJ(13,14)=  -0.3697119341563818D+02
        INVSIJ(13,15)=  -0.3697119341563683D+02
        INVSIJ(13,16)=   0.3908641975308540D+02
        INVSIJ(13,17)=  -0.9695473251029808D+01
        INVSIJ(13,18)=  -0.9695473251028792D+01
        INVSIJ(13,19)=   0.1185185185185066D+02
        INVSIJ(13,20)=   0.2370370370369933D+01
        INVSIJ(13,21)=  -0.7111111111110761D+01
        INVSIJ(13,22)=  -0.7111111111110676D+01
        INVSIJ(13,23)=   0.2370370370370473D+01
        INVSIJ(13,24)=   0.1185185185185141D+02
        INVSIJ(14,14)=   0.2975802469135818D+03
        INVSIJ(14,15)=  -0.3697119341563598D+02
        INVSIJ(14,16)=  -0.9695473251029920D+01
        INVSIJ(14,17)=   0.1224197530864217D+03
        INVSIJ(14,18)=  -0.9695473251028444D+01
        INVSIJ(14,19)=   0.2370370370371872D+01
        INVSIJ(14,20)=   0.1185185185185285D+02
        INVSIJ(14,21)=   0.1185185185185045D+02
        INVSIJ(14,22)=   0.2370370370369931D+01
        INVSIJ(14,23)=  -0.7111111111111079D+01
        INVSIJ(14,24)=  -0.7111111111110636D+01
        INVSIJ(15,15)=   0.2975802469135763D+03
        INVSIJ(15,16)=  -0.9695473251029238D+01
        INVSIJ(15,17)=  -0.9695473251028027D+01
        INVSIJ(15,18)=   0.1224197530864185D+03
        INVSIJ(15,19)=  -0.7111111111110485D+01
        INVSIJ(15,20)=  -0.7111111111110611D+01
        INVSIJ(15,21)=   0.2370370370370098D+01
        INVSIJ(15,22)=   0.1185185185185072D+02
        INVSIJ(15,23)=   0.1185185185185237D+02
        INVSIJ(15,24)=   0.2370370370371006D+01
        INVSIJ(16,16)=   0.1309135802469133D+03
        INVSIJ(16,17)=  -0.3697119341563987D+02
        INVSIJ(16,18)=  -0.3697119341563828D+02
        INVSIJ(16,19)=  -0.2222222222224268D+01
        INVSIJ(16,20)=   0.1799999999999934D+02
        INVSIJ(16,21)=   0.5377777777777819D+02
        INVSIJ(16,22)=   0.5377777777777809D+02
        INVSIJ(16,23)=   0.1799999999999959D+02
        INVSIJ(16,24)=  -0.2222222222223678D+01
        INVSIJ(17,17)=   0.2975802469135856D+03
        INVSIJ(17,18)=  -0.3697119341563796D+02
        INVSIJ(17,19)=  -0.6074074074074551D+01
        INVSIJ(17,20)=  -0.6148148148148204D+02
        INVSIJ(17,21)=  -0.6148148148148400D+02
        INVSIJ(17,22)=  -0.6074074074074362D+01
        INVSIJ(17,23)=  -0.1288888888888883D+02
        INVSIJ(17,24)=  -0.1288888888888762D+02
        INVSIJ(18,18)=   0.2975802469135814D+03
        INVSIJ(18,19)=  -0.1288888888888588D+02
        INVSIJ(18,20)=  -0.1288888888888791D+02
        INVSIJ(18,21)=  -0.6074074074074050D+01
        INVSIJ(18,22)=  -0.6148148148148333D+02
        INVSIJ(18,23)=  -0.6148148148148159D+02
        INVSIJ(18,24)=  -0.6074074074074767D+01
        INVSIJ(19,19)=   0.2321975308641969D+03
        INVSIJ(19,20)=   0.9451851851851619D+02
        INVSIJ(19,21)=   0.6694101508910386D+00
        INVSIJ(19,22)=  -0.4768175582990613D+02
        INVSIJ(19,23)=   0.2086145404663779D+02
        INVSIJ(19,24)=  -0.1434293552812344D+02
        INVSIJ(20,20)=   0.2556543209876525D+03
        INVSIJ(20,21)=   0.9108367626886212D+00
        INVSIJ(20,22)=   0.1943484224965622D+02
        INVSIJ(20,23)=  -0.2071330589849158D+02
        INVSIJ(20,24)=   0.2086145404663880D+02
        INVSIJ(21,21)=   0.2247352537722910D+03
        INVSIJ(21,22)=   0.7037585733882020D+02
        INVSIJ(21,23)=   0.1943484224965616D+02
        INVSIJ(21,24)=  -0.4768175582990614D+02
        INVSIJ(22,22)=   0.2247352537722911D+03
        INVSIJ(22,23)=   0.9108367626883500D+00
        INVSIJ(22,24)=   0.6694101508906032D+00
        INVSIJ(23,23)=   0.2556543209876534D+03
        INVSIJ(23,24)=   0.9451851851851781D+02
        INVSIJ(24,24)=   0.2321975308642003D+03
      ENDIF
      IF ((CLASS.EQ.3).AND.(FORM.EQ.8).AND.(GEOTYP.EQ. 8)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.6399999999999932D+02
        INVSIJ( 1, 2)=  -0.3199999999999941D+02
        INVSIJ( 1, 3)=   0.1599999999999952D+02
        INVSIJ( 1, 4)=  -0.3199999999999942D+02
        INVSIJ( 1, 5)=  -0.3199999999999962D+02
        INVSIJ( 1, 6)=   0.1599999999999972D+02
        INVSIJ( 1, 7)=  -0.7999999999999814D+01
        INVSIJ( 1, 8)=   0.1599999999999974D+02
        INVSIJ( 2, 2)=   0.6399999999999931D+02
        INVSIJ( 2, 3)=  -0.3199999999999943D+02
        INVSIJ( 2, 4)=   0.1599999999999951D+02
        INVSIJ( 2, 5)=   0.1599999999999971D+02
        INVSIJ( 2, 6)=  -0.3199999999999963D+02
        INVSIJ( 2, 7)=   0.1599999999999973D+02
        INVSIJ( 2, 8)=  -0.7999999999999814D+01
        INVSIJ( 3, 3)=   0.6399999999999935D+02
        INVSIJ( 3, 4)=  -0.3199999999999942D+02
        INVSIJ( 3, 5)=  -0.7999999999999810D+01
        INVSIJ( 3, 6)=   0.1599999999999973D+02
        INVSIJ( 3, 7)=  -0.3199999999999968D+02
        INVSIJ( 3, 8)=   0.1599999999999976D+02
        INVSIJ( 4, 4)=   0.6399999999999932D+02
        INVSIJ( 4, 5)=   0.1599999999999973D+02
        INVSIJ( 4, 6)=  -0.7999999999999811D+01
        INVSIJ( 4, 7)=   0.1599999999999976D+02
        INVSIJ( 4, 8)=  -0.3199999999999968D+02
        INVSIJ( 5, 5)=   0.6399999999999953D+02
        INVSIJ( 5, 6)=  -0.3199999999999961D+02
        INVSIJ( 5, 7)=   0.1599999999999975D+02
        INVSIJ( 5, 8)=  -0.3199999999999968D+02
        INVSIJ( 6, 6)=   0.6399999999999953D+02
        INVSIJ( 6, 7)=  -0.3199999999999968D+02
        INVSIJ( 6, 8)=   0.1599999999999975D+02
        INVSIJ( 7, 7)=   0.6399999999999967D+02
        INVSIJ( 7, 8)=  -0.3199999999999975D+02
        INVSIJ( 8, 8)=   0.6399999999999970D+02
      ENDIF
      IF ((CLASS.EQ.3).AND.(FORM.EQ.8).AND.(GEOTYP.EQ.20)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.3040000000000014D+03
        INVSIJ( 1, 2)=  -0.3200000000000143D+02
        INVSIJ( 1, 3)=  -0.4400000000000658D+02
        INVSIJ( 1, 4)=  -0.3200000000000141D+02
        INVSIJ( 1, 5)=  -0.3199999999999756D+02
        INVSIJ( 1, 6)=  -0.4400000000000114D+02
        INVSIJ( 1, 7)=   0.5200000000000168D+02
        INVSIJ( 1, 8)=  -0.4400000000000065D+02
        INVSIJ( 1, 9)=   0.1599999999999886D+02
        INVSIJ( 1,10)=   0.2199999999999956D+02
        INVSIJ( 1,11)=   0.2199999999999902D+02
        INVSIJ( 1,12)=   0.1599999999999918D+02
        INVSIJ( 1,13)=   0.1599999999999976D+02
        INVSIJ( 1,14)=   0.2200000000000000D+02
        INVSIJ( 1,15)=  -0.2600000000000198D+02
        INVSIJ( 1,16)=   0.2200000000000059D+02
        INVSIJ( 1,17)=   0.2200000000000102D+02
        INVSIJ( 1,18)=  -0.2600000000000075D+02
        INVSIJ( 1,19)=  -0.2600000000000045D+02
        INVSIJ( 1,20)=   0.2200000000000060D+02
        INVSIJ( 2, 2)=   0.3040000000000025D+03
        INVSIJ( 2, 3)=  -0.3199999999999993D+02
        INVSIJ( 2, 4)=  -0.4400000000000588D+02
        INVSIJ( 2, 5)=  -0.4400000000000137D+02
        INVSIJ( 2, 6)=  -0.3199999999999917D+02
        INVSIJ( 2, 7)=  -0.4400000000000210D+02
        INVSIJ( 2, 8)=   0.5200000000000212D+02
        INVSIJ( 2, 9)=   0.1599999999999875D+02
        INVSIJ( 2,10)=   0.1599999999999888D+02
        INVSIJ( 2,11)=   0.2199999999999964D+02
        INVSIJ( 2,12)=   0.2200000000000034D+02
        INVSIJ( 2,13)=   0.2199999999999986D+02
        INVSIJ( 2,14)=   0.1599999999999981D+02
        INVSIJ( 2,15)=   0.2200000000000042D+02
        INVSIJ( 2,16)=  -0.2600000000000177D+02
        INVSIJ( 2,17)=   0.2200000000000080D+02
        INVSIJ( 2,18)=   0.2200000000000077D+02
        INVSIJ( 2,19)=  -0.2600000000000059D+02
        INVSIJ( 2,20)=  -0.2600000000000134D+02
        INVSIJ( 3, 3)=   0.3040000000000038D+03
        INVSIJ( 3, 4)=  -0.3200000000000126D+02
        INVSIJ( 3, 5)=   0.5200000000000149D+02
        INVSIJ( 3, 6)=  -0.4400000000000162D+02
        INVSIJ( 3, 7)=  -0.3199999999999985D+02
        INVSIJ( 3, 8)=  -0.4400000000000003D+02
        INVSIJ( 3, 9)=   0.2200000000000015D+02
        INVSIJ( 3,10)=   0.1599999999999873D+02
        INVSIJ( 3,11)=   0.1599999999999962D+02
        INVSIJ( 3,12)=   0.2199999999999958D+02
        INVSIJ( 3,13)=  -0.2600000000000136D+02
        INVSIJ( 3,14)=   0.2199999999999985D+02
        INVSIJ( 3,15)=   0.1600000000000067D+02
        INVSIJ( 3,16)=   0.2199999999999975D+02
        INVSIJ( 3,17)=  -0.2600000000000100D+02
        INVSIJ( 3,18)=   0.2200000000000110D+02
        INVSIJ( 3,19)=   0.2200000000000043D+02
        INVSIJ( 3,20)=  -0.2600000000000054D+02
        INVSIJ( 4, 4)=   0.3040000000000038D+03
        INVSIJ( 4, 5)=  -0.4400000000000123D+02
        INVSIJ( 4, 6)=   0.5200000000000247D+02
        INVSIJ( 4, 7)=  -0.4400000000000126D+02
        INVSIJ( 4, 8)=  -0.3199999999999962D+02
        INVSIJ( 4, 9)=   0.2200000000000025D+02
        INVSIJ( 4,10)=   0.2199999999999957D+02
        INVSIJ( 4,11)=   0.1599999999999917D+02
        INVSIJ( 4,12)=   0.1599999999999878D+02
        INVSIJ( 4,13)=   0.2200000000000003D+02
        INVSIJ( 4,14)=  -0.2600000000000148D+02
        INVSIJ( 4,15)=   0.2200000000000006D+02
        INVSIJ( 4,16)=   0.1600000000000013D+02
        INVSIJ( 4,17)=  -0.2600000000000115D+02
        INVSIJ( 4,18)=  -0.2600000000000067D+02
        INVSIJ( 4,19)=   0.2200000000000076D+02
        INVSIJ( 4,20)=   0.2200000000000091D+02
        INVSIJ( 5, 5)=   0.3039999999999998D+03
        INVSIJ( 5, 6)=  -0.3200000000000295D+02
        INVSIJ( 5, 7)=  -0.4399999999999624D+02
        INVSIJ( 5, 8)=  -0.3200000000000218D+02
        INVSIJ( 5, 9)=   0.2200000000000031D+02
        INVSIJ( 5,10)=  -0.2600000000000007D+02
        INVSIJ( 5,11)=  -0.2599999999999980D+02
        INVSIJ( 5,12)=   0.2199999999999980D+02
        INVSIJ( 5,13)=   0.1599999999999864D+02
        INVSIJ( 5,14)=   0.2200000000000083D+02
        INVSIJ( 5,15)=  -0.2600000000000014D+02
        INVSIJ( 5,16)=   0.2200000000000108D+02
        INVSIJ( 5,17)=   0.1599999999999956D+02
        INVSIJ( 5,18)=   0.2199999999999989D+02
        INVSIJ( 5,19)=   0.2199999999999974D+02
        INVSIJ( 5,20)=   0.1600000000000012D+02
        INVSIJ( 6, 6)=   0.3040000000000013D+03
        INVSIJ( 6, 7)=  -0.3200000000000132D+02
        INVSIJ( 6, 8)=  -0.4399999999999660D+02
        INVSIJ( 6, 9)=   0.2200000000000067D+02
        INVSIJ( 6,10)=   0.2200000000000007D+02
        INVSIJ( 6,11)=  -0.2600000000000006D+02
        INVSIJ( 6,12)=  -0.2600000000000032D+02
        INVSIJ( 6,13)=   0.2200000000000070D+02
        INVSIJ( 6,14)=   0.1599999999999853D+02
        INVSIJ( 6,15)=   0.2200000000000118D+02
        INVSIJ( 6,16)=  -0.2600000000000015D+02
        INVSIJ( 6,17)=   0.1599999999999959D+02
        INVSIJ( 6,18)=   0.1599999999999983D+02
        INVSIJ( 6,19)=   0.2200000000000026D+02
        INVSIJ( 6,20)=   0.2200000000000043D+02
        INVSIJ( 7, 7)=   0.3039999999999986D+03
        INVSIJ( 7, 8)=  -0.3200000000000043D+02
        INVSIJ( 7, 9)=  -0.2600000000000071D+02
        INVSIJ( 7,10)=   0.2200000000000056D+02
        INVSIJ( 7,11)=   0.2199999999999980D+02
        INVSIJ( 7,12)=  -0.2600000000000018D+02
        INVSIJ( 7,13)=  -0.2599999999999961D+02
        INVSIJ( 7,14)=   0.2200000000000061D+02
        INVSIJ( 7,15)=   0.1599999999999789D+02
        INVSIJ( 7,16)=   0.2200000000000118D+02
        INVSIJ( 7,17)=   0.2200000000000053D+02
        INVSIJ( 7,18)=   0.1599999999999935D+02
        INVSIJ( 7,19)=   0.1599999999999982D+02
        INVSIJ( 7,20)=   0.2200000000000034D+02
        INVSIJ( 8, 8)=   0.3039999999999988D+03
        INVSIJ( 8, 9)=  -0.2600000000000020D+02
        INVSIJ( 8,10)=  -0.2599999999999982D+02
        INVSIJ( 8,11)=   0.2200000000000021D+02
        INVSIJ( 8,12)=   0.2200000000000079D+02
        INVSIJ( 8,13)=   0.2200000000000042D+02
        INVSIJ( 8,14)=  -0.2599999999999978D+02
        INVSIJ( 8,15)=   0.2200000000000099D+02
        INVSIJ( 8,16)=   0.1599999999999843D+02
        INVSIJ( 8,17)=   0.2200000000000042D+02
        INVSIJ( 8,18)=   0.2200000000000041D+02
        INVSIJ( 8,19)=   0.1599999999999990D+02
        INVSIJ( 8,20)=   0.1599999999999923D+02
        INVSIJ( 9, 9)=   0.7600000000000007D+02
        INVSIJ( 9,10)=  -0.1100000000000030D+02
        INVSIJ( 9,11)=  -0.8000000000000590D+01
        INVSIJ( 9,12)=  -0.1100000000000026D+02
        INVSIJ( 9,13)=  -0.1100000000000019D+02
        INVSIJ( 9,14)=  -0.1100000000000018D+02
        INVSIJ( 9,15)=   0.1300000000000005D+02
        INVSIJ( 9,16)=   0.1299999999999989D+02
        INVSIJ( 9,17)=  -0.8000000000000551D+01
        INVSIJ( 9,18)=   0.1299999999999995D+02
        INVSIJ( 9,19)=  -0.1099999999999959D+02
        INVSIJ( 9,20)=   0.1300000000000011D+02
        INVSIJ(10,10)=   0.7599999999999955D+02
        INVSIJ(10,11)=  -0.1100000000000016D+02
        INVSIJ(10,12)=  -0.8000000000000627D+01
        INVSIJ(10,13)=   0.1299999999999974D+02
        INVSIJ(10,14)=  -0.1100000000000004D+02
        INVSIJ(10,15)=  -0.1100000000000018D+02
        INVSIJ(10,16)=   0.1299999999999996D+02
        INVSIJ(10,17)=   0.1299999999999994D+02
        INVSIJ(10,18)=  -0.8000000000000243D+01
        INVSIJ(10,19)=   0.1299999999999985D+02
        INVSIJ(10,20)=  -0.1099999999999951D+02
        INVSIJ(11,11)=   0.7599999999999964D+02
        INVSIJ(11,12)=  -0.1100000000000001D+02
        INVSIJ(11,13)=   0.1299999999999989D+02
        INVSIJ(11,14)=   0.1299999999999987D+02
        INVSIJ(11,15)=  -0.1100000000000018D+02
        INVSIJ(11,16)=  -0.1100000000000011D+02
        INVSIJ(11,17)=  -0.1099999999999963D+02
        INVSIJ(11,18)=   0.1299999999999987D+02
        INVSIJ(11,19)=  -0.7999999999999990D+01
        INVSIJ(11,20)=   0.1299999999999964D+02
        INVSIJ(12,12)=   0.7599999999999980D+02
        INVSIJ(12,13)=  -0.1100000000000006D+02
        INVSIJ(12,14)=   0.1299999999999967D+02
        INVSIJ(12,15)=   0.1300000000000006D+02
        INVSIJ(12,16)=  -0.1100000000000014D+02
        INVSIJ(12,17)=   0.1300000000000009D+02
        INVSIJ(12,18)=  -0.1099999999999947D+02
        INVSIJ(12,19)=   0.1299999999999969D+02
        INVSIJ(12,20)=  -0.8000000000000457D+01
        INVSIJ(13,13)=   0.7599999999999947D+02
        INVSIJ(13,14)=  -0.8000000000000229D+01
        INVSIJ(13,15)=  -0.1099999999999961D+02
        INVSIJ(13,16)=  -0.8000000000000316D+01
        INVSIJ(13,17)=  -0.1099999999999966D+02
        INVSIJ(13,18)=   0.1299999999999966D+02
        INVSIJ(13,19)=   0.1299999999999973D+02
        INVSIJ(13,20)=  -0.1099999999999978D+02
        INVSIJ(14,14)=   0.7599999999999949D+02
        INVSIJ(14,15)=  -0.8000000000000359D+01
        INVSIJ(14,16)=  -0.1099999999999947D+02
        INVSIJ(14,17)=  -0.1099999999999949D+02
        INVSIJ(14,18)=  -0.1099999999999973D+02
        INVSIJ(14,19)=   0.1299999999999960D+02
        INVSIJ(14,20)=   0.1299999999999967D+02
        INVSIJ(15,15)=   0.7599999999999987D+02
        INVSIJ(15,16)=  -0.8000000000000430D+01
        INVSIJ(15,17)=   0.1299999999999958D+02
        INVSIJ(15,18)=  -0.1099999999999942D+02
        INVSIJ(15,19)=  -0.1099999999999962D+02
        INVSIJ(15,20)=   0.1299999999999952D+02
        INVSIJ(16,16)=   0.7599999999999973D+02
        INVSIJ(16,17)=   0.1299999999999962D+02
        INVSIJ(16,18)=   0.1299999999999953D+02
        INVSIJ(16,19)=  -0.1099999999999961D+02
        INVSIJ(16,20)=  -0.1099999999999930D+02
        INVSIJ(17,17)=   0.7599999999999986D+02
        INVSIJ(17,18)=  -0.1099999999999991D+02
        INVSIJ(17,19)=  -0.8000000000000039D+01
        INVSIJ(17,20)=  -0.1099999999999999D+02
        INVSIJ(18,18)=   0.7599999999999963D+02
        INVSIJ(18,19)=  -0.1099999999999982D+02
        INVSIJ(18,20)=  -0.8000000000000068D+01
        INVSIJ(19,19)=   0.7599999999999946D+02
        INVSIJ(19,20)=  -0.1099999999999976D+02
        INVSIJ(20,20)=   0.7599999999999972D+02
      ENDIF
      IF ((CLASS.EQ.3).AND.(FORM.EQ.8).AND.(GEOTYP.EQ.32)) THEN
        ERR=0
        INVSIJ( 1, 1)=   0.6399999999998139D+03
        INVSIJ( 1, 2)=  -0.2559999999998286D+03
        INVSIJ( 1, 3)=   0.9599999999982643D+02
        INVSIJ( 1, 4)=  -0.2559999999998132D+03
        INVSIJ( 1, 5)=  -0.2559999999998427D+03
        INVSIJ( 1, 6)=   0.9599999999985796D+02
        INVSIJ( 1, 7)=  -0.3199999999986984D+02
        INVSIJ( 1, 8)=   0.9599999999984999D+02
        INVSIJ( 1, 9)=   0.1517037037036765D+03
        INVSIJ( 1,10)=   0.1896296296298569D+02
        INVSIJ( 1,11)=  -0.4385185185183142D+02
        INVSIJ( 1,12)=  -0.9481481481506323D+01
        INVSIJ( 1,13)=  -0.9481481481503243D+01
        INVSIJ( 1,14)=  -0.4385185185182596D+02
        INVSIJ( 1,15)=   0.1896296296298955D+02
        INVSIJ( 1,16)=   0.1517037037036786D+03
        INVSIJ( 1,17)=   0.1517037037036897D+03
        INVSIJ( 1,18)=  -0.4385185185183872D+02
        INVSIJ( 1,19)=   0.5925925925908239D+01
        INVSIJ( 1,20)=  -0.4385185185183416D+02
        INVSIJ( 1,21)=   0.1896296296298633D+02
        INVSIJ( 1,22)=  -0.9481481481502051D+01
        INVSIJ( 1,23)=   0.4740740740754760D+01
        INVSIJ( 1,24)=  -0.9481481481501422D+01
        INVSIJ( 1,25)=  -0.4385185185183299D+02
        INVSIJ( 1,26)=  -0.9481481481495793D+01
        INVSIJ( 1,27)=   0.5925925925912117D+01
        INVSIJ( 1,28)=   0.4740740740752289D+01
        INVSIJ( 1,29)=   0.4740740740751233D+01
        INVSIJ( 1,30)=   0.5925925925908457D+01
        INVSIJ( 1,31)=  -0.9481481481496978D+01
        INVSIJ( 1,32)=  -0.4385185185183593D+02
        INVSIJ( 2, 2)=   0.6399999999998325D+03
        INVSIJ( 2, 3)=  -0.2559999999998228D+03
        INVSIJ( 2, 4)=   0.9599999999982894D+02
        INVSIJ( 2, 5)=   0.9599999999985930D+02
        INVSIJ( 2, 6)=  -0.2559999999998525D+03
        INVSIJ( 2, 7)=   0.9599999999985319D+02
        INVSIJ( 2, 8)=  -0.3199999999986860D+02
        INVSIJ( 2, 9)=   0.1896296296298786D+02
        INVSIJ( 2,10)=   0.1517037037036804D+03
        INVSIJ( 2,11)=   0.1517037037036839D+03
        INVSIJ( 2,12)=   0.1896296296299167D+02
        INVSIJ( 2,13)=  -0.4385185185182823D+02
        INVSIJ( 2,14)=  -0.9481481481503357D+01
        INVSIJ( 2,15)=  -0.9481481481504691D+01
        INVSIJ( 2,16)=  -0.4385185185182872D+02
        INVSIJ( 2,17)=  -0.4385185185183686D+02
        INVSIJ( 2,18)=   0.1517037037036955D+03
        INVSIJ( 2,19)=  -0.4385185185183764D+02
        INVSIJ( 2,20)=   0.5925925925908627D+01
        INVSIJ( 2,21)=  -0.9481481481501699D+01
        INVSIJ( 2,22)=   0.1896296296298803D+02
        INVSIJ( 2,23)=  -0.9481481481501895D+01
        INVSIJ( 2,24)=   0.4740740740755472D+01
        INVSIJ( 2,25)=  -0.9481481481495711D+01
        INVSIJ( 2,26)=  -0.4385185185183454D+02
        INVSIJ( 2,27)=  -0.4385185185183995D+02
        INVSIJ( 2,28)=  -0.9481481481500266D+01
        INVSIJ( 2,29)=   0.5925925925910115D+01
        INVSIJ( 2,30)=   0.4740740740752407D+01
        INVSIJ( 2,31)=   0.4740740740753540D+01
        INVSIJ( 2,32)=   0.5925925925912997D+01
        INVSIJ( 3, 3)=   0.6399999999998080D+03
        INVSIJ( 3, 4)=  -0.2559999999998241D+03
        INVSIJ( 3, 5)=  -0.3199999999987073D+02
        INVSIJ( 3, 6)=   0.9599999999985266D+02
        INVSIJ( 3, 7)=  -0.2559999999998263D+03
        INVSIJ( 3, 8)=   0.9599999999985475D+02
        INVSIJ( 3, 9)=  -0.9481481481504206D+01
        INVSIJ( 3,10)=  -0.4385185185182730D+02
        INVSIJ( 3,11)=   0.1896296296298490D+02
        INVSIJ( 3,12)=   0.1517037037036731D+03
        INVSIJ( 3,13)=   0.1517037037036724D+03
        INVSIJ( 3,14)=   0.1896296296298405D+02
        INVSIJ( 3,15)=  -0.4385185185182750D+02
        INVSIJ( 3,16)=  -0.9481481481505458D+01
        INVSIJ( 3,17)=   0.5925925925907402D+01
        INVSIJ( 3,18)=  -0.4385185185183962D+02
        INVSIJ( 3,19)=   0.1517037037036937D+03
        INVSIJ( 3,20)=  -0.4385185185183852D+02
        INVSIJ( 3,21)=   0.4740740740754439D+01
        INVSIJ( 3,22)=  -0.9481481481502108D+01
        INVSIJ( 3,23)=   0.1896296296298992D+02
        INVSIJ( 3,24)=  -0.9481481481500557D+01
        INVSIJ( 3,25)=   0.4740740740750891D+01
        INVSIJ( 3,26)=   0.5925925925908840D+01
        INVSIJ( 3,27)=  -0.9481481481493239D+01
        INVSIJ( 3,28)=  -0.4385185185182689D+02
        INVSIJ( 3,29)=  -0.4385185185182800D+02
        INVSIJ( 3,30)=  -0.9481481481493208D+01
        INVSIJ( 3,31)=   0.5925925925908804D+01
        INVSIJ( 3,32)=   0.4740740740751097D+01
        INVSIJ( 4, 4)=   0.6399999999998114D+03
        INVSIJ( 4, 5)=   0.9599999999985285D+02
        INVSIJ( 4, 6)=  -0.3199999999986976D+02
        INVSIJ( 4, 7)=   0.9599999999985623D+02
        INVSIJ( 4, 8)=  -0.2559999999998346D+03
        INVSIJ( 4, 9)=  -0.4385185185182529D+02
        INVSIJ( 4,10)=  -0.9481481481502836D+01
        INVSIJ( 4,11)=  -0.9481481481503112D+01
        INVSIJ( 4,12)=  -0.4385185185182792D+02
        INVSIJ( 4,13)=   0.1896296296298629D+02
        INVSIJ( 4,14)=   0.1517037037036753D+03
        INVSIJ( 4,15)=   0.1517037037036761D+03
        INVSIJ( 4,16)=   0.1896296296298863D+02
        INVSIJ( 4,17)=  -0.4385185185183452D+02
        INVSIJ( 4,18)=   0.5925925925910774D+01
        INVSIJ( 4,19)=  -0.4385185185184071D+02
        INVSIJ( 4,20)=   0.1517037037036924D+03
        INVSIJ( 4,21)=  -0.9481481481500177D+01
        INVSIJ( 4,22)=   0.4740740740755588D+01
        INVSIJ( 4,23)=  -0.9481481481502074D+01
        INVSIJ( 4,24)=   0.1896296296298920D+02
        INVSIJ( 4,25)=   0.5925925925909183D+01
        INVSIJ( 4,26)=   0.4740740740752111D+01
        INVSIJ( 4,27)=   0.4740740740752450D+01
        INVSIJ( 4,28)=   0.5925925925910647D+01
        INVSIJ( 4,29)=  -0.9481481481494409D+01
        INVSIJ( 4,30)=  -0.4385185185182978D+02
        INVSIJ( 4,31)=  -0.4385185185183227D+02
        INVSIJ( 4,32)=  -0.9481481481494537D+01
        INVSIJ( 5, 5)=   0.6399999999998770D+03
        INVSIJ( 5, 6)=  -0.2559999999998935D+03
        INVSIJ( 5, 7)=   0.9599999999990784D+02
        INVSIJ( 5, 8)=  -0.2559999999998938D+03
        INVSIJ( 5, 9)=  -0.4385185185182619D+02
        INVSIJ( 5,10)=  -0.9481481481499811D+01
        INVSIJ( 5,11)=   0.5925925925908031D+01
        INVSIJ( 5,12)=   0.4740740740758667D+01
        INVSIJ( 5,13)=   0.4740740740756109D+01
        INVSIJ( 5,14)=   0.5925925925903005D+01
        INVSIJ( 5,15)=  -0.9481481481503552D+01
        INVSIJ( 5,16)=  -0.4385185185183034D+02
        INVSIJ( 5,17)=   0.1896296296297922D+02
        INVSIJ( 5,18)=  -0.9481481481494546D+01
        INVSIJ( 5,19)=   0.4740740740752383D+01
        INVSIJ( 5,20)=  -0.9481481481497607D+01
        INVSIJ( 5,21)=   0.1517037037036879D+03
        INVSIJ( 5,22)=  -0.4385185185183684D+02
        INVSIJ( 5,23)=   0.5925925925915870D+01
        INVSIJ( 5,24)=  -0.4385185185183962D+02
        INVSIJ( 5,25)=   0.1517037037036862D+03
        INVSIJ( 5,26)=   0.1896296296297270D+02
        INVSIJ( 5,27)=  -0.4385185185184271D+02
        INVSIJ( 5,28)=  -0.9481481481490171D+01
        INVSIJ( 5,29)=  -0.9481481481488888D+01
        INVSIJ( 5,30)=  -0.4385185185184112D+02
        INVSIJ( 5,31)=   0.1896296296297271D+02
        INVSIJ( 5,32)=   0.1517037037036900D+03
        INVSIJ( 6, 6)=   0.6399999999998864D+03
        INVSIJ( 6, 7)=  -0.2559999999998986D+03
        INVSIJ( 6, 8)=   0.9599999999990966D+02
        INVSIJ( 6, 9)=  -0.9481481481501634D+01
        INVSIJ( 6,10)=  -0.4385185185182957D+02
        INVSIJ( 6,11)=  -0.4385185185183326D+02
        INVSIJ( 6,12)=  -0.9481481481505474D+01
        INVSIJ( 6,13)=   0.5925925925903754D+01
        INVSIJ( 6,14)=   0.4740740740756992D+01
        INVSIJ( 6,15)=   0.4740740740758854D+01
        INVSIJ( 6,16)=   0.5925925925905611D+01
        INVSIJ( 6,17)=  -0.9481481481495205D+01
        INVSIJ( 6,18)=   0.1896296296297410D+02
        INVSIJ( 6,19)=  -0.9481481481496735D+01
        INVSIJ( 6,20)=   0.4740740740754349D+01
        INVSIJ( 6,21)=  -0.4385185185183592D+02
        INVSIJ( 6,22)=   0.1517037037036854D+03
        INVSIJ( 6,23)=  -0.4385185185184091D+02
        INVSIJ( 6,24)=   0.5925925925916499D+01
        INVSIJ( 6,25)=   0.1896296296297322D+02
        INVSIJ( 6,26)=   0.1517037037036888D+03
        INVSIJ( 6,27)=   0.1517037037036944D+03
        INVSIJ( 6,28)=   0.1896296296297504D+02
        INVSIJ( 6,29)=  -0.4385185185184161D+02
        INVSIJ( 6,30)=  -0.9481481481487780D+01
        INVSIJ( 6,31)=  -0.9481481481489499D+01
        INVSIJ( 6,32)=  -0.4385185185184250D+02
        INVSIJ( 7, 7)=   0.6399999999998677D+03
        INVSIJ( 7, 8)=  -0.2559999999998960D+03
        INVSIJ( 7, 9)=   0.4740740740757720D+01
        INVSIJ( 7,10)=   0.5925925925903779D+01
        INVSIJ( 7,11)=  -0.9481481481498168D+01
        INVSIJ( 7,12)=  -0.4385185185181933D+02
        INVSIJ( 7,13)=  -0.4385185185182266D+02
        INVSIJ( 7,14)=  -0.9481481481500227D+01
        INVSIJ( 7,15)=   0.5925925925901473D+01
        INVSIJ( 7,16)=   0.4740740740756754D+01
        INVSIJ( 7,17)=   0.4740740740751826D+01
        INVSIJ( 7,18)=  -0.9481481481493814D+01
        INVSIJ( 7,19)=   0.1896296296297752D+02
        INVSIJ( 7,20)=  -0.9481481481493972D+01
        INVSIJ( 7,21)=   0.5925925925914198D+01
        INVSIJ( 7,22)=  -0.4385185185183972D+02
        INVSIJ( 7,23)=   0.1517037037036873D+03
        INVSIJ( 7,24)=  -0.4385185185184071D+02
        INVSIJ( 7,25)=  -0.9481481481490396D+01
        INVSIJ( 7,26)=  -0.4385185185184258D+02
        INVSIJ( 7,27)=   0.1896296296296666D+02
        INVSIJ( 7,28)=   0.1517037037036795D+03
        INVSIJ( 7,29)=   0.1517037037036858D+03
        INVSIJ( 7,30)=   0.1896296296297008D+02
        INVSIJ( 7,31)=  -0.4385185185183909D+02
        INVSIJ( 7,32)=  -0.9481481481487894D+01
        INVSIJ( 8, 8)=   0.6399999999998707D+03
        INVSIJ( 8, 9)=   0.5925925925900652D+01
        INVSIJ( 8,10)=   0.4740740740756372D+01
        INVSIJ( 8,11)=   0.4740740740755912D+01
        INVSIJ( 8,12)=   0.5925925925901743D+01
        INVSIJ( 8,13)=  -0.9481481481499328D+01
        INVSIJ( 8,14)=  -0.4385185185182269D+02
        INVSIJ( 8,15)=  -0.4385185185182370D+02
        INVSIJ( 8,16)=  -0.9481481481499596D+01
        INVSIJ( 8,17)=  -0.9481481481497399D+01
        INVSIJ( 8,18)=   0.4740740740752653D+01
        INVSIJ( 8,19)=  -0.9481481481493276D+01
        INVSIJ( 8,20)=   0.1896296296297623D+02
        INVSIJ( 8,21)=  -0.4385185185184119D+02
        INVSIJ( 8,22)=   0.5925925925916846D+01
        INVSIJ( 8,23)=  -0.4385185185184080D+02
        INVSIJ( 8,24)=   0.1517037037036859D+03
        INVSIJ( 8,25)=  -0.4385185185183813D+02
        INVSIJ( 8,26)=  -0.9481481481487288D+01
        INVSIJ( 8,27)=  -0.9481481481486892D+01
        INVSIJ( 8,28)=  -0.4385185185183855D+02
        INVSIJ( 8,29)=   0.1896296296296795D+02
        INVSIJ( 8,30)=   0.1517037037036827D+03
        INVSIJ( 8,31)=   0.1517037037036851D+03
        INVSIJ( 8,32)=   0.1896296296296801D+02
        INVSIJ( 9, 9)=   0.1768120713305865D+03
        INVSIJ( 9,10)=   0.6496570644719117D+02
        INVSIJ( 9,11)=   0.9481481481485034D+01
        INVSIJ( 9,13)=  -0.2181618655693015D+02
        INVSIJ( 9,14)=  -0.6707270233195825D+02
        INVSIJ( 9,15)=   0.9481481481485414D+01
        INVSIJ( 9,16)=  -0.8296296296301275D+01
        INVSIJ( 9,17)=  -0.8296296296297044D+01
        INVSIJ( 9,18)=   0.9481481481483483D+01
        INVSIJ( 9,19)=  -0.4740740740743175D+01
        INVSIJ( 9,20)=   0.2014814814814953D+02
        INVSIJ( 9,21)=   0.9481481481486011D+01
        INVSIJ( 9,24)=  -0.4740740740744971D+01
        INVSIJ( 9,25)=  -0.6707270233195862D+02
        INVSIJ( 9,26)=  -0.2181618655692907D+02
        INVSIJ( 9,27)=  -0.4740740740743239D+01
        INVSIJ( 9,29)=   0.5574759945131217D+01
        INVSIJ( 9,30)=   0.2286968449931091D+02
        INVSIJ( 9,31)=  -0.4740740740743731D+01
        INVSIJ( 9,32)=   0.2014814814815149D+02
        INVSIJ(10,10)=   0.1768120713305865D+03
        INVSIJ(10,11)=  -0.8296296296299493D+01
        INVSIJ(10,12)=   0.9481481481486089D+01
        INVSIJ(10,13)=  -0.6707270233195852D+02
        INVSIJ(10,14)=  -0.2181618655693013D+02
        INVSIJ(10,16)=   0.9481481481484744D+01
        INVSIJ(10,17)=   0.9481481481483568D+01
        INVSIJ(10,18)=  -0.8296296296296118D+01
        INVSIJ(10,19)=   0.2014814814814932D+02
        INVSIJ(10,20)=  -0.4740740740743205D+01
        INVSIJ(10,22)=   0.9481481481486041D+01
        INVSIJ(10,23)=  -0.4740740740744650D+01
        INVSIJ(10,25)=  -0.2181618655692905D+02
        INVSIJ(10,26)=  -0.6707270233195884D+02
        INVSIJ(10,27)=   0.2014814814814981D+02
        INVSIJ(10,28)=  -0.4740740740744505D+01
        INVSIJ(10,29)=   0.2286968449931184D+02
        INVSIJ(10,30)=   0.5574759945131551D+01
        INVSIJ(10,32)=  -0.4740740740742436D+01
        INVSIJ(11,11)=   0.1768120713305881D+03
        INVSIJ(11,12)=   0.6496570644719159D+02
        INVSIJ(11,13)=   0.9481481481483906D+01
        INVSIJ(11,15)=  -0.2181618655693058D+02
        INVSIJ(11,16)=  -0.6707270233195955D+02
        INVSIJ(11,17)=   0.2014814814814926D+02
        INVSIJ(11,18)=  -0.8296296296296429D+01
        INVSIJ(11,19)=   0.9481481481483879D+01
        INVSIJ(11,20)=  -0.4740740740743459D+01
        INVSIJ(11,21)=  -0.4740740740744234D+01
        INVSIJ(11,22)=   0.9481481481485721D+01
        INVSIJ(11,25)=  -0.4740740740742975D+01
        INVSIJ(11,26)=   0.2014814814815072D+02
        INVSIJ(11,27)=  -0.6707270233196053D+02
        INVSIJ(11,28)=  -0.2181618655692924D+02
        INVSIJ(11,29)=  -0.4740740740742421D+01
        INVSIJ(11,31)=   0.5574759945131627D+01
        INVSIJ(11,32)=   0.2286968449931294D+02
        INVSIJ(12,12)=   0.1768120713305852D+03
        INVSIJ(12,13)=  -0.8296296296302428D+01
        INVSIJ(12,14)=   0.9481481481484089D+01
        INVSIJ(12,15)=  -0.6707270233195869D+02
        INVSIJ(12,16)=  -0.2181618655693107D+02
        INVSIJ(12,17)=  -0.4740740740743711D+01
        INVSIJ(12,18)=   0.9481481481484005D+01
        INVSIJ(12,19)=  -0.8296296296296443D+01
        INVSIJ(12,20)=   0.2014814814814851D+02
        INVSIJ(12,23)=   0.9481481481487348D+01
        INVSIJ(12,24)=  -0.4740740740744839D+01
        INVSIJ(12,26)=  -0.4740740740743865D+01
        INVSIJ(12,27)=  -0.2181618655692899D+02
        INVSIJ(12,28)=  -0.6707270233195605D+02
        INVSIJ(12,29)=   0.2014814814815338D+02
        INVSIJ(12,30)=  -0.4740740740742500D+01
        INVSIJ(12,31)=   0.2286968449931050D+02
        INVSIJ(12,32)=   0.5574759945131479D+01
        INVSIJ(13,13)=   0.1768120713305840D+03
        INVSIJ(13,14)=   0.6496570644718989D+02
        INVSIJ(13,15)=   0.9481481481484794D+01
        INVSIJ(13,17)=  -0.4740740740743278D+01
        INVSIJ(13,18)=   0.2014814814814860D+02
        INVSIJ(13,19)=  -0.8296296296298117D+01
        INVSIJ(13,20)=   0.9481481481484067D+01
        INVSIJ(13,22)=  -0.4740740740744733D+01
        INVSIJ(13,23)=   0.9481481481486245D+01
        INVSIJ(13,25)=   0.5574759945131212D+01
        INVSIJ(13,26)=   0.2286968449931165D+02
        INVSIJ(13,27)=  -0.4740740740742363D+01
        INVSIJ(13,28)=   0.2014814814815315D+02
        INVSIJ(13,29)=  -0.6707270233195678D+02
        INVSIJ(13,30)=  -0.2181618655692745D+02
        INVSIJ(13,31)=  -0.4740740740742806D+01
        INVSIJ(14,14)=   0.1768120713305849D+03
        INVSIJ(14,15)=  -0.8296296296301405D+01
        INVSIJ(14,16)=   0.9481481481485220D+01
        INVSIJ(14,17)=   0.2014814814814969D+02
        INVSIJ(14,18)=  -0.4740740740742978D+01
        INVSIJ(14,19)=   0.9481481481482213D+01
        INVSIJ(14,20)=  -0.8296296296296463D+01
        INVSIJ(14,21)=  -0.4740740740744042D+01
        INVSIJ(14,24)=   0.9481481481486977D+01
        INVSIJ(14,25)=   0.2286968449931140D+02
        INVSIJ(14,26)=   0.5574759945131365D+01
        INVSIJ(14,28)=  -0.4740740740742195D+01
        INVSIJ(14,29)=  -0.2181618655692763D+02
        INVSIJ(14,30)=  -0.6707270233195641D+02
        INVSIJ(14,31)=   0.2014814814815217D+02
        INVSIJ(14,32)=  -0.4740740740742753D+01
        INVSIJ(15,15)=   0.1768120713305863D+03
        INVSIJ(15,16)=   0.6496570644719164D+02
        INVSIJ(15,17)=   0.9481481481483820D+01
        INVSIJ(15,18)=  -0.4740740740742951D+01
        INVSIJ(15,19)=   0.2014814814814827D+02
        INVSIJ(15,20)=  -0.8296296296296406D+01
        INVSIJ(15,23)=  -0.4740740740745158D+01
        INVSIJ(15,24)=   0.9481481481486968D+01
        INVSIJ(15,25)=  -0.4740740740743274D+01
        INVSIJ(15,27)=   0.5574759945131784D+01
        INVSIJ(15,28)=   0.2286968449931137D+02
        INVSIJ(15,29)=  -0.4740740740742885D+01
        INVSIJ(15,30)=   0.2014814814815238D+02
        INVSIJ(15,31)=  -0.6707270233195783D+02
        INVSIJ(15,32)=  -0.2181618655692899D+02
        INVSIJ(16,16)=   0.1768120713305874D+03
        INVSIJ(16,17)=  -0.8296296296297928D+01
        INVSIJ(16,18)=   0.2014814814814953D+02
        INVSIJ(16,19)=  -0.4740740740744285D+01
        INVSIJ(16,20)=   0.9481481481484890D+01
        INVSIJ(16,21)=   0.9481481481484995D+01
        INVSIJ(16,22)=  -0.4740740740744216D+01
        INVSIJ(16,25)=   0.2014814814815126D+02
        INVSIJ(16,26)=  -0.4740740740743144D+01
        INVSIJ(16,27)=   0.2286968449931257D+02
        INVSIJ(16,28)=   0.5574759945131555D+01
        INVSIJ(16,30)=  -0.4740740740742453D+01
        INVSIJ(16,31)=  -0.2181618655692879D+02
        INVSIJ(16,32)=  -0.6707270233195982D+02
        INVSIJ(17,17)=   0.1768120713305895D+03
        INVSIJ(17,18)=  -0.6707270233196024D+02
        INVSIJ(17,19)=   0.2286968449931072D+02
        INVSIJ(17,20)=  -0.6707270233195909D+02
        INVSIJ(17,21)=   0.6496570644719134D+02
        INVSIJ(17,22)=  -0.2181618655692953D+02
        INVSIJ(17,23)=   0.5574759945130688D+01
        INVSIJ(17,24)=  -0.2181618655692969D+02
        INVSIJ(17,25)=   0.9481481481483010D+01
        INVSIJ(17,27)=  -0.4740740740742400D+01
        INVSIJ(17,30)=  -0.4740740740742906D+01
        INVSIJ(17,32)=   0.9481481481482838D+01
        INVSIJ(18,18)=   0.1768120713305900D+03
        INVSIJ(18,19)=  -0.6707270233196031D+02
        INVSIJ(18,20)=   0.2286968449931149D+02
        INVSIJ(18,21)=  -0.2181618655692961D+02
        INVSIJ(18,22)=   0.6496570644719063D+02
        INVSIJ(18,23)=  -0.2181618655692954D+02
        INVSIJ(18,24)=   0.5574759945131592D+01
        INVSIJ(18,26)=   0.9481481481482467D+01
        INVSIJ(18,27)=   0.9481481481482289D+01
        INVSIJ(18,29)=  -0.4740740740742030D+01
        INVSIJ(18,32)=  -0.4740740740742249D+01
        INVSIJ(19,19)=   0.1768120713305904D+03
        INVSIJ(19,20)=  -0.6707270233196023D+02
        INVSIJ(19,21)=   0.5574759945130932D+01
        INVSIJ(19,22)=  -0.2181618655692989D+02
        INVSIJ(19,23)=   0.6496570644719101D+02
        INVSIJ(19,24)=  -0.2181618655692916D+02
        INVSIJ(19,26)=  -0.4740740740743391D+01
        INVSIJ(19,28)=   0.9481481481482524D+01
        INVSIJ(19,29)=   0.9481481481484247D+01
        INVSIJ(19,31)=  -0.4740740740741654D+01
        INVSIJ(20,20)=   0.1768120713305891D+03
        INVSIJ(20,21)=  -0.2181618655692995D+02
        INVSIJ(20,22)=   0.5574759945131798D+01
        INVSIJ(20,23)=  -0.2181618655692935D+02
        INVSIJ(20,24)=   0.6496570644719081D+02
        INVSIJ(20,25)=  -0.4740740740742273D+01
        INVSIJ(20,28)=  -0.4740740740740653D+01
        INVSIJ(20,30)=   0.9481481481482605D+01
        INVSIJ(20,31)=   0.9481481481481548D+01
        INVSIJ(21,21)=   0.1768120713305900D+03
        INVSIJ(21,22)=  -0.6707270233196027D+02
        INVSIJ(21,23)=   0.2286968449931339D+02
        INVSIJ(21,24)=  -0.6707270233196184D+02
        INVSIJ(21,25)=  -0.8296296296298888D+01
        INVSIJ(21,26)=   0.9481481481483986D+01
        INVSIJ(21,27)=   0.2014814814815034D+02
        INVSIJ(21,28)=  -0.4740740740742179D+01
        INVSIJ(21,29)=  -0.4740740740742627D+01
        INVSIJ(21,30)=   0.2014814814814882D+02
        INVSIJ(21,31)=   0.9481481481483037D+01
        INVSIJ(21,32)=  -0.8296296296298928D+01
        INVSIJ(22,22)=   0.1768120713305882D+03
        INVSIJ(22,23)=  -0.6707270233196178D+02
        INVSIJ(22,24)=   0.2286968449931402D+02
        INVSIJ(22,25)=   0.9481481481483391D+01
        INVSIJ(22,26)=  -0.8296296296299078D+01
        INVSIJ(22,27)=  -0.8296296296298800D+01
        INVSIJ(22,28)=   0.9481481481482721D+01
        INVSIJ(22,29)=   0.2014814814814947D+02
        INVSIJ(22,30)=  -0.4740740740741431D+01
        INVSIJ(22,31)=  -0.4740740740741579D+01
        INVSIJ(22,32)=   0.2014814814814998D+02
        INVSIJ(23,23)=   0.1768120713305895D+03
        INVSIJ(23,24)=  -0.6707270233196186D+02
        INVSIJ(23,25)=  -0.4740740740742448D+01
        INVSIJ(23,26)=   0.2014814814814848D+02
        INVSIJ(23,27)=   0.9481481481482112D+01
        INVSIJ(23,28)=  -0.8296296296299772D+01
        INVSIJ(23,29)=  -0.8296296296298516D+01
        INVSIJ(23,30)=   0.9481481481482568D+01
        INVSIJ(23,31)=   0.2014814814814943D+02
        INVSIJ(23,32)=  -0.4740740740742095D+01
        INVSIJ(24,24)=   0.1768120713305893D+03
        INVSIJ(24,25)=   0.2014814814815017D+02
        INVSIJ(24,26)=  -0.4740740740741328D+01
        INVSIJ(24,27)=  -0.4740740740741697D+01
        INVSIJ(24,28)=   0.2014814814814989D+02
        INVSIJ(24,29)=   0.9481481481481714D+01
        INVSIJ(24,30)=  -0.8296296296300046D+01
        INVSIJ(24,31)=  -0.8296296296299868D+01
        INVSIJ(24,32)=   0.9481481481482056D+01
        INVSIJ(25,25)=   0.1768120713305857D+03
        INVSIJ(25,26)=   0.6496570644718716D+02
        INVSIJ(25,27)=   0.9481481481482177D+01
        INVSIJ(25,29)=  -0.2181618655692705D+02
        INVSIJ(25,30)=  -0.6707270233195926D+02
        INVSIJ(25,31)=   0.9481481481482565D+01
        INVSIJ(25,32)=  -0.8296296296298898D+01
        INVSIJ(26,26)=   0.1768120713305861D+03
        INVSIJ(26,27)=  -0.8296296296297536D+01
        INVSIJ(26,28)=   0.9481481481482549D+01
        INVSIJ(26,29)=  -0.6707270233196037D+02
        INVSIJ(26,30)=  -0.2181618655692690D+02
        INVSIJ(26,32)=   0.9481481481481854D+01
        INVSIJ(27,27)=   0.1768120713305885D+03
        INVSIJ(27,28)=   0.6496570644718663D+02
        INVSIJ(27,29)=   0.9481481481481230D+01
        INVSIJ(27,31)=  -0.2181618655692696D+02
        INVSIJ(27,32)=  -0.6707270233196091D+02
        INVSIJ(28,28)=   0.1768120713305827D+03
        INVSIJ(28,29)=  -0.8296296296300413D+01
        INVSIJ(28,30)=   0.9481481481481923D+01
        INVSIJ(28,31)=  -0.6707270233195838D+02
        INVSIJ(28,32)=  -0.2181618655692701D+02
        INVSIJ(29,29)=   0.1768120713305854D+03
        INVSIJ(29,30)=   0.6496570644718537D+02
        INVSIJ(29,31)=   0.9481481481481421D+01
        INVSIJ(30,30)=   0.1768120713305834D+03
        INVSIJ(30,31)=  -0.8296296296299941D+01
        INVSIJ(30,32)=   0.9481481481480298D+01
        INVSIJ(31,31)=   0.1768120713305855D+03
        INVSIJ(31,32)=   0.6496570644718641D+02
        INVSIJ(32,32)=   0.1768120713305872D+03
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** set the lower triangle:                                     ***
C**     ----------------------                                      ***
C**                                                                 ***
      DO 200 I=1,GEOTYP
        DO 200 J=I,GEOTYP
          INVSIJ(J,I)=INVSIJ(I,J)
  200 CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMLSQ ---------------------------------------------------
      E    N    D
