C:::::      ,,,,,VEMPAT...                                          ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMPAT(NAME,LIVEM,IVEM,LNEK,NEK,LRPARM,RPARM,LIPARM,
     &                  IPARM,LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                  LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                  LBIG,RBIG,IBIG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMPAT         VECFEM ===> PATRAN neutral file             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"

      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,
     &                  LIDPRM,LNODN,LNOD,LNOPRM,LBIG
      DOUBLE PRECISION  NOD(LNOD),RPARM(LRPARM),RDPARM(LRDPRM),
     &                  NOPARM(LNOPRM),RBIG(LBIG)
      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  IDPARM(LIDPRM),DNOD(LDNOD),IBIG(RPI*LBIG)
      CHARACTER*80 NAME
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters  (see user's guide)                 ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                    >                                            ***
      INTEGER           MESH,UNIOUT,LOUT,NDEG,ERR,TOTNE,
     &                  NK,DIM,NN,OUTCNT,TIDS,NPROC,
     &                  MYPROC,NMSG,IOTID,MYTID,NBIG,NMIN,NMAX,
     &                  BUF,IBUF,RBUF,NDEGL,NDEG0L,I,COMP6,NCARD,
     &                  DIS,NGROUP,GINFO,GINFO1,DINFO,DINFO1,NCARD1,
     &                  OWN,NOP,LBFIN,LBFRN,LBFN,LBFRE,LBFIE,LBFE,LBFRF,
     &                  LBFIF,LBFF,LBFRD,LBFID,LBFD,LLNGTH(16),
     &                  NLNGTH(16),MPINFO,SBT,IH1(1),IH2(1)
      DOUBLE PRECISION  TIME,VEMSCD
      include "archi.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT=IVEM(120)
      TIDS=204
      IF ((ARCHI.LT.10).OR.(IVEM(200).EQ.1)) THEN
	IVEM(200)=1
	IVEM(201)=1
	IVEM(TIDS-1)=1
	IVEM(TIDS)=1
      ENDIF
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9300)
	IVEM(2)=99
	RETURN
      ENDIF
      ERR=0
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=0
      TIME=VEMSCD()
      OUTCNT = IVEM(121)
      COMP6 = IVEM(124)
      UNIOUT = IVEM(125)
      IF (LOUT.LE.0) LOUT=6
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      NBIG=0
      NCARD=0
      MESH=IVEM(1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print mesh infos :                                            ***
C**   -----------------                                             ***
C**                                                                 ***
      CALL VEM000('VEMPAT',OUTCNT,LOUT)
      CALL VEM600(LIVEM,IVEM,NLNGTH,0,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      CALL VEM098('VEMPAT',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      NDEG  =IVEM(MESH+1)
      NK    =IVEM(MESH+2)
      IF (NK.GT.6) COMP6=1
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      NOP   =0
      OWN   =IVEM(MESH+15)
      DIS   =IVEM(MESH+18)
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      DINFO =IVEM(MESH+23)+MESH
      DINFO1=IVEM(MESH+24)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute buffer sizes :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMAX=IH1(1)
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-IH1(1)
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,I,MYPROC,NPROC)

      CALL VEPA00(NDEGL,DIM,NOP,NGROUP,GINFO1,IVEM(GINFO),
     &            TOTNE,COMP6,
     &            NK,DINFO1,IVEM(DINFO),LBFIN,LBFRN,LBFN,
     &            LBFRE,LBFIE,LBFE,LBFRF,LBFIF,LBFF,
     &            LBFRD,LBFID,LBFD,
     &            IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),LOUT,ERR)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check the array length of IBIG:                               ***
C**                                                                 ***
      NBIG=(NGROUP+MAX(LBFE,LBFD*SBT,LBFN*SBT,LBFF)+RPI-1)/RPI
      NLNGTH(4)=NBIG
      CALL VEM098('VEMPAT',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write header of neutral file:                                 ***
C**   ----------------------------                                  ***
C**                                                                 ***
      NCARD1=NCARD
      IF (MYTID.EQ.IOTID) THEN
        REWIND(UNIOUT)
        CALL VEPA01 (UNIOUT,NAME,NCARD)
        IF (OUTCNT.GT.0) WRITE(LOUT,4040) NCARD-NCARD1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write node coordinates:                                       ***
C**   ----------------------                                        ***
C**                                                                 ***
      IBUF=1
      RBUF=(IBUF+LBFIN*SBT-1+RPI-1)/RPI+1

      NCARD1=NCARD
      CALL VEPA02(UNIOUT,NODNUM,NOD,DIM,NN,NDEG,TOTNE,SBT,
     &            LBFIN,IBIG(IBUF),LBFRN,RBIG(RBUF),NDEGL,NDEG0L,
     &            IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),NCARD)
      IF ((MYTID.EQ.IOTID).AND.(OUTCNT.GT.0)) THEN
	 WRITE(LOUT,4050) NCARD-NCARD1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write elements:                                               ***
C**   --------------                                                ***
C**                                                                 ***
      IBUF=1
      NCARD1=NCARD
      CALL VEPA03(UNIOUT,DIS,NODNUM,NDEG,NGROUP,GINFO1,IVEM(GINFO),
     &            LNEK,NEK,LIPARM,IPARM,LBFIE,IBIG(IBUF),
     &            IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),NCARD)
      IF ((MYTID.EQ.IOTID).AND.(OUTCNT.GT.0)) THEN
	 WRITE(LOUT,4060) NCARD-NCARD1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write node forces:                                            ***
C**   -----------------                                             ***
C**                                                                 ***
      IF (LBFRF.GT.0) THEN
        IBUF=1
        RBUF=(IBUF+LBFIF-1+RPI-1)/RPI+1
        BUF=IBUF
        NCARD1=NCARD
        CALL VEPA04(UNIOUT,DIS,NODNUM,NDEG,NGROUP,GINFO1,IVEM(GINFO),
     &              LNEK,NEK,LRPARM,RPARM,LBFIF,IBIG(IBUF),
     &              LBFRF,RBIG(RBUF),LBFF,IBIG(BUF),
     &              IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),NCARD)
        IF ((MYTID.EQ.IOTID).AND.(OUTCNT.GT.0)) THEN
	   WRITE(LOUT,4070) NCARD-NCARD1
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write dirichlet conditions :                                  ***
C**   --------------------------                                    ***
C**                                                                 ***
      IBUF=1
      RBUF=(IBUF+LBFID*SBT-1+RPI-1)/RPI+1
      NCARD1=NCARD
      IF (COMP6.EQ.0) THEN
         CALL VEPA05(UNIOUT,DIS,NODNUM,NDEG,NK,DINFO1,IVEM(DINFO),
     &               LDNOD,DNOD,LRDPRM,RDPARM,SBT,
     &               LBFID,IBIG(IBUF),LBFRD,RBIG(RBUF),NDEGL,NDEG0L,
     &               IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),NCARD)
      ELSE
         CALL VEPA06(UNIOUT,DIS,NODNUM,NDEG,NK,DINFO1,IVEM(DINFO),
     &               LDNOD,DNOD,LRDPRM,RDPARM,SBT,
     &               LBFID,IBIG(IBUF),LBFRD,RBIG(RBUF),NDEGL,NDEG0L,
     &               IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),NCARD)
      ENDIF
      IF ((MYTID.EQ.IOTID).AND.(OUTCNT.GT.0)) THEN
        WRITE(LOUT,4080) NCARD-NCARD1
      ENDIF
      IF (OUTCNT.GT.0) THEN
	IF (COMP6.EQ.0) THEN
          WRITE(LOUT,4081)
        ELSE
          WRITE(LOUT,4082)
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end cards of neutral file :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        WRITE(UNIOUT,'(I2,8I8)') 99,0,0,1,(0,I=1,5)
	NCARD=NCARD+1
      ENDIF
      IF ((MYTID.EQ.IOTID).AND.(OUTCNT.GT.0)) WRITE(LOUT,4083) NCARD
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it:                                                    ***
C**   ---------                                                     *** 
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMPAT',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9300  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
4040  FORMAT(3X,'write header ................... cards =',I8)
4041  FORMAT(3X,'write end card ................. cards =',I8)
4050  FORMAT(3X,'write node coordinates ......... cards =',I8)
4060  FORMAT(3X,'write elements ................. cards =',I8)
4070  FORMAT(3X,'write node forces .............. cards =',I8)
4080  FORMAT(3X,'write Dirichlet conditions ..... cards =',I8)
4083  FORMAT(3X,'total number of cards ................ =',I8)
4081  FORMAT(3X,'all components to one load set !')
4082  FORMAT(3X,'every component to individual load sets !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C*
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMPAT ---------------------------------------------------
      E    N    D
