C**:::      ,,,,,VEMPL0.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMPL0(CLASS,FORM,NELTYP,RWORK,IWORK,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEMPL0  compute the storage request to set the nodes of       ***
C**           Lagrangean proposal functions (VEMPLF)                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,NELTYP,FORM,IWORK,RWORK,ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of element
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of proposal functions
C--------I------I-----I------------------------------------------------
C RWORK  I  I   I out I needed real stoarge
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I out I needed integer stoarge
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10002   illegal NELTYP
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER       NELT,HELP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=10000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN
        ERR=10002
        IWORK=0
        RWORK=0
        IF (NELTYP.EQ.1) ERR=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        ERR=0
        IWORK=0
        RWORK=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN

        ERR=10001
C**                                                                 ***
C****** triangle :                                                  ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=10002
          IWORK=0
          RWORK=0
          NELT=(-1.D0+SQRT(8.D0*DBLE(NELTYP)+1.D0))/2+.5D0
          HELP=((NELT+1)*NELT)/2
          IF (NELTYP.NE.HELP) RETURN
          ERR=0
        ENDIF
C**                                                                 ***
C****** quadrilateral :                                             ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          IWORK=0
          RWORK=0
          NELT=SQRT(DBLE(NELTYP))+.5D0
          HELP=NELT**2
          IF (NELTYP.NE.HELP) RETURN
          ERR=0
        ENDIF
C**                                                                 ***
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN

        ERR=10001
C**                                                                 ***
C****** tetrahedron :                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          IWORK=0
          RWORK=0
          NELT=0
1234      NELT=NELT+1
          HELP=(NELT**3+3*NELT**2+2*NELT)/6
          IF (HELP.LT.NELTYP) GOTO 1234
          IF (HELP.NE.NELTYP) RETURN
          ERR=0
        ENDIF
C**                                                                 ***
C****** prism:                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=10002
          IWORK=0
          RWORK=0
          NELT=0
1235      NELT=NELT+1
          HELP=(NELT**3+NELT**2)/2
          IF (HELP.LT.NELTYP) GOTO 1235
          IF (HELP.NE.NELTYP) RETURN
          ERR=0
        ENDIF
C**                                                                 ***
C****** hexahedron :                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          ERR=10002
          IWORK=0
          RWORK=0
          NELT=DBLE(NELTYP)**(1.D0/3.D0)+.5D0
          HELP=NELT**3
          IF (HELP.NE.NELTYP) RETURN
          ERR=0
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMPL0 ---------------------------------------------------
      E    N    D
