C**:::      ,,,,,VEMPLP.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMPLP(CLASS,FORM,NELTYP,NODES,LRWORK,
     &                  RWORK,LIWORK,IWORK,ERR)

C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMPLP   computes the coordinates of local nodes             ***
C**             for the lagrangean proposal functions               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,NELTYP,FORM,LIWORK,LRWORK,
     &                  IWORK(LIWORK),ERR
      DOUBLE PRECISION  NODES(CLASS,NELTYP),RWORK(LRWORK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of element
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of proposal functions
C--------I------I-----I------------------------------------------------
C NODES  I  R   I out I coordinates of the nodes 
C        I      I     I                      array: NODES(CLASS,NELTYP)
C--------I------I-----I------------------------------------------------
C RWORK  I  R   I  -  I real work space            array: RWORK(LRWORK)
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I  -  I integer work space         array: IWORK(LIWORK)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10002   illegal NELTYP
C        I      I     I 10010   small storage
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER       NELT,MUELL,S,J,K,I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=10000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN
        ERR=0
        NODES(1,1)=0.
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        ERR=0
        IF (NELTYP.EQ.1) THEN
          NODES(1,1)=DBLE(1)/DBLE(2)
        ELSE
          DO 10 I=1,NELTYP
            NODES(1,I)=DBLE(I-1)/DBLE(NELTYP-1)
  10      CONTINUE
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle :                                                  ***
C**     --------                                                    ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=10002
          NELT=(-1.D0+SQRT(8.D0*DBLE(NELTYP)+1.D0))/2+.5D0
          MUELL=((NELT+1)*NELT)/2
          IF (NELTYP.NE.MUELL) RETURN
          ERR=0
          IF (NELT.EQ.1) THEN
            NODES(1,1)=DBLE(1)/DBLE(3)
            NODES(2,1)=DBLE(1)/DBLE(3)
          ELSE
            S=0
            DO 21 J=1,NELT
              DO 21 I=1,NELT-J+1
                S=S+1
                NODES(1,S)=DBLE(I-1)/DBLE(NELT-1)
                NODES(2,S)=DBLE(J-1)/DBLE(NELT-1)
  21        CONTINUE
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** quadrilateral :                                             ***
C**     ---------------                                             ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          NELT=SQRT(DBLE(NELTYP))+.5D0
          MUELL=NELT**2
          IF (NELTYP.NE.MUELL) RETURN
          ERR=0
          IF (NELT.EQ.1) THEN
            NODES(1,1)=DBLE(1)/DBLE(2)
            NODES(2,1)=DBLE(1)/DBLE(2)
          ELSE
            S=0
            DO 20 J=1,NELT
              DO 20 I=1,NELT
                S=S+1
                NODES(1,S)=DBLE(I-1)/DBLE(NELT-1)
                NODES(2,S)=DBLE(J-1)/DBLE(NELT-1)
  20        CONTINUE
          ENDIF
        ENDIF
C**                                                                 ***
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** tetrahedron :                                               ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          NELT=0
1234      NELT=NELT+1
          MUELL=(NELT**3+3*NELT**2+2*NELT)/6
          IF (MUELL.LT.NELTYP) GOTO 1234
          IF (MUELL.NE.NELTYP) RETURN
          ERR=0
          IF (NELT.EQ.1) THEN
            NODES(1,1)=DBLE(1)/DBLE(4)
            NODES(2,1)=DBLE(1)/DBLE(4)
            NODES(3,1)=DBLE(1)/DBLE(4)
          ELSE
            S=0
            DO 32 K=1,NELT
              DO 32 J=1,NELT-K+1
                DO 32 I=1,NELT-J-K+2
                  S=S+1
                  NODES(1,S)=DBLE(I-1)/DBLE(NELT-1)
                  NODES(2,S)=DBLE(J-1)/DBLE(NELT-1)
                  NODES(3,S)=DBLE(K-1)/DBLE(NELT-1)
   32       CONTINUE
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism:                                                      ***
C**     ------                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=10002
          NELT=0
1235      NELT=NELT+1
          MUELL=(NELT**3+NELT**2)/2
          IF (MUELL.LT.NELTYP) GOTO 1235
          IF (MUELL.NE.NELTYP) RETURN
          ERR=0
          IF (NELT.EQ.1) THEN
            NODES(1,1)=DBLE(1)/DBLE(3)
            NODES(2,1)=DBLE(1)/DBLE(3)
            NODES(3,1)=DBLE(1)/DBLE(2)
          ELSE
            S=0
            DO 31 K=1,NELT
              DO 31 J=1,NELT
                DO 31 I=1,NELT-J+1
                  S=S+1
                  NODES(1,S)=DBLE(I-1)/DBLE(NELT-1)
                  NODES(2,S)=DBLE(J-1)/DBLE(NELT-1)
                  NODES(3,S)=DBLE(K-1)/DBLE(NELT-1)
   31       CONTINUE
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          ERR=10002
          NELT=DBLE(NELTYP)**(1.D0/3.D0)+.5D0
          MUELL=NELT**3
          IF (MUELL.NE.NELTYP) RETURN
          ERR=0
          IF (NELT.EQ.1) THEN
            NODES(1,1)=DBLE(1)/DBLE(2)
            NODES(2,1)=DBLE(1)/DBLE(2)
            NODES(3,1)=DBLE(1)/DBLE(2)
          ELSE
            S=0
            DO 30 K=1,NELT
              DO 30 J=1,NELT
                DO 30 I=1,NELT
                  S=S+1
                  NODES(1,S)=DBLE(I-1)/DBLE(NELT-1)
                  NODES(2,S)=DBLE(J-1)/DBLE(NELT-1)
                  NODES(3,S)=DBLE(K-1)/DBLE(NELT-1)
  30        CONTINUE
          ENDIF
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VEMPLP ---------------------------------------------------
      E    N    D
