C**:::      ,,,,,VEMPR0.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMPR0(SETME,GROUP,CLASS,FORM,OWN,ORDER,NQ,
     &                  GEOTYP,NELTYP,PRFLIB,TOTNT,
     &                  LRWORK,LIWORK,MYPROC,MYTID,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMPR0  controls the parameters and storage for              ***
C**            the calculation of the proposal functions (vemprf)   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           SETME,GROUP,CLASS,FORM,OWN,ORDER,NQ,GEOTYP,
     &                  TOTNT,LRWORK,LIWORK,MYPROC,MYTID,LOUT,ERR

      INTEGER           NELTYP(OWN),PRFLIB(OWN)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C SETME  I  I   I in  I =0 only shape and proposal functions are set
C        I      I     I =1 additional shape and proposal functions
C        I      I     I    for error estimation are set
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I in  I current group number
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of the element
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I number of components
C        I      I     I =0 isoparametrical elements
C--------I------I-----I------------------------------------------------
C ORDER  I  I   I i/o I >0 order of the integration formula
C        I      I     I =0 geometrical nodes are selected instead
C        I      I     I    of integration nodes
C        I      I     I <0 nodes of Lagrangian proposal functions
C        I      I     I    with -order nodes are selected
C--------I------I-----I------------------------------------------------
C NQ     I  I   I out I number of nodes where the shape functions
C        I      I     I and proposal functionas are evaluated.
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes of the shape functions
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes of the proposal functions :
C        I      I     I                              array: NELTYP(OWN)
C--------I------I-----I------------------------------------------------
C PRFLIB I  I   I in  I proposal function library :
C        I      I     I                              array: PRFLIB(OWN)
C        I      I     I  =0 shape functions
C        I      I     I  =1 lagrange interpolation
C        I      I     I  =2 spline interpolation with shape functions
C        I      I     I  =3 spline interpolation
C--------I------I-----I------------------------------------------------
C LRWORK I  I   I out I length of needed real work space
C--------I------I-----I------------------------------------------------
C LIWORK I  I   I out I length of needed integer work space
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C MYTID  I  I   I in  I task id
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I line output unit
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10002   illegal NELTYP
C        I      I     I 10003   illegal GEOTYP
C        I      I     I 10004   illegal PRFLIB
C        I      I     I 10005   illegal integration order
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           LRW,LIW,I,LRW0,NP,NQL
      LOGICAL           PATCH
      EXTERNAL          VEMLP0,VEMPL0,VERLPZ
      EXTERNAL          VEMSH0,VEMPS0,VERSHZ
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      NP=2**CLASS
      PATCH=(SETME.EQ.1)
      DO 10 I=1,OWN
 10     PATCH=PATCH.OR.(PRFLIB(I).EQ.2).OR.(PRFLIB(I).EQ.3)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set integration formulas :                                    ***
C**   ------------------------                                      ***
C**                                                                 ***
      IF (ORDER.GT.0) THEN

        IF (.NOT.PATCH) THEN
          CALL VEMQD0(CLASS,FORM,ORDER,NQ,LRW,LIW,ERR)
          LRW0=0
        ELSE
          CALL VEMQD0(CLASS,FORM,ORDER,NQL,LRW,LIW,ERR)
          LRW0=NQL*(CLASS+1)+(CLASS+CLASS*CLASS)*NP
          NQ=NQL*NP
        ENDIF

      ELSEIF (.NOT.PATCH) THEN

        IF (ORDER.EQ.0) THEN
          NQ=GEOTYP
          LRW0=0
          CALL VEMPS0(CLASS,FORM,GEOTYP,LRW,LIW,ERR)
          IF (ERR.EQ.10002) ERR=10003
        ELSE
          NQ=ABS(ORDER)
          LRW0=0
          CALL VEMPL0(CLASS,FORM,ABS(ORDER),LRW,LIW,ERR)
          IF (ERR.EQ.10002) ERR=10003
        ENDIF

      ELSE
        ERR=10005
      ENDIF
      LIWORK=     LIW
      LRWORK=LRW0+LRW

      IF (ERR.NE.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set shape functions:                                          ***
C**   -------------------                                           ***
C**                                                                 ***
      CALL VEMSH0(CLASS,FORM,GEOTYP,LRW,LIW,ERR)
      LRWORK=MAX(LRWORK,LRW0+LRW)
      LIWORK=MAX(LIWORK,     LIW)
      IF (ERR.EQ.10002) ERR=10003
      IF (ERR.NE.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set proposal functions :                                      ***
C**   ----------------------                                        ***
C**                                                                 ***
      IF (OWN.GT.0) THEN
        DO 100 I=1,OWN

           IF (PRFLIB(I).EQ.0) THEN
            CALL VEMSH0(CLASS,FORM,NELTYP(I),LRW,LIW,ERR)
           ELSEIF (PRFLIB(I).EQ.1) THEN
            CALL VEMLP0(CLASS,FORM,NELTYP(I),LRW,LIW,ERR)
           ELSEIF (PRFLIB(I).EQ.2) THEN
            CALL VERPR0(CLASS,FORM,NELTYP(I),NQL,LRW,LIW,
     &                                        VEMSH0,VEMPS0,VERSHZ,ERR)
           ELSEIF (PRFLIB(I).EQ.3) THEN
            CALL VERPR0(CLASS,FORM,NELTYP(I),NQL,LRW,LIW,
     &                                        VEMLP0,VEMPL0,VERLPZ,ERR)
           ELSE
            ERR=10004
           ENDIF
           LRWORK=MAX(LRWORK,LRW0+LRW+NELTYP(I)*NQ*(CLASS+1))
           LIWORK=MAX(LIWORK,LIW)

100     CONTINUE
      ENDIF
      IF (ERR.NE.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** proposal functions for error estimation :                     ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      IF (SETME.EQ.1) THEN
        IF (OWN.EQ.0) THEN
          CALL VERPR0(CLASS,FORM,GEOTYP,NQL,LRW,LIW,
     &                           VEMSH0,VEMPS0,VERSHZ,ERR)
          LRWORK=MAX(LRWORK,LRW0+LRW)
          LIWORK=MAX(LIWORK,     LIW)
        ELSE
         DO 200 I=1,OWN

           IF (PRFLIB(I).EQ.2) THEN
             CALL VEMSH0(CLASS,FORM,NELTYP(I),LRW,LIW,ERR)
           ELSEIF (PRFLIB(I).EQ.3) THEN
            CALL VEMLP0(CLASS,FORM,NELTYP(I),LRW,LIW,ERR)
           ELSEIF (PRFLIB(I).EQ.1) THEN
            CALL VERPR0(CLASS,FORM,NELTYP(I),NQL,LRW,LIW,
     &                                        VEMLP0,VEMPL0,VERLPZ,ERR)
           ELSEIF (PRFLIB(I).EQ.0) THEN
            CALL VERPR0(CLASS,FORM,NELTYP(I),NQL,LRW,LIW,
     &                                        VEMSH0,VEMPS0,VERSHZ,ERR)
           ELSE
            ERR=10004
           ENDIF
           LRWORK=MAX(LRWORK,LRW+NELTYP(I)*NQ*(CLASS+1))
           LIWORK=MAX(LIWORK,LIW)

200      CONTINUE
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print error messages :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
9999  CONTINUE
      IF (ERR.GT.0) THEN
	IF (ERR.EQ.10000) 
     &                 WRITE(LOUT,9102) CLASS,MYPROC,MYTID,GROUP,CLASS
	IF (ERR.EQ.10001)
     &             WRITE(LOUT,9103) CLASS,FORM,MYPROC,MYTID,GROUP,FORM
	IF (ERR.EQ.10002) WRITE(LOUT,9104) MYPROC,MYTID,GROUP,NELTYP
	IF (ERR.EQ.10003) 
     &    WRITE(LOUT,9105) CLASS,FORM,GEOTYP,MYPROC,MYTID,GROUP,GEOTYP
	IF (ERR.EQ.10004) WRITE(LOUT,9106) MYPROC,MYTID,GROUP,PRFLIB
	IF (ERR.EQ.10005)
     &     WRITE(LOUT,9107) CLASS,FORM,MYPROC,MYTID,GROUP,CLASS,FORM
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9102  FORMAT('>>VEMCD:40:0001:',I3
     &      /'>>VEMPR0 error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal element class CLASS =',I10)
9103  FORMAT('>>VEMCD:40:0002:',I3,':',I3
     &      /'>>VEMPR0 error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal element form FORM =',I10)
9104  FORMAT('>>VEMCD:40:0003'
     &      /'>>VEMPR0 error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal NELTYP:'/(5X,15I5))
9105  FORMAT('>>VEMCD:40:0004:',I3,':',I3,':',I3
     &      /'>>VEMPR0 error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal GEOTYP =',I5)
9106  FORMAT('>>VEMCD:40:0005'
     &      /'>>VEMPR0 error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal element library:'/(5X,15I5))
9107  FORMAT('>>VEMCD:40:0006:',I3,':',I3
     &      /'>>VEMPRF error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : no integration formula for elment type '
     &      /'>>CLASS= ',I3,',  FORM= ',I3,'.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMPR0 ---------------------------------------------------
      E    N    D
