C**:::      ,,,,,VEMPRF.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMPRF(SETME,GROUP,CLASS,FORM,OWN,ORDER,NQ,NQMAX,WQ,Q,
     &                  GEOTYP,S,DSDV,NELTYP,PRFLIB,TOTNT,N,DNDV,
     &                  NER,DNERDV,LRWORK,RWORK,LIWORK,IWORK,
     &                  MYPROC,MYTID,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEMPRF  controls the calculation of the shape and           ***
C**             proposal functions                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           SETME,GROUP,CLASS,FORM,OWN,ORDER,NQ,NQMAX,
     &                  GEOTYP,TOTNT,LRWORK,LIWORK,ERR,MYPROC,MYTID,
     &                  LOUT

      INTEGER           NELTYP(OWN),PRFLIB(OWN),IWORK(LIWORK)
      DOUBLE PRECISION  WQ(NQMAX),Q(CLASS,NQMAX),S(GEOTYP,NQMAX),
     &                  DSDV(GEOTYP,CLASS,NQMAX),N(TOTNT,NQMAX),
     &                  DNDV(TOTNT,CLASS,NQMAX),NER(TOTNT,NQMAX),
     &                  DNERDV(TOTNT,CLASS,NQMAX),RWORK(LRWORK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C SETME  I  I   I in  I =0 only shape and proposal functions are set
C        I      I     I =1 additional shape and proposal functions
C        I      I     I    for error estimation are set
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I in  I current group number
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of the element
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I number of components
C        I      I     I =0 isoparametrical elements
C--------I------I-----I------------------------------------------------
C ORDER  I  I   I i/o I >0 order of the integration formula
C        I      I     I =0 geometrical nodes are selected instead
C        I      I     I    of integration nodes
C        I      I     I <0 nodes of Lagrangian proposal functions
C        I      I     I    with -order nodes are selected
C--------I------I-----I------------------------------------------------
C NQ     I  I   I out I number of nodes where the shape functions
C        I      I     I and proposal functionas were evaluated.
C--------I------I-----I------------------------------------------------
C W      I  I   I out I quadrature weights             array: WQ(NQMAX)
C--------I------I-----I------------------------------------------------
C Q      I  I   I out I quadrature nodes          array: Q(CLASS,NQMAX)
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes of the shape functions
C--------I------I-----I------------------------------------------------
C S      I  R   I out I shape functions at Q     array: S(GEOTYP,NQMAX)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I out I derivatives of shape functions at Q :
C        I      I     I                 array: DSDV(GEOTYP,CLASS,NQMAX)
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of nodes of the proposal functions :
C        I      I     I                              array: NELTYP(OWN)
C--------I------I-----I------------------------------------------------
C PRFLIB I  I   I in  I proposal function library :
C        I      I     I                              array: PRFLIB(OWN)
C        I      I     I  =0 shape functions
C        I      I     I  =1 lagrange interpolation
C        I      I     I  =2 spline interpolation with shape functions
C        I      I     I  =3 spline interpolation
C--------I------I-----I------------------------------------------------
C N      I  R   I out I proposal functions at Q (only set for OWN>0)
C        I      I     I                           array: N(TOTNT,NQMAX)
C--------I------I-----I------------------------------------------------
C DNDV   I  R   I out I derivatives of proposal functions at Q 
C        I      I     I (only set for OWN>0)
C        I      I     I                  array: DNDV(TOTNT,CLASS,NQMAX)
C--------I------I-----I------------------------------------------------
C NER    I  R   I out I proposal functions at Q for error estimation
C        I      I     I (only set for SETME=0)
C        I      I     I                         array: NER(TOTNT,NQMAX)
C--------I------I-----I------------------------------------------------
C DNERDV I  R   I out I derivatives of proposal functions at Q
C        I      I     I for error estimation (only set for SETME=0)
C        I      I     I                array: DNERDV(TOTNT,CLASS,NQMAX)
C--------I------I-----I------------------------------------------------
C RWORK  I  I   I  -  I real work space            array: RWORK(LRWORK)
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I  -  I integer work space          array: IWORK(LIWORK)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C MYTID  I  I   I in  I task id
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I line output unit
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10002   illegal NELTYP
C        I      I     I 10003   illegal GEOTYP
C        I      I     I 10004   illegal PRFLIB
C        I      I     I 10005   illegal integration order
C        I      I     I 10010   small storage
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           D,I,J,K,L,SN,DSNDV,RW,LRW,NQL,WQL,QL,
     &                  ROT,V0,NP,RW1
      LOGICAL           PATCH
      EXTERNAL          VEMLPF,VEMPLP,VERLPZ
      EXTERNAL          VEMSHF,VEMPSH,VERSHZ
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=0
      NP=2**CLASS
      PATCH=(SETME.EQ.1)
      DO 10 I=1,OWN
 10     PATCH=PATCH.OR.(PRFLIB(I).EQ.2).OR.(PRFLIB(I).EQ.3)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set quadrature formulas:                                      ***
C**   ------------------------                                      ***
C**                                                                 ***
      IF (ORDER.GT.0) THEN

        IF (.NOT.PATCH) THEN
          RW=1
          LRW=LRWORK-RW+1
          CALL VEMQDF(CLASS,FORM,ORDER,NQMAX,NQ,WQ,Q,
     &                LRW,RWORK(RW),LIWORK,IWORK,ERR)
        ELSE
          ROT=1
          V0 =ROT+CLASS*CLASS*NP
          WQL=V0 +CLASS*NP
          QL =WQL+NQMAX/NP
          RW =QL +(NQMAX/NP)*CLASS
          LRW=LRWORK-RW+1
          CALL VEMQDF(CLASS,FORM,ORDER,NQMAX/NP,NQL,RWORK(WQL),
     &                RWORK(QL),LRW,RWORK(LRW),LIWORK,IWORK,ERR)
          NQ=NQL*NP
          IF (NQ.GT.NQMAX) THEN
            ERR=10010
            GOTO 9999
          ENDIF
          CALL VERPR1(CLASS,FORM,NP,RWORK(ROT),RWORK(V0),
     &                NQL,RWORK(QL),Q,ERR)
          CALL VERPR3(CLASS,NP,RWORK(ROT),NQL,RWORK(WQL),WQ)


        ENDIF

      ELSEIF (.NOT.PATCH) THEN

        IF (ORDER.EQ.0) THEN

          NQ=GEOTYP
          RW=1
          LRW=LRWORK-RW+1
          IF (NQ.GT.NQMAX) THEN
           ERR=10010
          ELSE
           CALL VEMPSH(CLASS,FORM,GEOTYP,Q,LRW,RWORK(RW),
     &                 LIWORK,IWORK,ERR)
           IF (ERR.EQ.10002) ERR=10003
          ENDIF

        ELSE

          NQ=ABS(ORDER)
          IF (NQ.GT.NQMAX) THEN
            ERR=10010
          ELSE
            RW=1
            LRW=LRWORK-RW+1
            CALL VEMPLP(CLASS,FORM,NQ,Q,LRW,RWORK(RW),LIWORK,IWORK,ERR)
            IF (ERR.EQ.10002) ERR=10003
          ENDIF

        ENDIF
      ELSE
        ERR=10005
      ENDIF

      IF (ERR.NE.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set shape functions:                                          ***
C**   -------------------                                           ***
C**                                                                 ***
      CALL VEMSHF(CLASS,FORM,GEOTYP,NQ,Q,S,DSDV,
     &            LRW,RWORK(RW),LIWORK,IWORK,ERR)
      IF (ERR.EQ.10002) ERR=10003
      IF (ERR.NE.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set proposal functions for all components:                    ***
C**   -----------------------------------------                     ***
C**                                                                 ***
      IF (OWN.GT.0) THEN
        D=0
        DO 100 I=1,OWN

          IF (D+NELTYP(I).GT.TOTNT) THEN
            ERR=10010
            GOTO 9999
          ENDIF
          IF (NELTYP(I).GT.0) THEN
            SN=RW
            DSNDV=SN+NELTYP(I)*NQ
            RW1=DSNDV+NELTYP(I)*CLASS*NQ
            LRW=LRWORK-RW1+1

            IF (PRFLIB(I).EQ.0) THEN
             CALL VEMSHF(CLASS,FORM,NELTYP(I),NQ,Q,RWORK(SN),
     &                   RWORK(DSNDV),LRW,RWORK(RW1),LIWORK,IWORK,ERR)
            ELSEIF (PRFLIB(I).EQ.1) THEN
             CALL VEMLPF(CLASS,FORM,NELTYP(I),NQ,Q,RWORK(SN),
     &                   RWORK(DSNDV),LRW,RWORK(RW1),LIWORK,IWORK,ERR)
            ELSEIF (PRFLIB(I).EQ.2) THEN
             CALL VERPRF(CLASS,FORM,NELTYP(I),NQL,RWORK(QL),
     &                   RWORK(SN),RWORK(DSNDV),
     &                   LRW,RWORK(RW1),LIWORK,IWORK,
     &                   VEMSHF,VEMPSH,VERSHZ,ERR)
            ELSEIF (PRFLIB(I).EQ.3) THEN
             CALL VERPRF(CLASS,FORM,NELTYP(I),NQL,RWORK(QL),
     &                   RWORK(SN),RWORK(DSNDV),
     &                   LRW,RWORK(RW1),LIWORK,IWORK,
     &                   VEMLPF,VEMPLP,VERLPZ,ERR)
            ELSE
              ERR=10004
            ENDIF

            IF (ERR.EQ.0) THEN
              DO 30 J=1,NELTYP(I)
                DO 40 K=1,NQ
                   N(D+J,K)=RWORK(SN-1+J+NELTYP(I)*(K-1))
   40           CONTINUE
                DO 20 L=1,CLASS
                  DO 20 K=1,NQ
                    DNDV(D+J,L,K)=
     &                  RWORK(DSNDV-1+J+NELTYP(I)*((L-1)+CLASS*(K-1)))
   20           CONTINUE
  30          CONTINUE
            ENDIF
            D=D+NELTYP(I)
          ENDIF

100     CONTINUE
      ENDIF
      IF (ERR.NE.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set proposal functions for error estimation :                 ***
C**   --------------------------------------------                  ***
C**                                                                 ***
      IF (SETME.EQ.1) THEN
        IF (OWN.EQ.0) THEN
          CALL VERPRF(CLASS,FORM,GEOTYP,NQL,RWORK(QL),
     &                NER,DNERDV,LRW,RWORK(RW),LIWORK,IWORK,
     &                VEMSHF,VEMPSH,VERSHZ,ERR)
           IF (ERR.EQ.10002) ERR=10003
        ELSE
         D=0
         DO 200 I=1,OWN

          IF (D+NELTYP(I).GT.TOTNT) THEN
            ERR=10010
            GOTO 9999
          ENDIF
          IF (NELTYP(I).GT.0) THEN
            SN=RW
            DSNDV=SN+NELTYP(I)*NQ
            RW1=DSNDV+NELTYP(I)*CLASS*NQ
            LRW=LRWORK-RW1+1

            IF (PRFLIB(I).EQ.3) THEN
             CALL VEMLPF(CLASS,FORM,NELTYP(I),NQ,Q,RWORK(SN),
     &                   RWORK(DSNDV),LRW,RWORK(RW1),LIWORK,IWORK,ERR)
            ELSEIF (PRFLIB(I).EQ.2) THEN
             CALL VEMSHF(CLASS,FORM,NELTYP(I),NQ,Q,RWORK(SN),
     &                   RWORK(DSNDV),LRW,RWORK(RW1),LIWORK,IWORK,ERR)
            ELSEIF (PRFLIB(I).EQ.1) THEN
             CALL VERPRF(CLASS,FORM,NELTYP(I),NQL,RWORK(QL),
     &                   RWORK(SN),RWORK(DSNDV),
     &                   LRW,RWORK(RW1),LIWORK,IWORK,
     &                   VEMLPF,VEMPLP,VERLPZ,ERR)
            ELSEIF (PRFLIB(I).EQ.0) THEN
             CALL VERPRF(CLASS,FORM,NELTYP(I),NQL,RWORK(QL),
     &                   RWORK(SN),RWORK(DSNDV),
     &                   LRW,RWORK(RW1),LIWORK,IWORK,
     &                   VEMSHF,VEMPSH,VERSHZ,ERR)
            ELSE
              ERR=10004
            ENDIF

            IF (ERR.EQ.0) THEN
              DO 230 J=1,NELTYP(I)
                DO 240 K=1,NQ
                   NER(D+J,K)=RWORK(SN-1+J+NELTYP(I)*(K-1))
  240           CONTINUE
                DO 220 L=1,CLASS
                 DO 220 K=1,NQ
                   DNERDV(D+J,L,K)=
     &                   RWORK(DSNDV-1+J+NELTYP(I)*((L-1)+CLASS*(K-1)))
  220           CONTINUE
 230          CONTINUE
            ENDIF

            D=D+NELTYP(I)
          ENDIF

200      CONTINUE
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print error messages :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
9999  CONTINUE
      IF (ERR.GT.0) THEN
	IF (ERR.EQ.10000) 
     &                 WRITE(LOUT,9102) CLASS,MYPROC,MYTID,GROUP,CLASS
	IF (ERR.EQ.10001)
     &             WRITE(LOUT,9103) CLASS,FORM,MYPROC,MYTID,GROUP,FORM
	IF (ERR.EQ.10002) WRITE(LOUT,9104) MYPROC,MYTID,GROUP,NELTYP
	IF (ERR.EQ.10003) 
     &    WRITE(LOUT,9105) CLASS,FORM,GEOTYP,MYPROC,MYTID,GROUP,GEOTYP
	IF (ERR.EQ.10004) WRITE(LOUT,9106) MYPROC,MYTID,GROUP,PRFLIB
	IF (ERR.EQ.10005)
     &     WRITE(LOUT,9107) CLASS,FORM,MYPROC,MYTID,GROUP,CLASS,FORM
	IF (ERR.EQ.10010) WRITE (LOUT,9108) MYPROC,MYTID,GROUP
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9102  FORMAT('>>VEMCD:40:0001:',I3
     &      /'>>VEMPRF error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal element class CLASS =',I10)
9103  FORMAT('>>VEMCD:40:0002:',I3,':',I3
     &      /'>>VEMPRF error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal element form FORM =',I10)
9104  FORMAT('>>VEMCD:40:0003'
     &      /'>>VEMPRF error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal NELTYP:'/(5X,15I5))
9105  FORMAT('>>VEMCD:40:0004:',I3,':',I3,':',I3
     &      /'>>VEMPRF error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal GEOTYP =',I5)
9106  FORMAT('>>VEMCD:40:0005'
     &      /'>>VEMPRF error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal element library:'/(5X,15I5))
9107  FORMAT('>>VEMCD:40:0006:',I3,':',I3
     &      /'>>VEMPRF error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : no integration formula for elment type '
     &      /'>>CLASS= ',I3,',  FORM= ',I3,'.')
9108  FORMAT('>>VEMCD:40:0007'
     &      /'>>VEMPRF error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : too small work space !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMPRF ---------------------------------------------------
      E    N    D
