C**:::      ,,,,,VEMPS0.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMPS0(CLASS,FORM,GEOTYP,RWORK,IWORK,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEMPS0   compute storage to set node coordinates of shape     ***
C**            functions.                                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,GEOTYP,FORM,IWORK,RWORK,ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of element
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of shape functions
C--------I------I-----I------------------------------------------------
C RWORK  I  I   I out I needed real stoarge
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I out I needed integer stoarge
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10002   illegal GEOTYP
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**                                                                 ***
      ERR=10000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN
        ERR=10002
        IWORK=0
        RWORK=0
        IF (GEOTYP.EQ.1) ERR=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        ERR=10002
        IWORK=0
        RWORK=0
        IF (GEOTYP.EQ.1) ERR=0
        IF (GEOTYP.EQ.2) ERR=0
        IF (GEOTYP.EQ.3) ERR=0
        IF (GEOTYP.EQ.4) ERR=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle :                                                  ***
C**     --------                                                    ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=10002
          IWORK=0
          RWORK=0
          IF( GEOTYP .EQ. 1 ) ERR=0
          IF( GEOTYP .EQ. 3 ) ERR=0
          IF( GEOTYP .EQ. 6 ) ERR=0
          IF( GEOTYP .EQ. 9 ) ERR=0
          IF( GEOTYP .EQ. 10) ERR=0
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** quadrilateral :                                             ***
C**     ---------------                                             ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          IWORK=0
          RWORK=0
          IF( GEOTYP .EQ. 1 ) ERR=0
          IF( GEOTYP .EQ. 4 ) ERR=0
          IF( GEOTYP .EQ. 8 ) ERR=0
          IF( GEOTYP .EQ. 9 ) ERR=0
          IF( GEOTYP .EQ. 12 ) ERR=0
          IF( GEOTYP .EQ. 16 ) ERR=0
        ENDIF

C**                                                                 ***

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** TETRAHEDRON :                                               ***
C**     -------------                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          IWORK=0
          RWORK=0
          IF( GEOTYP .EQ. 1 ) ERR=0
          IF( GEOTYP .EQ. 4 ) ERR=0
          IF( GEOTYP .EQ. 10) ERR=0
          IF( GEOTYP .EQ. 16) ERR=0
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism:                                                      ***
C**     ------                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=10002
          IWORK=0
          RWORK=0
          IF( GEOTYP .EQ. 1 ) ERR=0
          IF( GEOTYP .EQ. 6 ) ERR=0
          IF( GEOTYP .EQ. 15 ) ERR=0
          IF( GEOTYP .EQ. 24 ) ERR=0
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          ERR=10002
          IWORK=0
          RWORK=0
          IF( GEOTYP .EQ. 1 ) ERR=0
          IF( GEOTYP .EQ. 8 ) ERR=0
          IF( GEOTYP .EQ. 20 ) ERR=0
          IF( GEOTYP .EQ. 32 ) ERR=0
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMPS0 ---------------------------------------------------
      E    N    D
