C**:::      ,,,,,VEMPSH.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMPSH(CLASS,FORM,GEOTYP,NODES,LRWORK,
     &                  RWORK,LIWORK,IWORK,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMPSH  sets the coordinates of local nodes of the shape     ***
C**            functions.                                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,GEOTYP,FORM,LIWORK,LRWORK,
     &                  IWORK(LIWORK),ERR
      DOUBLE PRECISION  NODES(CLASS,GEOTYP),RWORK(LRWORK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of element
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of shape functions
C--------I------I-----I------------------------------------------------
C NODES  I  R   I out I coordinates of the local nodes 
C        I      I     I                      array: NODES(CLASS,GEOTYP)
C--------I------I-----I------------------------------------------------
C RWORK  I  R   I  -  I real work sapce            array: RWORK(LRWORK)
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I  -  I integer work sapce         array: IWORK(LIWORK)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10002   illegal GEOTYP
C        I      I     I 10010   small storage
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**                                                                 ***
      ERR=10000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN
        ERR=10002
        IF( GEOTYP .EQ. 1 ) ERR=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        ERR=10002
        IF( GEOTYP .EQ. 1 ) THEN
           ERR=0
           NODES(1,1)=0.5
           RETURN
        ENDIF
        IF (GEOTYP.EQ.2) ERR=0

        NODES(1,1)=0.D0
        NODES(1,2)=1.D0


        IF (GEOTYP.EQ.3) THEN
          ERR=0
          NODES(1,3)=0.5D0
        ENDIF

        IF (GEOTYP.EQ.4) THEN
          ERR=0
          NODES(1,3)=1.D0/3.D0
          NODES(1,4)=2.D0/3.D0
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN
        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle :                                                  ***
C**     --------                                                    ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=10002
          IF( GEOTYP .EQ. 1 ) THEN
             ERR=0
             NODES(1,1)=1.D0/3.D0
             NODES(2,1)=1.D0/3.D0
             RETURN
          ENDIF
          IF (GEOTYP.EQ.3) ERR=0

          NODES(1,1)=0.D0
          NODES(2,1)=0.D0

          NODES(1,2)=1.D0
          NODES(2,2)=0.D0

          NODES(1,3)=0.D0
          NODES(2,3)=1.D0

          IF (GEOTYP.EQ.6) THEN
            ERR=0
            NODES(1,4)=0.5D0
            NODES(2,4)=0.D0

            NODES(1,5)=0.5D0
            NODES(2,5)=0.5D0

            NODES(1,6)=0.D0
            NODES(2,6)=0.5D0

          ENDIF
          IF (GEOTYP.EQ.6) THEN
            ERR=0
            NODES(1,4)=0.5D0
            NODES(2,4)=0.D0

            NODES(1,5)=0.5D0
            NODES(2,5)=0.5D0

            NODES(1,6)=0.D0
            NODES(2,6)=0.5D0

          ENDIF

          IF ((GEOTYP.EQ.9).OR.(GEOTYP.EQ.10)) THEN
            ERR=0
            NODES(1,4)=1.D0/3.D0
            NODES(2,4)=0.D0

            NODES(1,5)=2.D0/3.D0
            NODES(2,5)=0.D0

            NODES(1,6)=2.D0/3.D0
            NODES(2,6)=1.D0/3.D0

            NODES(1,7)=1.D0/3.D0
            NODES(2,7)=2.D0/3.D0

            NODES(1,8)=0.D0
            NODES(2,8)=2.D0/3.D0

            NODES(1,9)=0.D0
            NODES(2,9)=1.D0/3.D0

              IF (GEOTYP.EQ.10) THEN
                ERR=0
                NODES(1,10)=1.D0/3.D0
                NODES(2,10)=1.D0/3.D0

              ENDIF

          ENDIF

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** quadrilateral :                                             ***
C**     --------------                                              ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          IF( GEOTYP .EQ. 1 ) THEN
             ERR=0
             NODES(1,1)=0.5D0
             NODES(2,1)=0.5D0
             RETURN
          ENDIF
          IF (GEOTYP.EQ.4) ERR=0

          NODES(1,1)=0.D0
          NODES(2,1)=0.D0

          NODES(1,2)=1.D0
          NODES(2,2)=0.D0

          NODES(1,3)=1.D0
          NODES(2,3)=1.D0

          NODES(1,4)=0.D0
          NODES(2,4)=1.D0

          IF ((GEOTYP.EQ.8).OR.(GEOTYP.EQ.9)) THEN
            ERR=0
            NODES(1,5)=0.5D0
            NODES(2,5)=0.D0

            NODES(1,6)=1.D0
            NODES(2,6)=0.5D0

            NODES(1,7)=0.5D0
            NODES(2,7)=1.D0

            NODES(1,8)=0.D0
            NODES(2,8)=0.5D0

              IF (GEOTYP.EQ.9) THEN
                NODES(1,9)=0.5D0
                NODES(2,9)=0.5D0
              ENDIF

          ENDIF

          IF ((GEOTYP.EQ.12).OR.(GEOTYP.EQ.16)) THEN
            ERR=0
            NODES(1,5)=1.D0/3.D0
            NODES(2,5)=0.D0

            NODES(1,6)=2.D0/3.D0
            NODES(2,6)=0.D0

            NODES(1,7)=1.D0
            NODES(2,7)=1.D0/3.D0

            NODES(1,8)=1.D0
            NODES(2,8)=2.D0/3.D0

            NODES(1,9)=2.D0/3.D0
            NODES(2,9)=1.D0

            NODES(1,10)=1.D0/3.D0
            NODES(2,10)=1.D0

            NODES(1,11)=0.D0
            NODES(2,11)=2.D0/3.D0

            NODES(1,12)=0.D0
            NODES(2,12)=1.D0/3.D0

            IF (GEOTYP.EQ.16) THEN
              ERR=0
              NODES(1,13)=1.D0/3.D0
              NODES(2,13)=1.D0/3.D0

              NODES(1,14)=2.D0/3.D0
              NODES(2,14)=1.D0/3.D0

              NODES(1,15)=2.D0/3.D0
              NODES(2,15)=2.D0/3.D0

              NODES(1,16)=1.D0/3.D0
              NODES(2,16)=2.D0/3.D0

            ENDIF

          ENDIF

        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN
        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** tetrahedron :                                               ***
C**     -------------                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          IF( GEOTYP .EQ. 1 ) THEN
             ERR=0
             NODES(1,1)=1.D0/3.D0
             NODES(2,1)=1.D0/3.D0
             NODES(3,1)=1.D0/3.D0
             RETURN
          ENDIF
          IF (GEOTYP.EQ.4) ERR=0

          NODES(1,1)=0.D0
          NODES(2,1)=0.D0
          NODES(3,1)=0.D0

          NODES(1,2)=1.D0
          NODES(2,2)=0.D0
          NODES(3,2)=0.D0

          NODES(1,3)=0.D0
          NODES(2,3)=1.D0
          NODES(3,3)=0.D0

          NODES(1,4)=0.D0
          NODES(2,4)=0.D0
          NODES(3,4)=1.D0

          IF (GEOTYP.EQ.10) THEN

            ERR=0
            NODES(1,5)=0.5D0
            NODES(2,5)=0.D0
            NODES(3,5)=0.D0

            NODES(1,6)=0.5D0
            NODES(2,6)=0.5D0
            NODES(3,6)=0.D0

            NODES(1,7)=0.D0
            NODES(2,7)=0.5D0
            NODES(3,7)=0.D0

            NODES(1,8)=0.D0
            NODES(2,8)=0.D0
            NODES(3,8)=0.5D0

            NODES(1,9)=0.5D0
            NODES(2,9)=0.D0
            NODES(3,9)=0.5D0

            NODES(1,10)=0.D0
            NODES(2,10)=0.5D0
            NODES(3,10)=0.5D0
  
          ENDIF

          IF (GEOTYP.EQ.16) THEN

            ERR=0
            NODES(1,5)=1.D0/3.D0
            NODES(2,5)=0.D0
            NODES(3,5)=0.D0
  
            NODES(1,6)=2.D0/3.D0
            NODES(2,6)=0.D0
            NODES(3,6)=0.D0
  
            NODES(1,7)=2.D0/3.D0
            NODES(2,7)=1.D0/3.D0
            NODES(3,7)=0.D0
  
            NODES(1,8)=1.D0/3.D0
            NODES(2,8)=2.D0/3.D0
            NODES(3,8)=0.D0
  
            NODES(1,9)=0.D0
            NODES(2,9)=2.D0/3.D0
            NODES(3,9)=0.D0
  
            NODES(1,10)=0.D0
            NODES(2,10)=1.D0/3.D0
            NODES(3,10)=0.D0

            NODES(1,11)=0.D0
            NODES(2,11)=0.D0
            NODES(3,11)=1.D0/3.D0

            NODES(1,12)=2.D0/3.D0
            NODES(2,12)=0.D0
            NODES(3,12)=1.D0/3.D0

            NODES(1,13)=0.D0
            NODES(2,13)=2.D0/3.D0
            NODES(3,13)=1.D0/3.D0

            NODES(1,14)=0.D0
            NODES(2,14)=0.D0
            NODES(3,14)=2.D0/3.D0

            NODES(1,15)=1.D0/3.D0
            NODES(2,15)=0.D0
            NODES(3,15)=2.D0/3.D0

            NODES(1,16)=0.D0
            NODES(2,16)=1.D0/3.D0
            NODES(3,16)=2.D0/3.D0

          ENDIF

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism:                                                      ***
C**     ------                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=10002
          IF( GEOTYP .EQ. 1 ) THEN
             ERR=0
             NODES(1,1)=1.D0/3.D0
             NODES(2,1)=1.D0/3.D0
             NODES(3,1)=0.5D0
             RETURN
          ENDIF
          IF (GEOTYP.EQ.6) ERR=0

          NODES(1,1)=0.D0
          NODES(2,1)=0.D0
          NODES(3,1)=0.D0

          NODES(1,2)=1.D0
          NODES(2,2)=0.D0
          NODES(3,2)=0.D0

          NODES(1,3)=0.D0
          NODES(2,3)=1.D0
          NODES(3,3)=0.D0

          NODES(1,4)=0.D0
          NODES(2,4)=0.D0
          NODES(3,4)=1.D0

          NODES(1,5)=1.D0
          NODES(2,5)=0.D0
          NODES(3,5)=1.D0

          NODES(1,6)=0.D0
          NODES(2,6)=1.D0
          NODES(3,6)=1.D0

          IF (GEOTYP.EQ.15) THEN

           ERR=0
           NODES(1,7)=0.5D0
           NODES(2,7)=0.D0
           NODES(3,7)=0.D0

           NODES(1,8)=0.5D0
           NODES(2,8)=0.5D0
           NODES(3,8)=0.D0

           NODES(1,9)=0.D0
           NODES(2,9)=0.5D0
           NODES(3,9)=0.D0

           NODES(1,10)=0.D0
           NODES(2,10)=0.D0
           NODES(3,10)=0.5D0

           NODES(1,11)=1.D0
           NODES(2,11)=0.D0
           NODES(3,11)=0.5D0

           NODES(1,12)=0.D0
           NODES(2,12)=1.D0
           NODES(3,12)=0.5D0

           NODES(1,13)=0.5D0
           NODES(2,13)=0.D0
           NODES(3,13)=1.D0

           NODES(1,14)=0.5D0
           NODES(2,14)=0.5D0
           NODES(3,14)=1.D0

           NODES(1,15)=0.D0
           NODES(2,15)=0.5D0
           NODES(3,15)=1.D0
         ENDIF

         IF (GEOTYP.EQ.24) THEN

           ERR=0
           NODES(1,7)=1.D0/3.D0
           NODES(2,7)=0.D0
           NODES(3,7)=0.D0

           NODES(1,8)=2.D0/3.D0
           NODES(2,8)=0.D0
           NODES(3,8)=0.D0

           NODES(1,9)=2.D0/3.D0
           NODES(2,9)=1.D0/3.D0
           NODES(3,9)=0.D0

           NODES(1,10)=1.D0/3.D0
           NODES(2,10)=2.D0/3.D0
           NODES(3,10)=0.D0

           NODES(1,11)=0.D0
           NODES(2,11)=2.D0/3.D0
           NODES(3,11)=0.D0

           NODES(1,12)=0.D0
           NODES(2,12)=1.D0/3.D0
           NODES(3,12)=0.D0

           NODES(1,13)=0.D0
           NODES(2,13)=0.D0
           NODES(3,13)=1.D0/3.D0

           NODES(1,14)=1.D0
           NODES(2,14)=0.D0
           NODES(3,14)=1.D0/3.D0

           NODES(1,15)=0.D0
           NODES(2,15)=1.D0
           NODES(3,15)=1.D0/3.D0

           NODES(1,16)=0.D0
           NODES(2,16)=0.D0
           NODES(3,16)=2.D0/3.D0

           NODES(1,17)=1.D0
           NODES(2,17)=0.D0
           NODES(3,17)=2.D0/3.D0

           NODES(1,18)=0.D0
           NODES(2,18)=1.D0
           NODES(3,18)=2.D0/3.D0

           NODES(1,19)=1.D0/3.D0
           NODES(2,19)=0.D0
           NODES(3,19)=1.D0

           NODES(1,20)=2.D0/3.D0
           NODES(2,20)=0.D0
           NODES(3,20)=1.D0

           NODES(1,21)=2.D0/3.D0
           NODES(2,21)=1.D0/3.D0
           NODES(3,21)=1.D0

           NODES(1,22)=1.D0/3.D0
           NODES(2,22)=2.D0/3.D0
           NODES(3,22)=1.D0

           NODES(1,23)=0.D0
           NODES(2,23)=2.D0/3.D0
           NODES(3,23)=1.D0

           NODES(1,24)=0.D0
           NODES(2,24)=1.D0/3.D0
           NODES(3,24)=1.D0

          ENDIF

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          ERR=10002
          IF( GEOTYP .EQ. 1 ) THEN
             ERR=0
             NODES(1,1)=0.5D0
             NODES(2,1)=0.5D0
             NODES(3,1)=0.5D0
             RETURN
          ENDIF
          IF (GEOTYP.EQ.8) ERR=0

          NODES(1,1)=0.D0
          NODES(2,1)=0.D0
          NODES(3,1)=0.D0

          NODES(1,2)=1.D0
          NODES(2,2)=0.D0
          NODES(3,2)=0.D0

          NODES(1,3)=1.D0
          NODES(2,3)=1.D0
          NODES(3,3)=0.D0

          NODES(1,4)=0.D0
          NODES(2,4)=1.D0
          NODES(3,4)=0.D0

          NODES(1,5)=0.D0
          NODES(2,5)=0.D0
          NODES(3,5)=1.D0

          NODES(1,6)=1.D0
          NODES(2,6)=0.D0
          NODES(3,6)=1.D0

          NODES(1,7)=1.D0
          NODES(2,7)=1.D0
          NODES(3,7)=1.D0

          NODES(1,8)=0.D0
          NODES(2,8)=1.D0
          NODES(3,8)=1.D0


        IF (GEOTYP.EQ.20) THEN
          ERR=0
          NODES(1,9)=0.5D0
          NODES(2,9)=0.D0
          NODES(3,9)=0.D0

          NODES(1,10)=1.D0
          NODES(2,10)=0.5D0
          NODES(3,10)=0.D0

          NODES(1,11)=0.5D0
          NODES(2,11)=1.D0
          NODES(3,11)=0.D0

          NODES(1,12)=0.D0
          NODES(2,12)=0.5D0
          NODES(3,12)=0.D0

          NODES(1,13)=0.D0
          NODES(2,13)=0.D0
          NODES(3,13)=0.5D0

          NODES(1,14)=1.D0
          NODES(2,14)=0.D0
          NODES(3,14)=0.5D0

          NODES(1,15)=1.D0
          NODES(2,15)=1.D0
          NODES(3,15)=0.5D0

          NODES(1,16)=0.D0
          NODES(2,16)=1.D0
          NODES(3,16)=0.5D0

          NODES(1,17)=0.5D0
          NODES(2,17)=0.D0
          NODES(3,17)=1.D0

          NODES(1,18)=1.D0
          NODES(2,18)=0.5D0
          NODES(3,18)=1.D0

          NODES(1,19)=0.5D0
          NODES(2,19)=1.D0
          NODES(3,19)=1.D0

          NODES(1,20)=0.D0
          NODES(2,20)=0.5D0
          NODES(3,20)=1.D0

        ENDIF

        IF (GEOTYP.EQ.32) THEN

          ERR=0
          NODES(1,9)=1.D0/3.D0
          NODES(2,9)=0.D0
          NODES(3,9)=0.D0

          NODES(1,10)=2.D0/3.D0
          NODES(2,10)=0.D0
          NODES(3,10)=0.D0

          NODES(1,11)=1.D0
          NODES(2,11)=1.D0/3.D0
          NODES(3,11)=0.D0

          NODES(1,12)=1.D0
          NODES(2,12)=2.D0/3.D0
          NODES(3,12)=0.D0

          NODES(1,13)=2.D0/3.D0
          NODES(2,13)=1.D0
          NODES(3,13)=0.D0

          NODES(1,14)=1.D0/3.D0
          NODES(2,14)=1.D0
          NODES(3,14)=0.D0

          NODES(1,15)=0.D0
          NODES(2,15)=2.D0/3.D0
          NODES(3,15)=0.D0

          NODES(1,16)=0.D0
          NODES(2,16)=1.D0/3.D0
          NODES(3,16)=0.D0

          NODES(1,17)=0.D0
          NODES(2,17)=0.D0
          NODES(3,17)=1.D0/3.D0

          NODES(1,18)=1.D0
          NODES(2,18)=0.D0
          NODES(3,18)=1.D0/3.D0

          NODES(1,19)=1.D0
          NODES(2,19)=1.D0
          NODES(3,19)=1.D0/3.D0

          NODES(1,20)=0.D0
          NODES(2,20)=1.D0
          NODES(3,20)=1.D0/3.D0

          NODES(1,21)=0.D0
          NODES(2,21)=0.D0
          NODES(3,21)=2.D0/3.D0

          NODES(1,22)=1.D0
          NODES(2,22)=0.D0
          NODES(3,22)=2.D0/3.D0

          NODES(1,23)=1.D0
          NODES(2,23)=1.D0
          NODES(3,23)=2.D0/3.D0

          NODES(1,24)=0.D0
          NODES(2,24)=1.D0
          NODES(3,24)=2.D0/3.D0

          NODES(1,25)=1.D0/3.D0
          NODES(2,25)=0.D0
          NODES(3,25)=1.D0

          NODES(1,26)=2.D0/3.D0
          NODES(2,26)=0.D0
          NODES(3,26)=1.D0

          NODES(1,27)=1.D0
          NODES(2,27)=1.D0/3.D0
          NODES(3,27)=1.D0

          NODES(1,28)=1.D0
          NODES(2,28)=2.D0/3.D0
          NODES(3,28)=1.D0

          NODES(1,29)=2.D0/3.D0
          NODES(2,29)=1.D0
          NODES(3,29)=1.D0

          NODES(1,30)=1.D0/3.D0
          NODES(2,30)=1.D0
          NODES(3,30)=1.D0

          NODES(1,31)=0.D0
          NODES(2,31)=2.D0/3.D0
          NODES(3,31)=1.D0

          NODES(1,32)=0.D0
          NODES(2,32)=1.D0/3.D0
          NODES(3,32)=1.D0

          ENDIF
         ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VEMPSH ---------------------------------------------------
      E    N    D
