C**:::      ,,,,,VEMQ92 .....                                       ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMQ92(NQ,WQ1,Q1,WQ2,Q2)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMQ92     the 2-dimensional product of a 1-dimensional      ***
C**               quadrature scheme                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NQ
      DOUBLE PRECISION  WQ2(NQ,NQ),WQ1(NQ),Q2(2,NQ,NQ),Q1(NQ)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C  name  I type I i/o I     meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NQ     I  I   I in  I number of nodes in the 1-dim. quadratur scheme
C--------I------I-----I------------------------------------------------
C WQ1    I  R   I in  I weights in the 1-dim. quadratur scheme 
C        I      I     I array: WQ1(NQ)
C--------I------I-----I------------------------------------------------
C Q1     I  R   I in  I nodes in the 1-dim. quadratur scheme 
C        I      I     I array: Q1(NQ)
C--------I------I-----I------------------------------------------------
C WQ2    I  R   I out I weights in the 2-dim. quadratur scheme 
C        I      I     I array: WQ2(NQ,NQ)
C--------I------I-----I------------------------------------------------
C Q2     I  R   I out I nodes in the 2-dim. quadratur scheme
C        I      I     I array: Q2(2,NQ,NQ)
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           I,J
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
        DO 100 I=1,NQ
          DO 100 J=1,NQ
             Q2(1,I,J)=Q1(I)
             Q2(2,I,J)=Q1(J)
             WQ2(I,J)=WQ1(I)*WQ1(J)
  100   CONTINUE

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMQ92 ---------------------------------------------------
      E    N    D
