C**:::      ,,,,,VEMQ93 .....                                       ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMQ93(NQ,WQ1,Q1,WQ3,Q3)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMQ93     the 3-dimensional product of a 1-dimensional      ***
C**               quadrature scheme                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NQ
      DOUBLE PRECISION  WQ3(NQ,NQ,NQ),WQ1(NQ),Q3(3,NQ,NQ,NQ),Q1(NQ)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C  name  I type I i/o I     meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NQ     I  I   I in  I number of nodes in the 1-dim. quadratur scheme
C--------I------I-----I------------------------------------------------
C WQ1    I  R   I in  I weights in the 1-dim. quadratur scheme 
C        I      I     I array: WQ1(NQ)
C--------I------I-----I------------------------------------------------
C Q1     I  R   I in  I nodes in the 1-dim. quadratur scheme 
C        I      I     I array: Q1(NQ)
C--------I------I-----I------------------------------------------------
C WQ3    I  R   I out I weights in the 3-dim. quadratur scheme 
C        I      I     I array: WQ3(NQ,NQ,NQ)
C--------I------I-----I------------------------------------------------
C Q3     I  R   I out I nodes in the 3-dim. quadratur scheme
C        I      I     I array: Q3(3,NQ,NQ,NQ)
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
C**                    >                                            ***
      INTEGER           I,J,K
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
        DO 100 I=1,NQ
          DO 100 J=1,NQ
            DO 100 K=1,NQ
             Q3(1,I,J,K)=Q1(I)
             Q3(2,I,J,K)=Q1(J)
             Q3(3,I,J,K)=Q1(K)
             WQ3(I,J,K)=WQ1(I)*WQ1(J)*WQ1(K)
  100   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMQ93 ---------------------------------------------------
      E    N    D
