C**:::      ,,,,,VEMQD0.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMQD0(CLASS,FORM,ORDER,NQ,RWORK,IWORK,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMQD0  storage for setting of quadratur formulas            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,FORM,ORDER,NQ,IWORK,RWORK,ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of element
C--------I------I-----I------------------------------------------------
C ORDER  I  I   I i/o I order of quadratur formulas
C--------I------I-----I------------------------------------------------
C NQ     I  I   I out I number of quadratur nodes
C--------I------I-----I------------------------------------------------
C RWORK  I  I   I out I needed real work storage
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I out I needed integer work storage
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I  10000   illegal dimension
C        I      I     I  10001   illegal FORM
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           NQ0,NQ2
      PARAMETER(NQ0=10)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**                                                                 ***
      ERR=10000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** point :                                                       ***
C**   -------                                                       ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN
        NQ=1
        ERR=0
        RWORK=0
        IWORK=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** line :                                                        ***
C**   ------                                                        ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        ERR=0
        NQ=MIN(ORDER/2+1,NQ0)
        ORDER=2*NQ-1
        RWORK=0
        IWORK=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle :                                                  ***
C**     ---------                                                   ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=0
          IF (ORDER.EQ.1) THEN
           IWORK=0
           RWORK=0
           NQ=1
          ELSE
           NQ2=MIN((ORDER+1)/2+1,NQ0)
           ORDER=(2*NQ2-1)-1
           NQ=NQ2**CLASS
           RWORK=(CLASS+1)*NQ2
           IWORK=0
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** quadrilateral :                                             ***
C**     -------------                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          NQ2=MIN(ORDER/2+1,NQ0)
          ORDER=(2*NQ2-1)
          NQ=NQ2**CLASS
          RWORK=(CLASS+1)*NQ2
          IWORK=0
          ERR=0
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** tetrahedron :                                               ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=0
          IF (ORDER.EQ.1) THEN
           IWORK=0
           RWORK=0
           NQ=1
          ELSE
            NQ2=MIN((ORDER+2)/2+1,NQ0)
            ORDER=(2*NQ2-1)-2
            NQ=NQ2**CLASS
            RWORK=(CLASS+1)*NQ2
            IWORK=0
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism :                                                     ***
C**     -----                                                       ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=0
          IF (ORDER.EQ.1) THEN
           IWORK=0
           RWORK=0
           NQ=1
          ELSE
            NQ2=MIN((ORDER+1)/2+1,NQ0)
            ORDER=(2*NQ2-1)-1
            NQ=NQ2**CLASS
            RWORK=(CLASS+1)*NQ2
            IWORK=0
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ----------                                                  ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          NQ2=MIN(ORDER/2+1,NQ0)
          ORDER=(2*NQ2-1)
          NQ=NQ2**CLASS
          RWORK=(CLASS+1)*NQ2
          IWORK=0
          ERR=0
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation:                                           ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMQD0 ---------------------------------------------------
      E    N    D
