C**:::      ,,,,,VEMQD1.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMQD1(NQ,WQ,Q)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMQD1    sets quadratur formulas of lines                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           NQ
      DOUBLE PRECISION  WQ(NQ),Q(NQ)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NQ     I  I   I in  I number of quadratur nodes
C--------I------I-----I------------------------------------------------
C WQ     I  R   I out I weights                           array: WQ(NQ)
C--------I------I-----I------------------------------------------------
C  Q     I  R   I out I nodes                              array: Q(NQ)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
        IF( NQ .EQ. 1 ) THEN

          Q(1)=1./2.D0
          WQ(1)=1.

        ENDIF

        IF( NQ .EQ. 2 ) THEN

          Q(1)=(1.D0-.57735 02691 89626D0)/2.D0
          Q(2)=(1.D0+.57735 02691 89626D0)/2.D0
          WQ(1)=.5D0
          WQ(2)=.5D0

        ENDIF


        IF( NQ .EQ. 3 ) THEN

          Q(1)=(1.D0-.77459 66692 41483D0)/2.D0
          Q(2)=.5D0
          Q(3)=(1.D0+.77459 66692 41483D0)/2.D0

          WQ(1)=5.D0/18.D0
          WQ(2)=4.D0/ 9.D0
          WQ(3)=5.D0/18.D0

        ENDIF


        IF( NQ .EQ. 4 ) THEN

          Q(1)=(1.D0-.86113 63115 94053D0)/2.D0
          Q(2)=(1.D0-.33998 10435 84856D0)/2.D0
          Q(3)=(1.D0+.33998 10435 84856D0)/2.D0
          Q(4)=(1.D0+.86113 63115 94053D0)/2.D0

          WQ(1)=.34785 48451 37454D0/2.D0
          WQ(2)=.65214 51548 62546D0/2.D0
          WQ(3)=.65214 51548 62546D0/2.D0
          WQ(4)=.34785 48451 37454D0/2.D0

        ENDIF


        IF( NQ .EQ. 5 ) THEN

          Q(1)=(1.D0-.90617 98459 38664D0)/2.D0
          Q(2)=(1.D0-.53846 93101 05683D0)/2.D0
          Q(3)= .5D0
          Q(4)=(1.D0+.53846 93101 05683D0)/2.D0
          Q(5)=(1.D0+.90617 98459 38664D0)/2.D0

          WQ(1)=.23692 68850 56189D0/2.D0
          WQ(2)=.47862 86704 99366D0/2.D0
          WQ(3)=.56888 88888 88889D0/2.D0
          WQ(4)=.47862 86704 99366D0/2.D0
          WQ(5)=.23692 68850 56189D0/2.D0

        ENDIF


        IF( NQ .EQ. 6 ) THEN

          Q(1)=(1.D0-.93246 95142 03152D0)/2.D0
          Q(2)=(1.D0-.66120 93864 66265D0)/2.D0
          Q(3)=(1.D0-.23861 91860 83197D0)/2.D0
          Q(4)=(1.D0+.23861 91860 83197D0)/2.D0
          Q(5)=(1.D0+.66120 93864 66265D0)/2.D0
          Q(6)=(1.D0+.93246 95142 03152D0)/2.D0

          WQ(1)=.17132 44923 79170D0/2.D0
          WQ(2)=.36076 15730 48139D0/2.D0
          WQ(3)=.46791 39345 72691D0/2.D0
          WQ(4)=.46791 39345 72691D0/2.D0
          WQ(5)=.36076 15730 48139D0/2.D0
          WQ(6)=.17132 44923 79170D0/2.D0

        ENDIF

        IF (NQ.EQ.7) THEN

           Q(1)=(1.D0-.94910 79123 42759D0)/2.D0
           Q(2)=(1.D0-.74153 11855 99394D0)/2.D0
           Q(3)=(1.D0-.40584 51513 77397D0)/2.D0
           Q(4)=0.5D0
           Q(5)=(1.D0+.40584 51513 77397D0)/2.D0
           Q(6)=(1.D0+.74153 11855 99394D0)/2.D0
           Q(7)=(1.D0+.94910 79123 42759D0)/2.D0

           WQ(1)= .12948 49661 68870D0/2.D0
           WQ(2)= .27970 53914 89277D0/2.D0
           WQ(3)= .38183 00505 05119D0/2.D0
           WQ(4)= .41795 91836 73469D0/2.D0
           WQ(5)= .38183 00505 05119D0/2.D0
           WQ(6)= .27970 53914 89277D0/2.D0
           WQ(7)= .12948 49661 68870D0/2.D0

        ENDIF

        IF (NQ.EQ.8) THEN

           Q(1)=(1.D0-.96028 98564 97536D0)/2.D0
           Q(2)=(1.D0-.79666 64774 13627D0)/2.D0
           Q(3)=(1.D0-.52553 24099 16329D0)/2.D0
           Q(4)=(1.D0-.18343 46424 95650D0)/2.D0
           Q(5)=(1.D0+.18343 46424 95650D0)/2.D0
           Q(6)=(1.D0+.52553 24099 16329D0)/2.D0
           Q(7)=(1.D0+.79666 64774 13627D0)/2.D0
           Q(8)=(1.D0+.96028 98564 97536D0)/2.D0

           WQ(1)= .10122 85362 90376D0/2.D0
           WQ(2)= .22238 10344 53374D0/2.D0
           WQ(3)= .31370 66458 77887D0/2.D0
           WQ(4)= .36268 37833 78362D0/2.D0
           WQ(5)= .36268 37833 78362D0/2.D0
           WQ(6)= .31370 66458 77887D0/2.D0
           WQ(7)= .22238 10344 53374D0/2.D0
           WQ(8)= .10122 85362 90376D0/2.D0

        ENDIF

        IF (NQ.EQ.9) THEN

           Q(1)=(1.D0-.96816 02395 07626D0)/2.D0
           Q(2)=(1.D0-.83603 11073 26636D0)/2.D0
           Q(3)=(1.D0-.61337 14327 00590D0)/2.D0
           Q(4)=(1.D0-.32425 34234 03809D0)/2.D0
           Q(5)= .5D0
           Q(6)=(1.D0+.32425 34234 03809D0)/2.D0
           Q(7)=(1.D0+.61337 14327 00590D0)/2.D0
           Q(8)=(1.D0+.83603 11073 26636D0)/2.D0
           Q(9)=(1.D0+.96816 02395 07626D0)/2.D0

           WQ(1)= .08127 43883 61574D0/2.D0
           WQ(2)= .18064 81606 94857D0/2.D0
           WQ(3)= .26061 06964 02935D0/2.D0
           WQ(4)= .31234 70770 40003D0/2.D0
           WQ(5)= .33023 93550 01260D0/2.D0
           WQ(6)= .31234 70770 40003D0/2.D0
           WQ(7)= .26061 06964 02935D0/2.D0
           WQ(8)= .18064 81606 94857D0/2.D0
           WQ(9)= .08127 43883 61574D0/2.D0

        ENDIF

        IF (NQ.EQ.10) THEN

           Q(1)=(1.D0-.97390 65285 17172D0)/2.D0
           Q(2)=(1.D0-.86506 33666 88985D0)/2.D0
           Q(3)=(1.D0-.67940 95682 99024D0)/2.D0
           Q(4)=(1.D0-.43339 53941 29247D0)/2.D0
           Q(5)=(1.D0-.14887 43389 81631D0)/2.D0
           Q(6)=(1.D0+.14887 43389 81631D0)/2.D0
           Q(7)=(1.D0+.43339 53941 29247D0)/2.D0
           Q(8)=(1.D0+.67940 95682 99024D0)/2.D0
           Q(9)=(1.D0+.86506 33666 88985D0)/2.D0
           Q(10)=(1.D0+.97390 65285 17172D0)/2.D0

           WQ(1)= .06667 13443 08688D0/2.D0
           WQ(2)= .14945 13491 50581D0/2.D0
           WQ(3)= .21908 63625 15982D0/2.D0
           WQ(4)= .26926 67193 09996D0/2.D0
           WQ(5)= .29552 42247 14753D0/2.D0
           WQ(6)= .29552 42247 14753D0/2.D0
           WQ(7)= .26926 67193 09996D0/2.D0
           WQ(8)= .21908 63625 15982D0/2.D0
           WQ(9)= .14945 13491 50581D0/2.D0
           WQ(10)= .06667 13443 08688D0/2.D0

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMQD1 ---------------------------------------------------
      E    N    D
