C**:::      ,,,,,VEMQD6.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMQD6(NQ,WQ,Q)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMQD6  transforms a quadrature scheme on a hexahedron       ***
C**            to a quadrature scheme on a tetrahedron              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           NQ
      DOUBLE PRECISION  WQ(NQ),Q(3,NQ)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NQ     I  I   I in  I number of nodes in the quadrature scheme
C--------I------I-----I------------------------------------------------
C WQ     I  R   I i/o I weights                           array: WQ(NQ)
C--------I------I-----I------------------------------------------------
C Q      I  R   I i/o I nodes                            array: Q(3,NQ)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
        INTEGER          I
        DOUBLE PRECISION DET,JA(3,3),Q1,Q2,Q3
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      DO 100 I=1,NQ

          Q1=Q(1,I)
          Q2=Q(2,I)
          Q3=Q(3,I)

          JA(1,1)= (1.D0/3.D0)*Q2*Q3-(1.D0/2.D0)*(Q2+Q3) + 1.D0
          JA(1,2)= (1.D0/3.D0)*Q1*Q3-(1.D0/2.D0)*Q1
          JA(1,3)= (1.D0/3.D0)*Q1*Q2-(1.D0/2.D0)*Q1
          JA(2,1)= (1.D0/3.D0)*Q2*Q3-(1.D0/2.D0)*Q2
          JA(2,2)= (1.D0/3.D0)*Q1*Q3-(1.D0/2.D0)*(Q1+Q3) + 1.D0
          JA(2,3)= (1.D0/3.D0)*Q1*Q2-(1.D0/2.D0)*Q2
          JA(3,1)= (1.D0/3.D0)*Q2*Q3-(1.D0/2.D0)*Q3
          JA(3,2)= (1.D0/3.D0)*Q1*Q3-(1.D0/2.D0)*Q3
          JA(3,3)= (1.D0/3.D0)*Q1*Q2-(1.D0/2.D0)*(Q1+Q2) + 1.D0

          DET=JA(1,1)*JA(2,2)*JA(3,3) + JA(1,2)*JA(2,3)*JA(3,1)
     #      + JA(1,3)*JA(2,1)*JA(3,2) - JA(1,3)*JA(2,2)*JA(3,1)
     #      - JA(1,1)*JA(2,3)*JA(3,2) - JA(1,2)*JA(2,1)*JA(3,3)

          WQ(I)=WQ(I)*ABS(DET)
          Q(1,I)=Q1*( (1.D0/3.D0)*Q2*Q3 -(1.D0/2.D0)*(Q2+Q3) + 1.D0)
          Q(2,I)=Q2*( (1.D0/3.D0)*Q1*Q3 -(1.D0/2.D0)*(Q1+Q3) + 1.D0)
          Q(3,I)=Q3*( (1.D0/3.D0)*Q1*Q2 -(1.D0/2.D0)*(Q1+Q2) + 1.D0)

 100  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMQD6 ---------------------------------------------------
      E    N    D
