C**:::      ,,,,,VEMQD7.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMQD7(NQ,WQ,CLASS,Q)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMQD7  transforms the quadratur formulas on a               ***
C**            quadrilateral to a triangle (CLASS=2) and            ***
C**            on a hexahedron to a prism (CLASS=3).                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***

       INTEGER          NQ,CLASS
       DOUBLE PRECISION WQ(NQ),Q(CLASS,NQ)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NQ     I  I   I in  I number of quadratur nodes
C--------I------I-----I------------------------------------------------
C WQ     I  R   I i/o I weights                           array: WQ(NQ)
C--------I------I-----I------------------------------------------------
C Q      I  R   I i/o I nodes                        array: Q(CLASS,NQ)
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
        INTEGER         I
        DOUBLE PRECISIONQ1,Q2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      DO 100 I=1,NQ
        Q1=Q(1,I)
        Q2=Q(2,I)

        WQ(I)=WQ(I)*(1.D0-(1.D0/2.D0)*(Q1+Q2))
        Q(1,I)=Q1*(1.D0-(1.D0/2.D0)*Q2)
        Q(2,I)=Q2*(1.D0-(1.D0/2.D0)*Q1)
 100  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMQD7 ---------------------------------------------------
      E    N    D
