C**:::      ,,,,,VEMQDF.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMQDF(CLASS,FORM,ORDER,NQMAX,NQ,WQ,Q,
     &                  LRWORK,RWORK,LIWORK,IWORK,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMQDF   sets the quadratur formulas                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,FORM,ORDER,NQMAX,ERR,NQ,LRWORK,LIWORK,
     &                  IWORK(LIWORK)
      DOUBLE PRECISION  WQ(NQMAX),Q(CLASS,NQMAX),RWORK(LRWORK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of element
C--------I------I-----I------------------------------------------------
C ORDER  I  I   I in  I order of quadratur formula
C--------I------I-----I------------------------------------------------
C NQMAX  I  I   I in  I maximal number of quadratur nodes
C--------I------I-----I------------------------------------------------
C NQ     I  I   I out I number of quadratur nodes
C--------I------I-----I------------------------------------------------
C WQ     I  R   I out I weights                        array: WQ(NQMAX)
C--------I------I-----I------------------------------------------------
C Q      I  R   I out I nodes                     array: Q(NQMAX,CLASS)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number 
C        I      I     I   10000 illegal dimension
C        I      I     I   10001 illegal FORM
C        I      I     I   10005 illegal ORDER
C        I      I     I   10010 too small storage
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           WQ2,Q2,NQ0,NQ2
      PARAMETER(NQ0=10)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**                                                                 ***
      ERR=10000
      NQ=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                     ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN

        ERR=0
        NQ=1

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN

        ERR=0
        NQ=MIN(ORDER/2+1,NQ0)
        ORDER=2*NQ-1

        IF (NQ.GT.NQMAX) THEN
          ERR=10010
          GOTO 9999
        ENDIF

        CALL VEMQD1(NQ,WQ,Q)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle :                                                  ***
C**     --------                                                    ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN

          ERR=0
          IF (ORDER.EQ.1) THEN
             NQ=1
             Q(1,1)=1.D0/3.D0
             Q(2,1)=Q(1,1)
             WQ(1)= .5D0
             GOTO 9999
          ENDIF

          NQ2=MIN((ORDER+1)/2+1,NQ0)
          ORDER=(2*NQ2-1)-1
          NQ=NQ2**CLASS

          IF ((NQ.GT.NQMAX).OR.((CLASS+1)*NQ2.GT.LRWORK)) THEN
            ERR=10010
            GOTO 9999
          ENDIF


          WQ2=1
          Q2=WQ2+NQ2
          CALL VEMQD1(NQ2,RWORK(WQ2),RWORK(Q2))
          CALL VEMQ92(NQ2,RWORK(WQ2),RWORK(Q2),WQ,Q)
          CALL VEMQD7(NQ,WQ,CLASS,Q)

        ENDIF

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** quadrilateral :                                             ***
C**     -------------                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN

          ERR=0
          NQ2=MIN(ORDER/2+1,NQ0)
          ORDER=(2*NQ2-1)
          NQ=NQ2**CLASS

          IF ((NQ.GT.NQMAX).OR.((CLASS+1)*NQ2.GT.LRWORK)) THEN
            ERR=10010
            GOTO 9999
          ENDIF

          WQ2=1
          Q2=WQ2+NQ2
          CALL VEMQD1(NQ2,RWORK(WQ2),RWORK(Q2))
          CALL VEMQ92(NQ2,RWORK(WQ2),RWORK(Q2),WQ,Q)

        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** tetrahedron :                                               ***
C**     -----------                                                 ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN

          ERR=0
          IF (ORDER.EQ.1) THEN
             NQ=1
             Q(1,1)= .25D0
             Q(2,1)= .25D0
             Q(3,1)= .25D0
             WQ(1)=1.D0/6.D0
             GOTO 9999
          ENDIF

          NQ2=MIN((ORDER+2)/2+1,NQ0)
          ORDER=(2*NQ2-1)-2
          NQ=NQ2**CLASS

          IF ((NQ.GT.NQMAX).OR.((CLASS+1)*NQ2.GT.LRWORK)) THEN
            ERR=10010
            GOTO 9999
          ENDIF

          WQ2=1
          Q2=WQ2+NQ2
          CALL VEMQD1(NQ2,RWORK(WQ2),RWORK(Q2))
          CALL VEMQ93(NQ2,RWORK(WQ2),RWORK(Q2),WQ,Q)
          CALL VEMQD6(NQ,WQ,Q)

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism :                                                     ***
C**     -----                                                       ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN

          ERR=0
          IF (ORDER.EQ.1) THEN
             NQ=1
             Q(1,1)=1.D0/3.D0
             Q(2,1)=Q(1,1)
             Q(3,1)= .5D0
             WQ(1)= .5D0
             GOTO 9999
          ENDIF

          NQ2=MIN((ORDER+1)/2+1,NQ0)
          ORDER=(2*NQ2-1)-1
          NQ=NQ2**CLASS

          IF ((NQ.GT.NQMAX).OR.((CLASS+1)*NQ2.GT.LRWORK)) THEN
            ERR=10010
            GOTO 9999
          ENDIF

          WQ2=1
          Q2=WQ2+NQ2
          CALL VEMQD1(NQ2,RWORK(WQ2),RWORK(Q2))
          CALL VEMQ93(NQ2,RWORK(WQ2),RWORK(Q2),WQ,Q)
          CALL VEMQD7(NQ,WQ,CLASS,Q)

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ----------                                                  ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN

          ERR=0
          NQ2=MIN(ORDER/2+1,NQ0)
          ORDER=(2*NQ2-1)
          NQ=NQ2**CLASS

          IF ((NQ.GT.NQMAX).OR.((CLASS+1)*NQ2.GT.LRWORK)) THEN
            ERR=10010
            GOTO 9999
          ENDIF

          WQ2=1
          Q2=WQ2+NQ2
          CALL VEMQD1(NQ2,RWORK(WQ2),RWORK(Q2))
          CALL VEMQ93(NQ2,RWORK(WQ2),RWORK(Q2),WQ,Q)

        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
9999  CONTINUE
      R E T U R N
C-----End of VEMQDF ---------------------------------------------------
      E    N    D
