C**:::      ,,,,,VEMSH1.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMSH1(GEOTYP,N,V,S,DSDV,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMSH1 sets shape functions for lines                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           GEOTYP,N,ERR
      DOUBLE PRECISION  V(N),S(GEOTYP,N), DSDV(GEOTYP,N)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of point
C--------I------I-----I------------------------------------------------
C V      I  R   I in  I points in the element               array: V(N)
C--------I------I-----I------------------------------------------------
C S      I  R   I out I shape functions at V         array: S(GEOTYP,N)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I out I derivations of shape functions at V
C        I      I     I array: DSDV(GEOTYP,N)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10002   illegal GEOTYP
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** GEOTYP =  2 :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF( GEOTYP .EQ. 2 ) THEN

        ERR=0

        include "scalar.h"
        DO 1010 I=1,N

          S(1,I)=1.D0-V(I)
          S(2,I)=   V(I)

          DSDV(1,I)=-1.D0
          DSDV(2,I)= 1.D0

1010    CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** GEOTYP =  3 :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF( GEOTYP .EQ. 3 ) THEN

        ERR=0

      include "scalar.h"
        DO 1020 I=1,N

          S(1,I)=( 2.D0 * V(I) - 1.D0 ) * ( V(I) - 1.D0)
          S(2,I)=( 2.D0 * V(I) - 1.D0) * V(I)
          S(3,I)=  4.D0 * V(I) * ( 1.D0 - V(I) )

          DSDV(1,I)= 4.D0 * V(I) - 3.D0
          DSDV(2,I)= 4.D0 * V(I) - 1.D0
          DSDV(3,I)=-8.D0 * V(I) + 4.D0

1020    CONTINUE

      ENDIF

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** GEOTYP =  4 :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF( GEOTYP .EQ. 4 ) THEN
        ERR=0

       include "scalar.h"
       DO 1030 I=1,N

       S( 1,I)=
     #  (    0.1000000000D+01) +
     #  (   -0.5500000000D+01) * V(I)** 1 +
     #  (    0.9000000000D+01) * V(I)** 2 +
     #  (   -0.4500000000D+01) * V(I)** 3 +
     #              0.D0
      S( 2,I)=
     #  (    0.1000000000D+01) * V(I)** 1 +
     #  (   -0.4500000000D+01) * V(I)** 2 +
     #  (    0.4500000000D+01) * V(I)** 3 +
     #              0.D0
      S( 3,I)=
     #  (    0.9000000000D+01) * V(I)** 1 +
     #  (   -0.2250000000D+02) * V(I)** 2 +
     #  (    0.1350000000D+02) * V(I)** 3 +
     #              0.D0
      S( 4,I)=
     #  (   -0.4500000000D+01) * V(I)** 1 +
     #  (    0.1800000000D+02) * V(I)** 2 +
     #  (   -0.1350000000D+02) * V(I)** 3 +
     #              0.D0
      DSDV( 1,I)=
     #  (   -0.5500000000D+01) +
     #  (    0.1800000000D+02) * V(I)** 1 +
     #  (   -0.1350000000D+02) * V(I)** 2 +
     #              0.D0
      DSDV( 2,I)=
     #  (    0.1000000000D+01) +
     #  (   -0.9000000000D+01) * V(I)** 1 +
     #  (    0.1350000000D+02) * V(I)** 2 +
     #              0.D0
      DSDV( 3,I)=
     #  (    0.9000000000D+01) +
     #  (   -0.4500000000D+02) * V(I)** 1 +
     #  (    0.4050000000D+02) * V(I)** 2 +
     #              0.D0
      DSDV( 4,I)=
     #  (   -0.4500000000D+01) +
     #  (    0.3600000000D+02) * V(I)** 1 +
     #  (   -0.4050000000D+02) * V(I)** 2 +
     #              0.D0

1030  CONTINUE
C**                                                                 ***
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMSH1 ---------------------------------------------------
      E    N    D
