C**:::      ,,,,,VEMSH4.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMSH4(GEOTYP,N,V,S,DSDV,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMSH4  sets shape functions for tetrahedron                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           GEOTYP,N,ERR
      DOUBLE PRECISION  V(3,N),S(GEOTYP,N), DSDV(GEOTYP,3,N)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of point
C--------I------I-----I------------------------------------------------
C V      I  R   I in  I points in the element             array: V(3,N)
C--------I------I-----I------------------------------------------------
C S      I  R   I out I shape functions at V         array: S(GEOTYP,N)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I out I derivations of shape functions at V
C        I      I     I array: DSDV(GEOTYP,3,N)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10002   illegal GEOTYP
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***

      ERR=10002
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** GEOTYP = 4  :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF( GEOTYP .EQ. 4 ) THEN
         ERR=0

      include "scalar.h"
        DO 1510 I=1,N

          S(1,I)=1.D0-V(1,I)-V(2,I)-V(3,I)
          S(2,I)=V(1,I)
          S(3,I)=V(2,I)
          S(4,I)=V(3,I)

          DSDV(1,1,I)=-1.D0
          DSDV(1,2,I)=-1.D0
          DSDV(1,3,I)=-1.D0

          DSDV(2,1,I)= 1.D0
          DSDV(2,2,I)= 0.
          DSDV(2,3,I)= 0.

          DSDV(3,1,I)= 0.
          DSDV(3,2,I)= 1.D0
          DSDV(3,3,I)= 0.

          DSDV(4,1,I)= 0.
          DSDV(4,2,I)= 0.
          DSDV(4,3,I)= 1.D0

1510  CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** GEOTYP = 10 :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF( GEOTYP .EQ. 10) THEN
        ERR=0

      include "scalar.h"
        DO 1520 I=1,N

        S(1,I) = (1.D0-V(1,I)-V(2,I)-V(3,I))*(1.D0-2.D0*V(1,I)
     *        -2.D0*V(2,I)-2.D0*V(3,I))
        S(2,I) = V(1,I)*(2.D0*V(1,I)-1.D0)
        S(3,I) = V(2,I)*(2.D0*V(2,I)-1.D0)
        S(4,I) = V(3,I)*(2.D0*V(3,I)-1.D0)
        S(5,I) = (1.D0-V(1,I)-V(2,I)-V(3,I))*4.D0*V(1,I)
        S(6,I) = 4.D0*V(1,I)*V(2,I)
        S(7,I) = (1.D0-V(1,I)-V(2,I)-V(3,I))*4.D0*V(2,I)
        S(8,I) = (1.D0-V(1,I)-V(2,I)-V(3,I))*4.D0*V(3,I)
        S(9,I) = 4.D0*V(1,I)*V(3,I)
        S(10,I)= 4.D0*V(2,I)*V(3,I)

        DSDV(1,1,I)= - 3.D0 + 4.D0*V(1,I)+ 4.D0*V(2,I)+ 4.D0*V(3,I)
        DSDV(1,2,I)= - 3.D0 + 4.D0*V(1,I)+ 4.D0*V(2,I)+ 4.D0*V(3,I)
        DSDV(1,3,I)= - 3.D0 + 4.D0*V(1,I)+ 4.D0*V(2,I)+ 4.D0*V(3,I)

        DSDV(2,1,I)= - 1.D0 + 4.D0*V(1,I)
        DSDV(2,2,I)=   0.D0
        DSDV(2,3,I)=   0.D0

        DSDV(3,1,I)=   0.D0
        DSDV(3,2,I)=  -1.D0            +  4.D0*V(2,I)
        DSDV(3,3,I)=   0.D0

        DSDV(4,1,I)=   0.D0
        DSDV(4,2,I)=   0.D0
        DSDV(4,3,I)=  -1.D0                         +  4.D0*V(3,I)

        DSDV(5,1,I)=   4.D0 - 8.D0*V(1,I) - 4.D0*V(2,I) - 4.D0*V(3,I)
        DSDV(5,2,I)=      -  4.D0*V(1,I)
        DSDV(5,3,I)=      -  4.D0*V(1,I)

        DSDV(6,1,I)=                      4.D0*V(2,I)
        DSDV(6,2,I)=         4.D0*V(1,I)
        DSDV(6,3,I)=   0.D0

        DSDV(7,1,I)=                   -  4.D0*V(2,I)
        DSDV(7,2,I)=   4.D0 - 4.D0*V(1,I) - 8.D0*V(2,I) - 4.D0*V(3,I)
        DSDV(7,3,I)=                   -  4.D0*V(2,I)

        DSDV(8,1,I)=                                -  4.D0*V(3,I)
        DSDV(8,2,I)=                                -  4.D0*V(3,I)
        DSDV(8,3,I)=   4.D0 - 4.D0*V(1,I) - 4.D0*V(2,I) - 8.D0*V(3,I)

        DSDV(9,1,I)=                                   4.D0*V(3,I)
        DSDV(9,2,I)=   0.D0
        DSDV(9,3,I)=         4.D0*V(1,I)

        DSDV(10,1,I)=  0.D0
        DSDV(10,2,I)=                                  4.D0*V(3,I)
        DSDV(10,3,I)=                      4.D0*V(2,I)


1520  CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** GEOTYP = 16 :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF( GEOTYP .EQ. 16) THEN
        ERR=0

      include "scalar.h"
      DO 1530 I=1,N
      S( 1,I)=
     #  (    0.1000000000D+01) +
     #  (   -0.5500000000D+01) * V(1,I)** 1 +
     #  (   -0.5500000000D+01) * V(2,I)** 1 +
     #  (   -0.5500000000D+01) * V(3,I)** 1 +
     #  (    0.9000000000D+01) * V(1,I)** 2 +
     #  (   -0.4500000000D+01) * V(1,I)** 3 +
     #  (    0.4500000000D+01) * V(1,I)** 2 * V(2,I)** 1 +
     #  (    0.4500000000D+01) * V(1,I)** 1 * V(2,I)** 2 +
     #  (   -0.4500000000D+01) * V(2,I)** 3 +
     #  (    0.9000000000D+01) * V(2,I)** 2 +
     #  (    0.9000000000D+01) * V(3,I)** 2 +
     #  (    0.4500000000D+01) * V(1,I)** 2 * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(2,I)** 2 * V(3,I)** 1 +
     #  (   -0.4500000000D+01) * V(3,I)** 3 +
     #  (    0.4500000000D+01) * V(1,I)** 1 * V(3,I)** 2 +
     #  (    0.4500000000D+01) * V(2,I)** 1 * V(3,I)** 2 +
     #              0.D0
      S( 2,I)=
     #  (    1.0000000000D+00) * V(1,I)** 1 +
     #  (   -0.4500000000D+01) * V(1,I)** 2 +
     #  (    0.4500000000D+01) * V(1,I)** 3 +
     #              0.D0
      S( 3,I)=
     #  (    1.0000000000D+00) * V(2,I)** 1 +
     #  (    0.4500000000D+01) * V(2,I)** 3 +
     #  (   -0.4500000000D+01) * V(2,I)** 2 +
     #              0.D0
      S( 4,I)=
     #  (    1.0000000000D+00) * V(3,I)** 1 +
     #  (   -0.4500000000D+01) * V(3,I)** 2 +
     #  (    0.4500000000D+01) * V(3,I)** 3 +
     #              0.D0
      S( 5,I)=
     #  (    0.9000000000D+01) * V(1,I)** 1 +
     #  (   -0.2250000000D+02) * V(1,I)** 2 +
     #  (    0.1350000000D+02) * V(1,I)** 3 +
     #  (    0.4500000000D+01) * V(1,I)** 2 * V(2,I)** 1 +
     #  (   -0.9000000000D+01) * V(1,I)** 1 * V(2,I)** 2 +
     #  (    0.4500000000D+01) * V(1,I)** 2 * V(3,I)** 1 +
     #  (   -0.9000000000D+01) * V(1,I)** 1 * V(3,I)** 2 +
     #              0.D0
      S( 6,I)=
     #  (   -0.4500000000D+01) * V(1,I)** 1 +
     #  (    0.1800000000D+02) * V(1,I)** 2 +
     #  (   -0.1350000000D+02) * V(1,I)** 3 +
     #  (   -0.9000000000D+01) * V(1,I)** 2 * V(2,I)** 1 +
     #  (    0.4500000000D+01) * V(1,I)** 1 * V(2,I)** 2 +
     #  (   -0.9000000000D+01) * V(1,I)** 2 * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(1,I)** 1 * V(3,I)** 2 +
     #              0.D0
      S( 7,I)=
     #  (    0.9000000000D+01) * V(1,I)** 2 * V(2,I)** 1 +
     #  (   -0.4500000000D+01) * V(1,I)** 1 * V(2,I)** 2 +
     #              0.D0
      S( 8,I)=
     #  (   -0.4500000000D+01) * V(1,I)** 2 * V(2,I)** 1 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(2,I)** 2 +
     #              0.D0
      S( 9,I)=
     #  (   -0.4500000000D+01) * V(2,I)** 1 +
     #  (    0.4500000000D+01) * V(1,I)** 2 * V(2,I)** 1 +
     #  (   -0.9000000000D+01) * V(1,I)** 1 * V(2,I)** 2 +
     #  (   -0.1350000000D+02) * V(2,I)** 3 +
     #  (    0.1800000000D+02) * V(2,I)** 2 +
     #  (   -0.9000000000D+01) * V(2,I)** 2 * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(2,I)** 1 * V(3,I)** 2 +
     #              0.D0
      S(10,I)=
     #  (    0.9000000000D+01) * V(2,I)** 1 +
     #  (   -0.9000000000D+01) * V(1,I)** 2 * V(2,I)** 1 +
     #  (    0.4500000000D+01) * V(1,I)** 1 * V(2,I)** 2 +
     #  (    0.1350000000D+02) * V(2,I)** 3 +
     #  (   -0.2250000000D+02) * V(2,I)** 2 +
     #  (    0.4500000000D+01) * V(2,I)** 2 * V(3,I)** 1 +
     #  (   -0.9000000000D+01) * V(2,I)** 1 * V(3,I)** 2 +
     #              0.D0
      S(11,I)=
     #  (    0.9000000000D+01) * V(3,I)** 1 +
     #  (   -0.2250000000D+02) * V(3,I)** 2 +
     #  (   -0.9000000000D+01) * V(1,I)** 2 * V(3,I)** 1 +
     #  (   -0.9000000000D+01) * V(2,I)** 2 * V(3,I)** 1 +
     #  (    0.1350000000D+02) * V(3,I)** 3 +
     #  (    0.4500000000D+01) * V(1,I)** 1 * V(3,I)** 2 +
     #  (    0.4500000000D+01) * V(2,I)** 1 * V(3,I)** 2 +
     #              0.D0
      S(12,I)=
     #  (    0.9000000000D+01) * V(1,I)** 2 * V(3,I)** 1 +
     #  (   -0.4500000000D+01) * V(1,I)** 1 * V(3,I)** 2 +
     #              0.D0
      S(13,I)=
     #  (    0.9000000000D+01) * V(2,I)** 2 * V(3,I)** 1 +
     #  (   -0.4500000000D+01) * V(2,I)** 1 * V(3,I)** 2 +
     #              0.D0
      S(14,I)=
     #  (   -0.4500000000D+01) * V(3,I)** 1 +
     #  (    0.1800000000D+02) * V(3,I)** 2 +
     #  (    0.4500000000D+01) * V(1,I)** 2 * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(2,I)** 2 * V(3,I)** 1 +
     #  (   -0.1350000000D+02) * V(3,I)** 3 +
     #  (   -0.9000000000D+01) * V(1,I)** 1 * V(3,I)** 2 +
     #  (   -0.9000000000D+01) * V(2,I)** 1 * V(3,I)** 2 +
     #              0.D0
      S(15,I)=
     #  (   -0.4500000000D+01) * V(1,I)** 2 * V(3,I)** 1 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(3,I)** 2 +
     #              0.D0
      S(16,I)=
     #  (   -0.4500000000D+01) * V(2,I)** 2 * V(3,I)** 1 +
     #  (    0.9000000000D+01) * V(2,I)** 1 * V(3,I)** 2 +
     #              0.D0
      DSDV( 1, 1,I)=
     #  (   -0.5500000000D+01) +
     #  (    0.1800000000D+02) * V(1,I)** 1 +
     #  (   -0.1350000000D+02) * V(1,I)** 2 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(2,I)** 1 +
     #  (    0.4500000000D+01) * V(2,I)** 2 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV( 2, 1,I)=
     #  (    1.0000000000D+00) +
     #  (   -0.9000000000D+01) * V(1,I)** 1 +
     #  (    0.1350000000D+02) * V(1,I)** 2 +
     #              0.D0
      DSDV( 3, 1,I)=
     #              0.D0
      DSDV( 4, 1,I)=
     #              0.D0
      DSDV( 5, 1,I)=
     #  (    0.9000000000D+01) +
     #  (   -0.4500000000D+02) * V(1,I)** 1 +
     #  (    0.4050000000D+02) * V(1,I)** 2 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(2,I)** 1 +
     #  (   -0.9000000000D+01) * V(2,I)** 2 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(3,I)** 1 +
     #  (   -0.9000000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV( 6, 1,I)=
     #  (   -0.4500000000D+01) +
     #  (    0.3600000000D+02) * V(1,I)** 1 +
     #  (   -0.4050000000D+02) * V(1,I)** 2 +
     #  (   -0.1800000000D+02) * V(1,I)** 1 * V(2,I)** 1 +
     #  (    0.4500000000D+01) * V(2,I)** 2 +
     #  (   -0.1800000000D+02) * V(1,I)** 1 * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV( 7, 1,I)=
     #  (    0.1800000000D+02) * V(1,I)** 1 * V(2,I)** 1 +
     #  (   -0.4500000000D+01) * V(2,I)** 2 +
     #              0.D0
      DSDV( 8, 1,I)=
     #  (   -0.9000000000D+01) * V(1,I)** 1 * V(2,I)** 1 +
     #  (    0.9000000000D+01) * V(2,I)** 2 +
     #              0.D0
      DSDV( 9, 1,I)=
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(2,I)** 1 +
     #  (   -0.9000000000D+01) * V(2,I)** 2 +
     #              0.D0
      DSDV(10, 1,I)=
     #  (   -0.1800000000D+02) * V(1,I)** 1 * V(2,I)** 1 +
     #  (    0.4500000000D+01) * V(2,I)** 2 +
     #              0.D0
      DSDV(11, 1,I)=
     #  (   -0.1800000000D+02) * V(1,I)** 1 * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV(12, 1,I)=
     #  (    0.1800000000D+02) * V(1,I)** 1 * V(3,I)** 1 +
     #  (   -0.4500000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV(13, 1,I)=
     #              0.D0
      DSDV(14, 1,I)=
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(3,I)** 1 +
     #  (   -0.9000000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV(15, 1,I)=
     #  (   -0.9000000000D+01) * V(1,I)** 1 * V(3,I)** 1 +
     #  (    0.9000000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV(16, 1,I)=
     #              0.D0
      DSDV( 1, 2,I)=
     #  (   -0.5500000000D+01) +
     #  (    0.4500000000D+01) * V(1,I)** 2 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(2,I)** 1 +
     #  (   -0.1350000000D+02) * V(2,I)** 2 +
     #  (    0.1800000000D+02) * V(2,I)** 1 +
     #  (    0.9000000000D+01) * V(2,I)** 1 * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV( 2, 2,I)=
     #              0.D0
      DSDV( 3, 2,I)=
     #  (    1.0000000000D+00) +
     #  (    0.1350000000D+02) * V(2,I)** 2 +
     #  (   -0.9000000000D+01) * V(2,I)** 1 +
     #              0.D0
      DSDV( 4, 2,I)=
     #              0.D0
      DSDV( 5, 2,I)=
     #  (    0.4500000000D+01) * V(1,I)** 2 +
     #  (   -0.1800000000D+02) * V(1,I)** 1 * V(2,I)** 1 +
     #              0.D0
      DSDV( 6, 2,I)=
     #  (   -0.9000000000D+01) * V(1,I)** 2 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(2,I)** 1 +
     #              0.D0
      DSDV( 7, 2,I)=
     #  (    0.9000000000D+01) * V(1,I)** 2 +
     #  (   -0.9000000000D+01) * V(1,I)** 1 * V(2,I)** 1 +
     #              0.D0
      DSDV( 8, 2,I)=
     #  (   -0.4500000000D+01) * V(1,I)** 2 +
     #  (    0.1800000000D+02) * V(1,I)** 1 * V(2,I)** 1 +
     #              0.D0
      DSDV( 9, 2,I)=
     #  (   -0.4500000000D+01) +
     #  (    0.4500000000D+01) * V(1,I)** 2 +
     #  (   -0.1800000000D+02) * V(1,I)** 1 * V(2,I)** 1 +
     #  (   -0.4050000000D+02) * V(2,I)** 2 +
     #  (    0.3600000000D+02) * V(2,I)** 1 +
     #  (   -0.1800000000D+02) * V(2,I)** 1 * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV(10, 2,I)=
     #  (    0.9000000000D+01) +
     #  (   -0.9000000000D+01) * V(1,I)** 2 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(2,I)** 1 +
     #  (    0.4050000000D+02) * V(2,I)** 2 +
     #  (   -0.4500000000D+02) * V(2,I)** 1 +
     #  (    0.9000000000D+01) * V(2,I)** 1 * V(3,I)** 1 +
     #  (   -0.9000000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV(11, 2,I)=
     #  (   -0.1800000000D+02) * V(2,I)** 1 * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV(12, 2,I)=
     #              0.D0
      DSDV(13, 2,I)=
     #  (    0.1800000000D+02) * V(2,I)** 1 * V(3,I)** 1 +
     #  (   -0.4500000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV(14, 2,I)=
     #  (    0.9000000000D+01) * V(2,I)** 1 * V(3,I)** 1 +
     #  (   -0.9000000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV(15, 2,I)=
     #              0.D0
      DSDV(16, 2,I)=
     #  (   -0.9000000000D+01) * V(2,I)** 1 * V(3,I)** 1 +
     #  (    0.9000000000D+01) * V(3,I)** 2 +
     #              0.D0
      DSDV( 1, 3,I)=
     #  (   -0.5500000000D+01) +
     #  (    0.1800000000D+02) * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(1,I)** 2 +
     #  (    0.4500000000D+01) * V(2,I)** 2 +
     #  (   -0.1350000000D+02) * V(3,I)** 2 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(3,I)** 1 +
     #  (    0.9000000000D+01) * V(2,I)** 1 * V(3,I)** 1 +
     #              0.D0
      DSDV( 2, 3,I)=
     #              0.D0
      DSDV( 3, 3,I)=
     #              0.D0
      DSDV( 4, 3,I)=
     #  (    1.0000000000D+00) +
     #  (   -0.9000000000D+01) * V(3,I)** 1 +
     #  (    0.1350000000D+02) * V(3,I)** 2 +
     #              0.D0
      DSDV( 5, 3,I)=
     #  (    0.4500000000D+01) * V(1,I)** 2 +
     #  (   -0.1800000000D+02) * V(1,I)** 1 * V(3,I)** 1 +
     #              0.D0
      DSDV( 6, 3,I)=
     #  (   -0.9000000000D+01) * V(1,I)** 2 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(3,I)** 1 +
     #              0.D0
      DSDV( 7, 3,I)=
     #              0.D0
      DSDV( 8, 3,I)=
     #              0.D0
      DSDV( 9, 3,I)=
     #  (   -0.9000000000D+01) * V(2,I)** 2 +
     #  (    0.9000000000D+01) * V(2,I)** 1 * V(3,I)** 1 +
     #              0.D0
      DSDV(10, 3,I)=
     #  (    0.4500000000D+01) * V(2,I)** 2 +
     #  (   -0.1800000000D+02) * V(2,I)** 1 * V(3,I)** 1 +
     #              0.D0
      DSDV(11, 3,I)=
     #  (    0.9000000000D+01) +
     #  (   -0.4500000000D+02) * V(3,I)** 1 +
     #  (   -0.9000000000D+01) * V(1,I)** 2 +
     #  (   -0.9000000000D+01) * V(2,I)** 2 +
     #  (    0.4050000000D+02) * V(3,I)** 2 +
     #  (    0.9000000000D+01) * V(1,I)** 1 * V(3,I)** 1 +
     #  (    0.9000000000D+01) * V(2,I)** 1 * V(3,I)** 1 +
     #              0.D0
      DSDV(12, 3,I)=
     #  (    0.9000000000D+01) * V(1,I)** 2 +
     #  (   -0.9000000000D+01) * V(1,I)** 1 * V(3,I)** 1 +
     #              0.D0
      DSDV(13, 3,I)=
     #  (    0.9000000000D+01) * V(2,I)** 2 +
     #  (   -0.9000000000D+01) * V(2,I)** 1 * V(3,I)** 1 +
     #              0.D0
      DSDV(14, 3,I)=
     #  (   -0.4500000000D+01) +
     #  (    0.3600000000D+02) * V(3,I)** 1 +
     #  (    0.4500000000D+01) * V(1,I)** 2 +
     #  (    0.4500000000D+01) * V(2,I)** 2 +
     #  (   -0.4050000000D+02) * V(3,I)** 2 +
     #  (   -0.1800000000D+02) * V(1,I)** 1 * V(3,I)** 1 +
     #  (   -0.1800000000D+02) * V(2,I)** 1 * V(3,I)** 1 +
     #              0.D0
      DSDV(15, 3,I)=
     #  (   -0.4500000000D+01) * V(1,I)** 2 +
     #  (    0.1800000000D+02) * V(1,I)** 1 * V(3,I)** 1 +
     #              0.D0
      DSDV(16, 3,I)=
     #  (   -0.4500000000D+01) * V(2,I)** 2 +
     #  (    0.1800000000D+02) * V(2,I)** 1 * V(3,I)** 1 +
     #              0.D0

1530  CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMSH4 ---------------------------------------------------
      E    N    D
