C**:::      ,,,,,VEMSHF.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMSHF(CLASS,FORM,GEOTYP,N,V,S,DSDV,
     &                  LRWORK,RWORK,LIWORK,IWORK,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMSHF controls the calculation of the shape functions       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,GEOTYP,FORM,N,LIWORK,IWORK(LIWORK),
     &                  LRWORK,ERR
      DOUBLE PRECISION  V(CLASS,N),S(GEOTYP,N),DSDV(GEOTYP,CLASS,N),
     &                  RWORK(LRWORK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of the element
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of point
C--------I------I-----I------------------------------------------------
C V      I  R   I in  I points in the element         array: V(CLASS,N)
C--------I------I-----I------------------------------------------------
C S      I  R   I out I shape functions at V         array: S(GEOTYP,N)
C--------I------I-----I------------------------------------------------
C DSDV   I  R   I out I derivations of shape functions at V
C        I      I     I array: DSDV(GEOTYP,CLASS,N)
C--------I------I-----I------------------------------------------------
C RWORK  I  R   I  -  I real work space            array: RWORK(LRWORK)
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I  -  I integer work space         array: IWORK(LIWORK)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I ERROR NUMBER
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10002   illegal ORDER
C        I      I     I 10003   work space is too small
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           I,J
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=10000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** GEOTYP =  1 :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF( GEOTYP .EQ. 1 ) THEN
        ERR=0
        DO 1001 I=1,N
          S(1,I)=1.D0
1001    CONTINUE
        DO 1002 J=1,CLASS
          DO 1002 I=1,N
            DSDV(1,J,I)=0.D0
1002    CONTINUE
        RETURN
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        ERR=10002
        CALL VEMSH1(GEOTYP,N,V,S,DSDV,ERR)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN
        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle :                                                  ***
C**     --------                                                    ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=10002
          CALL VEMSH2(GEOTYP,N,V,S,DSDV,ERR)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** quadrilateral :                                             ***
C**     ---------------                                             ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          CALL VEMSH3(GEOTYP,N,V,S,DSDV,ERR)
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN
        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** tetrahedron :                                               ***
C**     -------------                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          CALL VEMSH4(GEOTYP,N,V,S,DSDV,ERR)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism:                                                      ***
C**     ------                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=10002
          CALL VEMSH5(GEOTYP,N,V,S,DSDV,ERR)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          ERR=10002
          CALL VEMSH6(GEOTYP,N,V,S,DSDV,ERR)
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMSHF ---------------------------------------------------
      E    N    D
