C**:::      ,,,,,VEMSL0.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMSL0(CLASS,FORM,GEOTYP,NSUBE,LIWORK,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMSL0  computes the storage requirement to set the index    ***
C**            element tree of the Lagrangean elements (VEMSLP)     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           GEOTYP,CLASS,FORM,NSUBE,LIWORK,ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of the element
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes
C--------I------I-----I------------------------------------------------
C NSUBE  I  I   I out I number of subelements
C--------I------I-----I------------------------------------------------
C LIWORK I  I   I out I required integer work space
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10003   illegal GEOTYP
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**                                                                 ***
      ERR=10000
      LIWORK=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN
        NSUBE=1
        ERR=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        ERR=0
        NSUBE=FORM+1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle :                                                  ***
C**     --------                                                    ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=0
          NSUBE=7
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** quadrilateral :                                             ***
C**     ---------------                                             ***
C**                                                                 ***
        IF( form .EQ. 4 ) THEN
          ERR=0
          NSUBE=9
        ENDIF
C**                                                                 ***
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** tetrahedron :                                               ***
C**     -------------                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=0
          NSUBE=15
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism:                                                      ***
C**     ------                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=0
          NSUBE=21
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          ERR=0
          NSUBE=27
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMSL0----------------------------------------------------
      E    N    D
