C**:::      ,,,,,VEMSLP.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMSLP(CLASS,FORM,NELTYP,NSUBE,NSMAX,NODES,NNODES,
     &                  LIWORK,IWORK,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMSLP  sets list of local nodes in elements in the element  ***
C**            tree (=element, face, edge, nodes) for the           ***
C**            lagrangean elements.                                 ***
C**                                                                 ***
C**            The succession of the elements in the tree           ***
C**            has to correspond to the succession of the elements  ***
C**            in the tree of the shape functions.                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           NELTYP,CLASS,FORM,NSUBE,NSMAX,LIWORK,ERR
      INTEGER           NODES(NELTYP,NSMAX),NNODES(NSMAX),IWORK(LIWORK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of the element
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of proposal functions
C--------I------I-----I------------------------------------------------
C NSUBE  I  I   I out I number of elements in the tree
C--------I------I-----I------------------------------------------------
C NODES  I  I   I out I list of the nodes in the elements in the 
C        I      I     I tree                 array: NODES(NELTYP,NSMAX)
C--------I------I-----I------------------------------------------------
C NNODES I  I   I out I number of nodes in the elements in the tree
C        I      I     I                            array: NNODES(NSMAX)
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I -   I integer work array         array: IWORK(LIWORK)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I ERROR NUMBER
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10003   illegal NELTYP
C        I      I     I 10010   too small storage
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           I,J,K,N,NND,OFF,MUELL,UPNODE, UPNELT,
     &                  LEVNEL,OFFSET(6),VSTEP(6),HSTEP(6),VHSTEP(4)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=10000

      IF (NSMAX.LT.1) THEN
        ERR=10010
        RETURN
      ENDIF

      IF (NELTYP.EQ.0) THEN
        ERR=10003
        RETURN
      ENDIF

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the first element in the tree is the element itself:          ***
C**   ---------------------------------------------------           ***
C**                                                                 ***
      NNODES(1)=NELTYP
      DO 10 I=1,NELTYP
10      NODES(I,1)=I
      NSUBE=1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN

        IF (1.LT.NELTYP) THEN
          ERR=10003
          RETURN
        ENDIF

        GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN

        IF (NSMAX.LT.1+2) THEN
          ERR=10010
          RETURN
        ENDIF
        ERR=0

        NODES(1,NSUBE+1)=1
        NODES(1,NSUBE+2)=NELTYP
        NNODES( NSUBE+1)=1
        NNODES( NSUBE+2)=1

        NSUBE=NSUBE+2
        GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN
        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle :                                                  ***
C**     --------                                                    ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN

          IF( NSMAX .LT. 1+3+3 )THEN
           ERR=10010
           RETURN
          ENDIF

C****** FITTING NELTYP ? ***
          NND=INT((SQRT(DBLE(8*NELTYP+1)+0.5)-1)/2)
          IF (INT((NND*NND + NND)/2).NE.NELTYP) THEN
            ERR=10003
            RETURN
          ENDIF
          ERR=0

          DO 300 I=1,NND
            NODES(I,NSUBE+1)=I
            NODES(I,NSUBE+2)=NELTYP-((NND-I)**2   +(NND-I))/2
            NODES(I,NSUBE+3)=NELTYP-((I      )**2   +(I      ))/2 + 1
300       CONTINUE

          NODES(1,NSUBE+4)=1
          NODES(1,NSUBE+5)=NND
          NODES(1,NSUBE+6)=NELTYP

          DO 301 I=1,3
            NNODES(NSUBE+I)=NND
            NNODES(NSUBE+3+I)=1
301       CONTINUE
          NSUBE= NSUBE + 3 + 3

          GOTO 9999
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** quadrilateral :                                             ***
C**     ---------------                                             ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN

          IF( NSMAX .LT. 1+4+4 )THEN
           ERR=10010
           RETURN
          ENDIF

C****** FITTING NELTYP ? ***
          NND=INT(SQRT(DBLE(NELTYP)+0.5))
          IF (NND**2.NE.NELTYP) THEN
            ERR=10003
            RETURN
          ENDIF
          ERR=0

          DO 400 I=1,NND
            NODES(I,NSUBE+1)=I
            NODES(I,NSUBE+2)=I*NND
            NODES(I,NSUBE+3)=NELTYP-I+1
            NODES(I,NSUBE+4)=NELTYP-I*NND+1
400       CONTINUE
          NODES(1,NSUBE+5)=1
          NODES(1,NSUBE+6)=NND
          NODES(1,NSUBE+7)=NELTYP
          NODES(1,NSUBE+8)=NND*(NND-1)+1

          DO 410 I=1,4
            NNODES(NSUBE+I)=NND
            NNODES(NSUBE+I+4)=1
410       CONTINUE
          NSUBE= NSUBE + 4 + 4

          GOTO 9999
        ENDIF
C**                                                                 ***
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN
        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** tetrahedron :                                               ***
C**     -------------                                               ***
C**                                                                 ***
        IF( FORM .EQ .4 )THEN

        IF( NSMAX .LT. 1+4+6+4 )THEN
          ERR=10010
          RETURN
        ENDIF

C****** FIND NUMBER OF NODES PER NODES: ***
          NND=0
4400      NND=NND+1
          MUELL=(NND**3 + 3*NND**2 + 2*NND)/6
          IF (MUELL.LT.NELTYP) GOTO 4400
          IF (MUELL.NE.NELTYP) THEN
            ERR=10003
            RETURN
          ENDIF
          ERR=0

C*************
C**  FACES  **
C*************
C*** CUT THE TETRAHEDON IN LEVELS, FIRST BASE TRIANGLE  ***

            LEVNEL=(NND**2+NND)/2
            N=0
            DO 4401 I=1,NND
              DO 4411 J=0,(NND-I)
                N=N+1
                NODES(N,NSUBE+1) = LEVNEL -((NND-I)**2 +NND-I)/2 -J
4411          CONTINUE
4401        CONTINUE
            NNODES(NSUBE+1)=LEVNEL
            NSUBE=NSUBE+1

            N=0
            DO 4402 I=0,NND-1

C**     *** NODES ON THE EDGES OF THE UPPER TETRAHEDON: ***
              UPNODE = NND-I
C**     *** LEFT NODES UNDER UPPER TETRAHEDON: ***
              UPNELT=NELTYP-(UPNODE**3 +3*UPNODE**2 +2*UPNODE)/6
C**     *** NUMBER OF NODES IN ACTUAL LEVEL ***
              LEVNEL=(UPNODE**2+UPNODE)/2

              DO 4412 J=1,UPNODE
                N=N+1
                NODES(N,NSUBE+1)=UPNELT+ J
                NODES(N,NSUBE+2)=UPNELT+LEVNEL
     &                         -((UPNODE-J)**2 +(UPNODE-J))/2
                NODES(N,NSUBE+3)=UPNELT+LEVNEL - (J**2+J)/2+1
4412          CONTINUE
4402        CONTINUE
            NNODES(NSUBE+1)=N
            NNODES(NSUBE+2)=N
            NNODES(NSUBE+3)=N
            NSUBE=NSUBE+3

C*************
C**  EDGES  **
C*************
            LEVNEL=(NND**2+NND)/2
            DO 4403 I=1,NND
              NODES(I,NSUBE+1)=I
              NODES(I,NSUBE+2)=LEVNEL-((NND-I)**2   +(NND-I))/2
              NODES(I,NSUBE+3)=LEVNEL-((I      )**2   +(I      ))/2 + 1
4403        CONTINUE

            DO 4404 I=0,NND-1

C**     *** NODES ON THE EDGES OF THE UPPER TETRAHEDON: ***
              UPNODE = NND-I
C**     *** LEFT NODES UNDER UPPER TETRAHEDON: ***
              UPNELT=NELTYP-(UPNODE**3 +3*UPNODE**2 +2*UPNODE)/6
C**     *** NUMBER OF NODES IN ACTUAL LEVEL ***
              LEVNEL=(UPNODE**2+UPNODE)/2

              NODES(I+1,NSUBE+4)=UPNELT+1
              NODES(I+1,NSUBE+5)=UPNELT+UPNODE
              NODES(I+1,NSUBE+6)=UPNELT+LEVNEL
4404        CONTINUE

            DO 4405 I=1,6
              NNODES(NSUBE+I)=NND
4405        CONTINUE
            NSUBE=NSUBE+6

C***************
C**  VERTEXS  **
C***************
            NODES(1,NSUBE+1)=1
            NODES(1,NSUBE+2)=NND
            NODES(1,NSUBE+3)=(NND**2+NND)/2
            NODES(1,NSUBE+4)=NELTYP
            NNODES(NSUBE+1)=1
            NNODES(NSUBE+2)=1
            NNODES(NSUBE+3)=1
            NNODES(NSUBE+4)=1
            NSUBE=NSUBE+4

            GOTO 9999
          ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism:                                                      ***
C**     ------                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN

          IF( NSMAX .LT. 1+5+9+6 )THEN
            ERR=10010
            RETURN
          ENDIF

C** *** FIND NUMBER OF NODES PER NODES AND LEVEL ***
          NND=0
600       NND=NND+1
          LEVNEL=(NND**2 + NND)/2
          MUELL=NND * LEVNEL
          IF (MUELL.LT.NELTYP) GOTO 600
          IF (MUELL.NE.NELTYP) THEN
            ERR=10003
            RETURN
          ENDIF
          ERR=0

C*************
C**  FACES  **
C*************
            N=0
            DO 601 I=1,NND
              DO 611 J=0,(NND-I)
                N=N+1
                NODES(N,NSUBE+1)= LEVNEL - ((NND-I)**2 +(NND-I))/2 -J
                NODES(N,NSUBE+2)= (NND-1) * LEVNEL + N
611          CONTINUE
601        CONTINUE
           NNODES(NSUBE+1)=LEVNEL
           NNODES(NSUBE+2)=LEVNEL
           NSUBE=NSUBE+2

           N=0
           DO 602 I=0,NND-1
             DO 612 J=1,NND
               N=N+1
               NODES(N,NSUBE+1)=I * LEVNEL + J
               NODES(N,NSUBE+2)=I * LEVNEL
     &                        + LEVNEL-((NND-J)**2   +(NND-J))/2
               NODES(N,NSUBE+3)=I * LEVNEL + LEVNEL - (J**2 + J)/2 + 1
612          CONTINUE
602       CONTINUE
          NNODES(NSUBE+1)=NND**2
          NNODES(NSUBE+2)=NND**2
          NNODES(NSUBE+3)=NND**2
          NSUBE=NSUBE+3

C*************
C**  EDGES  **
C*************
          DO 603 I=1,NND
            NODES(I,NSUBE+1)=I
            NODES(I,NSUBE+2)=LEVNEL-((NND-I)**2   +(NND-I))/2
            NODES(I,NSUBE+3)=LEVNEL-((I      )**2   +(I      ))/2 + 1
            NODES(I,NSUBE+4)=(I-1)*LEVNEL + 1
            NODES(I,NSUBE+5)=(I-1)*LEVNEL + NND
            NODES(I,NSUBE+6)=(I-1)*LEVNEL + LEVNEL
            NODES(I,NSUBE+7)=(NND-1) * LEVNEL + I
            NODES(I,NSUBE+8)=(NND-1) * LEVNEL
     &                     +LEVNEL-((NND-I)**2   +(NND-I))/2
            NODES(I,NSUBE+9)=(NND-1) * LEVNEL
     &                     +LEVNEL-(I**2 + I)/2 + 1
603       CONTINUE

          DO 604 I=1,9
            NNODES(NSUBE+I)=NND
604       CONTINUE

          NSUBE = NSUBE + 9

C***************
C**  VERTEXS  **
C***************
          NODES(1,NSUBE+1)=1
          NODES(1,NSUBE+2)=NND
          NODES(1,NSUBE+3)=LEVNEL
          NODES(1,NSUBE+4)=(NND-1)*LEVNEL+1
          NODES(1,NSUBE+5)=(NND-1)*LEVNEL+NND
          NODES(1,NSUBE+6)=NELTYP

          DO 605 I=1,6
            NNODES(NSUBE+I)=1
605       CONTINUE

          NSUBE=NSUBE+6

          GOTO 9999
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN

          IF (NSMAX.LT.1+6+12+8) THEN
           ERR=10010
           RETURN
          ENDIF

C**                                                                 ***
C******** correct NELTYP ?                                          ***
C**                                                                 ***
          NND=INT(DBLE(NELTYP)**(1./3.)+0.5)
          IF (NND**3.NE.NELTYP) THEN
            ERR=10003
            RETURN
          ENDIF
          ERR=0

C**  ****************************************************************
C**  *** OFFSET AND STEP WIDTH BETWEEN THE NODES ON THE FACES     ***
C**  *** ALONG THE EDGES                                          ***
C**  *** NUMBER OF FACES: 1 BOTTOM,  2 LID,         3 RIGHT SIDE  ***
C**  ***                  4 BACK,    5 LEFT SIDE,   6 FRONT       ***
C**  *** HSTEP == RIGHT,    VSTEP == UP,    VHSTEP == DEEP        ***
C**  ****************************************************************

          OFFSET(1)=NND*(NND-1)+1
          OFFSET(2)=NND*NND*(NND-1)+1
          OFFSET(3)=NND
          OFFSET(4)=NND*NND*NND
          OFFSET(5)=NND*(NND-1)+1
          OFFSET(6)=1
          DO 801 I=1,6
            HSTEP(I)=1
            VSTEP(I)=NND*NND
801       CONTINUE
          HSTEP(3)=NND
          HSTEP(4)=-NND*NND
          HSTEP(5)=-NND
          VSTEP(1)=-NND
          VSTEP(2)=NND
          VSTEP(4)=-1
          VHSTEP(1)=NND*NND
          VHSTEP(2)=-NND*NND
          VHSTEP(3)=-1
          VHSTEP(4)=-NND

C*************
C**  FACES  **
C*************
          DO 810 I=1,6
            NSUBE=NSUBE+1
            N=0
            DO 811 J=0,NND-1
              DO 812 K=0,NND-1
                N=N+1
                NODES(N,NSUBE)=OFFSET(I)+J*VSTEP(I)+K*HSTEP(I)
812           CONTINUE
811         CONTINUE
            NNODES(NSUBE)=NND*NND
810       CONTINUE

C*************
C**  EDGES  **
C*************
          DO 820 I=1,4
            DO 821 J=0, NND-1
              N=J+1
              NODES(N,NSUBE+1)=OFFSET(I)+J*HSTEP(I)
              NODES(N,NSUBE+2)=OFFSET(I)+J*VSTEP(I)
              NODES(N,NSUBE+3)=OFFSET(I)+J*VHSTEP(I)
821         CONTINUE
            NNODES(NSUBE+1)=NND
            NNODES(NSUBE+2)=NND
            NNODES(NSUBE+3)=NND
            NSUBE=NSUBE+3
820       CONTINUE

C***************
C**  VERTEXS  **
C*************** Calculation IN 2 STEPS: 0==BOTTOM, 1==LID *
          DO 830 I=0,1
            OFF=I*NND*NND*(NND-1)
            NODES(1,NSUBE+1)=OFF+1
            NODES(1,NSUBE+2)=OFF+NND
            NODES(1,NSUBE+3)=OFF+NND*NND
            NODES(1,NSUBE+4)=OFF+NND*(NND-1)+1
            NNODES(NSUBE+1)=1
            NNODES(NSUBE+2)=1
            NNODES(NSUBE+3)=1
            NNODES(NSUBE+4)=1
            NSUBE=NSUBE+4
830       CONTINUE
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
9999  ERR=0
      R E T U R N
C-----End of VEMSLP ---------------------------------------------------
      E    N    D
