C**:::      ,,,,,VEMSSH.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMSSH(CLASS,FORM,GEOTYP,NSUBE,NSMAX,EDGE,NEDGE,
     &                  LIWORK,IWORK,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMSSH  sets list of local nodes in elements in the element  ***
C**            tree (=element, face, edge, nodes) for the           ***
C**            shape functions.                                     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           GEOTYP,CLASS,FORM,NSUBE,NSMAX,LIWORK,ERR
      INTEGER           EDGE(GEOTYP,NSMAX),NEDGE(NSMAX),IWORK(LIWORK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of the element
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of proposal functions
C--------I------I-----I------------------------------------------------
C NSUBE  I  I   I out I number of elements in the tree
C--------I------I-----I------------------------------------------------
C NODES  I  I   I out I list of the nodes in the elements in the 
C        I      I     I tree                 array: NODES(GEOTYP,NSMAX)
C--------I------I-----I------------------------------------------------
C NNODES I  I   I out I number of nodes in the elements in the tree
C        I      I     I                            array: NNODES(NSMAX)
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I -   I integer work array         array: IWORK(LIWORK)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I ERROR NUMBER
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10003   illegal GEOTYP
C        I      I     I 10010   too small storage
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           I,J,NODES
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**                                                                 ***
      ERR=10000

      IF (GEOTYP.LT.1) THEN
        ERR=10003
        RETURN
      ENDIF

      IF (NSMAX.LT.1) THEN
        ERR=10010
        RETURN
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** first element in tree is the element itself:                  ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      DO 10 I=1,GEOTYP
10      EDGE(I,1)=I
      NEDGE(1)=GEOTYP
      NSUBE=1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN

        IF (GEOTYP.GT.1) THEN
          ERR=10003
          RETURN
        ENDIF

        NSUBE=0
        GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN

        IF (NSMAX.LT.1+2) THEN
          ERR=10010
          RETURN
        ENDIF

        GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle and quadriliteral:                                 ***
C**     --------------------------                                  ***
C**                                                                 ***
        IF ( (FORM .EQ. 3).OR.(FORM .EQ. 4) ) THEN

          IF( NSMAX.LT.(FORM+FORM+1) )THEN
           ERR=10010
           RETURN
          ENDIF

          NODES = INT(GEOTYP/FORM)+1

          IF( FORM.EQ.4 )THEN
            IF( GEOTYP.EQ.9 )THEN
              NODES = 3
              GOTO 399
            ENDIF
            IF( GEOTYP.EQ.16 )THEN
              NODES=4
              GOTO 399
            ENDIF
          ENDIF

          IF( FORM.EQ.3 )THEN
            IF( GEOTYP.EQ.10 )THEN
              NODES=4
              GOTO 399
            ENDIF
          ENDIF

          IF( FORM*(NODES-1).NE.GEOTYP ) THEN
            ERR=10003
            RETURN
          ENDIF

399       ERR=0

          DO 300 I=1,FORM
            EDGE(1,NSUBE+I)=I
            IF (I.EQ.FORM) THEN
              EDGE(2,NSUBE+I)=1
            ELSE
              EDGE(2,NSUBE+I)=I+1
            ENDIF
            DO 310 J=3,NODES
              EDGE(J,NSUBE+I)=FORM+(I-1)*(NODES-2)+J-2
310         CONTINUE
300       CONTINUE

          DO 301 I=1,FORM
            NEDGE(NSUBE+I)=NODES
301       CONTINUE
          NSUBE=NSUBE+FORM

        GOTO 9999
        ENDIF

        ERR=10001
        RETURN
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** tetrahedron :                                               ***
C**     -------------                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN

          IF (NSMAX.LT.4+6+4+1) THEN
           ERR=10010
           RETURN
          ENDIF

          IF( GEOTYP.EQ.4) THEN
            ERR=0
            EDGE(1,NSUBE+1)=2
            EDGE(2,NSUBE+1)=1
            EDGE(3,NSUBE+1)=3
            NEDGE(NSUBE+1)=3

            EDGE(1,NSUBE+2)=1
            EDGE(2,NSUBE+2)=2
            EDGE(3,NSUBE+2)=4
            NEDGE(NSUBE+2)=3

            EDGE(1,NSUBE+3)=2
            EDGE(2,NSUBE+3)=3
            EDGE(3,NSUBE+3)=4
            NEDGE(NSUBE+3)=3

            EDGE(1,NSUBE+4)=3
            EDGE(2,NSUBE+4)=1
            EDGE(3,NSUBE+4)=4
            NEDGE(NSUBE+4)=3

            NSUBE=NSUBE+4

            EDGE(1,NSUBE+1)=1
            EDGE(2,NSUBE+1)=2
            NEDGE(NSUBE+1)=2

            EDGE(1,NSUBE+2)=2
            EDGE(2,NSUBE+2)=3
            NEDGE(NSUBE+2)=2

            EDGE(1,NSUBE+3)=3
            EDGE(2,NSUBE+3)=1
            NEDGE(NSUBE+3)=2

            EDGE(1,NSUBE+4)=1
            EDGE(2,NSUBE+4)=4
            NEDGE(NSUBE+4)=2

            EDGE(1,NSUBE+5)=2
            EDGE(2,NSUBE+5)=4
            NEDGE(NSUBE+5)=2

            EDGE(1,NSUBE+6)=3
            EDGE(2,NSUBE+6)=4
            NEDGE(NSUBE+6)=2

            NSUBE=NSUBE+6

            GOTO 9999
          ENDIF

          IF( GEOTYP.EQ.10 )THEN
            ERR=0
            EDGE(1,NSUBE+1)=2
            EDGE(2,NSUBE+1)=1
            EDGE(3,NSUBE+1)=3
            EDGE(4,NSUBE+1)=5
            EDGE(5,NSUBE+1)=7
            EDGE(6,NSUBE+1)=6
            NEDGE(NSUBE+1)=6

            EDGE(1,NSUBE+2)=1
            EDGE(2,NSUBE+2)=2
            EDGE(3,NSUBE+2)=4
            EDGE(4,NSUBE+2)=5
            EDGE(5,NSUBE+2)=9
            EDGE(6,NSUBE+2)=8
            NEDGE(NSUBE+2)=6

            EDGE(1,NSUBE+3)=2
            EDGE(2,NSUBE+3)=3
            EDGE(3,NSUBE+3)=4
            EDGE(4,NSUBE+3)=6
            EDGE(5,NSUBE+3)=10
            EDGE(6,NSUBE+3)=9
            NEDGE(NSUBE+3)=6

            EDGE(1,NSUBE+4)=3
            EDGE(2,NSUBE+4)=1
            EDGE(3,NSUBE+4)=4
            EDGE(4,NSUBE+4)=7
            EDGE(5,NSUBE+4)=8
            EDGE(6,NSUBE+4)=10
            NEDGE(NSUBE+4)=6

            NSUBE=NSUBE+4

            EDGE(1,NSUBE+1)=1
            EDGE(2,NSUBE+1)=2
            EDGE(3,NSUBE+1)=5
            NEDGE(NSUBE+1)=3

            EDGE(1,NSUBE+2)=2
            EDGE(2,NSUBE+2)=3
            EDGE(3,NSUBE+2)=6
            NEDGE(NSUBE+2)=3

            EDGE(1,NSUBE+3)=3
            EDGE(2,NSUBE+3)=1
            EDGE(3,NSUBE+3)=7
            NEDGE(NSUBE+3)=3

            EDGE(1,NSUBE+4)=1
            EDGE(2,NSUBE+4)=4
            EDGE(3,NSUBE+4)=8
            NEDGE(NSUBE+4)=3

            EDGE(1,NSUBE+5)=2
            EDGE(2,NSUBE+5)=4
            EDGE(3,NSUBE+5)=9
            NEDGE(NSUBE+5)=3

            EDGE(1,NSUBE+6)=3
            EDGE(2,NSUBE+6)=4
            EDGE(3,NSUBE+6)=10
            NEDGE(NSUBE+6)=3

            NSUBE=NSUBE+6

            GOTO 9999
          ENDIF

          ERR=10003
          RETURN
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism:                                                      ***
C**     ------                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN

          IF (NSMAX.LT.1+5+9+6) THEN
           ERR=10010
           RETURN
          ENDIF

          IF( GEOTYP.EQ.6 )THEN
            ERR=0
            EDGE(1,NSUBE+1)=2
            EDGE(2,NSUBE+1)=1
            EDGE(3,NSUBE+1)=3
            NEDGE(NSUBE+1)=3

            EDGE(1,NSUBE+2)=4
            EDGE(2,NSUBE+2)=5
            EDGE(3,NSUBE+2)=6
            NEDGE(NSUBE+2)=3

            EDGE(1,NSUBE+3)=1
            EDGE(2,NSUBE+3)=2
            EDGE(3,NSUBE+3)=5
            EDGE(4,NSUBE+3)=4
            NEDGE(NSUBE+3)=4

            EDGE(1,NSUBE+4)=2
            EDGE(2,NSUBE+4)=3
            EDGE(3,NSUBE+4)=6
            EDGE(4,NSUBE+4)=5
            NEDGE(NSUBE+4)=4

            EDGE(1,NSUBE+5)=3
            EDGE(2,NSUBE+5)=1
            EDGE(3,NSUBE+5)=4
            EDGE(4,NSUBE+5)=6
            NEDGE(NSUBE+5)=4

            NSUBE=NSUBE+5

            EDGE(1,NSUBE+1)=1
            EDGE(2,NSUBE+1)=2
            NEDGE(NSUBE+1)=2

            EDGE(1,NSUBE+2)=2
            EDGE(2,NSUBE+2)=3
            NEDGE(NSUBE+2)=2

            EDGE(1,NSUBE+3)=3
            EDGE(2,NSUBE+3)=1
            NEDGE(NSUBE+3)=2

            EDGE(1,NSUBE+4)=1
            EDGE(2,NSUBE+4)=4
            NEDGE(NSUBE+4)=2

            EDGE(1,NSUBE+5)=2
            EDGE(2,NSUBE+5)=5
            NEDGE(NSUBE+5)=2

            EDGE(1,NSUBE+6)=3
            EDGE(2,NSUBE+6)=6
            NEDGE(NSUBE+6)=2

            EDGE(1,NSUBE+7)=4
            EDGE(2,NSUBE+7)=5
            NEDGE(NSUBE+7)=2

            EDGE(1,NSUBE+8)=5
            EDGE(2,NSUBE+8)=6
            NEDGE(NSUBE+8)=2

            EDGE(1,NSUBE+9)=6
            EDGE(2,NSUBE+9)=4
            NEDGE(NSUBE+9)=2

            NSUBE=NSUBE+9

            GOTO 9999
          ENDIF

          IF( GEOTYP.EQ.15 )THEN
            ERR=0
            EDGE(1,NSUBE+1)=2
            EDGE(2,NSUBE+1)=1
            EDGE(3,NSUBE+1)=3
            EDGE(4,NSUBE+1)=5
            EDGE(5,NSUBE+1)=7
            EDGE(6,NSUBE+1)=6
            NEDGE(NSUBE+1)=6

            EDGE(1,NSUBE+2)=4
            EDGE(2,NSUBE+2)=5
            EDGE(3,NSUBE+2)=6
            EDGE(4,NSUBE+2)=13
            EDGE(5,NSUBE+2)=14
            EDGE(6,NSUBE+2)=15
            NEDGE(NSUBE+2)=6

            EDGE(1,NSUBE+3)=1
            EDGE(2,NSUBE+3)=2
            EDGE(3,NSUBE+3)=5
            EDGE(4,NSUBE+3)=4
            EDGE(5,NSUBE+3)=7
            EDGE(6,NSUBE+3)=11
            EDGE(7,NSUBE+3)=13
            EDGE(8,NSUBE+3)=10
            NEDGE(NSUBE+3)=8

            EDGE(1,NSUBE+4)=2
            EDGE(2,NSUBE+4)=3
            EDGE(3,NSUBE+4)=6
            EDGE(4,NSUBE+4)=5
            EDGE(5,NSUBE+4)=8
            EDGE(6,NSUBE+4)=12
            EDGE(7,NSUBE+4)=14
            EDGE(8,NSUBE+4)=11
            NEDGE(NSUBE+4)=8

            EDGE(1,NSUBE+5)=3
            EDGE(2,NSUBE+5)=1
            EDGE(3,NSUBE+5)=4
            EDGE(4,NSUBE+5)=6
            EDGE(5,NSUBE+5)=9
            EDGE(6,NSUBE+5)=10
            EDGE(7,NSUBE+5)=15
            EDGE(8,NSUBE+5)=12
            NEDGE(NSUBE+5)=8

            NSUBE=NSUBE+5

            EDGE(1,NSUBE+1)=1
            EDGE(2,NSUBE+1)=2
            EDGE(3,NSUBE+1)=7
            NEDGE(NSUBE+1)=3

            EDGE(1,NSUBE+2)=2
            EDGE(2,NSUBE+2)=3
            EDGE(3,NSUBE+2)=8
            NEDGE(NSUBE+2)=3

            EDGE(1,NSUBE+3)=3
            EDGE(2,NSUBE+3)=1
            EDGE(3,NSUBE+3)=9
            NEDGE(NSUBE+3)=3

            EDGE(1,NSUBE+4)=1
            EDGE(2,NSUBE+4)=4
            EDGE(3,NSUBE+4)=10
            NEDGE(NSUBE+4)=3

            EDGE(1,NSUBE+5)=2
            EDGE(2,NSUBE+5)=5
            EDGE(3,NSUBE+5)=11
            NEDGE(NSUBE+5)=3

            EDGE(1,NSUBE+6)=3
            EDGE(2,NSUBE+6)=6
            EDGE(3,NSUBE+6)=12
            NEDGE(NSUBE+6)=3

            EDGE(1,NSUBE+7)=4
            EDGE(2,NSUBE+7)=5
            EDGE(3,NSUBE+7)=13
            NEDGE(NSUBE+7)=3

            EDGE(1,NSUBE+8)=5
            EDGE(2,NSUBE+8)=6
            EDGE(3,NSUBE+8)=14
            NEDGE(NSUBE+8)=3

            EDGE(1,NSUBE+9)=6
            EDGE(2,NSUBE+9)=4
            EDGE(3,NSUBE+9)=15
            NEDGE(NSUBE+9)=3

            NSUBE=NSUBE+9

            GOTO 9999
          ENDIF

          ERR=10003
          RETURN
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN

          IF (NSMAX.LT.1+6+12+8) THEN
            ERR=10010
            RETURN
          ENDIF

          IF( GEOTYP.EQ.8 )THEN
            ERR=0
            EDGE(1,NSUBE+1)=4
            EDGE(2,NSUBE+1)=3
            EDGE(3,NSUBE+1)=2
            EDGE(4,NSUBE+1)=1
            NEDGE(NSUBE+1)=4

            EDGE(1,NSUBE+2)=5
            EDGE(2,NSUBE+2)=6
            EDGE(3,NSUBE+2)=7
            EDGE(4,NSUBE+2)=8
            NEDGE(NSUBE+2)=4

            EDGE(1,NSUBE+3)=2
            EDGE(2,NSUBE+3)=3
            EDGE(3,NSUBE+3)=7
            EDGE(4,NSUBE+3)=6
            NEDGE(NSUBE+3)=4

            EDGE(1,NSUBE+4)=7
            EDGE(2,NSUBE+4)=3
            EDGE(3,NSUBE+4)=4
            EDGE(4,NSUBE+4)=8
            NEDGE(NSUBE+4)=4

            EDGE(1,NSUBE+5)=4
            EDGE(2,NSUBE+5)=1
            EDGE(3,NSUBE+5)=5
            EDGE(4,NSUBE+5)=8
            NEDGE(NSUBE+5)=4

            EDGE(1,NSUBE+6)=1
            EDGE(2,NSUBE+6)=2
            EDGE(3,NSUBE+6)=6
            EDGE(4,NSUBE+6)=5
            NEDGE(NSUBE+6)=4

            NSUBE=NSUBE+6

            EDGE(1,NSUBE+1)=4
            EDGE(2,NSUBE+1)=3
            NEDGE(NSUBE+1)=2

            EDGE(1,NSUBE+2)=4
            EDGE(2,NSUBE+2)=1
            NEDGE(NSUBE+2)=2

            EDGE(1,NSUBE+3)=4
            EDGE(2,NSUBE+3)=8
            NEDGE(NSUBE+3)=2

            EDGE(1,NSUBE+4)=5
            EDGE(2,NSUBE+4)=6
            NEDGE(NSUBE+4)=2

            EDGE(1,NSUBE+5)=5
            EDGE(2,NSUBE+5)=8
            NEDGE(NSUBE+5)=2

            EDGE(1,NSUBE+6)=5
            EDGE(2,NSUBE+6)=1
            NEDGE(NSUBE+6)=2

            EDGE(1,NSUBE+7)=2
            EDGE(2,NSUBE+7)=3
            NEDGE(NSUBE+7)=2

            EDGE(1,NSUBE+8)=2
            EDGE(2,NSUBE+8)=6
            NEDGE(NSUBE+8)=2

            EDGE(1,NSUBE+9)=2
            EDGE(2,NSUBE+9)=1
            NEDGE(NSUBE+9)=2

            EDGE(1,NSUBE+10)=7
            EDGE(2,NSUBE+10)=3
            NEDGE(NSUBE+10)=2

            EDGE(1,NSUBE+11)=7
            EDGE(2,NSUBE+11)=8
            NEDGE(NSUBE+11)=2

            EDGE(1,NSUBE+12)=7
            EDGE(2,NSUBE+12)=6
            NEDGE(NSUBE+12)=2

            NSUBE=NSUBE+12

            GOTO 9999
          ENDIF

          IF( GEOTYP.EQ.20 )THEN
            ERR=0
            EDGE(1,NSUBE+1)=4
            EDGE(2,NSUBE+1)=3
            EDGE(3,NSUBE+1)=2
            EDGE(4,NSUBE+1)=1
            EDGE(5,NSUBE+1)=11
            EDGE(6,NSUBE+1)=10
            EDGE(7,NSUBE+1)=9
            EDGE(8,NSUBE+1)=12
            NEDGE(NSUBE+1)=8

            EDGE(1,NSUBE+2)=5
            EDGE(2,NSUBE+2)=6
            EDGE(3,NSUBE+2)=7
            EDGE(4,NSUBE+2)=8
            EDGE(5,NSUBE+2)=17
            EDGE(6,NSUBE+2)=18
            EDGE(7,NSUBE+2)=19
            EDGE(8,NSUBE+2)=20
            NEDGE(NSUBE+2)=8

            EDGE(1,NSUBE+3)=2
            EDGE(2,NSUBE+3)=3
            EDGE(3,NSUBE+3)=7
            EDGE(4,NSUBE+3)=6
            EDGE(5,NSUBE+3)=10
            EDGE(6,NSUBE+3)=15
            EDGE(7,NSUBE+3)=18
            EDGE(8,NSUBE+3)=14
            NEDGE(NSUBE+3)=8

            EDGE(1,NSUBE+4)=7
            EDGE(2,NSUBE+4)=3
            EDGE(3,NSUBE+4)=4
            EDGE(4,NSUBE+4)=8
            EDGE(5,NSUBE+4)=15
            EDGE(6,NSUBE+4)=11
            EDGE(7,NSUBE+4)=16
            EDGE(8,NSUBE+4)=19
            NEDGE(NSUBE+4)=8

            EDGE(1,NSUBE+5)=4
            EDGE(2,NSUBE+5)=1
            EDGE(3,NSUBE+5)=5
            EDGE(4,NSUBE+5)=8
            EDGE(5,NSUBE+5)=12
            EDGE(6,NSUBE+5)=13
            EDGE(7,NSUBE+5)=20
            EDGE(8,NSUBE+5)=16
            NEDGE(NSUBE+5)=8

            EDGE(1,NSUBE+6)=1
            EDGE(2,NSUBE+6)=2
            EDGE(3,NSUBE+6)=6
            EDGE(4,NSUBE+6)=5
            EDGE(5,NSUBE+6)=9
            EDGE(6,NSUBE+6)=14
            EDGE(7,NSUBE+6)=17
            EDGE(8,NSUBE+6)=13
            NEDGE(NSUBE+6)=8

            NSUBE=NSUBE+6

            EDGE(1,NSUBE+1)=4
            EDGE(2,NSUBE+1)=3
            EDGE(3,NSUBE+1)=11
            NEDGE(NSUBE+1)=3

            EDGE(1,NSUBE+2)=4
            EDGE(2,NSUBE+2)=1
            EDGE(3,NSUBE+2)=12
            NEDGE(NSUBE+2)=3

            EDGE(1,NSUBE+3)=4
            EDGE(2,NSUBE+3)=8
            EDGE(3,NSUBE+3)=16
            NEDGE(NSUBE+3)=3

            EDGE(1,NSUBE+4)=5
            EDGE(2,NSUBE+4)=6
            EDGE(3,NSUBE+4)=17
            NEDGE(NSUBE+4)=3

            EDGE(1,NSUBE+5)=5
            EDGE(2,NSUBE+5)=8
            EDGE(3,NSUBE+5)=20
            NEDGE(NSUBE+5)=3

            EDGE(1,NSUBE+6)=5
            EDGE(2,NSUBE+6)=1
            EDGE(3,NSUBE+6)=13
            NEDGE(NSUBE+6)=3

            EDGE(1,NSUBE+7)=2
            EDGE(2,NSUBE+7)=3
            EDGE(3,NSUBE+7)=10
            NEDGE(NSUBE+7)=3

            EDGE(1,NSUBE+8)=2
            EDGE(2,NSUBE+8)=6
            EDGE(3,NSUBE+8)=14
            NEDGE(NSUBE+8)=3

            EDGE(1,NSUBE+9)=2
            EDGE(2,NSUBE+9)=1
            EDGE(3,NSUBE+9)=9
            NEDGE(NSUBE+9)=3

            EDGE(1,NSUBE+10)=7
            EDGE(2,NSUBE+10)=3
            EDGE(3,NSUBE+10)=15
            NEDGE(NSUBE+10)=3

            EDGE(1,NSUBE+11)=7
            EDGE(2,NSUBE+11)=8
            EDGE(3,NSUBE+11)=19
            NEDGE(NSUBE+11)=3

            EDGE(1,NSUBE+12)=7
            EDGE(2,NSUBE+12)=6
            EDGE(3,NSUBE+12)=18
            NEDGE(NSUBE+12)=3

            NSUBE=NSUBE+12

            GOTO 9999
          ENDIF

          ERR=10003
          RETURN
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** at last the nodal elements:                                   ***
C**   --------------------------                                    ***
C**                                                                 ***
9999  DO 20 I=1,FORM
        NEDGE(NSUBE+I)=1
20      EDGE(1,NSUBE+I)=I

      NSUBE=NSUBE+FORM
      ERR=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMSSH ---------------------------------------------------
      E    N    D
