C:::::      ,,,,,VEMU01...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU01(LIVEM,IVEM,LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                  LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                  LBIG,RBIG,IBIG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU01    print the mesh arrays                            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"
      include "archi.h"
      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,LNODN,
     &                  LDNOD,LRDPRM,LIDPRM,LNOD,LNOPRM,LBIG

      DOUBLE PRECISION  RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  DNOD(LDNOD),IDPARM(LIDPRM),IBIG(RPI*LBIG)
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                    >                                            ***
      DOUBLE PRECISION  RMARK,TIME,VEMSCD
      INTEGER           LOUT,OUTCNT,ERR,IERR(1),MESH,NDEG,NINFO,SUMNDC,
     &                  ONEIO,LIVE1,IVE1,LNE1,NE1,LRPR1,RPAR1,LIPR1,I,
     &                  IPAR1,LDNO1,DNO1,LRDPR1,RDPAR1,LIDPR1,IDPAR1,
     &                  LNOD1,NODNU1,LNO1,NO1,LNOPR1,NOPAR1,NIVE1,NNE1,
     &                  NRPR1,NIPR1,NDNO1,NRDPR1,NIDPR1,NNO1,NNOPR1,
     &                  NDEG1,IERR12,MYPROC,NPROC,MYTID,IOTID,SUMNE,
     &                  TID,INFO,TOKEN(1),NNOD,NNOPRM,NNEK,NRPRM,TIDS,
     &                  NIPRM,NDNOD,NRDPRM,NIDPRM,NIVEM,NBIG,NMSG,
     &                  MIDS,MIDR,ARRLEN(2,10),MID(10),NDEGL,NDEG0L,
     &                  IH1(3),OUTPUT,DIS,DIM,MPINFO,SBT,
     &                  LBFIE,LBFRE,LBFE,LBFIN,LBFRN,LBFN,K,NK,OWN,
     &                  LBFID,LBFRD,LBFD,RBUF,IBUF,BUF,NN,NOP1,NOP,
     &                  NMAX,NMIN,DINFO,DINFO1,GINFO,GINFO1,NGROUP,
     &                  NINFO1,SORTI,LLNGTH(16),NLNGTH(16)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT=IVEM(20)
      TIDS=204
      IF ((ARCHI.LT.10).OR.(IVEM(200).EQ.1)) THEN
	IVEM(200)=1
	IVEM(201)=1
	IVEM(TIDS-1)=1
	IVEM(TIDS)=1
      ENDIF
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=0
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9300)
	IVEM(2)=99
	RETURN
      ENDIF
      ERR=0
      TIME=VEMSCD()
      ONEIO=IVEM(22)
      IF (LOUT.LE.0) LOUT=6
      OUTCNT=MAX(0,IVEM(21))
      RMARK=DBLE(OUTCNT)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      NBIG=0
      MESH=IVEM(1)
      IF ((ONEIO.EQ.1).AND.(MYTID.NE.IOTID)) THEN
        IH1(1)=0
      ELSE
        IH1(1)=OUTCNT
      ENDIF
      CALL LL4INM(1,1,1,IH1(1),IH1(2),IH1(3),MYPROC,NPROC,
     &                                          IVEM(TIDS),IVEM(NMSG))
      OUTPUT=IH1(2)
      CALL VEM000('VEMU01',OUTCNT,LOUT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print mesh infos :                                            ***
C**   ----------------                                              ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,0,IERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      CALL VEM098('VEMU01',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      NDEG  =IVEM(MESH+1)
      NK    =IVEM(MESH+2)
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      NNEK  =IVEM(MESH+6)
      NRPRM =IVEM(MESH+7)
      NIPRM =IVEM(MESH+8)
      NDNOD =IVEM(MESH+9)
      NRDPRM=IVEM(MESH+10)
      NIDPRM=IVEM(MESH+11)
      NINFO =IVEM(MESH+12)
      NOP1  =IVEM(MESH+13)
      NOP   =IVEM(MESH+14)
      OWN   =IVEM(MESH+15)
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      DINFO =IVEM(MESH+23)+MESH
      DINFO1=IVEM(MESH+24)
      DIS=IVEM(MESH+18)
      SORTI=IVEM(MESH+19)
      NNOD  =IVEM(MESH+3)*IVEM(MESH+5)
      NNOPRM=IVEM(MESH+13)*IVEM(MESH+14)

      NIVEM=MESH+IVEM(MESH+12)
      IVEM(5)=NIVEM
      IF (DIS.EQ.220964) THEN
	NINFO1=SORTI+1+3*NPROC+NGROUP+IVEM(MESH+SORTI+1)+MESH
      ELSE
        NINFO1=MAX(GINFO+GINFO1*NGROUP,DINFO+DINFO1*NK)
      ENDIF
      SUMNE=NINFO1+3
      SUMNDC=SUMNE+NGROUP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      IF (OUTPUT.NE.0) THEN
        IF (ONEIO.EQ.0) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** every process prints its own mesh:                          ***
C**     --------------------------------                            ***
C**                                                                 ***
          IF (OUTCNT.NE.0) THEN
            WRITE (LOUT,9040) MYPROC,MYTID
            CALL VEMU20(LIVEM,IVEM,LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                  LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM)
	  ENDIF
C**                                                                 ***
        ELSEIF (ONEIO.EQ.1) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**     all meshes are printed on one process :                     ***
C**     --------------------------------------                      ***
C**                                                                 ***
	  IF (MYTID.EQ.IOTID) THEN
            DO 1000 I=1,NPROC
	      TID=IVEM(TIDS-1+I)
              WRITE (LOUT,9040) I,TID
	      IF (TID.EQ.IOTID) THEN
               CALL VEMU20(LIVEM,IVEM,LNEK,NEK,LRPARM,RPARM,LIPARM,
     &                     IPARM,LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,
     &   		   IDPARM,LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM)
	      ELSE
	       CALL MPSNDA(TID,IVEM(NMSG)+I,IINT,TOKEN,MIDS,INFO)
	       CALL MPSNDW(TID,IVEM(NMSG)+I,IINT,TOKEN,MIDS,INFO)
 	       CALL MPRCVA(TID,IVEM(NMSG)+I+NPROC,IINT*2*10,ARRLEN,
     &                                                       MIDR,INFO)
	       CALL MPRCVW(TID,IVEM(NMSG)+I+NPROC,IINT*2*10,ARRLEN,
     &                                                       MIDR,INFO)
		
	       LIVE1=ARRLEN(1,1)
	       NIVE1=ARRLEN(2,1)
	       LNE1=ARRLEN(1,2)
	       NNE1=ARRLEN(2,2)
	       LRPR1=ARRLEN(1,3)
	       NRPR1=ARRLEN(2,3)
	       LIPR1=ARRLEN(1,4)
	       NIPR1=ARRLEN(2,4)
	       LDNO1=ARRLEN(1,5)
	       NDNO1=ARRLEN(2,5)
	       LRDPR1=ARRLEN(1,6)
	       NRDPR1=ARRLEN(2,6)
	       LIDPR1=ARRLEN(1,7)
	       NIDPR1=ARRLEN(2,7)
	       LNOD1=ARRLEN(1,8)
	       NDEG1=ARRLEN(2,8)
	       LNO1=ARRLEN(1,9)
	       NNO1=ARRLEN(2,9)
	       LNOPR1=ARRLEN(1,10)
	       NNOPR1=ARRLEN(2,10)
               IERR12=0
	
               IVE1=1	
	       NE1=IVE1+LIVE1
	       RPAR1=(NE1+LNE1-1+RPI)/RPI+1
	       IPAR1=(RPAR1+LRPR1-1)*RPI+1
	       DNO1=IPAR1+LIPR1
	       RDPAR1=(DNO1+LDNO1-1+RPI)/RPI+1
               IDPAR1=(RDPAR1+LRDPR1-1)*RPI+1
	       NODNU1=IDPAR1+LIDPR1
	       NO1=(NODNU1+LNOD1-1+RPI)/RPI+1
	       NOPAR1=NO1+LNO1
	
	       NBIG=MAX(NBIG,NOPAR1+LNOPR1-1)
	       IF (NBIG.GT.LBIG) THEN
		 IERR(1)=90
               ELSE
		 IERR(1)=0
	       ENDIF
	       CALL MPSNDA(TID,IVEM(NMSG)+I+NPROC*2,IINT,IERR,
     &                                                   MIDR,INFO)
	       CALL MPSNDW(TID,IVEM(NMSG)+I+NPROC*2,IINT,IERR,
     &                                                   MIDR,INFO)
	       IF (IERR(1).EQ.0) THEN
C**                                                                 ***
	        CALL MPRCVA(TID,IVEM(NMSG)+I+NPROC*3,IINT*NIVE1,
     &                                          IBIG(IVE1),MID(1),INFO)
	        CALL MPRCVA(TID,IVEM(NMSG)+I+NPROC*4,IINT*NNE1,
     &                                           IBIG(NE1),MID(2),INFO)
	        CALL MPRCVA(TID,IVEM(NMSG)+I+NPROC*5,IREAL*NRPR1,
     &                                         RBIG(RPAR1),MID(3),INFO)
	        CALL MPRCVA(TID,IVEM(NMSG)+I+NPROC*6,IINT*NIPR1,
     &                                         IBIG(IPAR1),MID(4),INFO)
	        CALL MPRCVA(TID,IVEM(NMSG)+I+NPROC*7,IINT*NDNO1,
     &                                         IBIG(DNO1),MID(5),INFO)
	        CALL MPRCVA(TID,IVEM(NMSG)+I+NPROC*8,IREAL*NRDPR1,
     &                                       RBIG(RDPAR1),MID(6),INFO)
	        CALL MPRCVA(TID,IVEM(NMSG)+I+NPROC*9,IINT*NIDPR1,
     &                                       IBIG(IDPAR1),MID(7),INFO)
	        CALL MPRCVA(TID,IVEM(NMSG)+I+NPROC*10,IINT*NDEG1,
     &                                        IBIG(NODNU1),MID(8),INFO)
	        CALL MPRCVA(TID,IVEM(NMSG)+I+NPROC*11,IREAL*NNO1,
     &                                         RBIG(NO1),MID(9),INFO)
	        CALL MPRCVA(TID,IVEM(NMSG)+I+NPROC*12,IREAL*NNOPR1,
     &                                     RBIG(NOPAR1),MID(10),INFO)
	        CALL MPRCVW(TID,IVEM(NMSG)+I+NPROC*3,IINT*NIVE1,
     &                                        IBIG(IVE1),MID(1),INFO)
	        CALL MPRCVW(TID,IVEM(NMSG)+I+NPROC*4,IINT*NNE1,
     &                                          IBIG(NE1),MID(2),INFO)
	        CALL MPRCVW(TID,IVEM(NMSG)+I+NPROC*5,IREAL*NRPR1,
     &                                         RBIG(RPAR1),MID(3),INFO)
	        CALL MPRCVW(TID,IVEM(NMSG)+I+NPROC*6,IINT*NIPR1,
     &                                         IBIG(IPAR1),MID(4),INFO)
	        CALL MPRCVW(TID,IVEM(NMSG)+I+NPROC*7,IINT*NDNO1,
     &                                         IBIG(DNO1),MID(5),INFO)
	        CALL MPRCVW(TID,IVEM(NMSG)+I+NPROC*8,IREAL*NRDPR1,
     &                                       RBIG(RDPAR1),MID(6),INFO)
	        CALL MPRCVW(TID,IVEM(NMSG)+I+NPROC*9,IINT*NIDPR1,
     &                                       IBIG(IDPAR1),MID(7),INFO)
	        CALL MPRCVW(TID,IVEM(NMSG)+I+NPROC*10,IINT*NDEG1,
     &                                       IBIG(NODNU1),MID(8),INFO)
	        CALL MPRCVW(TID,IVEM(NMSG)+I+NPROC*11,IREAL*NNO1,
     &                                         RBIG(NO1),MID(9),INFO)
	        CALL MPRCVW(TID,IVEM(NMSG)+I+NPROC*12,IREAL*NNOPR1,
     &                                      RBIG(NOPAR1),MID(10),INFO)
		IVEM(IVE1+19)=LOUT
		IVEM(IVE1+20)=OUTCNT
		IVEM(IVE1+21)=0
                CALL VEMU20(LIVE1,IBIG(IVE1),LNE1,IBIG(NE1),LRPR1,
     &                      RBIG(RPAR1),LIPR1,IBIG(IPAR1),LDNO1,
     &                      IBIG(DNO1),LRDPR1,RBIG(RDPAR1),LIDPR1,
     &                      IBIG(IDPAR1),LNOD1,IBIG(NODNU1),LNO1,
     &                      RBIG(NO1),LNOPR1,RBIG(NOPAR1))
	       ENDIF
	      ENDIF
 1000       CONTINUE
	  ELSE
	    CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
	    ARRLEN(1,1)=LIVEM
	    ARRLEN(2,1)=NIVEM
	    ARRLEN(1,2)=LNEK
	    ARRLEN(2,2)=NNEK
	    ARRLEN(1,3)=LRPARM
	    ARRLEN(2,3)=NRPRM
	    ARRLEN(1,4)=LIPARM
	    ARRLEN(2,4)=NIPRM
	    ARRLEN(1,5)=LDNOD
	    ARRLEN(2,5)=NDNOD
	    ARRLEN(1,6)=LRDPRM
	    ARRLEN(2,6)=NRDPRM
	    ARRLEN(1,7)=LIDPRM
	    ARRLEN(2,7)=NIDPRM
	    ARRLEN(1,8)=LNODN
	    ARRLEN(2,8)=NDEG
	    ARRLEN(1,9)=LNOD
	    ARRLEN(2,9)=NNOD
	    ARRLEN(1,10)=LNOPRM
	    ARRLEN(2,10)=NNOPRM
C**                                                                 ***
	    CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
	    CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC+NPROC*2,IINT,
     &                                               IERR,MIDR,INFO)
            CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC,IINT*2*10,
     &                                                ARRLEN,MIDS,INFO)
	    CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC+NPROC*2,IINT,
     &                                               IERR,MIDR,INFO)
	    IF (IERR(1).EQ.0) THEN
	     CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC*3,IINT*NIVEM,
     &                                               IVEM,MID(1),INFO)
	     CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC*4,IINT*NNEK,
     &                                                NEK,MID(2),INFO)
	     CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC*5,IREAL*NRPRM,
     &                                              RPARM,MID(3),INFO)
	     CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC*6,IINT*NIPRM,
     &                                             IPARM,MID(4),INFO)
	     CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC*7,IINT*NDNOD,
     &                                              DNOD,MID(5),INFO)
	     CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC*8,IREAL*NRDPRM,
     &                                            RDPARM,MID(6),INFO)
	     CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC*9,IINT*NIDPRM,
     &                                            IDPARM,MID(7),INFO)
	     CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC*10,IINT*NDEG,
     &                                            NODNUM,MID(8),INFO)
	     CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC*11,IREAL*NNOD,
     &                                               NOD,MID(9),INFO)
	     CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC*12,IREAL*NNOPRM,
     &                                           NOPARM,MID(10),INFO)
	     CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC*3,IINT*NIVEM,
     &                                           IVEM,MID(1),INFO)
	     CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC*4,IINT*NNEK,
     &                                           NEK,MID(2),INFO)
	     CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC*5,IREAL*NRPRM,
     &                                           RPARM,MID(3),INFO)
	     CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC*6,IINT*NIPRM,
     &                                           IPARM,MID(4),INFO)
	     CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC*7,IINT*NDNOD,
     &                                           DNOD,MID(5),INFO)
	     CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC*8,IREAL*NRDPRM,
     &                                           RDPARM,MID(6),INFO)
	     CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC*9,IINT*NIDPRM,
     &                                           IDPARM,MID(7),INFO)
	     CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC*10,IINT*NDEG,
     &                                           NODNUM,MID(8),INFO)
	     CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC*11,IREAL*NNOD,
     &                                           NOD,MID(9),INFO)
	     CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC*12,IREAL*NNOPRM,
     &                                           NOPARM,MID(10),INFO)
            ENDIF
	  ENDIF
  	  IVEM(NMSG)=IVEM(NMSG)+NPROC*13
	  NLNGTH(4)=NBIG
          CALL VEM098('VEMU01',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &                LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &                IVEM(19),OUTCNT,LOUT)
          IF (ERR.GT.0) GOTO 9999
        ELSE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** the mesh is put together on process 1:                      ***
C**     --------------------------------------                      ***
C**                                                                 ***
C******* compute buffer sizes:                                      ***
C**      --------------------                                       ***
C**                                                                 ***
         CALL LL4INM(NDEG,1,NDEG,NODNUM,NMAX,IH1,
     &               MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
         DO 8000 I=1,NDEG
8000       NODNUM(I)=-NODNUM(I)
         CALL LL4INM(NDEG,1,NDEG,NODNUM,NMIN,IH1,
     &               MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
         NMIN=-NMIN
         DO 8001 I=1,NDEG
8001       NODNUM(I)=-NODNUM(I)
         CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,I,MYPROC,NPROC)
         CALL VEMU21(OWN,NDEGL,DIM,NOP,NGROUP,GINFO1,IVEM(GINFO),
     &               NK,DINFO1,IVEM(DINFO),LBFIN,LBFRN,LBFN,
     &               LBFRE,LBFIE,LBFE,LBFRD,LBFID,LBFD,
     &               IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C******* check the array length of IBIG:                            ***
C**      ------------------------------                             ***
C**                                                                 ***
         NBIG=(MAX(LBFE,LBFD,LBFN*SBT)+RPI-1)/RPI
	 NLNGTH(4)=NBIG
         CALL VEM098('VEMU01',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &                LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &                IVEM(19),OUTCNT,LOUT)
         IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C******* print node coordinates :                                   ***
C**      ----------------------                                     ***
C**                                                                 ***
         RMARK=OUTPUT
         K=INT((RMARK/10000.-AINT(RMARK/10000.))*10.+.5)
         RMARK=RMARK-K*1000.
         K=INT((RMARK/1000.-AINT(RMARK/1000.))*10.+.5)
         RMARK=RMARK-K*100
         IF (K.NE.0) THEN
           IBUF=1
           RBUF=(IBUF+LBFIN*SBT-1+RPI-1)/RPI+1
           CALL VEMU22(LOUT,NODNUM,NOD,DIM,NN,NOPARM,NOP,NOP1,NDEG,SBT,
     &                 LBFIN,IBIG(IBUF),LBFRN,RBIG(RBUF),NDEGL,NDEG0L,
     &                 IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
         ENDIF
C**                                                                 ***
C******* print elements:                                            ***
C**      --------------                                             ***
C**                                                                 ***
         K=INT((RMARK/100.-AINT(RMARK/100.))*10.+.5)
         RMARK=RMARK-K*10.
         IF (K.NE.0) THEN
           IBUF=1
           RBUF=(IBUF+LBFIE-1+RPI-1)/RPI+1
           BUF=IBUF
           CALL VEMU23 (LOUT,DIS,OWN,NODNUM,NDEG,NGROUP,GINFO1,
     &                  IVEM(GINFO),IVEM(SUMNE),
     &                  LNEK,NEK,LIPARM,IPARM,LRPARM,RPARM,LBFIE,
     &                  IBIG(IBUF),LBFRE,RBIG(RBUF),LBFE,IBIG(BUF),
     &                  IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
         ENDIF
C**                                                                 ***
C******* print dirichlet conditions:                                ***
C**      --------------------------                                 ***
C**                                                                 ***
         K=INT(RMARK+.5)
         IF (K.NE.0) THEN
           IBUF=1
           RBUF=(IBUF+LBFID-1+RPI-1)/RPI+1
           BUF=IBUF
           CALL VEMU24 (LOUT,DIS,OWN,NODNUM,NDEG,NK,DINFO1,
     &                  IVEM(DINFO),IVEM(SUMNDC),
     &                  LDNOD,DNOD,LIDPRM,IDPARM,LRDPRM,RDPARM,LBFIE,
     &                  IBIG(IBUF),LBFRE,RBIG(RBUF),LBFE,IBIG(BUF),
     &                  IOTID,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
	 ENDIF
	ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ----------                                                    ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMU01',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
9040  FORMAT (/2X,70('=')
     &        /2X,11X,'mesh on processor :',I10,'     TID =',I10
     &        /2X,70('='))
9300  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU01----------------------------------------------------
      E    N    D
