C:::::      ,,,,,VEMU04...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU04(T,LCU,CU,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                  LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                  LBIG,RBIG,IBIG,USERC)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU04   integrates a function C of the solution U         ***
C**               over inner elements                               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
      include "bytes.h"

      INTEGER           LU,LCU,LIVEM,LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,
     &                  LIDPRM,LNOD,LNOPRM,LBIG,LNODN

      DOUBLE PRECISION  T,U(LU),CU(LCU),RPARM(LRPARM),RDPARM(LRDPRM),
     &                  NOD(LNOD),NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                  IDPARM(LIDPRM),IBIG(LBIG*RPI),NODNUM(LNODN)

      EXTERNAL          USERC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      include "archi.h"

      DOUBLE PRECISION  TIME,VEMSCD

      INTEGER           NQMAX,Q,WQ,S,DSDV,X,UU,DUDV,DVDX,DUDX,
     &                  CUCU,IWORK,ENOP,N,DNDV,JACOBI,DNOPDX,
     &                  LOUT,OUTCNT,ORDER,ERR,IERR,G,K,I,J,
     &                  STORE,L,STR,NELIS,ORD,RWORK0,RWORK,LRWORK,
     &                  MYPROC,MYTID,NPROC,NBUF,NLOCU,
     &                  MESH,NGROUP,NDEG,NK,DIM,NN,GINFO,GINFO1,
     &                  NE,NELTYP,FORM,CLASS,ADDNEK,NEK1,
     &                  ADRSP,NRSP,ADRVP,RVP1,NRVP,ADISP,NISP,ADIVP,
     &                  IVP1,NIVP,ADDCU,NC,NOP,NOP1,NC2,U2,TIDS,NMSG,
     &                  OWN,NK2,LM,GEOTYP,ADDGEO,GEO1,TOTNT,LMATBK,
     &                  PTRMBK,SORTI,NJUMP,JUMP,NBLK,BLKLST,BLK,NBIG,
     &                  NCU,RW1,IW1,NQ,POINT,PRFLIB,LOCU,BUF,ADDLOC,
     &                  LLNGTH(16),NLNGTH(16),MPINFO,SBT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT=IVEM(30)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9300)
	IVEM(2)=99
	RETURN
      ENDIF
      NMSG=202
      TIDS=204
      MYTID=IVEM(TIDS-1+MYPROC)
      TIME=VEMSCD()
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=LU
      LLNGTH(15)=LCU
      LLNGTH(16)=0
      IF (LOUT.LE.0) LOUT=6
      OUTCNT=MAX(0,IVEM(31))
      NC=MAX(0,IVEM(33))
      ORDER=MAX(IVEM(35),1)
      NBIG=0
      IF (NC.EQ.0) RETURN
      MESH=IVEM(1)
      ERR=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('VEMU04',OUTCNT,LOUT)
        WRITE (LOUT,9100) 30,LOUT
        WRITE (LOUT,9110) 33,NC
        WRITE (LOUT,9130) 35,ORDER
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check mesh infos :                                            ***
C**   ----------------                                              ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      CALL VEM098('VEMU04',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch values from IVEM  :                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      NDEG  =IVEM(MESH+1)
      NK    =IVEM(MESH+2)
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      NOP1  =IVEM(MESH+13)
      NOP   =IVEM(MESH+14)
      OWN   =IVEM(MESH+15)
      NK2   =MAX(1,OWN)
      LM     =IVEM(MESH+16)
      SORTI    =IVEM(MESH+19)+MESH
      NJUMP=IVEM(SORTI)
      NBLK=IVEM(SORTI+1)
      JUMP=SORTI+2
      LMATBK=JUMP+NPROC
      PTRMBK=LMATBK+NPROC
      BLKLST=JUMP+3*NPROC
      BLK=BLKLST+NGROUP

      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      NCU=0
      DO 1 G=1,NGROUP
        NE     = IVEM(GINFO+GINFO1*(G-1)   )
        CLASS  = IVEM(GINFO+GINFO1*(G-1)+ 3)
	IF (CLASS.EQ.DIM) NCU=NCU+NC*NE
1     CONTINUE

      CALL VEM660(OWN,NK,NGROUP,GINFO1,IVEM(GINFO),
     &            NPROC,IVEM(LMATBK),NLOCU,NBUF)
      NBIG=NLOCU+NBUF

      NLNGTH(14)=LM
      NLNGTH(15)=NCU
      NLNGTH(4)=NBIG
      CALL VEM098('VEMU04',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** distribute the solution to the elements :                     ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      LOCU=1
      BUF=LOCU+NLOCU
      CALL VEM661(LM,U,OWN,NK,NGROUP,GINFO1,IVEM(GINFO),NEK,NJUMP,
     &            IVEM(JUMP),IVEM(LMATBK),IVEM(PTRMBK),
     &            NLOCU,RBIG(LOCU),SBT,NBUF/SBT,RBIG(BUF),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   STORE gives the storage per element:                          ***
C**   -----------------------------------                           ***
C**                                                                 ***
      STORE=DIM+DIM*DIM+NK+NOP+DIM*MAX(NK,NOP)+(NK+NOP)*DIM+NC+1
      RWORK0=BUF
      ADDCU=1
      ADDLOC=1
      IERR=0
      IF (OUTCNT.NE.0) WRITE (LOUT,9400)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** begin of group loop :                                         ***
C**   -------------------                                           ***
C**                                                                 ***
      DO 10   G=1,NGROUP

        NE     = IVEM(GINFO+GINFO1*(G-1)   )
        GEOTYP = IVEM(GINFO+GINFO1*(G-1)+ 1)
        FORM   = IVEM(GINFO+GINFO1*(G-1)+ 2)
        CLASS  = IVEM(GINFO+GINFO1*(G-1)+ 3)
        ADDGEO = IVEM(GINFO+GINFO1*(G-1)+ 4)
        GEO1   = IVEM(GINFO+GINFO1*(G-1)+ 5)

        ADRSP  = IVEM(GINFO+GINFO1*(G-1)+ 7)
        NRSP   = IVEM(GINFO+GINFO1*(G-1)+ 8)
        ADRVP  = IVEM(GINFO+GINFO1*(G-1)+ 9)
        RVP1   = IVEM(GINFO+GINFO1*(G-1)+10)
        NRVP   = IVEM(GINFO+GINFO1*(G-1)+11)

        ADISP  = IVEM(GINFO+GINFO1*(G-1)+12)
        NISP   = IVEM(GINFO+GINFO1*(G-1)+13)
        ADIVP  = IVEM(GINFO+GINFO1*(G-1)+14)
        IVP1   = IVEM(GINFO+GINFO1*(G-1)+15)
        NIVP   = IVEM(GINFO+GINFO1*(G-1)+16)

        ADDNEK = IVEM(GINFO+GINFO1*(G-1)+20)
        NEK1   = IVEM(GINFO+GINFO1*(G-1)+21)
        TOTNT  = IVEM(GINFO+GINFO1*(G-1)+22)
        NELTYP = GINFO+GINFO1*(G-1)+23
        PRFLIB = GINFO+GINFO1*(G-1)+23+NK
        U2=TOTNT*(NK-MAX(OWN,1)+1)

        ORD  =ORDER
        LRWORK=RWORK0
	STR=0

        IF ((CLASS.NE.DIM).OR.(NE.LE.0)) THEN
          NC2=0
          L=0
          NQ=0
          ORD=0
        ELSE
          NC2=NC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** initizalize CU :                                          ***
C**       --------------                                            ***
C**                                                                 ***
          DO   5000   K = 1,NC
             DO   5000   I = 1,NE
                CU(ADDCU-1+NE*(K-1)+I) =0.
 5000     CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** check proposal functions :                                ***
C**       ------------------------                                  ***
C**                                                                 ***
          CALL VEMPR0(0,G,CLASS,FORM,OWN,ORD,NQ,
     &                GEOTYP,IVEM(NELTYP),IVEM(PRFLIB),TOTNT,
     &                RW1,IW1,MYPROC,MYTID,LOUT,IERR)
          LRWORK=LRWORK+NQ*(GEOTYP+1)*(CLASS+1)
          IF (OWN.GT.0) LRWORK=LRWORK+NQ*(TOTNT*(CLASS+1))
          IF (IERR.NE.0) THEN
            ERR=99
            GOTO 9998
          ENDIF
          LRWORK=RW1+(IW1+RPI-1)/RPI+LRWORK
          L=MIN(MV,NE)
	  NBIG=MAX(LRWORK+L*STORE,NBIG)
	  IF (NBIG.GT.LBIG) GOTO 9998
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******* compute proposal funnction at integration points :         ***
C**      ------------------------------------------------           ***
C**                                                                 ***
          NQMAX=NQ
          WQ   =RWORK0+1
          Q    =WQ  +1           *NQMAX
          S    =Q   +CLASS       *NQMAX
          DSDV =S   +GEOTYP      *NQMAX
          IF (OWN.EQ.0) THEN
            N    =S
          ELSE
            N    =DSDV+GEOTYP*CLASS*NQMAX
          ENDIF
          DNDV =N   +TOTNT       *NQMAX
          RWORK=DNDV+TOTNT *CLASS*NQMAX
          IWORK=(RWORK+RW1)*RPI+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** set proposal functions :                                  ***
C**       ----------------------                                    ***
C**                                                                 ***
          CALL VEMPRF(0,G,CLASS,FORM,OWN,ORD,NQ,NQMAX,RBIG(WQ),
     &                RBIG(Q),GEOTYP,RBIG(S),RBIG(DSDV),
     &                IVEM(NELTYP),IVEM(PRFLIB),
     &                TOTNT,RBIG(N),RBIG(DNDV),RBIG(N),RBIG(DNDV),
     &                RW1,RBIG(RWORK),IW1,IBIG(IWORK),
     &                MYPROC,MYTID,LOUT,ERR)
	  IF (ERR.GT.0) GOTO 9998
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** start addresses in RBIG :                                 ***
C**       ------------------------                                  ***
C**                                                                 ***
          X     =RWORK
          DVDX  =X     +L*DIM
          UU    =DVDX  +L*DIM*DIM
          ENOP  =UU    +L*NK
          DUDV  =ENOP  +L*NOP
          DUDX  =DUDV  +L*MAX(NK,NOP)*DIM
          DNOPDX=DUDX  +L*NK*DIM
          CUCU=DNOPDX  +L*NOP*DIM
          JACOBI=CUCU  +L*NC
          NBIG =MAX(JACOBI+L,NBIG)
	  IF (NBIG.GT.LBIG) GOTO 9998
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** loop over quadrature points :                             ***
C**       ----------------------------                              ***
C**                                                                 ***
        DO   3000   POINT = 1,NQ
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** section loop :                                            ***
C**       --------------                                            ***
C**                                                                 ***
          DO 2000 J=1,NE,L
	    STR=STR+1
            NELIS=MIN(L,NE-J+1)
            CALL VEM538(T,J-1,NELIS,G,NK,NK2,IVEM(NELTYP),
     &                  TOTNT,GEO1,GEOTYP,NEK(ADDGEO),
     &                  NRSP,RPARM(ADRSP),NRVP,RVP1,RPARM(ADRVP),
     &                  NISP,IPARM(ADISP),NIVP,IVP1,IPARM(ADIVP),
     &                  NOP1,NOP,NOPARM,DIM,NN,NOD,NE,U2,RBIG(ADDLOC),
     &                  USERC,RBIG(S+(POINT-1)*GEOTYP),
     &                  RBIG(DSDV+(POINT-1)*GEOTYP*DIM),
     &                  RBIG(N+(POINT-1)*TOTNT),
     &                  RBIG(DNDV+(POINT-1)*TOTNT*DIM),
     &                  L,RBIG(X),RBIG(UU),RBIG(ENOP),
     &                  RBIG(DVDX),MAX(NOP,NK),RBIG(DUDV),
     &                  RBIG(DUDX),RBIG(DNOPDX),RBIG(JACOBI),
     &                  NC,RBIG(CUCU))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C*********** integration :                                          ***
C**          ------------                                           ***
C**                                                                 ***
             DO   510   I = 1,NELIS
               RBIG(JACOBI-1+I)= RBIG(JACOBI-1+I)*RBIG(WQ-1+POINT)
  510        CONTINUE
             DO   500   K = 1,NC
               DO   500   I = 1,NELIS
                 CU(ADDCU-1+NE*(K-1)+J-1+I) =
     &             CU(ADDCU-1+NE*(K-1)+J-1+I) +
     &                     RBIG(JACOBI-1+I) * RBIG(CUCU+L*(K-1)+I-1)
  500        CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********* end of section loop :                                    ***
C**        --------------------                                     ***
C**                                                                 ***
2000       CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******* end of integration loop                                    ***
C**      -----------------------                                    ***
C**                                                                 ***
3000     CONTINUE
	 STR=STR/NQ
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of group loop :                                           ***
C**   -------------------                                           ***
C**                                                                 ***
        IF (OUTCNT.NE.0) WRITE(LOUT,9410) G,NE,L,STR,NQ,ORD
        IVEM(GINFO+GINFO1*(G-1)+17)=ADDCU
        IVEM(GINFO+GINFO1*(G-1)+18)=NE
        IVEM(GINFO+GINFO1*(G-1)+19)=NC2

        ADDCU=ADDCU+NE*NC2
        ADDLOC=ADDLOC+NE*U2
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** error handling:                                               ***
C**   --------------                                                ***
C**                                                                 ***
9998  CONTINUE
      NLNGTH(4)=NBIG
      CALL VEM098('VEMU04',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMU04',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9100  FORMAT(/'    line output unit ...................... LOUT =',
     &                                         ' IVEM(',I4,') = ',I10)
9110  FORMAT('    number of components of C ................ NC =',
     &                                         ' IVEM(',I4,') = ',I10)
9130  FORMAT('    integration order ..................... ORDER =',
     &                                         ' IVEM(',I4,') = ',I10)
9300  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
9400  FORMAT(/'  integration over inner elements'
     &       /'  -------------------------------'/
     &       /'      group |     NE    |    ELM1   | ',
     &                              ' stripes  |  points   | order |'
     &       /6X,63('-'))
9410  FORMAT(9X,I2,4(' | ',I9),' | ',I5,' |')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU04----------------------------------------------------
      E    N    D
