C:::::      ,,,,,VEMU06...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU06(T,LCU,CU,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                  LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                  LBIG,RBIG,IBIG,USERC)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU06   computes function C at global nodes               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
      include "bytes.h"

      INTEGER          LU,LCU,LIVEM,LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,
     &                 LIDPRM,LNOD,LNOPRM,LBIG,LNODN

      DOUBLE PRECISION T,U(LU),CU(LCU),RPARM(LRPARM),RDPARM(LRDPRM),
     &                 NOD(LNOD),NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER          IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                 IDPARM(LIDPRM),IBIG(LBIG*RPI),NODNUM(LNODN)

      EXTERNAL         USERC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      include "archi.h"

      DOUBLE PRECISION  TIME,VEMSCD

      INTEGER           NQMAX,WQ,Q,S,DSDV,X,UU,DUDV,DVDX,DUDX,
     &                  CUCU,IWORK,ENOP,JACOBI,DNOPDX,
     &                  COUNO

      INTEGER           LOUT,OUTCNT,ERR,IERR,G,K,I,J,Z,
     &                  STORE,L,STR,NELIS,D,D0,RWORK0,RWORK,LRWORK,
     &                  LIB,MYPROC,MYTID,NPROC,U2,HI,NMSG,TIDS
      INTEGER           MESH,NGROUP,NDEG,NK,DIM,NN,GINFO,GINFO1,
     &                  NE,NELTYP,FORM,CLASS,ADDNEK,NEK1,SKIP,
     &                  ADRSP,NRSP,ADRVP,RVP1,NRVP,ADISP,NISP,ADIVP,
     &                  IVP1,NIVP,NOP,NOP1,U1,NK3,NELTY1,PRFLI1,
     &                  OWN,NK2,NUBUF,GEOTYP,ADDGEO,GEO1,TOTNT,TOTNT1,
     &                  SORTI,NJUMP,JUMP,NBLK,BLKLST,BLK,NBIG,ORD,
     &                  NQ,NU,RW1,IW1,POINT,NMIN,NMAX,NDEGL,NDEG0L,
     &                  LCOUNT,NLOCCU,NBUF,LOCU,NLOCU,ALOCU,LMATBK,
     &                  PTRMBK,UCOBUF,UBUF,CCOBUF,LM,LOCCU,CUBUF,
     &                  ALOCCU,LLNGTH(16),NLNGTH(16),MPINFO,SBT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      NPROC=IVEM(200)
      LOUT=IVEM(30)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      MYTID=IVEM(TIDS-1+MYPROC)
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9350)
	IVEM(2)=99
	RETURN
      ENDIF
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=LCU
      LLNGTH(16)=LU
      TIME=VEMSCD()
      IF (LOUT.LE.0) LOUT=6
      OUTCNT=MAX(0,IVEM(31))
      U1=MAX(0,IVEM(36))
      U2=MAX(0,IVEM(37))
      MESH=IVEM(1)
      RWORK0=0
      NBIG=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('VEMU06',OUTCNT,LOUT)
        WRITE (LOUT,9100) 30,LOUT
        WRITE (LOUT,9121) 36,U1
        WRITE (LOUT,9110) 37,U2
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check input parameters :                                      ***
C**   ----------------------                                        ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NDEG  =IVEM(MESH+1)
      IF (U2*U1.LT.NDEG*U2) THEN
        ERR=MAX(ERR,99)
        WRITE (LOUT,9510) MYPROC,MYTID,U1,NDEG
      ENDIF
      CALL VEM098('VEMU06',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch values from IVEM :                                      ***
C**   ----------------------                                        ***
C**                                                                 ***
      NDEG  =IVEM(MESH+1)
      NK    =IVEM(MESH+2)
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      NOP1  =IVEM(MESH+13)
      NOP   =IVEM(MESH+14)
      OWN   =IVEM(MESH+15)
      NK2   =MAX(1,OWN)
      LM     =IVEM(MESH+16)
      SORTI    =IVEM(MESH+19)+MESH
      NJUMP=IVEM(SORTI)
      NBLK=IVEM(SORTI+1)
      JUMP=SORTI+2
      LMATBK=JUMP+NPROC
      PTRMBK=LMATBK+NPROC
      BLKLST=JUMP+3*NPROC
      BLK=BLKLST+NGROUP
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      NU=U2*U1
      NK3=NK-NK2+1
      IF (OUTCNT.NE.0) WRITE (LOUT,9400)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create buffers :                                              ***
C**   --------------                                                ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMAX,HI,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMIN,HI,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-NMIN
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,NUBUF,MYPROC,NPROC)
      SKIP=1

      LCOUNT=SKIP+NGROUP
      UCOBUF=LCOUNT+NDEG
      UBUF  =(UCOBUF-1+(NUBUF+2)*SBT+RPI)/RPI+1
      NBIG=UBUF+NUBUF*U2*SBT-1

      CALL VEM660(OWN,NK,NGROUP,GINFO1,IVEM(GINFO),
     &            NPROC,IVEM(LMATBK),NLOCCU,NBUF)

      NLOCU=0
      DO 15 G=1,NGROUP
        NE     = IVEM(GINFO+GINFO1*(G-1)   )
        GEOTYP = IVEM(GINFO+GINFO1*(G-1)+ 1)
        CLASS  = IVEM(GINFO+GINFO1*(G-1)+ 3)
        IF (CLASS.EQ.DIM) NLOCU=NLOCU+NE*U2*GEOTYP
15    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** STORE gives the storage per element                           ***
C**   -----------------------------------                           ***
C**                                                                 ***
      STORE=DIM+DIM*DIM+NK+NOP+DIM*MAX(U2,NOP)+(U2+NOP)*DIM+NK+4+U2

      LOCCU=(SKIP-1+NGROUP+RPI)/RPI+1
      LOCU=LOCCU+NLOCCU
      RWORK0=LOCU+NLOCU-1
      NBIG=MAX(RWORK0+MV*STORE,NBIG)

      CUBUF=LOCCU+NLOCCU
      CCOBUF=(CUBUF+NBUF-1)*RPI+1
      NBIG=MAX((CCOBUF-1+NBUF+RPI)/RPI,NBIG)

      NLNGTH(15)=LM
      NLNGTH(16)=NU
      NLNGTH(4)=NBIG
      CALL VEM098('VEMU06',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** exchange geometrical solution to other processes:             ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      IF (U2.GT.0) THEN
	DO 161 I=1,NDEG
	  IBIG(LCOUNT-1+I)=1
 161    CONTINUE

        CALL VEM664(NDEG,IBIG(LCOUNT),NODNUM,U2,U1,U,
     &              NDEGL,NDEG0L,SBT,NUBUF,IBIG(UCOBUF),RBIG(UBUF),
     &              MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
        DO 160 K=1,U2
          DO 160 I=1,NDEG
            IF (IBIG(LCOUNT-1+I).GT.0) THEN
              U(I+U1*(K-1))=1./DBLE(IBIG(LCOUNT-1+I))*U(I+U1*(K-1))
            ENDIF
 160    CONTINUE

	ALOCU=LOCU-1
	DO 150 G=1,NGROUP
          NE     = IVEM(GINFO+GINFO1*(G-1)   )
          GEOTYP = IVEM(GINFO+GINFO1*(G-1)+ 1)
          CLASS  = IVEM(GINFO+GINFO1*(G-1)+ 3)
          ADDGEO = IVEM(GINFO+GINFO1*(G-1)+ 4)
          GEO1   = IVEM(GINFO+GINFO1*(G-1)+ 5)
	  IF (CLASS.EQ.DIM) THEN
	    DO 151 K=1,U2
	      DO 151 J=1,GEOTYP
	        DO 151 Z=1,NE
		  RBIG(ALOCU+Z+NE*(GEOTYP*(K-1)+J-1))=
     &                            U(NEK(ADDGEO-1+Z+GEO1*(J-1))+U1*(K-1))
151         CONTINUE
	    ALOCU=ALOCU+NE*U2*GEOTYP
          ENDIF
 150    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** begin of group loop :                                         ***
C**   -------------------                                           ***
C**                                                                 ***
      DO 10 D=1,NK2
       ALOCU=LOCU
       ALOCCU=LOCCU
       DO 10 G=1,NGROUP

        NE     = IVEM(GINFO+GINFO1*(G-1)   )
        GEOTYP = IVEM(GINFO+GINFO1*(G-1)+ 1)
        FORM   = IVEM(GINFO+GINFO1*(G-1)+ 2)
        CLASS  = IVEM(GINFO+GINFO1*(G-1)+ 3)
        ADDGEO = IVEM(GINFO+GINFO1*(G-1)+ 4)
        GEO1   = IVEM(GINFO+GINFO1*(G-1)+ 5)

        ADRSP  = IVEM(GINFO+GINFO1*(G-1)+ 7)
        NRSP   = IVEM(GINFO+GINFO1*(G-1)+ 8)
        ADRVP  = IVEM(GINFO+GINFO1*(G-1)+ 9)
        RVP1   = IVEM(GINFO+GINFO1*(G-1)+10)
        NRVP   = IVEM(GINFO+GINFO1*(G-1)+11)

        ADISP  = IVEM(GINFO+GINFO1*(G-1)+12)
        NISP   = IVEM(GINFO+GINFO1*(G-1)+13)
        ADIVP  = IVEM(GINFO+GINFO1*(G-1)+14)
        IVP1   = IVEM(GINFO+GINFO1*(G-1)+15)
        NIVP   = IVEM(GINFO+GINFO1*(G-1)+16)
        NELTY1 = GINFO+GINFO1*(G-1)+1
        PRFLI1 = GINFO+GINFO1*(G-1)+6
        TOTNT1 = GEOTYP

        ADDNEK = IVEM(GINFO+GINFO1*(G-1)+20)
        NEK1   = IVEM(GINFO+GINFO1*(G-1)+21)
        TOTNT  = IVEM(GINFO+GINFO1*(G-1)+22)
        NELTYP = IVEM(GINFO+GINFO1*(G-1)+22+D)

        LIB=IVEM(GINFO+GINFO1*(G-1)+22+NK+D)
        IF ((LIB.NE.0).AND.(LIB.NE.1)) THEN
          ERR=99
          WRITE(LOUT,9511) MYPROC,MYTID,G,LIB
          GOTO 9998
        ENDIF

        D0=0
        DO 201 I=1,D-1
 201      D0 = D0+ IVEM(GINFO+GINFO1*(G-1)+22+I)

        IF (LIB.EQ.0) THEN
         ORD=0
        ELSE
         ORD=-NELTYP
        ENDIF

        LRWORK=RWORK0
	STR=0

        IF ((CLASS.EQ.DIM).AND.(NE.GT.0).AND.(NELTYP.GT.0)) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** check proposal functions :                                ***
C**       ------------------------                                  ***
C**                                                                 ***
          CALL VEMPR0(0,G,CLASS,FORM,0,ORD,NQ,
     &                GEOTYP,IVEM(NELTY1),IVEM(PRFLI1),TOTNT1,
     &                RW1,IW1,MYPROC,MYTID,LOUT,IERR)
          LRWORK=LRWORK+NQ*(GEOTYP+1)*(CLASS+1)
          IF (IERR.NE.0) THEN
            ERR=99
            GOTO 9998
          ENDIF
          LRWORK=RW1+(IW1+RPI-1)/RPI+LRWORK
          L=MIN(MV,NE)
	  NBIG=MAX(NBIG,LRWORK+L*STORE)
	  IF (NBIG.GT.LBIG) GOTO 9998
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** compute shape function at geometrical nodes :             ***
C**       -------------------------------------------               ***
C**                                                                 ***
          NQMAX=NQ
          WQ   =RWORK0+1
          Q    =WQ  +1           *NQMAX
          S    =Q   +CLASS       *NQMAX
          DSDV =S   +GEOTYP      *NQMAX
          RWORK=DSDV+GEOTYP*CLASS*NQMAX
          IWORK=(RWORK+RW1)*RPI+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** set shape functions:                                      ***
C**       -------------------                                       ***
C**                                                                 ***
          CALL VEMPRF(0,G,CLASS,FORM,0,ORD,NQ,NQMAX,RBIG(WQ),
     &                RBIG(Q),GEOTYP,RBIG(S),RBIG(DSDV),
     &                IVEM(NELTY1),IVEM(PRFLI1),
     &                TOTNT1,RBIG(S),RBIG(DSDV),RBIG(S),RBIG(DSDV),
     &                RW1,RBIG(RWORK),IW1,IBIG(IWORK),
     &                MYPROC,MYTID,LOUT,ERR)
          IF (ERR.NE.0) GOTO 9998
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** start addresses in RBIG :                                 ***
C**       -----------------------                                   ***
C**                                                                 ***
          X     =RWORK
          DVDX  =X     +L*DIM
          UU    =DVDX  +L*DIM*DIM
          ENOP  =UU    +L*U2
          DUDV  =ENOP  +L*NOP
          DUDX  =DUDV  +L*MAX(U2,NOP)*DIM
          DNOPDX=DUDX  +L*U2*DIM
          CUCU=DNOPDX  +L*NOP*DIM
          JACOBI=CUCU  +L*NK
          NBIG =MAX(JACOBI+L,NBIG)
	  IF (NBIG.GT.LBIG) GOTO 9998
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** loop over global nodes :                                  ***
C**       ----------------------                                    ***
C**                                                                 ***
          DO   3000   POINT = 1,NELTYP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** section loop :                                          ***
C**         ------------                                            ***
C**                                                                 ***
            DO 2000 J=1,NE,L
              NELIS=MIN(L,NE-J+1)
	      STR=STR+1
              CALL VEM538(T,J-1,NELIS,G,U2,1,IVEM(NELTY1),
     &                    TOTNT1,GEO1,GEOTYP,NEK(ADDGEO),
     &                    NRSP,RPARM(ADRSP),NRVP,RVP1,RPARM(ADRVP),
     &                    NISP,IPARM(ADISP),NIVP,IVP1,IPARM(ADIVP),
     &                    NOP1,NOP,NOPARM,DIM,NN,NOD,NE,U2*GEOTYP,
     &                    RBIG(ALOCU),USERC,RBIG(S+(POINT-1)*GEOTYP),
     &                    RBIG(DSDV+(POINT-1)*GEOTYP*DIM),
     &                    RBIG(S+(POINT-1)*TOTNT1),
     &                    RBIG(DSDV+(POINT-1)*TOTNT1*DIM),
     &                    L,RBIG(X),RBIG(UU),RBIG(ENOP),
     &                    RBIG(DVDX),MAX(NOP,U2),RBIG(DUDV),
     &                    RBIG(DUDX),RBIG(DNOPDX),RBIG(JACOBI),
     &                    NK,RBIG(CUCU))
	      include "norec.h"
              DO 3001 K=1,NK3
	        DO 3001 Z=1,NELIS
	          RBIG(ALOCCU-1+J-1+Z+NE*(D0+NELTYP*(K-1)+POINT-1))=
     &                                   RBIG(CUCU-1+Z+L*(D-1+K-1))
3001          CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C*********** end of section loop :                                  ***
C**          --------------------                                   ***
C**                                                                 ***
2000        CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** end of global node loop:                                  ***
C**       -----------------------                                   ***
C**                                                                 ***
3000      CONTINUE
	  STR=STR/NELTYP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** end of group loop :                                         ***
C**     -------------------                                         ***
C**                                                                 ***
        IF (OUTCNT.NE.0) THEN
	   IF (D.EQ.NK2) WRITE(LOUT,9410) G,NE,L,STR,TOTNT
        ENDIF
        ALOCU=ALOCU+NE*U2*GEOTYP
        ALOCCU=ALOCCU+NE*NK3*TOTNT
        IBIG(SKIP-1+G)=0

        ELSE

        IF (OUTCNT.NE.0) THEN
          IF (D.EQ.NK2) WRITE(LOUT,9410) G,NE,0,0,0
        ENDIF
        IBIG(SKIP-1+G)=1

        ENDIF
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
9998  CONTINUE
      NLNGTH(4)=NBIG
      CALL VEM098('VEMU06',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the element results are distributed to the vector U:      ***
C**   --------------------------------------------------------      ***
C**                                                                 ***
      CALL VEM662(LM,COUNO,CU,OWN,NK,NGROUP,GINFO1,IVEM(GINFO),NEK,
     &            NJUMP,IVEM(JUMP),IVEM(LMATBK),IVEM(PTRMBK),
     &            NLOCCU,RBIG(LOCCU),SBT,NBUF/SBT,IBIG(CCOBUF),
     &            RBIG(CUBUF),IBIG(SKIP),IVEM(BLKLST),IVEM(BLK),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF (OUTCNT.NE.0) WRITE (LOUT,9300) COUNO
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ----------                                                    ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMU06',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
9100  FORMAT(/'    line output unit ....................... LOUT =',
     &                                          ' IVEM(',I4,') = ',I10)
9110  FORMAT('    number of components of U ................ NU =',
     &                                          ' IVEM(',I4,') = ',I10)
9121  FORMAT('    leading dimension of U ................... U1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9300  FORMAT(/'    nodes with no value ......................... =',I10)
9400  FORMAT(/'  evaluation at global nodes'
     &       /'  --------------------------'/
     &       /'      group |     NE    |    ELM1   | ',
     &                                        ' stripes  |  pionts   |'
     &       /6X,55('-'))

9410  FORMAT(9X,I2,4(' | ',I9),' |')
9350  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
9511  FORMAT('>>VEMCD:40:0005'
     &      /'>>VEMU06 error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal element library:',I4)
9510  FORMAT('>>VEMCD:40:0008'
     &      /'>>VEMU06 error: process ',I10,' (TID=',I10,'):'
     &      /'>>leading dimension of U =',I9,' must be greater/equal '
     &      /'>>number of geometrical nodes=',I9,' !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU06----------------------------------------------------
      E    N    D
