C:::::      ,,,,,VEMU07...)
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU07(T,LCU,CU,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                  LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                  LBIG,RBIG,IBIG,USERC)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU07   computes function C at geometrical nodes          ***
C**               using extrapolation from quadrature points        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights Lutz Grosz Canberra 1999                      ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
      include "bytes.h"

      INTEGER          LU,LCU,LIVEM,LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,
     &                 LIDPRM,LNOD,LNOPRM,LBIG,LNODN

      DOUBLE PRECISION T,U(LU),CU(LCU),RPARM(LRPARM),RDPARM(LRDPRM),
     &                 NOD(LNOD),NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER          IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                 IDPARM(LIDPRM),IBIG(LBIG*RPI),NODNUM(LNODN)

      EXTERNAL         USERC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      include "archi.h"

      DOUBLE PRECISION  TIME,VEMSCD,LIMIT,TEN,ZERO,RREG,ONE,VOLREF

      INTEGER           NQMAX,WQ,Q,S,DSDV,X,UU,DUDV,DVDX,DUDX,
     &                  CUCU,IWORK,ENOP,N,DNDV,JACOBI,DNOPDX,
     &                  LCOUNT,INDEX,NODES,MARK,MASK,COUNO,
     &                  NMIN,NMAX,NDEGL,NDEG0L,COUNBF,CUBUF,
     &                  LOUT,OUTCNT,ERR,G,I,J,NFAIL,K1,K,
     &                  L,STR,NELIS,D,HI,TIDS,NMSG,
     &                  RWORK0,RWORK,LRWORK,EXTC,ISC,VOL,
     &                  MYPROC,MYTID,NPROC,NBUF,NLOCU,NCUBUF,
     &                  MESH,NGROUP,NDEG,NK,DIM,NN,GINFO,GINFO1,
     &                  NE,NELTYP,FORM,CLASS,ADDNEK,NEK1,
     &                  ADRSP,NRSP,ADRVP,RVP1,NRVP,ADISP,NISP,ADIVP,
     &                  IVP1,NIVP,NC,NOP,NOP1,LOCU,BUF,ADDLOC,U2,
     &                  OWN,NK2,LM,GEOTYP,ADDGEO,GEO1,TOTNT,ORDER,
     &                  SORTI,NJUMP,JUMP,NBLK,BLKLST,BLK,NBIG,ORD,NQ,
     &                  NCU,RW1,IW1,POINT,PRFLIB,CU1,LMATBK,PTRMBK,
     &                  LLNGTH(16),NLNGTH(16),MPINFO,SBT,INVSIJ,Z
      PARAMETER(ZERO=0.D0,ONE=1.D0)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT=IVEM(30)
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9350)
	IVEM(2)=99
	RETURN
      ENDIF
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=LU
      LLNGTH(15)=LCU
      LLNGTH(16)=0
      MYTID=IVEM(TIDS-1+MYPROC)
      TIME=VEMSCD()
      IF (LOUT.LE.0) LOUT=6
      OUTCNT=MAX(0,IVEM(31))
      NC=MAX(0,IVEM(33))
      CU1=MAX(0,IVEM(32))
      IF (NC.EQ.0) RETURN
      MESH=IVEM(1)
      TEN=10.
      ORDER=MAX(IVEM(35),1)
      LIMIT=TEN**MAX(IVEM(4),10)
      ERR=0
      NBIG=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('VEMU07',OUTCNT,LOUT)
        WRITE (LOUT,9100) 30,LOUT
        WRITE (LOUT,9121) 32,CU1
        WRITE (LOUT,9110) 33,NC
        WRITE (LOUT,9130) 35,ORDER
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check input parameters :                                      ***
C**   ----------------------                                        ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      CALL VEM098('VEMU07',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch values from IVEM  :                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      NDEG  =IVEM(MESH+1)
      NK    =IVEM(MESH+2)
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      NOP1  =IVEM(MESH+13)
      NOP   =IVEM(MESH+14)
      OWN   =IVEM(MESH+15)
      NK2   =MAX(1,OWN)
      LM     =IVEM(MESH+16)
      SORTI    =IVEM(MESH+19)+MESH
      NJUMP=IVEM(SORTI)
      NBLK=IVEM(SORTI+1)
      JUMP=SORTI+2
      LMATBK=JUMP+NPROC
      PTRMBK=LMATBK+NPROC
      BLKLST=JUMP+3*NPROC
      BLK=BLKLST+NGROUP
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      CU1=MAX(NDEG,CU1)
      IVEM(32)=CU1
      NCU=NC*CU1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create buffer :                                               ***
C**   -------------                                                 ***
C**                                                                 ***
      CALL VEM660(OWN,NK,NGROUP,GINFO1,IVEM(GINFO),
     &            NPROC,IVEM(LMATBK),NLOCU,NBUF)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMAX,HI,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      DO 4000 I=1,NDEG
4000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMIN,HI,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-NMIN
      DO 4001 I=1,NDEG
4001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,NCUBUF,MYPROC,NPROC)
	
      LCOUNT=1
      COUNBF=LCOUNT+NDEG
      CUBUF=(COUNBF-1+(NCUBUF+2)*SBT+RPI)/RPI+1
      LOCU=(LCOUNT-1+NDEG+RPI)/RPI+1
      BUF=LOCU+NLOCU
      MARK=(BUF-1)*RPI+1
      RWORK0=(MARK+NDEG+RPI-1)/RPI
      NBIG=MAX(RWORK0,BUF+NBUF-1,CUBUF+NCUBUF*NC*SBT-1)

      NLNGTH(4)=NBIG
      NLNGTH(14)=LM
      NLNGTH(15)=NCU
      CALL VEM098('VEMU07',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   distribute the solution to the elements:                      ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      CALL VEM661(LM,U,OWN,NK,NGROUP,GINFO1,IVEM(GINFO),NEK,NJUMP,
     &            IVEM(JUMP),IVEM(LMATBK),IVEM(PTRMBK),
     &            NLOCU,RBIG(LOCU),SBT,NBUF/SBT,RBIG(BUF),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initizalize CU :                                              ***
C**   --------------                                                ***
C**                                                                 ***
      DO   5000   I = 1,NDEG
         IBIG(LCOUNT-1+I) = 0
 5000 CONTINUE
      DO   5001   I = 1,NCU
         CU(I) = ZERO
 5001 CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      IF (OUTCNT.NE.0) WRITE (LOUT,9400)
      ADDLOC=LOCU
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** begin of group loop :                                         ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 10   G=1,NGROUP

        NE     = IVEM(GINFO+GINFO1*(G-1)   )
        GEOTYP = IVEM(GINFO+GINFO1*(G-1)+ 1)
        FORM   = IVEM(GINFO+GINFO1*(G-1)+ 2)
        CLASS  = IVEM(GINFO+GINFO1*(G-1)+ 3)
        ADDGEO = IVEM(GINFO+GINFO1*(G-1)+ 4)
        GEO1   = IVEM(GINFO+GINFO1*(G-1)+ 5)

        ADRSP  = IVEM(GINFO+GINFO1*(G-1)+ 7)
        NRSP   = IVEM(GINFO+GINFO1*(G-1)+ 8)
        ADRVP  = IVEM(GINFO+GINFO1*(G-1)+ 9)
        RVP1   = IVEM(GINFO+GINFO1*(G-1)+10)
        NRVP   = IVEM(GINFO+GINFO1*(G-1)+11)

        ADISP  = IVEM(GINFO+GINFO1*(G-1)+12)
        NISP   = IVEM(GINFO+GINFO1*(G-1)+13)
        ADIVP  = IVEM(GINFO+GINFO1*(G-1)+14)
        IVP1   = IVEM(GINFO+GINFO1*(G-1)+15)
        NIVP   = IVEM(GINFO+GINFO1*(G-1)+16)

        ADDNEK = IVEM(GINFO+GINFO1*(G-1)+20)
        NEK1   = IVEM(GINFO+GINFO1*(G-1)+21)
        TOTNT  = IVEM(GINFO+GINFO1*(G-1)+22)
        NELTYP = GINFO+GINFO1*(G-1)+23
        PRFLIB = GINFO+GINFO1*(G-1)+23+NK
	U2=TOTNT*(NK-MAX(OWN,1)+1)
	STR=0
        L=MIN(MV,NE)

        DO 1234 D=1,NK2
          IF ((IVEM(PRFLIB-1+D).NE.0).AND.IVEM(PRFLIB-1+D).NE.1) THEN
            ERR=99
            WRITE (LOUT,9511) MYPROC,MYTID,G,IVEM(PRFLIB-1+D)
            GOTO 9998
          ENDIF
1234    CONTINUE
        LRWORK=RWORK0

        IF ((CLASS.EQ.DIM).AND.(NE.GT.0)) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** check proposal functions :                                ***
C**       -------------------------                                 ***
C**                                                                 ***
          ORD=ORDER
          CALL VEMPR0(0,G,CLASS,FORM,OWN,ORD,NQ,
     &                GEOTYP,IVEM(NELTYP),IVEM(PRFLIB),TOTNT,
     &                RW1,IW1,MYPROC,MYTID,LOUT,ERR)
          LRWORK=LRWORK+NQ*(GEOTYP+1)*(CLASS+1)
          IF (OWN.GT.0) LRWORK=LRWORK+NQ*(TOTNT*(CLASS+1))
          IF (ERR.NE.0) THEN
            ERR=99
            GOTO 9998
          ENDIF
          LRWORK=RW1+(IW1+RPI-1)/RPI+LRWORK
	  NBIG=MAX(LRWORK,NBIG)
	  IF (NBIG.GT.LBIG) GOTO 9998
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** compute proposal functions at geometrical nodes :         ***
C**       -----------------------------------------------           ***
C**                                                                 ***
C**                                                                 ***
          NQMAX=NQ
          WQ   =RWORK0+1
          Q    =WQ  +1           *NQMAX
          S    =Q   +CLASS       *NQMAX
          DSDV =S   +GEOTYP      *NQMAX
          IF (OWN.EQ.0) THEN
            N    =S
          ELSE
            N    =DSDV+GEOTYP*CLASS*NQMAX
          ENDIF
          DNDV =N   +TOTNT       *NQMAX
          INVSIJ=DNDV+TOTNT *CLASS*NQMAX 
          RWORK= INVSIJ+GEOTYP*GEOTYP
          IWORK=(RWORK+RW1)*RPI+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** set proposal functions:                                   ***
C**       ----------------------                                    ***
C**                                                                 ***
          CALL VEMPRF(0,G,CLASS,FORM,OWN,ORD,NQ,NQMAX,RBIG(WQ),
     &                RBIG(Q),GEOTYP,RBIG(S),RBIG(DSDV),
     &                IVEM(NELTYP),IVEM(PRFLIB),
     &                TOTNT,RBIG(N),RBIG(DNDV),RBIG(N),RBIG(DNDV),
     &                RW1,RBIG(RWORK),IW1,IBIG(IWORK),
     &                MYPROC,MYTID,LOUT,ERR)
          IF (ERR.GT.0) GOTO 9998
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** set the weights for extrapolation:                        ***
C**       ---------------------------------                         ***
C**                                                                 ***
          CALL VEMLSQ(CLASS,FORM,GEOTYP,RBIG(INVSIJ),ERR)
          IF (ERR.GT.0) GOTO 9998
          VOLREF=ZERO
          DO 312 POINT=1,NQ
            VOLREF=VOLREF+RBIG(WQ-1+POINT)
 312      CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** start addresses in RBIG :                                 ***
C**       -----------------------                                   ***
C**                                                                 ***
          INDEX =(RWORK-1)*RPI+1
          NODES =INDEX+L
          MASK  =NODES+L
          EXTC  =(MASK+L+RPI-1)/RPI+1
          ISC   =EXTC+L*NC
          VOL   =ISC+L*GEOTYP*NC
          X     =VOL   +L
          DVDX  =X     +L*DIM
          UU    =DVDX  +L*DIM*DIM
          ENOP  =UU    +L*NK
          DUDV  =ENOP  +L*NOP
          DUDX  =DUDV  +L*MAX(NK,NOP)*DIM
          DNOPDX=DUDX  +L*NK*DIM
          CUCU=DNOPDX  +L*NOP*DIM
          JACOBI=CUCU  +L*NC
          NBIG =MAX(JACOBI+L-1,NBIG)
	  IF (NBIG.GT.LBIG) GOTO 9998
          STR=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** section loop :                                            ***
C**       ------------                                              ***
C**                                                                 ***
        
          DO 2000 J=1,NE,L

            STR=STR+1
            NELIS=MIN(L,NE-J+1)
            DO 2100 Z=1,NC*L*GEOTYP
              RBIG(ISC-1+Z)=ZERO
 2100       CONTINUE
            DO 2110 Z=1,L
              RBIG(VOL-1+Z)=ZERO
 2110       CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** loop over the quadrature nodes:                         ***
C**         -------------------------------                         ***
C**                                                                 ***
            DO 3000 POINT = 1,NQ
              CALL VEM538(T,J-1,NELIS,G,NK,NK2,IVEM(NELTYP),
     &                    TOTNT,GEO1,GEOTYP,NEK(ADDGEO),
     &                    NRSP,RPARM(ADRSP),NRVP,RVP1,RPARM(ADRVP),
     &                    NISP,IPARM(ADISP),NIVP,IVP1,IPARM(ADIVP),
     &                    NOP1,NOP,NOPARM,DIM,NN,NOD,NE,U2,RBIG(ADDLOC),
     &                    USERC,RBIG(S+(POINT-1)*GEOTYP),
     &                    RBIG(DSDV+(POINT-1)*GEOTYP*DIM),
     &                    RBIG(N+(POINT-1)*TOTNT),
     &                    RBIG(DNDV+(POINT-1)*TOTNT*DIM),
     &                    L,RBIG(X),RBIG(UU),RBIG(ENOP),
     &                    RBIG(DVDX),MAX(NOP,NK),RBIG(DUDV),
     &                    RBIG(DUDX),RBIG(DNOPDX),RBIG(JACOBI),
     &                    NC,RBIG(CUCU))
              
              DO 3120 Z=1,NELIS
                RBIG(JACOBI-1+Z)=RBIG(WQ-1+POINT)*RBIG(JACOBI-1+Z)
 3120         CONTINUE

              DO 3100 K=1,GEOTYP
               RREG=RBIG(S-1+(POINT-1)*GEOTYP+K)
               DO 3100 I=1,NC
                DO 3100 Z=1,NELIS
                  RBIG(ISC-1+Z+L*((I-1)+NC*(K-1)))=
     &               RBIG(ISC-1+Z+L*((I-1)+NC*(K-1)))+
     &                    RBIG(JACOBI-1+Z)*RBIG(CUCU-1+Z+L*(I-1))*RREG
 3100         CONTINUE

              DO 3110 Z=1,NELIS
                RBIG(VOL-1+Z)=RBIG(VOL-1+Z)+RBIG(JACOBI-1+Z)
 3110         CONTINUE

3000        CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** inverse the element volums:                             ***
C**         --------------------------                              ***
C**                                                                 ***
            NFAIL=0
            DO 3550 Z=1,NELIS
               IF (RBIG(VOL-1+Z).NE.ZERO) THEN
                 RBIG(VOL-1+Z)=VOLREF/RBIG(VOL-1+Z)
               ELSE
                 NFAIL=NFAIL+1
               ENDIF
3550       CONTINUE
           IF (NFAIL.GT.0) THEN
              WRITE (LOUT,9070) MYPROC,MYTID,NFAIL,G,NFAIL
              ERR=83
              GOTO 9998
           ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** Do the extrapolation:                                   ***
C**         ---------------------                                   ***
C**                                                                 ***
            DO 3500 K=1,GEOTYP

              DO 3510 I=1,NC
                DO 3510 Z=1,NELIS
                  RBIG(EXTC-1+Z+L*(I-1))=ZERO
3510          CONTINUE

              DO 3520 K1=1,GEOTYP
                DO 3520 I=1,NC
                  DO 3520 Z=1,NELIS
                    RBIG(EXTC-1+Z+L*(I-1))=
     &                    RBIG(EXTC-1+Z+L*(I-1))+
     &                    RBIG(INVSIJ-1+K+GEOTYP*(K1-1))*
     &                    RBIG(ISC-1+Z+L*((I-1)+NC*(K1-1)))
3520          CONTINUE

              DO 3530 I=1,NC
                DO 3530 Z=1,NELIS
                  RBIG(EXTC-1+Z+L*(I-1))=
     &                       RBIG(EXTC-1+Z+L*(I-1))*RBIG(VOL-1+Z)
3530          CONTINUE
C**                                                                 ***
C************ addition to result vector at one process:             ***
C**                                                                 ***
              CALL VEM653(NDEG,NC,CU1,CU,L,RBIG(EXTC),
     &                    IBIG(LCOUNT),J-1,NELIS,GEO1,
     &                    1,NEK(ADDGEO+(K-1)*GEO1),
     &                    IBIG(INDEX),IBIG(NODES),
     &                    IBIG(MARK),IBIG(MASK))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
3500        CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********* end of section loop :                                    ***
C**        --------------------                                     ***
C**                                                                 ***
2000       CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of group loop :                                           ***
C**   -----------------                                             ***
C**                                                                 ***
          IF (OUTCNT.NE.0) WRITE(LOUT,9410) G,NE,L,STR,GEOTYP
        ELSE
          IF (OUTCNT.NE.0) WRITE(LOUT,9410) G,NE,NE,0,0
        ENDIF
        ADDLOC=ADDLOC+NE*U2
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** error handling :                                              ***
C**   --------------                                                ***
C**                                                                 ***
9998  CONTINUE
      NLNGTH(4)=NBIG
      CALL VEM098('VEMU07',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** exchange geoemtrical solution to other processes:             ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      CALL VEM664(NDEG,IBIG(LCOUNT),NODNUM,NC,CU1,CU,
     &            NDEGL,NDEG0L,SBT,NCUBUF,IBIG(COUNBF),RBIG(CUBUF),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set the result vector :                                       ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 160 K=1,NC
        COUNO=0
        DO 160 I=1,NDEG
          IF (IBIG(LCOUNT-1+I).GT.0) THEN
            CU(I+CU1*(K-1))=1./DBLE(IBIG(LCOUNT-1+I))*CU(I+CU1*(K-1))
          ELSE
            COUNO=COUNO+1
            CU(I+CU1*(K-1))=LIMIT
          ENDIF
 160  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF (OUTCNT.NE.0) WRITE (LOUT,9300) COUNO
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMU07',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9100  FORMAT(/'    line output unit ....................... LOUT =',
     &                                          ' IVEM(',I4,') = ',I10)
9110  FORMAT('    number of components of C ................ NC =',
     &                                          ' IVEM(',I4,') = ',I10)
9121  FORMAT('    permitted leading dimension of CU ....... CU1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9130  FORMAT('    integration order ..................... ORDER =',
     &                                         ' IVEM(',I4,') = ',I10)
9300  FORMAT(/'    nodes with no value ......................... =',I10)
9350  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
9400  FORMAT(/'  evaluation at geometrical nodes'
     &       /'  -------------------------------'/
     &       /'      group |     NE    |    ELM1   | ',
     &                                       ' stripes  |  points   |'
     &       /6X,55('-'))
9410  FORMAT(9X,I2,4(' | ',I9),' |')
9511  FORMAT('>>VEMCD:40:0008'
     &      /'>>VEMU07 error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : illegal element library:',I4)
9070  FORMAT('>>VEMCD:31:0001:',I9
     &      /'>>VEMU07 error: process ',I10,' (TID=',I10,'):'
     &      /'>>group ',I3,': At least ',I9,
     &       ' illegal element jacobean.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU07----------------------------------------------------
      E    N    D
